
<nav class="navbar navbar-expand-md navbar-light bg-white border-bottom"> <!-- sticky-top -->
    <div class="container">
        <!-- Logo -->
        <a class="navbar-brand me-4" href="/">
            <x-application-mark width="36" />
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <!-- Left Side Of Navbar -->
            <ul class="navbar-nav me-auto">
                <x-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                    {{ __('Dashboard') }}
                </x-nav-link>
                <x-nav-link href="{{ route('designs') }}" :active="request()->routeIs('designs')">
                    {{ __('Designs') }}
                </x-nav-link>

				<x-dropdown id="devDropdown">
                    <x-slot name="trigger">
                        Development
                        <svg class="ms-2" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </x-slot>
                    <x-slot name="content">
                        <h6 class="dropdown-header">
                            {{ __('Edit') }}
                        </h6>
						<x-dropdown-link href="{{ route('styles') }}">
                            {{ __('Styles') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('samples') }}">
                            {{ __('Samples') }}
                        </x-dropdown-link>
                        <hr>
                        <h6 class="dropdown-header">
                            {{ __('Reports') }}
                        </h6>
                        <x-dropdown-link href="{{ route('stylesoverview') }}">
                            {{ __('Styles Overview') }}
                        </x-dropdown-link>
                    </x-slot>
                </x-dropdown>

				<x-dropdown id="salesDropdown">
                    <x-slot name="trigger">
                        Sales
                        <svg class="ms-2" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </x-slot>
                    <x-slot name="content">
                        <h6 class="dropdown-header">
                            {{ __('Edit') }}
                        </h6>
						<x-dropdown-link href="{{ route('pricing') }}" :active="request()->routeIs('pricing')">
							{{ __('Pricing') }}
						</x-dropdown-link>
                        <x-dropdown-link href="{{ route('orders') }}">
                            {{ __('Orders') }}
                        </x-dropdown-link>
                        <h6 class="dropdown-header">
                            {{ __('Reports') }}
                        </h6>
                        <x-dropdown-link href="{{ route('salesvalues') }}">
                            {{ __('Sales Value Pivot') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('salesoutlook') }}">
                            {{ __('Sales Outlook') }}
                        </x-dropdown-link>
                    </x-slot>
                </x-dropdown>

                <x-dropdown id="productionDropdown">
                    <x-slot name="trigger">
                        Production
                        <svg class="ms-2" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </x-slot>
                    <x-slot name="content">
                        <h6 class="dropdown-header">
                            {{ __('Edit') }}
                        </h6>
                        <x-dropdown-link href="{{ route('yarnorders') }}">
                            {{ __('Yarn Orders') }}
                        </x-dropdown-link>
						<x-dropdown-link href="{{ route('shipments') }}">
                            {{ __('Shipments') }}
                        </x-dropdown-link>
                        <hr>
                        <h6 class="dropdown-header">
                            {{ __('Reports') }}
                        </h6>
                        {{-- <x-dropdown-link href="{{ route('criticalpath') }}">
                            {{ __('Critical Path') }}
                        </x-dropdown-link> --}}
                        <x-dropdown-link href="{{ route('criticalpathtest') }}">
                            {{ __('Critical Path') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('asoscriticalpath') }}">
                            {{ __('Asos Critical Path') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('factoryorders') }}">
                            {{ __('Factory PO') }}
                        </x-dropdown-link>
						<x-dropdown-link href="{{ route('shipmentschedule') }}">
                            {{ __('Shipment Schedule') }}
                        </x-dropdown-link>
                        {{-- <x-dropdown-link href="{{ route('commissionshipmentschedule') }}">
                            {{ __('Commission SS') }}
                        </x-dropdown-link> --}}
                        <x-dropdown-link href="{{ route('commissionshipmentschedule') }}">
                            {{ __('Commission SS') }}
                        </x-dropdown-link>
                    </x-slot>
                </x-dropdown>

                @can('finance:read')
                    <x-dropdown id="reportsDropdown">
                        <x-slot name="trigger">
                            Finance
                            <svg class="ms-2" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </x-slot>
                        <x-slot name="content">
                            <h6 class="dropdown-header">
                                {{ __('Reports') }}
                            </h6>
                            <x-dropdown-link href="{{ route('samplesinvoice') }}">
                                {{ __('Samples') }}
                            </x-dropdown-link>
                            <x-dropdown-link href="{{ route('cashflow') }}">
                                {{ __('WH Cashflow') }}
                            </x-dropdown-link>
                            <x-dropdown-link href="{{ route('prodlookup') }}">
                                {{ __('PROD Lookup') }}
                            </x-dropdown-link>
                        </x-slot>
                    </x-dropdown>
                @endcan
                <x-dropdown id="adminDropdown">
                    <x-slot name="trigger">
                        Admin
                        <svg class="ms-2" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </x-slot>
                    <x-slot name="content">
                        <h6 class="dropdown-header">
                            {{ __('General') }}
                        </h6>
                        <x-dropdown-link href="{{ route('customers') }}">
                            {{ __('Customers') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('suppliers') }}">
                            {{ __('Suppliers') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('departments') }}">
                            {{ __('Departments') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('seasons') }}">
                            {{ __('Seasons') }}
                        </x-dropdown-link>
                        <hr>
                        <h6 class="dropdown-header">
                            {{ __('Styles') }}
                        </h6>
                        <x-dropdown-link href="{{ route('yarns') }}">
                            {{ __('Yarns') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('materials') }}">
                            {{ __('Materials') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('counts') }}">
                            {{ __('Counts') }}
                        </x-dropdown-link>
                        <hr>
                        <h6 class="dropdown-header">
                            {{ __('Samples') }}
                        </h6>
                        <x-dropdown-link href="{{ route('sampletypes') }}">
                            {{ __('Sample Types') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('sizes') }}">
                            {{ __('Sizes') }}
                        </x-dropdown-link>
                        <x-dropdown-link href="{{ route('gauges') }}">
                            {{ __('Gauges') }}
                        </x-dropdown-link>
                    </x-slot>
                </x-dropdown>
            </ul>

            <!-- Right Side Of Navbar -->
            <ul class="navbar-nav align-items-baseline">
                <!-- Teams Dropdown -->
                @can('rt:admin')
                    @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
                        <x-dropdown id="teamManagementDropdown">
                            <x-slot name="trigger">
                                {{ Auth::user()->currentTeam->name }}

                                <svg class="ms-2" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </x-slot>

                            <x-slot name="content">
                                @if(TRUE)
                                    <!-- Team Management -->
                                    <h6 class="dropdown-header">
                                        {{ __('Manage Teams') }}
                                    </h6>

                                    @foreach(Auth::user()->allTeams() as $team)
                                        <x-dropdown-link href="{{ route('teams.show', $team->id) }}">
                                            {{ __($team->name) }}
                                        </x-dropdown-link>
                                    @endforeach
                                    <hr>
                                    <h6 class="dropdown-header">
                                        {{ __('Create Team') }}
                                    </h6>
                                    @can('create', Laravel\Jetstream\Jetstream::newTeamModel())
                                        <x-dropdown-link href="{{ route('teams.create') }}">
                                            {{ __('Create New Team') }}
                                        </x-dropdown-link>
                                    @endcan
                                @endif
                            </x-slot>
                        </x-dropdown>
                    @endif
                @endcan

                <!-- Settings Dropdown -->
                @auth
                    <x-dropdown id="settingsDropdown">
                        <x-slot name="trigger">
                            @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                                <img class="rounded-circle" width="32" height="32" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                            @else
                                {{ Auth::user()->name }}

                                <svg class="ms-2" width="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            @endif
                        </x-slot>

                        <x-slot name="content">
                            <!-- Account Management -->
                            <h6 class="dropdown-header small text-muted">
                                {{ __('Manage Account') }}
                            </h6>

                            <x-dropdown-link href="{{ route('profile.show') }}">
                                {{ __('Profile') }}
                            </x-dropdown-link>

                            @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                                <x-dropdown-link href="{{ route('api-tokens.index') }}">
                                    {{ __('API Tokens') }}
                                </x-dropdown-link>
                            @endif

                            <hr class="dropdown-divider">

                            <!-- Authentication -->
                            <x-dropdown-link href="{{ route('logout') }}"
                                                 onclick="event.preventDefault();
                                                         document.getElementById('logout-form').submit();">
                                {{ __('Log out') }}
                            </x-dropdown-link>
                            <form method="POST" id="logout-form" action="{{ route('logout') }}">
                                @csrf
                            </form>
                        </x-slot>
                    </x-dropdown>
                @endauth
            </ul>
        </div>
    </div>
</nav>
