<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <meta name="x-apple-disable-message-reformatting">
  <style>
    table, td, div, h1, p {font-family: Arial, sans-serif;}
  </style>
</head>
<body style="margin:0;padding:0;">
  <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;background:#ffffff;">
    <tr>
      <td align="center" style="padding:0;">
        <table role="presentation" style="width:602px;border-collapse:collapse;border:1px solid #cccccc;border-spacing:0;text-align:left;">
          <tr>
            <td align="center" style="background:#5d5f56;">
              <img src="https://roberttodds.com/images/logo-white.png" alt="" width="400" style="height:auto;display:block;" />
            </td>
          </tr>
          <tr>
            <td style="padding:36px 30px 42px 30px;">
              <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;">
                <tr>
                  <td style="padding:0 0 36px 0;color:#153643;">
                    <h1>Yarn Order Details</h1>
                    <ul style="list-style-type: none; padding: 0; margin: 0;">
                        <li>Customer: {{$order->customer_agents->customers->name}} - {{$order->customer_agents->name}}</li>
                        <li>Customer VAT: {{$order->customer_agents->customers->vat}}</li>
                        <li>Customer EORI: {{$order->customer_agents->customers->eori}}</li>
                        <li>Season: {{ $order->y_c_order_lines->first()->y_c_yarn_seasons->seasons->description }}</li>
                        <li>Spinner: {{ $order->y_c_order_lines->first()->y_c_yarn_seasons->yarn->suppliers->name }}</li>
                        <li>Delivery Address: {{ preg_replace('#\s+#',',',trim($order->address)) }}</li>
                        <li>Order Notes: {{($order->notes)}}</li>
                    </ul>
                    <br>
                    <br>

                    {{-- <p style="white-space: pre-wrap">{{($order->notes)}}</p> --}}
                    <table style="width: 100%; border-collapse: collapse;" cellpadding="0">
                        <thead>
                            {{-- <th style="border-bottom: 2px solid black; padding: 5px">Spinner</th> --}}
                            <th style="border-bottom: 2px solid black; padding: 5px">Yarn</th>
                            <th style="border-bottom: 2px solid black; padding: 5px">List Price</th>
                            <th style="border-bottom: 2px solid black; padding: 5px">Swatch</th>
                            <th style="border-bottom: 2px solid black; padding: 5px">Card</th>
                            <th style="border-bottom: 2px solid black; padding: 5px">Cone</th>
                            <th style="border-bottom: 2px solid black; padding: 5px">Part Cone</th>
                            <th style="border-bottom: 2px solid black; padding: 5px">Notes</th>
                        </thead>
                        <tbody>
                            @foreach ($order->y_c_order_lines as $line)
                                <tr>
                                    {{-- <td style="border-bottom: 1px solid grey; padding: 5px">{{$line->y_c_yarn_seasons->yarn->suppliers->name}}</td> --}}
                                    <td style="border-bottom: 1px solid grey; padding: 5px">{{$line->y_c_yarn_seasons->yarn->description}} {{$line->y_c_yarn_seasons->yarn->counts->count}}</td>
                                    <td style="border-bottom: 1px solid grey; padding: 5px">{{$line->y_c_yarn_seasons->yarn->suppliers->currency}}{{number_format($line->y_c_yarn_seasons->price, 2)}}</td>
                                    <td style="border-bottom: 1px solid grey; padding: 5px; text-align: center">@if($line->swatch) Y @endif</td>
                                    <td style="border-bottom: 1px solid grey; padding: 5px; text-align: center">@if($line->card) Y @endif</td>
                                    <td style="border-bottom: 1px solid grey; padding: 5px; text-align: center">@if($line->cone) Y @endif</td>
                                    <td style="border-bottom: 1px solid grey; padding: 5px; text-align: center">@if($line->part_cone) Y @endif</td>
                                    <td style="border-bottom: 1px solid grey; padding: 5px">{{$line->notes}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td style="padding:30px;background:#5d5f56;">
              <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;font-size:9px;font-family:Arial,sans-serif;">
                <tr>
                  <td style="padding:0;width:50%;" align="left">

                  </td>
                  <td style="padding:0;width:50%;" align="right">

                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</body>
</html>
