<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="x-apple-disable-message-reformatting">
    <style>
        table, td, div, h1, p {font-family: Arial, sans-serif;}
    </style>
</head>
<body style="margin:0;padding:0;">
    <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;background:#ffffff;">
        <tr>
            <td align="center" style="padding:0;">
                <table role="presentation" style="width:602px;border-collapse:collapse;border:1px solid #cccccc;border-spacing:0;text-align:left;">
                    <tr>
                        <td align="center" style="background:#5d5f56;">
                            <img src="https://roberttodds.com/images/logo-white.png" alt="" width="400" style="height:auto;display:block;" />
                        </td>
                    </tr>
                    <tr>
                        <td style="padding:36px 30px 42px 30px;">
                            <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;">
                                <tr>
                                    <td style="padding:0 0 36px 0;color:#153643;">
                                        <h1 style="margin:0 0 20px 0;color:#28a745;">New Customer Created</h1>
                                        <p style="margin:0 0 20px 0;font-size:14px;color:#666;">
                                            A new customer has been added to the system by <strong>{{ $createdBy }}</strong>.
                                        </p>
                                        
                                        <h2 style="margin:30px 0 15px 0;color:#333;font-size:18px;border-bottom:2px solid #eee;padding-bottom:10px;">Customer Details</h2>
                                        <table style="width:100%;border-collapse:collapse;" cellpadding="0">
                                            <tr>
                                                <td style="padding:8px 0;color:#666;width:40%;">Name:</td>
                                                <td style="padding:8px 0;color:#333;font-weight:bold;">{{ $customer->name }}</td>
                                            </tr>
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Country:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $customer->countries->country ?? 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Currency:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $customer->currency }}</td>
                                            </tr>
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">VAT Number:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $customer->vat ?? 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Finance Email:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $customer->finance_email ?? 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Phone:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $customer->phone ?? 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Factored:</td>
                                                <td style="padding:8px 0;color:#333;">
                                                    @if($customer->factored)
                                                        <span style="background:#28a745;color:white;padding:2px 8px;border-radius:3px;font-size:12px;">Yes</span>
                                                    @else
                                                        <span style="background:#6c757d;color:white;padding:2px 8px;border-radius:3px;font-size:12px;">No</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                        
                                        @if($customer->customer_payment_terms->count() > 0)
                                        <h2 style="margin:30px 0 15px 0;color:#333;font-size:18px;border-bottom:2px solid #eee;padding-bottom:10px;">Payment Terms</h2>
                                        <table style="width:100%;border-collapse:collapse;" cellpadding="0">
                                            @foreach($customer->customer_payment_terms as $term)
                                            <tr>
                                                <td style="padding:8px 0;color:#333;">
                                                    {{ $term->percentage }}% due in {{ $term->days }} days
                                                </td>
                                            </tr>
                                            @endforeach
                                        </table>
                                        @endif
                                        
                                        @if($customer->customer_addresses->count() > 0)
                                        <h2 style="margin:30px 0 15px 0;color:#333;font-size:18px;border-bottom:2px solid #eee;padding-bottom:10px;">Address</h2>
                                        @foreach($customer->customer_addresses as $address)
                                        <table style="width:100%;border-collapse:collapse;margin-bottom:15px;" cellpadding="0">
                                            <tr>
                                                <td style="padding:8px 0;color:#666;width:40%;">Address Name:</td>
                                                <td style="padding:8px 0;color:#333;font-weight:bold;">{{ $address->name }}</td>
                                            </tr>
                                            @if($address->line1)
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Address:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $address->line1 }}</td>
                                            </tr>
                                            @endif
                                            @if($address->city)
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">City:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $address->city }}</td>
                                            </tr>
                                            @endif
                                            @if($address->postcode)
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Postcode:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $address->postcode }}</td>
                                            </tr>
                                            @endif
                                            <tr>
                                                <td style="padding:8px 0;color:#666;">Country:</td>
                                                <td style="padding:8px 0;color:#333;">{{ $address->countries->country ?? 'N/A' }}</td>
                                            </tr>
                                        </table>
                                        @endforeach
                                        @endif
                                        
                                        <div style="margin:30px 0;text-align:center;">
                                            <a href="{{ $customerUrl }}" 
                                               style="display:inline-block;padding:12px 30px;background:#007bff;color:#ffffff;text-decoration:none;border-radius:5px;font-weight:bold;">
                                                View Customer in Loop
                                            </a>
                                        </div>
                                        
                                        <p style="margin:30px 0 0 0;font-size:12px;color:#999;">
                                            Created on {{ now()->format('d M Y \a\t H:i') }}
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding:30px;background:#5d5f56;">
                            <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;font-size:9px;font-family:Arial,sans-serif;">
                                <tr>
                                    <td style="padding:0;width:50%;color:#fff;" align="left">
                                        Robert Todd's Ltd
                                    </td>
                                    <td style="padding:0;width:50%;color:#fff;" align="right">
                                        This is an automated notification from Loop
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>




































