<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <meta name="x-apple-disable-message-reformatting">
  <style>
    table, td, div, h1, p {font-family: Arial, sans-serif;}
  </style>
</head>
<body style="margin:0;padding:0;">
  <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;background:#ffffff;">
    <tr>
      <td align="center" style="padding:0;">
        <table role="presentation" style="width:602px;border-collapse:collapse;border:1px solid #cccccc;border-spacing:0;text-align:left;">
          <tr>
            <td align="center" style="background:#4a1942;">
              <img src="https://roberttodds.com/images/logo-white.png" alt="" width="400" style="height:auto;display:block;" />
            </td>
          </tr>
          <tr>
            <td style="padding:36px 30px 42px 30px;">
              <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;">
                <tr>
                  <td style="padding:0 0 20px 0;color:#153643;">
                    <h2 style="margin:0 0 20px 0;font-size:24px;color:#4a1942;">Commission Invoice Ready</h2>
                    <p style="margin:0 0 12px 0;font-size:16px;line-height:24px;">
                      A commission invoice has been sent to finance by <strong>{{ $senderName }}</strong>.
                    </p>
                  </td>
                </tr>
                <tr>
                  <td style="padding:20px;background:#f8f9fa;border-radius:8px;">
                    <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;">
                      <tr>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;">
                          <strong style="color:#6b7280;">Customer:</strong>
                        </td>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;text-align:right;">
                          {{ $invoice->customer?->name ?? 'Unknown' }}
                        </td>
                      </tr>
                      <tr>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;">
                          <strong style="color:#6b7280;">Reference:</strong>
                        </td>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;text-align:right;">
                          {{ $invoice->reference ?? '—' }}
                        </td>
                      </tr>
                      @if($invoice->supplier_invoice_ref)
                      <tr>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;">
                          <strong style="color:#6b7280;">Supplier Ref:</strong>
                        </td>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;text-align:right;">
                          {{ $invoice->supplier_invoice_ref }}
                        </td>
                      </tr>
                      @endif
                      <tr>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;">
                          <strong style="color:#6b7280;">Invoice Date:</strong>
                        </td>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;text-align:right;">
                          {{ $invoice->invoice_date?->format('d M Y') ?? '—' }}
                        </td>
                      </tr>
                      <tr>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;">
                          <strong style="color:#6b7280;">Drops:</strong>
                        </td>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;text-align:right;">
                          {{ $invoice->drops()->count() }}
                        </td>
                      </tr>
                      <tr>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;">
                          <strong style="color:#6b7280;">Total Qty:</strong>
                        </td>
                        <td style="padding:8px 0;border-bottom:1px solid #e5e7eb;text-align:right;">
                          {{ number_format($invoice->total_qty ?? 0) }}
                        </td>
                      </tr>
                      <tr>
                        <td style="padding:12px 0 8px 0;">
                          <strong style="color:#6b7280;font-size:16px;">Total Value:</strong>
                        </td>
                        <td style="padding:12px 0 8px 0;text-align:right;">
                          <strong style="color:#059669;font-size:18px;">£{{ number_format($invoice->total_value ?? 0, 2) }}</strong>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
                @if($invoice->notes)
                <tr>
                  <td style="padding:20px 0 0 0;">
                    <p style="margin:0;font-size:14px;color:#6b7280;"><strong>Notes:</strong></p>
                    <p style="margin:8px 0 0 0;font-size:14px;color:#374151;">{{ $invoice->notes }}</p>
                  </td>
                </tr>
                @endif
                <tr>
                  <td style="padding:30px 0 0 0;text-align:center;">
                    <a href="{{ url('/commission/sl-invoicing') }}" 
                       style="display:inline-block;padding:12px 24px;background:#4a1942;color:#ffffff;text-decoration:none;border-radius:6px;font-weight:bold;">
                      View in SL Invoicing
                    </a>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td style="padding:30px;background:#4a1942;">
              <table role="presentation" style="width:100%;border-collapse:collapse;border:0;border-spacing:0;font-size:9px;font-family:Arial,sans-serif;">
                <tr>
                  <td style="padding:0;color:#ffffff;" align="center">
                    Commission Invoice Notification - Robert Todd's
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</body>
</html>



