<div>
    @if(!$zohoConnected)
    <button class="btn btn-light w-100" wire:click="initiateZohoOAuth">Connect Zoho</button>
    @else
        <select class="form-select mb-2" wire:model.live="customerInvoice"  wire:loading.class="hidden">
            <option selected value="">All Customers</option>
            @foreach($customers as $cust)
                <option value="{{ $cust->id }}">{{ $cust->name }}</option>
            @endforeach
        </select>
        <select class="form-select mb-2" wire:model.live="supplier"  wire:loading.class="hidden">
            <option selected value="">Supplier</option>
            @if(!empty($this->suppliers))
                @foreach($this->suppliers as $supplier)
                    <option value="{{ $supplier['name'] ?? $supplier }}">{{ $supplier['name'] ?? $supplier }}</option>
                @endforeach
            @else
                <option value="" disabled>No suppliers available</option>
            @endif
        </select>
        <input type="date" class="form-select mb-2" wire:model.live="date"  wire:loading.class="hidden">
        <div class="d-flex gap-2 mb-2">
            <button class="btn btn-light flex-grow-1" wire:click="sendInvoices" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                <span wire:loading.remove>Send Invoices</span>
                <span wire:loading>
                    <i class="fas fa-spinner fa-spin me-2"></i>
                    Processing Invoices...
                </span>
            </button>
            <button class="btn btn-outline-secondary" wire:click="clearZohoCache" wire:loading.attr="disabled" title="Clear cached Zoho data">
                <i class="fas fa-sync-alt"></i>
            </button>
        </div>
        
        <!-- Flash Messages -->
        @if(Session::has('message'))
            <div class="alert {{ Session::get('alert-class', 'alert-info') }} mt-3" role="alert">
                <div style="white-space: pre-wrap;">{{ Session::get('message') }}</div>
            </div>
        @endif
        
        <!-- Loading Progress -->
        <div wire:loading class="mt-3">
            <div class="alert alert-info">
                <div class="d-flex align-items-center mb-2">
                    <div class="spinner-border spinner-border-sm me-2" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <span>Creating {{ $totalInvoices }} invoice(s) in Zoho, please wait...</span>
                </div>
                <div class="progress" style="height: 20px;">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" 
                         role="progressbar" 
                         style="width: 100%" 
                         aria-valuenow="100" 
                         aria-valuemin="0" 
                         aria-valuemax="100">
                        Processing...
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Completion Modal -->
        @if($showCompletionModal)
            <div class="modal fade show d-block" style="background-color: rgba(0,0,0,0.5);" tabindex="-1">
                <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable" style="max-width: 90vw;">
                    <div class="modal-content">
                        <div class="modal-header bg-success text-white">
                            <h5 class="modal-title">
                                <i class="fas fa-check-circle me-2"></i>
                                Invoice Creation Complete
                            </h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="refresh"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-success">
                                <div class="mb-3">
                                    <strong>{{ $completionMessage }}</strong>
                                </div>
                                
                                @if(!empty($createdInvoices))
                                    <div class="mb-3">
                                        <strong>Created Invoice Numbers:</strong>
                                        <div class="mt-2">
                                            @foreach($createdInvoices as $invoiceNo)
                                                <span class="badge bg-success me-1 mb-1">{{ $invoiceNo }}</span>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                                
                                @if(!empty($addressWarnings))
                                    <div class="mb-3">
                                        <strong class="text-warning">Address Warnings:</strong>
                                        <div class="mt-2">
                                            @foreach($addressWarnings as $warning)
                                                <div class="alert alert-warning py-2 mb-2">
                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                    {{ $warning }}
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                                
                                @if(!empty($tagWarnings))
                                    <div class="mb-3">
                                        <strong class="text-warning">Reporting Tag Warnings:</strong>
                                        <div class="mt-2">
                                            @foreach($tagWarnings as $warning)
                                                <div class="alert alert-warning py-2 mb-2">
                                                    <i class="fas fa-tag me-2"></i>
                                                    {{ $warning }}
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-success" wire:click="refresh">
                                <i class="fas fa-check me-2"></i>
                                Close & Continue
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        

    @endif
</div>


@script
    <script>
        window.addEventListener('open-zoho-oauth-popup', event => {
            const popup = window.open(event.detail.url, 'Zoho OAuth', 'width=600,height=600');

            // Periodically check if the popup is closed
            const checkPopupClosed = setInterval(() => {
                if (popup.closed) {
                    clearInterval(checkPopupClosed); // Stop checking
                    console.log('Popup closed');
                    @this.refresh();
                    // You can trigger any event or logic here
                    // window.dispatchEvent(new CustomEvent('zoho-oauth-popup-closed')); // Custom event to handle closure
                }
            }, 500); // Check every 500 milliseconds
        });

        // Listen for the custom event when the popup is closed
        window.addEventListener('zoho-oauth-popup-closed', () => {
            console.log('OAuth process completed or window closed.');
            // Handle any logic you need here
        });
    </script>
@endscript
