<div>
    @if ($authInProgress)
        <p>Authenticating with Zoho Books...</p>
    @else
        <a href="{{ $authUrl }}" class="btn btn-primary">Connect to Zoho Books</a>
    @endif

    @if ($errorMessage)
        <div class="alert alert-danger">{{ $errorMessage }}</div>
    @endif

    <input type="hidden" id="zoho-callback-data" name="zoho-callback-data" value="">
</div>

@script
    <script>
        window.addEventListener('load', function() {
            window.addEventListener('message', function(event) {
                if (event.origin === 'https://accounts.zoho.eu') {
                    document.getElementById('zoho-callback-data').value = event.data;
                    Livewire.emit('zohoAuthCallback', event.data);
                }
            });
        });
    </script>
@endscript
