<x-slot name="header">
	<h2 class="font-semibold text-xl text-gray-800 leading-tight">
		{{ __('Yarn Orders') }}
	</h2>
</x-slot>
<div>
	<main>
		<div class="container p-0 bg-light">
			<div class="row">
				<div class="col-12">
					@if (Session::get('message'))
						<div class="alert {{ Session::get('alert-class') }}" role="alert">
							{{ Session::get('message') }}
						</div>
					@endif
				</div>
			</div>
			<div class="row">
				<div class="col-md-3">
					<div class="form-floating my-3">
						<select class="form-select" wire:model.lazy="filter.spinner">
							<option selected value="">All</option>
							@foreach($spinners as $spinner)
								<option value="{{ $spinner->id }}">{{ $spinner->name }}</option>
							@endforeach
						</select>
						<label class="form-label">Spinner:</label>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="row mt-3">
					<div class="col-lg-4">

					</div>
					<div class="col">
						<div class="d-flex flex-row-reverse">
							<div class="form-check form-switch form-check-float-height-3">
								<input class="form-check-input" type="checkbox" wire:model.lazy="filter.cancelled">
								<label>Cancelled</label>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="table">
					<table id="tableSort" class="table align-middle">
						<thead>
							<tr>
								<th onclick="sortTable(0)">PROD</th>
								<th onclick="sortTable(1)">Date</th>
								<th onclick="sortTable(2)">Spinner</th>
								<th onclick="sortTable(3)">Yarns</th>
								<th onclick="sortTable(4)">Customer(s)</th>
								<th style="width: 1px;"></th>
							</tr>
						</thead>
						<tbody>
							@foreach($yarnOrders as $yarnOrder)
									<tr>
										<td>{{ $yarnOrder->prod }}</td>
										<td>{{ $yarnOrder->date }}</td>
										<td>{{ $yarnOrder->spinner }}</td>
                                        <td>
                                            <table class="table table-sm" style="table-layout: fixed; width: 100%;">
                                                <tbody>
                                                    @foreach(json_decode($yarnOrder->lines) as $i=>$line)
                                                        <tr>
                                                            <td style="width: 10%">{{ $line->qty }}kg</td>
                                                            <td style="width: 25%">{{ $line->yarn }}</td>
                                                            <td style="width: 10%">{{ $line->count }}</td>
                                                            <td style="width: 20%">{{ $line->colour }}</td>
                                                            <td style="width: 55%; overflow: auto; -ms-overflow-style: none; /* for Internet Explorer, Edge */
                                                            scrollbar-width: none; /* for Firefox */">{{ $line->styles }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
										</td>
										<td>
											{{ $yarnOrder->customer }}
										</td>
										<td>
											<div class="btn-group-vertical">
												@if(Gate::check('finance:update'))
													<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#financeModal" wire:click.prevent="financeView({{$yarnOrder->prod}})">Invoices</button>
												@endif
												@if(Gate::check('order:update'))
													<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#editModal" wire:click.prevent="edit({{$yarnOrder->prod}})">Edit</button>
												@endif
												<a class="btn btn-primary" href="/yarn-order-po/{{$yarnOrder->prod}}">PO</a>
											</div>
										</td>
									</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<footer class="mt-auto fixed-bottom bg-white border-top navbar navbar-light py-3">
			<div class="container">
				<div class="row w-100 align-items-center">
					<div class="col-lg-6">
						<livewire:footer />
					</div>
					<div class="col-lg-6 text-end">
						@if(Gate::check('order:create'))
							<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#newModal" wire:click.prevent="new()">New</button>
						@endif
					</div>
				</div>
			</div>
		</footer>
	</main>
	{{-- EDIT --}}
	<div wire:ignore.self class="modal fade" id="editModal" data-bs-backdrop="static"  tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="false">
		<div class="modal-dialog modal-fullscreen">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="editModalLabel">Edit Yarn Order: @if($edit) PROD{{$orderSelected->id}} @endif</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click.prevent="closeEdit"></button>
				</div>
				<div class="modal-body">
						<div class="row">
							<div class="col-12">
								@if (Session::get('message'))
									<div class="alert {{ Session::get('alert-class') }}" role="alert">
										{{ Session::get('message') }}
									</div>
								@endif
							</div>
						</div>
						<div class="row">
							<div class="col-12">
								@if($edit && (Gate::check('order:update') || Gate::check('order:create')))
									<form>
										<div class="row">
											<div class="col">
												<div class="form-floating mb-3">
													<select class="form-select @error('orderSelected.*') is-valid @enderror @error('orderSelected.suppliers_id') is-invalid @enderror" wire:model.lazy="orderSelected.suppliers_id">
														<option selected disabled value="">Choose...</option>
														@foreach($spinners as $supplier)
															<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
														@endforeach
													</select>
													<label class="form-label">Spinner:</label>
													<div class="invalid-feedback">@error('orderSelected.suppliers_id') {{ $message }} @enderror</div>
												</div>
											</div>
											<div class="col">
												<div class="form-floating mb-3">
													<select class="form-select @error('orderSelected.*') is-valid @enderror @error('orderSelected.invoice_to_id') is-invalid @enderror" wire:model.lazy="orderSelected.invoice_to_id">
														<option selected value="">Choose...</option>
														@foreach($suppliers->sortby('name') as $supplier)
															<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
														@endforeach
													</select>
													<label class="form-label">Invoice To:</label>
													<div class="invalid-feedback">@error('orderSelected.invoice_to_id') {{ $message }} @enderror</div>
												</div>
											</div>
											<div class="col">
												<div class="form-floating mb-3">
													<select class="form-select @error('orderSelected.*') is-valid @enderror @error('orderSelected.deliver_to_id') is-invalid @enderror" wire:model.lazy="orderSelected.deliver_to_id">
														<option selected value="">Choose...</option>
														@foreach($suppliers->sortby('name') as $supplier)
															<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
														@endforeach
													</select>
													<label class="form-label">Deliver To:</label>
													<div class="invalid-feedback">@error('orderSelected.deliver_to_id') {{ $message }} @enderror</div>
												</div>
											</div>
											<div class="col">
												<div class="form-floating mb-3">
													<input type="date" class="form-control @error('orderSelected.*') is-valid @enderror @error('orderSelected.date') is-invalid @enderror" wire:model.lazy="orderSelected.date">
													<label class="form-label">Date:</label>
													<div class="invalid-feedback">@error('orderSelected.date') {{ $message }} @enderror</div>
												</div>
											</div>
											<div class="col">
												<div class="btn-group">
													<input style="height: calc(3.5rem + 2px);" multiple type="file"  class="form-control @error('shipment.*') is-valid @enderror @error('uploadFiles') is-invalid @enderror" wire:model.lazy="uploadFiles">
													<button style="height: calc(3.5rem + 2px);" class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">View</button>
													<ul class="dropdown-menu dropdown-menu-end">
														@foreach($orderSelected->yarn_order_files as $file)
															<li><a download class="dropdown-item" href="{{url(asset('storage/' . $file->file))}}">{{ $file->filename }}</a></li>
														@endforeach
													</ul>
												</div>
												<div class="invalid-feedback">@error('uploadFiles') {{ $message }} @enderror</div>
											</div>
                                            <div class="col">
												<div class="form-floating mb-3">
													<select class="form-select @error('orderSelected.*') is-valid @enderror @error('orderSelected.customers_id') is-invalid @enderror" wire:model.lazy="orderSelected.customers_id">
														<option selected value="">Choose...</option>
														@foreach($customers->sortby('name') as $supplier)
															<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
														@endforeach
													</select>
													<label class="form-label">Customer:</label>
													<div class="invalid-feedback">@error('orderSelected.customers_id') {{ $message }} @enderror</div>
												</div>
											</div>
										</div>
										<div class="row mb-3">
											<div class="col">
												<textarea class="form-control" wire:model="orderSelected.comments"></textarea>
											</div>
										</div>
										<div class="row">
											<div class="col-12">
												<div class="table-responsive">
													<table style="table-layout: fixed; width: 100%;" id="tableSort" class="table text-center align-middle">
														<thead>
															<tr>
																<th onclick="sortTable(0)">Yarn</th>
																<th onclick="sortTable(1)">Colour</th>
																<th onclick="sortTable(2)">Qty (KG)</th>
																<th onclick="sortTable(4)">ExMill</th>
																<th onclick="sortTable(5)">Confirmed ExMill</th>
																<th onclick="sortTable(6)">Delivery</th>
																{{-- <th onclick="sortTable(9)">Invoice / Delivery</th> --}}
																<th style="width:30%;" onclick="">Customer | Order | Colourway</th>
																<th style="width:100px"></th>
															</tr>
														</thead>
														<tbody>
															@foreach($lines as $i=>$line)
																	<tr>
																		<td>
																			<select class="form-select @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.yarn_id') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.yarn_id">
																				<option selected value="">Choose...</option>
																				@foreach($yarns as $yarn)
																					<option value="{{ $yarn->id }}">{{ $yarn->yarn_code }} {{ $yarn->description }} {{ $yarn->counts->count }}</option>
																				@endforeach
																			</select>
																		</td>
																		<td>
																			<select class="form-select @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.yarn_colours_id') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.yarn_colours_id">
																				<option selected value="">Choose...</option>
																				@if(array_key_exists('yarn_id', $lines[$i]) && $lines[$i]['yarn_id'] != NULL)
																					@if(!empty($yarns->find($lines[$i]['yarn_id'])))
																						@foreach($yarns->find($lines[$i]['yarn_id'])->yarn_colours as $colour)
																							<option value="{{ $colour->id }}">{{ $colour->reference }} {{ $colour->description }}</option>
																						@endforeach
																					@endif
																				@endif
																			</select>
																		</td>
																		<td><input type="text" class="form-control @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.qty') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.qty"></td>
																		<td><input type="date" class="form-control @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.ship_date') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.ship_date"></td>
																		<td><input type="date" class="form-control @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.actual_ship_date') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.actual_ship_date"></td>
																		{{-- <td>{{ print_r($line['ship_date']) }}</td> --}}
																		<td><input type="date" class="form-control @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.delivery_date') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.delivery_date"></td>
																		{{-- <td>
																			<select class="form-select @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.invoiceto_id') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.invoiceto_id">
																				<option selected value="">Choose...</option>
																				@foreach($suppliers->sortby('name') as $supplier)
																					<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
																				@endforeach
																			</select>
																			<select class="mt-1 form-select @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.deliver_to_id') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.deliver_to_id">
																				<option selected value="">Choose...</option>
																				@foreach($suppliers->sortby('name') as $supplier)
																					<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
																				@endforeach
																			</select>
																		</td> --}}
																		<td style="min-width: 300px">
																			@if(!empty($line['styles']))
																				@foreach($line['styles'] as $x=>$style)
																					<div class="input-group mt-1">
																						<select class="form-select @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.styles.{{$x}}.customer_id') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.styles.{{$x}}.customer_id">
																							<option selected value="">Choose...</option>
																							@if(array_key_exists('yarn_colours_id', $line) && $line['yarn_colours_id'] != NULL)
																								@foreach($this->getCustomers($line['yarn_colours_id']) as $customer)
																									<option value="{{ $customer->id }}">{{ $customer->name }}</option>
																								@endforeach
																							@endif
																						</select>
																						<select class="form-select @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.styles.{{$x}}.cust_order_id') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.styles.{{$x}}.cust_order_id">
																							<option selected value="">Choose...</option>
																							@if(array_key_exists('customer_id', $lines[$i]['styles'][$x]) && array_key_exists('yarn_colours_id', $line))
																								@foreach($this->getOrders($this->lines[$i]['styles'][$x]['customer_id'], $line['yarn_colours_id']) as $order)
																									<option value="{{ $order->id }}">{{ $order->customer_po }}</option>
																								@endforeach
																							@endif
																						</select>
																						<select class="form-select @error('orderSelected.*') is-valid @enderror @error('lines.{{$i}}.styles.{{$x}}.customer_order_lines_id') is-invalid @enderror" wire:model.lazy="lines.{{$i}}.styles.{{$x}}.customer_order_lines_id">
																							<option selected value="">Choose...</option>
																							@if(array_key_exists('cust_order_id', $lines[$i]['styles'][$x]) && array_key_exists('yarn_colours_id', $line))
																								@foreach($this->getCustOrderLines($this->lines[$i]['styles'][$x]['cust_order_id'], $line['yarn_colours_id']) as $order_line)
																									<option value="{{ $order_line->id }}">{{ $order_line->colourways->style_versions->styles->customer_ref }} {{ $order_line->colourways->name }}</option>
																								@endforeach
																							@endif
																						</select>
																						{{-- @if(!empty($line['yarn_colours_id']))
																							<input class="form-control" type="text" disabled value="{{ $orderSelected->suppliers->currency }}{{ $this->getColourway($this->lines[$i]['styles'][$x]['cust_order_id'], $line['yarn_colours_id']) }}">
																						@endif --}}
																						<a target="_blank" class="btn btn-primary" href="https://knit.roberttodds.com/editstyle?styleID={{ $this->getStyle($this->lines[$i]['styles'][$x]['customer_order_lines_id']) }}">></a>
																						<button class="btn btn-danger" wire:click.prevent="deleteStyle({{$i}}, {{$x}})">X</button>
																					</div>
																				@endforeach
																			@endif
																		</td>
																		<td>
																			<button class="btn btn-primary" wire:click.prevent="addStyle({{$i}})">+</button>
																			{{-- <button class="btn btn-primary" wire:click.prevent="test({{$this->lines[$i]['styles'][$x]['customer_id']}}, {{$line['yarn_colours_id']}})">TEST</button> --}}

																			<button class="btn btn-danger" wire:click.prevent="deleteLine({{$i}}, @if(array_key_exists('id', $line)) {{$line['id']}} @endif)">X</button>
																		</td>
																	</tr>
															@endforeach
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</form>
								@endif
							</div>
						</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-bs-dismiss="modal" wire:click.prevent="closeEdit">Close</button>
					@if(Gate::check('order:update'))
						<button type="button" class="btn btn-primary" wire:click.prevent="newLine">Add Line</button>
						<button type="button" class="btn btn-success" wire:click.prevent="save">Save</button>
					@endif
				</div>
			</div>
		</div>
	</div>
	{{-- NEW --}}
	<div wire:ignore.self class="modal fade" id="newModal" data-bs-backdrop="static"  tabindex="-1" aria-labelledby="newModalLabel" aria-hidden="false">
		<div class="modal-dialog modal-fullscreen-sm-down">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="newModalLabel">New Yarn Order</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click.prevent="closeNew"></button>
				</div>
				<div class="modal-body">
					<div class="container">
						<div class="row">
							<div class="col-12">
								@if (Session::get('message'))
									<div class="alert {{ Session::get('alert-class') }}" role="alert">
										{{ Session::get('message') }}
									</div>
								@endif
							</div>
						</div>
						<div class="row">
							<div class="col-12">
								@if($new && (Gate::check('order:update') || Gate::check('order:create')))
									<form>
										<div class="row">
											<div class="col-12">
												<div class="form-floating mb-3">
													<select class="form-select @error('orderSelected.*') is-valid @enderror @error('orderSelected.suppliers_id') is-invalid @enderror" wire:model.lazy="orderSelected.suppliers_id">
														<option selected disabled value="">Choose...</option>
														@foreach($spinners as $supplier)
															<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
														@endforeach
													</select>
													<label class="form-label">Spinner:</label>
													<div class="invalid-feedback">@error('orderSelected.suppliers_id') {{ $message }} @enderror</div>
												</div>
												<div class="form-floating mb-3">
													<input type="date" class="form-control @error('orderSelected.*') is-valid @enderror @error('orderSelected.date">') is-invalid @enderror" wire:model.lazy="orderSelected.date">
													<label class="form-label">Date:</label>
													<div class="invalid-feedback">@error('orderSelected.date') {{ $message }} @enderror</div>

												</div>
												<div class="form-floating mb-3">
													<select class="form-select @error('orderSelected.*') is-valid @enderror @error('orderSelected.invoice_to_id') is-invalid @enderror" wire:model.lazy="orderSelected.invoice_to_id">
														<option selected value="">Choose...</option>
														@foreach($suppliers->sortby('name') as $supplier)
															<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
														@endforeach
													</select>
													<label class="form-label">Invoice To:</label>
													<div class="invalid-feedback">@error('orderSelected.invoice_to_id') {{ $message }} @enderror</div>
												</div>
												<div class="form-floating mb-3">
													<select class="form-select @error('orderSelected.*') is-valid @enderror @error('orderSelected.deliver_to_id') is-invalid @enderror" wire:model.lazy="orderSelected.deliver_to_id">
														<option selected value="">Choose...</option>
														@foreach($suppliers->sortby('name') as $supplier)
															<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
														@endforeach
													</select>
													<label class="form-label">Deliver To:</label>
													<div class="invalid-feedback">@error('orderSelected.deliver_to_id') {{ $message }} @enderror</div>
												</div>
											</div>
										</div>
									</form>
								@endif
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-bs-dismiss="modal" wire:click.prevent="closeNew">Close</button>
					@if(Gate::check('order:create'))
						<button type="button" class="btn btn-primary" wire:click.prevent="create">Create</button>
					@endif
				</div>
			</div>
		</div>
	</div>
		{{-- FINANCE --}}
		<div wire:ignore.self class="modal fade" id="financeModal" data-bs-backdrop="static"  tabindex="-1" aria-labelledby="financeModalLabel" aria-hidden="false">
			<div class="modal-dialog modal-fullscreen">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="financeModalLabel">Invoices for Yarn Order: @if($edit) PROD{{$orderSelected->id}} @endif</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click.prevent="closeFinance"></button>
					</div>
					<div class="modal-body">
							<div class="row">
								<div class="col-12">
									@if (Session::get('message'))
										<div class="alert {{ Session::get('alert-class') }}" role="alert">
											{{ Session::get('message') }}
										</div>
									@endif
								</div>
							</div>
							<div class="row">
								<div class="col-12">
									@if($invoices && Gate::check('finance:update'))
										<div class="card mb-3 w-100">
											<div class="card-header">Style Details</div>
											<div class="card-body">
												<div class="row">
													<div class="col">
														<div class="row align-items-center">
															<div class="col-sm-5">
																<h6 class="mb-0 fw-bold">Spinner</h6>
															</div>
															<div class="col-sm-7 text-secondary">{{$orderSelected->suppliers->name}}</div>
														</div>
													</div>
													<div class="col">
														<div class="row align-items-center">
															<div class="col-sm-5">
																<h6 class="mb-0 fw-bold">Invoice To</h6>
															</div>
															<div class="col-sm-7 text-secondary">{{$orderSelected->invoice_to->name}}</div>
														</div>
													</div>
													<div class="col">
														<div class="row align-items-center">
															<div class="col-sm-5">
																<h6 class="mb-0 fw-bold">Deliver To</h6>
															</div>
															<div class="col-sm-7 text-secondary">{{$orderSelected->deliver_to->name}}</div>
														</div>
													</div>
													<div class="col">
														<div class="row align-items-center">
															<div class="col-sm-5">
																<h6 class="mb-0 fw-bold">Date</h6>
															</div>
															<div class="col-sm-7 text-secondary">{{$orderSelected->date}}</div>
														</div>
													</div>
													<div class="col">
														<div class="row align-items-center">
															<div class="col-sm-5">
																<h6 class="mb-0 fw-bold">Files</h6>
															</div>
															<div class="col-sm-7 text-secondary">
																@foreach($orderSelected->yarn_order_files as $file)
																	<div class="row"><a download class="dropdown-item" href="{{url(asset('storage/' . $file->file))}}">{{ $file->filename }}</a></div>
																@endforeach
															</div>
														</div>
													</div>
												</div>
												<hr>
												<div class="row mt-3">
													<div class="col">
														<div class="row align-items-center">
															<div><b>Notes</b></div>
															<div class="col-sm-7 text-secondary">{{$orderSelected->comments}}</div>
														</div>
													</div>
												</div>
											</div>
										</div>



										<form>
											<div class="row">
												<div class="col-12">
													<div class="table-responsive">
														<table style="table-layout: fixed; width: 100%;" id="tableSort" class="table text-center align-middle">
															<thead>
																<tr>
																	<th>Yarn</th>
																	<th>Colour</th>
																	<th>Qty (KG)</th>
																	<th>ExMill</th>
																	<th>Confirmed ExMill</th>
																	<th>Delivery</th>
																	<th>Invoice No</th>
																	<th>Invoiced Qty</th>
																	<th>Notes</th>
																	<th style="width: 500px">Customer | Order | Colourway</th>
																</tr>
															</thead>
															<tbody>
																@foreach($lines as $i=>$line)
																		<tr>
																			<td>{{ $line['yarn'] }}</td>
																			<td>{{ $line['colour'] }}</td>
																			<td>{{ $line['qty'] }}</td>
																			<td>{{ $line['ship_date'] }}</td>
																			<td>{{ $line['actual_ship_date'] }}</td>
																			<td>{{ $line['delivery_date'] }}</td>
																			<td><input class="form-control" type="text" wire:model.lazy="lines.{{$i}}.invoice_no"></td>
																			<td><input class="form-control" type="text" wire:model.lazy="lines.{{$i}}.invoiced_qty"></td>
																			<td><input class="form-control" type="text" wire:model.lazy="lines.{{$i}}.fn_notes"></td>
																			<td>
																				@if(!empty($line['styles']))
																					@foreach($line['styles'] as $s=>$style)
																						<table class="table">
																							@if(!empty($style['customer']))
																								<td>{{ $style['customer'] }}</td>
																								<td>{{ $style['order'] }}</td>
																								<td>{{ $style['style'] }}</td>
																							@endif
																						</table>
																					@endforeach
																				@endif
																			</td>
																		</tr>
																@endforeach
															</tbody>
														</table>
													</div>
												</div>
											</div>
										</form>
									@endif
								</div>
							</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-danger" data-bs-dismiss="modal" wire:click.prevent="closeFinance">Close</button>
						@if(Gate::check('finance:update'))
							<button type="button" class="btn btn-success" wire:click.prevent="saveFinance">Save</button>
						@endif
					</div>
				</div>
			</div>
		</div>

	<x-slot name="modalScripts">
		document.addEventListener('DOMContentLoaded', () => {
			var newModal = new bootstrap.Modal('#newModal');
			var editModal = new bootstrap.Modal('#editModal');
			var financeModal = new bootstrap.Modal('#financeModal');
			document.addEventListener('closeNewModal', () => {
				newModal.hide();
			});
			document.addEventListener('closeEditModal', () => {
				editModal.hide();
			});
			document.addEventListener('closefinanceModal', () => {
				financeModal.hide();
			});
		});
	</x-slot>
</div>

