<x-slot name="header">
	<h2 class="font-semibold text-xl text-gray-800 leading-tight">
		{{ __('Yarn Commissions') }}
	</h2>
</x-slot>
<x-slot name="css">
	<style>
        #headers{
            display: none;
        }
        main{
            margin-top: 20px !important;
        }
    </style>
</x-slot>
<div>
	<main>
		<div class="container p-0 bg-light">
			<div class="row">
				<div class="col">
					@if (Session::get('message'))
						<div class="alert {{ Session::get('alert-class') }}" role="alert">
							{{ Session::get('message') }}
						</div>
					@endif
				</div>
			</div>
			<div class="row">
				<div class="col">
                    <div class="row">
                        <div class="col">
                            @if(!$errors->isEmpty())
                                <div class="alert alert-danger">
                                    <ul class="list-unstyled mb-0">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                        </div>
                    </div>
                    @if(empty($season))
                        <div class="text-center" style="font-size: 2em;">
                            @foreach($this->getSeasons() as $season)
                                <a class="p-4 text-decoration-none" href="/" wire:click.prevent="$set('season', {{$season->id}})">{{$season->description}}</a>
                            @endforeach
                        </div>
                    @elseif(is_null($spinner))
                        <div class="text-center">
                            @foreach($this->getSpinners() as $supplier)
                                <a class="p-4" href="/" wire:click.prevent="$set('spinner', {{$supplier->id}})"><img style="width: 200px;padding: 20px;" src="{{url(asset('storage/' . $supplier->logo))}}" class="rounded" alt="{{ $supplier->name }}"></a>
                            @endforeach
                                <a class="p-4" href="/" wire:click.prevent="$set('spinner', 0)"><img style="width: 200px;padding: 20px;" src="https://cdn-icons-png.flaticon.com/512/5110/5110754.png" class="rounded" alt="All"></a>
                        </div>
                        {{$spinner}}
                    @else
                        @if($spinner != 0)
                            <div class="row">
                                <div class="col">
                                    <div class="card mb-3 w-100">
                                        <div class="card-header">Customer Details</div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col">
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="form-floating mb-3">
                                                                <select class="form-select @error("selectCustomer") is-invalid @enderror" wire:model.lazy="selectCustomer">
                                                                    <option selected value="">Choose...</option>
                                                                    @foreach($customers->sortBy('name') as $customer)
                                                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <label class="form-label">Customer:</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="form-floating mb-3">
                                                                <input type="date" class="form-control @error("selectCustomer") is-invalid @enderror" wire:model.lazy="newOrder.date">
                                                                <label class="form-label">Date:</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="form-floating mb-3">
                                                                <select class="form-select @error("newOrder.customer_agents_id") is-invalid @enderror" wire:model.lazy="newOrder.customer_agents_id">
                                                                    <option selected value="">Select</option>
                                                                    <option value="0">New</option>
                                                                    @if(!empty($selectCustomer))
                                                                        @foreach($customers->where('id', $selectCustomer)->first()->customer_agents->sortBy('name') as $agent)
                                                                            <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                                                        @endforeach
                                                                    @endif
                                                                </select>
                                                                <label class="form-label">Name:</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if(!empty($selectCustomer) && $newOrder->customer_agents_id == 0)
                                                        <hr>
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <div class="form-floating mb-3">
                                                                    <input type="text" class="form-control @error("newAgent.name") is-invalid @enderror" wire:model.lazy="newAgent.name">
                                                                    <label class="form-label">Name:</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <div class="form-floating mb-3">
                                                                    <input type="text" class="form-control @error("newAgent.email") is-invalid @enderror" wire:model.lazy="newAgent.email">
                                                                    <label class="form-label">Email:</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <div class="form-floating mb-3">
                                                                    <input type="text" class="form-control @error("newAgent.phone") is-invalid @enderror" wire:model.lazy="newAgent.phone">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col">
                                                    <label>Address</label>
                                                    <textarea class="form-control @error("newOrder.address") is-invalid @enderror" rows="5" wire:model.lazy="newOrder.address"></textarea>
                                                </div>
                                                <div class="col">
                                                    <label>Notes</label>
                                                    <textarea class="form-control @error("newOrder.notes") is-invalid @enderror" rows="5" wire:model.lazy="newOrder.notes"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="row">
                            <div class="col">
                                <div class="card mb-3 w-100">
                                    <div class="card-header">Yarn</div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col">
                                                <div class="form-floating mb-3">
                                                    <input type="text" class="form-control mb-3" wire:model.debounce.100ms="search">
                                                    <label>Search</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <table class="table align-middle">
                                                    <thead>
                                                        @if($spinner == 0)
                                                            <th>Spinner</th>
                                                        @endif
                                                        <th>Yarn</th>
                                                        <th>Count</th>
                                                        <th>Composition</th>
                                                        <th>Price</th>
                                                        <th>Swatch</th>
                                                        <th>Card</th>
                                                        <th>Cone</th>
                                                        <th>Part Cone</th>
                                                        <th>Notes</th>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($this->getyarns()->sortBy(['yarn.suppliers.name', 'yarn.description']) as $yarn)
                                                            <tr>
                                                                @if($spinner == 0)
                                                                    <td>{{ $yarn->yarn->suppliers->name }}</td>
                                                                @endif
                                                                <td>{{ $yarn->yarn->description }}</td>
                                                                <td>{{ $yarn->yarn->counts->count }}</td>
                                                                <td>
                                                                    @foreach($yarn->yarn->yarn_compositions as $material)
                                                                        {{ $material->percentage }}% {{ $material->materials->material }} <br>
                                                                    @endforeach
                                                                </td>
                                                                <td>{{ $yarn->yarn->suppliers->currency }}{{ number_format($yarn->price, 2) }}</td>
                                                                <td>
                                                                    <div class="form-check form-switch form-check-float-height-3">
                                                                        <input class="form-check-input" type="checkbox" wire:model="orderLines.{{$yarn->id}}.swatch">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-check form-switch form-check-float-height-3">
                                                                        <input class="form-check-input" type="checkbox" wire:model="orderLines.{{$yarn->id}}.card">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-check form-switch form-check-float-height-3">
                                                                        <input class="form-check-input" type="checkbox" wire:model="orderLines.{{$yarn->id}}.cone">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-check form-switch form-check-float-height-3">
                                                                        <input class="form-check-input" type="checkbox" wire:model="orderLines.{{$yarn->id}}.part_cone">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control" wire:model="orderLines.{{$yarn->id}}.notes">
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
				</div>
			</div>


		<footer class="mt-auto fixed-bottom bg-white border-top navbar navbar-light py-3">
			<div class="container">
				<div class="row w-100 align-items-center">
					<div class="col-lg-6">
						<livewire:footer />
					</div>
					<div class="col-lg-6 text-end">
						{{-- @if(Gate::check('order:create')) --}}
							<a class="btn btn-primary" href="/yc">Reset</a>
                        {{-- @endif --}}
                        @if(Gate::check('asdasd:create'))
							{{-- <button class="btn btn-primary" wire:click.prevent="test()">Run Import</button> --}}
                        @endif
                        @if($spinner != 0)
                            <button type="button" @if(!$errors->isEmpty()) disabled @endif class="btn btn-primary" wire:click.prevent="save">Send</button>
                        @endif
					</div>
				</div>
			</div>
		</footer>
	</main>

	{{-- NEW --}}
	<div wire:ignore.self class="modal fade" id="newModal" data-bs-backdrop="static"  tabindex="-1" aria-labelledby="newModalLabel" aria-hidden="false">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="newModalLabel">New Order</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click.prevent="close"></button>
				</div>
				<div class="modal-body">
					<div class="container">
						<div class="row">
							<div class="col-12">
                                @if(!$errors->isEmpty())
                                    <div class="alert alert-danger">
                                        <ul class="list-unstyled mb-0">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
							</div>
						</div>
                        @if($new || $edit)
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-floating mb-3">
                                                <select class="form-select @error("selectCustomer") is-invalid @enderror" wire:model.lazy="selectCustomer">
                                                    <option selected value="">Choose...</option>
                                                    @foreach($customers as $customer)
                                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                                    @endforeach
                                                </select>
                                                <label class="form-label">Customer:</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-floating mb-3">
                                                <input type="date" class="form-control @error("selectCustomer") is-invalid @enderror" wire:model.lazy="newOrder.date">
                                                <label class="form-label">Date:</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-floating mb-3">
                                                <select class="form-select @error("newOrder.customer_agents_id") is-invalid @enderror" wire:model.lazy="newOrder.customer_agents_id">
                                                    <option selected value="">Select</option>
                                                    <option value="0">New</option>
                                                    @if(!empty($selectCustomer))
                                                        @foreach($customers->where('id', $selectCustomer)->first()->customer_agents as $agent)
                                                            <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                <label class="form-label">Name:</label>
                                            </div>
                                        </div>
                                    </div>
                                    @if(!empty($selectCustomer) && $newOrder->customer_agents_id == 0)
                                        <hr>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-floating mb-3">
                                                    <input type="text" class="form-control @error("newAgent.name") is-invalid @enderror" wire:model.lazy="newAgent.name">
                                                    <label class="form-label">Name:</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-floating mb-3">
                                                    <input type="text" class="form-control @error("newAgent.email") is-invalid @enderror" wire:model.lazy="newAgent.email">
                                                    <label class="form-label">Email:</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-floating mb-3">
                                                    <input type="text" class="form-control @error("newAgent.phone") is-invalid @enderror" wire:model.lazy="newAgent.phone">
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <textarea class="form-control @error("newOrder.notes") is-invalid @enderror" rows="5" wire:model.lazy="newOrder.notes"></textarea>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col">
                                    <table class="table text-center">
                                        <thead>
                                            <th>Season</th>
                                            <th>Spinner</th>
                                            <th>Yarn</th>
                                            <th>Swatch</th>
                                            <th>Card</th>
                                            <th>Cone</th>
                                            <th>Part</th>
                                            <th>Notes</th>
                                            <th></th>
                                        </thead>
                                        <tbody>
                                            @foreach($orderLines as $l=>$line)
                                                <tr>
													<td>
                                                        <select class="form-select @error("orderLines.$l.suppliers_id") is-invalid @enderror" wire:model.lazy="orderLines.{{$l}}.seasons_id">
                                                            <option selected value="">Select...</option>
                                                            @foreach ($seasons->sortBy('name') as $season)
                                                                <option value="{{$season->id}}">{{ $season->description }}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select class="form-select @error("orderLines.$l.suppliers_id") is-invalid @enderror" wire:model.lazy="orderLines.{{$l}}.suppliers_id">
                                                            <option selected value="">Select...</option>
                                                            @foreach ($spinners->sortBy('name') as $supplier)
                                                                <option value="{{$supplier->id}}">{{ $supplier->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
														<input class="form-control" list="yarns{{$l}}" class="@error("orderLines.$l.yarns_id") is-invalid @enderror" wire:model.lazy="orderLines.{{$l}}.yarn_desc">
                                                        <datalist id="yarns{{$l}}">
                                                            @if(!empty($line['suppliers_id']))
                                                                @foreach ($this->yarns->where('yarn.suppliers_id', $line['suppliers_id'])->where('seasons_id', $line['seasons_id']) as $yarn)
                                                                    <option value="{{ $yarn->yarn->description }} | {{ $yarn->yarn->counts->count }}">{{ $yarn->yarn->description }} {{ $yarn->yarn->counts->count }}</option>
                                                                @endforeach
                                                            @endif
														</datalist>
                                                    </td>
                                                    <td style="vertical-align: middle"><input type="checkbox" class="form-check-input @error("orderLines.{{$l}}.swatch") is-invalid @enderror" wire:model="orderLines.{{$l}}.swatch"></td>
                                                    <td style="vertical-align: middle"><input type="checkbox" class="form-check-input @error("orderLines.{{$l}}.card") is-invalid @enderror" wire:model="orderLines.{{$l}}.card"></td>
                                                    <td style="vertical-align: middle"><input type="checkbox" class="form-check-input @error("orderLines.{{$l}}.cone") is-invalid @enderror" wire:model="orderLines.{{$l}}.cone"></td>
                                                    <td style="vertical-align: middle"><input type="checkbox" class="form-check-input @error("orderLines.{{$l}}.part_cone") is-invalid @enderror" wire:model="orderLines.{{$l}}.part_cone"></td>
                                                    <td><input type="text" class="form-control @error("orderLines.{{$l}}.notes") is-invalid @enderror" wire:model.lazy="orderLines.{{$l}}.notes"></td>
                                                    <td><button type="button" class="btn btn-primary" wire:click.prevent="removeLine({{$l}})">X</button></td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        @endif
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-bs-dismiss="modal" wire:click.prevent="close">Close</button>
					@if(!$delete)
						<button type="button" class="btn btn-danger" wire:click.prevent="$toggle('delete')">Delete Order</button>
					@else
						<button type="button" class="btn btn-danger" wire:click.prevent="delete()">Sure?</button>
					@endif
					@if(Gate::check('order:create'))
						<button type="button" @if(!$errors->isEmpty()) disabled @endif class="btn btn-primary" wire:click.prevent="save('TRUE')">Save</button>
                    @endif
                    <button type="button" class="btn btn-primary" wire:click.prevent="addLine">Add Line</button>
				</div>
			</div>
		</div>
	</div>
    <x-slot name="modalScripts">
        document.addEventListener('DOMContentLoaded', () => {
            var newModal = new bootstrap.Modal('#newModal');
            document.addEventListener('closeNewModal', () => {
                newModal.hide();
            });
        });
    </x-slot>

