<x-slot name="header">
	<h2 class="font-semibold text-xl text-gray-800 leading-tight">
		{{ __('Yarns') }}
	</h2>
</x-slot>
<x-slot name="css">
	<style>
        #headers{
            display: none;
        }
        main{
            margin-top: 20px !important;
        }
    </style>
</x-slot>
<div>
	<main>
		<div class="container-fluid p-0 bg-light">
			<div class="container mt-3">
				<div class="row">
					<div class="col-12">
						@if (Session::get('message'))
							<div class="alert {{ Session::get('alert-class') }}" role="alert">
								{{ Session::get('message') }}
							</div>
						@endif
					</div>
				</div>
				<div class="row my-3">
					<div class="col">
						<div class="row">
							<div class="col">
								<div class="form-floating">
									<select class="form-select" wire:model.lazy="filter.spinner">
										<option selected value="">All</option>
										@foreach($spinners->sortBy('name') as $spinner)
											<option value="{{ $spinner->id }}">{{ $spinner->name }}</option>
										@endforeach
									</select>
									<label class="form-label">Spinner:</label>
								</div>
							</div>
						</div>
					</div>
                    <div class="col">
                        <button class="btn btn-light w-100" style="height: calc(3.5rem + 2px);" type="button" id="dropdownMenuButton3" data-bs-toggle="dropdown" aria-expanded="false">
                            Columns &#9660;
                        </button>
                        <ul class="dropdown-menu" style="max-height: 300px; min-width: 260px; overflow-y: scroll">
                            <li class="px-3 py-1">
                                <button class="form-control" wire:click="allCols()">All</button>
                            </li>
                            @foreach($seasons as $season)
                                <li class="px-3 py-1">
                                    <input class="form-checkbox" id="column{{$season->id}}" type="checkbox" wire:model="filter.seasons.{{$season->id}}">
                                    <label for="column{{$season->id}}">{{ $season->description }}</label><br>
                                </li>
                            @endforeach
                        </ul>
                    </div>
					<div class="col">
						<div class="d-flex flex-row-reverse">
							<div class="ps-3">
								<div class="form-floating">
									<input type="text" placeholder="Quantity" class="form-control" wire:model.lazy="filter.search">
									<label>Search</label>
									<div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="container">
			<div class="row">
				<div class="table-responsive">
					<table id="tableSort" class="table align-middle text-center">
						<thead>
							<tr>
								<th onclick="sortTable(0)">Spinner</th>
								<th onclick="sortTable(3)">Description</th>
                                <th onclick="sortTable(4)">Count</th>
                                <th>Materials</th>
								<th></th>
                                @foreach ($seasons as $season)
                                    @if(!empty($filter['seasons'][$season->id]) && $filter['seasons'][$season->id])
                                        <th style="width: 130px">{{$season->description}}</th>
                                    @endif
                                @endforeach
							</tr>
						</thead>
						<tbody>
							@foreach($yarns->sortBy('description') as $i=>$yarn)
									<tr>
										<td>{{ $yarn->suppliers->name }}</td>
										<td>{{ $yarn->description }}</td>
										<td>{{ $yarn->counts->count }}</td>
										<td>
											@foreach($yarn->yarn_compositions as $material)
												{{ $material->percentage }}% {{ $material->materials->material }} <br>
											@endforeach
										</td>
										@if(Gate::check('yc:update'))
											<td class="text-end" style="width: 100px">
												<button class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#newModal" wire:click="edit({{$yarn->id}})">Edit</button>
											</td>
										@endif
										@foreach ($seasons as $season)
                                            @if(!empty($filter['seasons'][$season->id]) && $filter['seasons'][$season->id])
                                                <td>
                                                    <div class="input-group">
                                                        <span class="input-group-text">{{ $yarn->suppliers->currency }}</span>
                                                        <input type="text" class="form-control" wire:model.lazy="yarnSeasons.{{$yarn->id}}.{{$season->id}}">
                                                    </div>
                                                </td>
                                            @endif
										@endforeach
									</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<footer class="mt-auto fixed-bottom bg-white border-top navbar navbar-light py-3">
			<div class="container">
				<div class="row w-100 align-items-center">
					<div class="col-lg-6">
						<livewire:footer />
					</div>
					<div class="col-lg-6 text-end">
						@if(Gate::check('yc:create'))
							<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#newModal" wire:click.prevent="new()">New</button>
						@endif
					</div>
				</div>
			</div>
		</footer>
	</main>

    {{-- NEW --}}
	<div wire:ignore.self class="modal fade" id="newModal" data-bs-backdrop="static"  tabindex="-1" aria-labelledby="newModalLabel" aria-hidden="false">
		<div class="modal-dialog modal-fullscreen-sm-down">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="newModalLabel">@if($edit) Edit @elseif($new) New @endif</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click.prevent="close"></button>
				</div>
				<div class="modal-body">
					<div class="container">
						<div class="row">
							<div class="col-12">
								@if (Session::get('message'))
									<div class="alert {{ Session::get('alert-class') }}" role="alert">
										{{ Session::get('message') }}
									</div>
								@endif
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
							</div>
						</div>
						<div class="row">
							<div class="col-12">
								@if(($new || $edit) && (Gate::check('yc:update') || Gate::check('yc:create')))
									<form>
										<div class="row">
											<div class="col-12">
												<div class="form-floating mb-3">
													<select class="form-select" wire:model.lazy="item.suppliers_id">
                                                        <option disabled selected value="">Choose...</option>
                                                        @foreach($spinners as $spinner)
                                                            <option value="{{ $spinner->id }}">{{ strtoupper($spinner->name) }}</option>
                                                        @endforeach
                                                    </select>
													<label class="form-label">Spinner:</label>
													<div class="invalid-feedback">@error('item.suppliers_id') {{ $message }} @enderror</div>
												</div>
												<div class="form-floating mb-3">
													<input type="text" class="form-control @error('item.*') is-valid @enderror @error('item.description') is-invalid @enderror" wire:model.lazy="item.description">
													<label class="form-label">Description:</label>
													<div class="invalid-feedback">@error('item.description') {{ $message }} @enderror</div>
												</div>
                                                <div class="form-floating mb-3">
													{{-- <select class="form-select @error('item.*') is-valid @enderror @error('item.counts_id') is-invalid @enderror" wire:model.lazy="item.counts_id">
														<option default disabled value="">Choose...</option>
														@foreach($counts->sortBy('count') as $count)
															<option value="{{$count->id}}">{{$count->count}}</option>
														@endforeach
													</select> --}}

                                                    <input list="counts" class="form-select @error('item.*') is-valid @enderror @error('item.count') is-invalid @enderror" wire:model.lazy="item.count">

                                                    <datalist id="counts">
                                                        @foreach($counts->sortBy('count') as $count)
															<option value="{{$count->count}}">{{$count->count}}</option>
														@endforeach
                                                    </datalist>

													<label class="form-label">Count:</label>
													<div class="invalid-feedback">@error('item.count') {{ $message }} @enderror</div>
												</div>
												<div>
													@for($x = 0; $x <= 6; $x++)
														<div class="input-group mb-2">
															<select class="form-select @error("yarns.*") is-valid @enderror @error("yarns.$x.material") is-invalid @enderror" wire:model.lazy="compositions.{{$x}}.material">
																	<option value="">-</option>
																@foreach($materials->sortBy('material') as $material)
																	<option value="{{ $material->id }}">{{ $material->material }}</option>
																@endforeach
															</select>
															<input type="text" class="form-control @error("yarns.*") is-valid @enderror @error("yarns.$x.percentage") is-invalid @enderror" wire:model.lazy="compositions.{{$x}}.percentage">
														</div>
													@endfor
												</div>
											</div>
										</div>
									</form>
								@endif
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-bs-dismiss="modal" wire:click.prevent="close">Close</button>
					@if(Gate::check('yc:create'))
						<button type="button" class="btn btn-primary" wire:click.prevent="save">Save</button>
					@endif
				</div>
			</div>
		</div>
	</div>

	<x-slot name="modalScripts">
		document.addEventListener('DOMContentLoaded', () => {
			var newModal = new bootstrap.Modal('#newModal');
			document.addEventListener('closeNewModal', () => {
				newModal.hide();
			});
		});
	</x-slot>
</div>
