<div class="h-100">
    {{-- {{$statusID}} --}}
    {{-- {{$sample?->id}} --}}
    @if($sample?->status == "approved")
        <div class="bg-good p-2 h-100" style="display: flex; align-items: center;">
            <div class="col">
                <b><div @can('style:update') x-on:click="$dispatch('open-modal', {name:'edit-sample'})" wire:click="$dispatch('samples-edit', { samples: {{ $sample->id }}, statusID: '{{ $statusID }}'})" role="button" @endcan>Approved {{empty($sample->approved_date) ? "" : date_format(date_create($sample->approved_date), "d-M")}}</div></b>
                @if(!empty($sample?->colourway_id) && $colourwayId != $sample?->colourway_id)
                    <div>({{Illuminate\Support\Str::title($sample?->colourway ?? "")}})</div>
                @endif
                @if(Gate::check('style:update') && $add && !$season_locked)
                    <button class="btn btn-outline mt-2 border border-primary" wire:click="addSample({{$colourwayId}}, {{$type}})">Add</button>
                @endif
                @if($comments)
                    {{$sample->comment ?? ""}}
                @endif
            </div>
        </div>
    @elseif($sample?->status == "rejected")
    <div class="bg-red p-2 h-100" style="display: flex; align-items: center;">
        <div class="col">
            <b><div @can('style:update') x-on:click="$dispatch('open-modal', {name:'edit-sample'})" wire:click="$dispatch('samples-edit', { samples: {{ $sample->id }}, statusID: '{{ $statusID }}'})" role="button" @endcan>Rejected</div></b>
            @if(!empty($sample?->colourway_id) && $colourwayId != $sample?->colourway_id)
                <div>({{Illuminate\Support\Str::title($sample?->colourway ?? "")}})</div>
            @endif
            @can('style:update' && !$season_locked)
                <button class="btn btn-outline mt-2 border border-primary" wire:click="addSample({{$colourwayId}}, {{$type}})">Add</button>
            @endcan
        </div>
    </div>
    @elseif(!empty($sample?->date_sent))
        <div class="bg-amber p-2 h-100" style="display: flex; align-items: center;">
            <div class="col">
                <b><div @can('style:update') x-on:click="$dispatch('open-modal', {name:'edit-sample'})" wire:click="$dispatch('samples-edit', { samples: {{ $sample->id }}, statusID: '{{ $statusID }}'})" role="button" @endcan>Sent <br>{{date_format(date_create($sample?->date_sent), "d-M")}}</div></b>
                @if(!empty($sample?->colourway_id) && $colourwayId != $sample?->colourway_id)
                    <div>({{Illuminate\Support\Str::title($sample?->colourway ?? "")}})</div>
                @endif
                @if(Gate::check('style:update') && $add && !$season_locked)
                    <button class="btn btn-outline mt-2 border border-primary" wire:click="addSample({{$colourwayId}}, {{$type}})">Add</button>
                @endif
                @if($comments)
                    {{$sample->comment ?? ""}}
                @endif
            </div>
        </div>
    @elseif(!empty($sample?->date_expected))
        <div class="bg-amber p-2 h-100" style="display: flex; align-items: center;">
            <div class="col">
                <b><div @can('style:update') x-on:click="$dispatch('open-modal', {name:'edit-sample'})" wire:click="$dispatch('samples-edit', { samples: {{ $sample->id }}, statusID: '{{ $statusID }}'})" role="button" @endcan>Expected <br> {{date_format(date_create($sample?->date_expected), "d-M")}}</div></b>
                @if(!empty($sample?->colourway_id) && $colourwayId != $sample?->colourway_id)
                    <div>({{Illuminate\Support\Str::title($sample?->colourway ?? "")}})</div>
                @endif
                @if(Gate::check('style:update') && $add && !$season_locked)
                    <button class="btn btn-outline mt-2 border border-primary" wire:click="addSample({{$colourwayId}}, {{$type}})">Add</button>
                @endif
                @if($comments)
                    {{$sample->comment ?? ""}}
                @endif
            </div>
        </div>
    @elseif(!empty($sample))
        <div class="bg-amber p-2 h-100" style="display: flex; align-items: center;">
            <div class="col">
                <b><div @can('style:update') x-on:click="$dispatch('open-modal', {name:'edit-sample'})" wire:click="$dispatch('samples-edit', { samples: {{ $sample->id }}, statusID: '{{ $statusID }}'})" role="button" @endcan>TBC</div></b>
                @if(!empty($sample?->colourway_id) && $colourwayId != $sample?->colourway_id)
                    <div>({{Illuminate\Support\Str::title($sample?->colourway ?? "")}})</div>
                @endif
            </div>
        </div>
    @elseif($sample_required && empty($sample))
        <div class="bg-red p-2 h-100" style="display: flex; align-items: center;">
            <div class="col">
                <div>Not Ordered</div>
                @if(Gate::check('style:update') && $add && !$season_locked)
                    <button class="btn btn-outline mt-2 border border-primary" wire:click="addSample({{$colourwayId}}, {{$type}})">Add</button>
                @endif
                @if($comments)
                    {{$sample->comment ?? ""}}
                @endif
            </div>
        </div>
    @else
        <div class="bg-good p-2 h-100" style="display: flex; align-items: center;">
            <div class="col">
                <div>Not Required</div>
                @if(Gate::check('style:update') && $add && !$season_locked)
                    <button class="btn btn-outline mt-2 border border-primary" wire:click="addSample({{$colourwayId}}, {{$type}})">Add</button>
                @endif
                @if($comments)
                    {{$sample->comment ?? ""}}
                @endif
            </div>
        </div>
    @endif

</div>

