<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Wholesale Pricing
        </x-slot:title>
        <x-slot:end>
            <a class="btn btn-light" wire:click="customerPrint">Quote Customer</a>
            <a class="btn btn-light" wire:click="$dispatch('select-all')">Select All</a>
        </x-slot:end>
        @if(!$goTo)
            <x-slot:sub>
                <div class="row mt-2 d-xl-none">
                    <div class="col text-end">
                        <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                    </div>
                </div>
                @if(!$hideFilters)
                    <div class="row mt-2 mx-1">
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="season">
                                    @foreach($this->seasons as $s=>$season)
                                        <option value="{{$season->id}}">{{$season->description}}</option>
                                    @endforeach
                                </select>
                                <label>Season</label>
                            </div>
                        </div>
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="customer">
                                    @foreach($this->customers as $s=>$customer)
                                        <option value="{{$customer->id}}">{{$customer->name}}</option>
                                    @endforeach
                                </select>
                                <label>Customer</label>
                            </div>
                        </div>
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="factory">
                                    <option value="">All</option>
                                    @foreach($this->factories as $s=>$factory)
                                        <option value="{{$factory->id}}">{{$factory->name}}</option>
                                    @endforeach
                                </select>
                                <label>Factory</label>
                            </div>
                        </div>
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="coo">
                                    <option value="">All</option>
                                    @foreach($this->factories->unique('countries_id') as $s=>$factory)
                                        <option value="{{$factory->countries->id}}">{{$factory->countries->country}}</option>
                                    @endforeach
                                </select>
                                <label>COO</label>
                            </div>
                        </div>
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="department">
                                    <option value="">All</option>
                                    @foreach($this->departments as $s=>$department)
                                        <option value="{{$department->id}}">{{$department->description}}</option>
                                    @endforeach
                                </select>
                                <label>Department</label>
                            </div>
                        </div>
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="category">
                                    <option value="">All</option>
                                    <option value="mens">Mens</option>
                                    <option value="ladies">Ladies</option>
                                    <option value="childrens">Chidrens</option>
                                    <option value="accessories">Accessories</option>
                                </select>
                                <label>Category</label>
                            </div>
                        </div>
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="cancelled">
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                                <label>Show Cancelled</label>
                            </div>
                        </div>
                        <div class="col-xl col-6 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="not_quoted">
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                                <label>Show Unconfirmed Only</label>
                            </div>
                        </div>
                        {{-- <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" /> --}}
                    </div>
                    <div class="row mx-1">
                        <div class="col-12 mb-2 px-1">
                            <div class="form-floating form-outline">
                                <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                                <label>Search</label>
                                <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                            </div>
                        </div>
                    </div>
                @endif
            </x-slot:sub>
        @endif
    </x-title-bar>

    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white text-center">
                        <tr class="border-bottom border-primary">
                            <th>Style</th>
                            <th style="min-width: 150px">Version</th>
                            <th>Image</th>
                            <th>Yarns</th>
                            <th style="min-width: 200px">Price</th>
                            <th style="min-width: 100px">Apply To</th>
                            <th style="min-width: 110px">Yarn/Kg</th>
                            <th style="min-width: 80px">Yarn Interest</th>
                            <th style="min-width: 110px">Yarn Trans</th>
                            <th style="min-width: 80px">Sample Weight</th>
                            <th style="min-width: 80px">Gross Weight</th>
                            <th>Yarn Value</th>
                            <th style="min-width: 160px">CMT</th>
                            {{-- <th>CMT History</th> --}}
                            <th>Valid Till</th>
                            <th style="min-width: 50px">AOC %</th>
                            <th style="min-width: 110px">Accessories</th>
                            <th style="min-width: 110px">Labels</th>
                            <th style="min-width: 110px">GMT Trans</th>
                            <th style="min-width: 110px">Testing</th>
                            {{-- <th style="min-width: 110px">Testing Trans</th> --}}
                            <th style="min-width: 110px">Embroidery</th>
                            <th style="min-width: 75px">Duty %</th>
                            <th>Customs</th>
                            <th>Factoring</th>
                            <th>Subtotal</th>
                            <th style="min-width: 235px">Quote</th>
                            <th>Quotes Sent</th>
                            {{-- <th>Quote History</th> --}}
                            <th style="min-width: 120px">Target</th>
                            <th style="min-width: 90px">MOQ</th>
                            <th style="min-width: 200px">Internal Notes</th>
                            <th style="min-width: 200px">Customer Notes</th>
                            <th>Share</th>
                            {{-- <th>Last Update</th> --}}
                        </tr>
                    </thead>
                    @if(!empty($chunks))
                        @foreach (array_slice($chunks, 0, $page) as $chunk)
                            <livewire:sales.pricing.price-row
                                :chunk="$chunk"
                                :cancelled="$cancelled"
                                :not_quoted="$not_quoted"
                                :key="'chunk-' . md5(json_encode($chunk)) . '-' . $refreshKey"
                            />
                        @endforeach
                    @endif
                </table>
                @if ($this->hasMorePages())
                    <div x-intersect="$wire.loadMore" style="transform: translateY(-30vh)"></div>
                @endif

                <x-modal name="edit-style" title="Edit Style">
                    <x-slot:body>
                            <livewire:development.styles.style-edit wire:key='editStyle'>
                    </x-slot:body>
                </x-modal>

                <x-modal name="edit-colourways" title="Edit Yarns">
                    <x-slot:body>
                            <livewire:development.styles.edit-colourways wire:key='editColourways'>
                    </x-slot:body>
                </x-modal>
            </div>
        </div>
    </div>
    
    {{-- Apply Price to Orders Modal --}}
    <livewire:sales.pricing.apply-price-to-orders />
</div>
