<tbody>
    @foreach($styles ?? [] as $s=>$style)
        @foreach($style['style_versions'] ?? [] as $sv=>$styleVersion)
            @foreach($styleVersion['prices'] ?? [] as $p=>$price)
                <tr class="
                    @if(!empty($price['flag_issue']))
                        bg-warning
                    @elseif($price['cmt_status'] === 'confirmed' && $price['quote_status'] === 'confirmed')
                        bg-good
                    @elseif(($price['cmt_status'] === 'estimate') || ($price['quote_status'] === 'estimate'))
                        bg-pink
                    @endif
                    @if($loop->parent->last && $loop->last) border-primary @endif
                ">
                    {{-- If first row for this style, output style header cell --}}
                    @if($loop->parent->iteration === 1 && $loop->iteration === 1)
                        <td rowspan="{{ $this->countPricesInStyle($style) * 2 }}" class="border-start @if($loop->first) border-primary @endif"
                            role="button"
                            x-data
                            x-on:click="$dispatch('open-modal', {name:'edit-style'})"
                            wire:click="$dispatch('edit-style', {style: {{ $styleVersion['styles_id'] }} })">
                            {{ $style['designs_id'] }}<br>
                            <b>{{ $style['customer_ref'] }}</b><br>
                            {{ ucwords($style['designs']['description']) }}
                        </td>
                    @endif

                    {{-- First cell for the style version --}}
                    @if($loop->first)
                        <td rowspan="{{ $this->countPricesInVersion($styleVersion['prices']) * 2 }}" class="@if($loop->parent->last || $loop->parent->count == 1) border-bottom-primary @endif">
                            @if($this->canedit($style))
                                <input type="text" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.name"
                                    wire:dirty.class="border-warning">
                                <select class="form-select mt-2"
                                        wire:model.live="styles.{{$s}}.style_versions.{{$sv}}.factory_id"
                                        wire:dirty.class="border-warning">
                                    @foreach($this->factories as $factory)
                                        <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                    @endforeach
                                </select>
                            @else
                                {{ $styleVersion['name'] }}<br>
                                {{ $styleVersion['factories']['name'] ?? "" }}
                            @endif
                            @php
                                $totalQty = $this->getTotalOrderedQty($styleVersion);
                            @endphp
                            @if($totalQty > 0)
                                <br><small class="text-muted">Ordered: 
                                    <a href="#" wire:click.prevent="viewOrders({{ $styleVersion['id'] }})" class="text-decoration-none">
                                        <strong>{{ number_format($totalQty) }}</strong>
                                    </a>
                                </small>
                            @endif
                        </td>
                    @endif

                    {{-- Image cell (only once per style version) --}}
                    @if($loop->first)
                        <td rowspan="{{ $this->countPricesInVersion($styleVersion['prices']) * 2 }}" class="@if($loop->parent->last || $loop->parent->count == 1) border-bottom-primary @endif">
                            <img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded"
                                src="{{ $styleVersion['image'] ?? "" }}">
                        </td>
                    @endif

                    {{-- Yarns cell (only once per style version) --}}
                    @if($loop->first)
                        <td
                            rowspan="{{ $this->countPricesInVersion($styleVersion['prices']) * 2 }}"
                            class="@if($loop->parent->last || $loop->parent->count == 1) border-bottom-primary @endif"
                            style="white-space: nowrap;">
                            @foreach ($this->getYarns($styleVersion) as $yarn)
                                {{ $yarn }}<br>
                            @endforeach
                        </td>
                    @endif

                    {{-- Price actions and identification --}}
                    <td rowspan="2" class="@if($loop->parent->last && $loop->last) border-primary @endif">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <button class="btn btn-outline border bg-white"
                                        wire:click="clonePrice({{ $price['id'] }})">⎘</button>
                                <button class="btn btn-outline border bg-white"
                                        wire:click="deletePrice({{ $s }}, {{ $price['id'] }})">🗑</button>
                                <button class="btn btn-outline border {{ !empty($price['links_count']) && $price['links_count'] > 0 ? 'btn-primary text-white' : 'bg-white' }}"
                                        wire:click="$dispatch('open-apply-price-modal', { priceId: {{ $price['id'] }} })"
                                        title="Apply to Orders{{ !empty($price['links_count']) && $price['links_count'] > 0 ? ' (Linked to ' . $price['links_count'] . ' orders)' : '' }}">
                                    <i class="fas fa-link"></i>
                                </button>
                                <div class="input-group-text">
                                    <input type="checkbox" class="form-check-input mt-0"
                                        wire:click="$dispatch('toggle-selected-price', { id: {{ $price['id'] }} })"
                                        wire:model="printList.{{ $price['id'] }}"
                                        wire:key="checkbox_{{ $price['id'] }}_{{ now()->timestamp }}">
                                </div>
                                <input type="text" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.name">
                            </div>
                            <select class="form-select mt-2"
                                    wire:model.live="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.model">
                                <option value="standard">Standard</option>
                                <option value="full_factored">Full Factored</option>
                                <option value="manual">Manual</option>
                            </select>
                            <button class="btn btn-sm mt-2 w-100 {{ !empty($price['flag_issue']) ? 'btn-warning text-dark' : 'btn-outline-warning' }}"
                                    wire:click="togglePriceFlag({{ $price['id'] }})">
                                {{ !empty($price['flag_issue']) ? 'Unflag Price' : 'Flag Price' }}
                            </button>
                        @else
                            {{ $price['name'] }}
                            <input type="checkbox" class="form-check-input mt-0"
                                wire:model="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.name">
                        @endif
                    </td>

                    {{-- Size, Colourway, Colour Type --}}
                    <td rowspan="2" class="@if($loop->parent->last && $loop->last) border-primary @endif">
                        @if($this->canedit($style))
                            <select class="form-select mt-2"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.sizes_id">
                                @foreach($this->sizes as $size)
                                    <option value="{{ $size->id }}">{{ $size->name }}</option>
                                @endforeach
                            </select>
                            <select class="form-select mt-2"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.colourways_id">
                                <option value=""></option>
                                @foreach($styleVersion['colourways'] ?? [] as $colourway)
                                    <option value="{{ $colourway['id'] }}">{{ \Illuminate\Support\Str::title($colourway['name']) }}</option>
                                @endforeach
                            </select>
                            <select class="form-select mt-2"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.colour_type">
                                <option value=""></option>
                                <option value="solid">Solid</option>
                                <option value="melange">Melange</option>
                                <option value="mixed">Mixed</option>
                            </select>
                        @else
                            {{ optional(collect($this->sizes)->firstWhere('id', $price['sizes_id']))->name }}<br>
                            {{ $price['colourway_name'] ?? "" }}<br>
                            {{ $price['colour_type'] ?? "" }}
                        @endif
                    </td>

                    {{-- Yarn Cost --}}
                    <td class="border-0">
                        @if($price['model'] === 'manual' && $this->canedit($style))
                            <div class="input-group">
                                <select style="max-width: 30px;" class="small-select form-select"
                                        wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.yarnkg_currency">
                                    <option value="">-</option>
                                    <option value="£">£</option>
                                    <option value="€">€</option>
                                    <option value="$">$</option>
                                </select>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.yarn">
                            </div>
                        @else
                            <div role="button" x-data x-on:click="$dispatch('open-modal', {name:'edit-colourways'})" wire:click="$dispatch('edit-colourways', {sv: {{$styleVersion['id']}}})">
                                €{{ number_format($price['yarn_cost_kg'], 2) }}
                            </div>
                        @endif
                    </td>

                    {{-- Yarn Interest --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <input type="number" class="form-control" step="0.01"
                                wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.yarn_interest"
                                placeholder="%">
                        @else
                            {{ $price['yarn_interest'] ?? "0" }}%
                        @endif
                    </td>

                    {{-- Yarn Transport --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <select style="max-width: 30px;" class="small-select form-select"
                                        wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.yarn_trans_currency">
                                    <option value="">-</option>
                                    <option value="£">£</option>
                                    <option value="€">€</option>
                                    <option value="$">$</option>
                                </select>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.yarn_trans">
                            </div>
                        @else
                            {{ $price['yarn_trans_currency'] ?? "" }}{{ $price['yarn_trans'] ?? "" }}
                        @endif
                    </td>

                    {{-- Weight --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <input type="number" class="form-control"
                                wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.weight">
                        @else
                            {{ $price['weight'] }}
                        @endif
                    </td>

                    {{-- Costed Weight --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <input type="number" class="form-control"
                                wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.costed_weight">
                        @else
                            {{ $price['costed_weight'] }}
                        @endif
                    </td>

                    {{-- Yarn Value (Calculated) --}}
                    <td class="border-0">
                        €{{ $price['yarn_value_euro'] }}
                    </td>

                    {{-- CMT & Status --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <span class="input-group-text">{{ $styleVersion['factories']['currency'] }}</span>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.cmt">
                                <select style="max-width: 40px;" class="small-select form-select"
                                        wire:model.live="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.cmt_status">
                                    <option value="not_confirmed">NC</option>
                                    <option value="confirmed">CO</option>
                                    <option value="estimate">ES</option>
                                </select>
                            </div>
                        @else
                            {{ $styleVersion['factories']['currency'] }}{{ $price['cmt'] }} - {{ $price['cmt_status'] }}
                        @endif
                    </td>

                    {{-- Valid Until --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <input type="date" style="max-width: 130px" class="form-control"
                                wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.valid_until">
                        @else
                            {{ $price['valid_until'] }}
                        @endif
                    </td>

                    {{-- AOC --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <input type="number" class="form-control"
                                wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.aoc">
                        @else
                            {{ $price['aoc'] ?? "" }}%
                        @endif
                    </td>

                    {{-- Accessory --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <select style="max-width: 30px;" class="small-select form-select"
                                        wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.accessory_currency">
                                    <option value="">-</option>
                                    <option value="£">£</option>
                                    <option value="€">€</option>
                                    <option value="$">$</option>
                                </select>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.accessory">
                            </div>
                        @else
                            {{ $price['accessory_currency'] ?? "" }}{{ $price['accessory'] ?? "" }}
                        @endif
                    </td>

                    {{-- Label --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <select style="max-width: 30px;" class="small-select form-select"
                                        wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.label_currency">
                                    <option value="">-</option>
                                    <option value="£">£</option>
                                    <option value="€">€</option>
                                    <option value="$">$</option>
                                </select>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.label">
                            </div>
                        @else
                            {{ $price['label_currency'] ?? "" }}{{ $price['label'] ?? "" }}
                        @endif
                    </td>

                    {{-- GMT Trans --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <select style="max-width: 30px;" class="small-select form-select"
                                        wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.gmt_trans_currency">
                                    <option value="">-</option>
                                    <option value="£">£</option>
                                    <option value="€">€</option>
                                    <option value="$">$</option>
                                </select>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.gmt_trans">
                            </div>
                        @else
                            {{ $price['gmt_trans_currency'] ?? "" }}{{ $price['gmt_trans'] ?? "" }}
                        @endif
                    </td>

                    {{-- Testing --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <span class="input-group-text">£</span>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.testing">
                            </div>
                        @else
                            £{{ $price['testing'] ?? "" }}
                        @endif
                    </td>

                    {{-- Embroidery --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <select style="max-width: 30px;" class="small-select form-select"
                                        wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.embroidery_currency">
                                    <option value="">-</option>
                                    <option value="£">£</option>
                                    <option value="€">€</option>
                                    <option value="$">$</option>
                                </select>
                                <input type="number" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.embroidery">
                            </div>
                        @else
                            {{ $price['embroidery_currency'] ?? "" }}{{ $price['embroidery'] ?? "0.00" }}
                        @endif
                    </td>

                    {{-- Duty --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <input type="number" class="form-control"
                                wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.duty">
                        @else
                            £{{ $price['duty'] ?? "" }}
                        @endif
                    </td>

                    {{-- Customs --}}
                    <td class="border-0">
                        £{{ $price['customs'] }}
                    </td>

                    {{-- Factoring --}}
                    <td class="border-0">
                        {{ $styleVersion['factories']['currency'] }}{{ $price['factoring'] }}
                    </td>

                    {{-- Subtotal --}}
                    <td class="border-0">
                        {{ $styleVersion['factories']['currency'] }}{{ $price['subtotal'] }}<br>
                        £{{ $price['subtotal_base'] }}
                    </td>

                    {{-- Quote & Margin --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <span class="input-group-text">{{ $style['customers']['currency'] }}</span>
                                <input type="number" step="0.01" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.quote">
                                <select class="small-select form-select"
                                        wire:model.live="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.quote_status">
                                    <option value="not_confirmed">NC</option>
                                    <option value="confirmed">CO</option>
                                    <option value="estimate">ES</option>
                                </select>
                                <input type="text" class="form-control" disabled
                                    value="{{ $price['margin'] }}%">
                            </div>
                        @else
                            {{ $style['customers']['currency'] ?? "" }}{{ $price['quote'] ?? "0.00" }}<br>
                            Margin: {{ $price['margin'] }}%
                        @endif
                    </td>

                    {{-- Quotes Sent --}}
                    <td class="border-0" style="white-space: nowrap;">
                        @foreach($price['quotes_sent'] ?? [] as $quote)
                            {{ \Carbon\Carbon::parse($quote['date_sent'])->format('d-M') }} - {{ $style['customers']['currency'] }}{{ $quote['quote'] }}<br>
                        @endforeach
                    </td>

                    {{-- Target --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <div class="input-group">
                                <span class="input-group-text">{{ $style['customers']['currency'] }}</span>
                                <input type="number" step="0.01" class="form-control"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.target">
                            </div>
                        @else
                            {{ $style['customers']['currency'] ?? "" }}{{ $price['target'] ?? "0.00" }}
                        @endif
                    </td>

                    {{-- Min Qty --}}
                    <td class="border-0">
                        @if($this->canedit($style))
                            <input type="number" class="form-control"
                                wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.min_qty">
                        @else
                            {{ $price['min_qty'] ?? "" }}
                        @endif
                    </td>

                    {{-- Notes --}}
                    <td rowspan="2">
                        @if($this->canedit($style))
                            <textarea style="height: 135px;" class="form-control" rows="{{ ceil(strlen($price['notes'])/35) }}" oninput="this.style.height='';this.style.height=this.scrollHeight+'px'" wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.notes"></textarea>
                        @else
                            {{ $price['notes'] ?? "" }}
                        @endif
                    </td>

                    {{-- Customer Notes --}}
                    <td rowspan="2">
                        @if($this->canedit($style))
                            <textarea style="height: 135px;" class="form-control" rows="{{ ceil(strlen($price['customer_notes'])/35) }}" oninput="this.style.height='';this.style.height=this.scrollHeight+'px'" wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.customer_notes"></textarea>
                        @else
                            {{ $price['customer_notes'] ?? "" }}
                        @endif
                    </td>

                    {{-- Share Button --}}
                    <td class="border-0">
                        <button class="form-control" onclick="copyToClipboard({{ $price['id'] }})">Share</button>
                    </td>

                    {{-- Last Updated By --}}
                    {{-- <td class="border-0">
                        {{ $price['last_updated_by'] }}
                    </td> --}}
                </tr>
                <tr class="
                    @if($loop->parent->last && $loop->last) border-primary @endif
                    @if(!empty($price['flag_issue']))
                        bg-warning
                    @elseif($price['cmt_status'] === 'confirmed' && $price['quote_status'] === 'confirmed')
                        bg-good
                    @elseif($price['cmt_status'] === 'estimate' || $price['quote_status'] === 'estimate')
                        bg-pink
                    @endif
                ">
                    <td colspan="5">
                        @if($this->canedit($style))
                            <textarea class="form-control text-red fw-bold m-0"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.weight_comments"></textarea>
                        @else
                            {{ $styleVersion['comments_yarn'] ?? '' }}
                        @endif
                    </td>
                    <td style="white-space: nowrap;">
                        @if(isset($price['historic']))
                            @foreach(json_decode($price['historic'], true) ?? [] as $old_price)
                                <b>{{ $old_price['season'] }}</b> {{ $styleVersion['factories']['currency'] }}{{ number_format($old_price['cmt'], 2) }} <span style="cursor:pointer" onclick="confirm('This will overwrite this prices data with the price from the previous season?') || event.stopImmediatePropagation()" wire:click="pullOldPrice({{$price['id']}}, {{$old_price['price_id'] ?? "NA"}})">&#x2398;</span><br>
                            @endforeach
                        @endif
                    </td>
                    <td colspan="8">
                        @if($this->canedit($style))
                            <textarea class="form-control text-red fw-bold m-0"
                                    wire:model.blur="styles.{{$s}}.style_versions.{{$sv}}.prices.{{$p}}.cost_comments"></textarea>
                        @else
                            {{ $styleVersion['comments_cmt'] ?? '' }}
                        @endif
                    </td>
                    <td colspan="3"></td>
                    <td style="white-space: nowrap;">
                        @if(isset($price['historic']))
                            @foreach(json_decode($price['historic'], true) ?? [] as $old_price)
                                <b>{{ $old_price['season'] }}</b> {{ $style['customers']['currency'] }}{{ number_format($old_price['quote'], 2) }}<br>
                            @endforeach
                        @endif
                    </td>
                    <td colspan="3"></td>
                    <td colspan="2"></td>
                </tr>
                
                @endforeach
            @endforeach
        @if(!$style['empty'])
            <tr class="border-primary">
                <td colspan="100%"></td>
            </tr>
        @endif
    @endforeach
</tbody>
