<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Wholesale Pricing
        </x-slot:title>
        <x-slot:end>
            <a class="btn btn-light" wire:click="customerPrint">Quote Customer</a>
			<a class="btn btn-light" wire:click="$dispatch('select-all')">Select All</a>
            @can('admin')
			    <a class="btn btn-light" wire:click="refreshAllPriceCaches">Refresh All Price Caches</a>
            @endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="season">
								@foreach($this->seasons as $s=>$season)
									<option value="{{$season->id}}">{{$season->description}}</option>
								@endforeach
							</select>
							<label>Season</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="phase">
                                <option value=""></option>
								@foreach($this->phases as $s=>$phase)
									<option value="{{$phase->id}}">{{$phase->name}}</option>
								@endforeach
							</select>
							<label>Phase</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="customer">
								@foreach($this->customers as $s=>$customer)
									<option value="{{$customer->id}}">{{$customer->name}}</option>
								@endforeach
							</select>
							<label>Customer</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="factory">
								<option value="">All</option>
								@foreach($this->factories as $s=>$factory)
									<option value="{{$factory->id}}">{{$factory->name}}</option>
								@endforeach
							</select>
							<label>Factory</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="coo">
								<option value="">All</option>
								@foreach($this->factories->unique('countries_id') as $s=>$factory)
									<option value="{{$factory->countries->id}}">{{$factory->countries->country}}</option>
								@endforeach
							</select>
							<label>COO</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="department">
								<option value="">All</option>
								@foreach($this->departments as $s=>$department)
									<option value="{{$department->id}}">{{$department->description}}</option>
								@endforeach
							</select>
							<label>Department</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="category">
								<option value="">All</option>
								<option value="mens">Mens</option>
								<option value="ladies">Ladies</option>
								<option value="childrens">Chidrens</option>
								<option value="accessories">Accessories</option>
							</select>
							<label>Category</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="cancelled">
								<option value="1">Yes</option>
								<option value="0">No</option>
							</select>
							<label>Show Cancelled</label>
						</div>
					</div>
                    <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>

    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table table-bordered table-sm align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white text-center">
                        <tr class="border-bottom border-primary">
                            <th style="min-width: 150px"></th>
                            <th>Factory</th>
                            <th>Phase</th>
                            <th>Date</th>
                            <th>RT No.</th>
                            <th>Version</th>
                            <th>Colourway</th>
                            <th>Description</th>
                            <th>Yarns</th>
                            <th style="min-width: 80px">Qty</th>
                            <th style="min-width: 170px">Factory Price</th>
                            <th>Factoring</th>
                            <th>Total Cost</th>
                            <th style="min-width: 170px">Gross Sale</th>
                            <th>Net Sale</th>
                            <th>Margin</th>
                            <th>Comments</th>
                            <th>Last Update</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($styles as $i=>$intake)
                            <tr>
                                <td colspan="100%" style="height: 30px" class="border-0 border-bottom border-black">Intake: {{$i}}</td>
                            </tr>
                            @foreach($intake as $s=>$style)
                                @livewire('sales.pricing.kwa-price-row', ['style' => $style], key($s))
                            @endforeach

                        @endforeach
                    </tbody>
                </table>

                <x-modal name="edit-style" title="Edit Style">
                    <x-slot:body>
                            <livewire:development.styles.style-edit wire:key='editStyle'>
                    </x-slot:body>
                </x-modal>

                <x-modal name="edit-colourways" title="Edit Yarns">
                    <x-slot:body>
                            <livewire:development.styles.edit-colourways wire:key='editColourways'>
                    </x-slot:body>
                </x-modal>
            </div>
        </div>
    </div>
    
    {{-- Apply Price to Orders Modal --}}
    <livewire:sales.pricing.apply-price-to-orders />
</div>


