<tbody>
    @foreach($style as $v=>$version)
        @foreach($version as $p=>$price)
            <tr
            class="@if($price['flag_issue'] ?? false) bg-issue @elseif($price['cmt_status'] == 'confirmed' && $price['quote_status'] == 'confirmed') bg-good @elseif($price['cmt_status'] == 'estimate' || $price['quote_status'] == 'estimate') bg-pink @endif
            border-primary"
            >
                <td>
                    @if(Gate::allows('price:update') && !$price['season_locked'])
                        <div class="input-group">
                            <button class="btn btn-outline border bg-white" wire:click="clonePrice({{$price['id']}})">⎘</button>
                            <button class="btn btn-outline border bg-white" wire:click="deletePrice({{$price['id']}})">🗑</button>
                            <button class="btn btn-outline border {{ !empty($price['links_count']) && $price['links_count'] > 0 ? 'btn-primary text-white' : 'bg-white' }}" wire:click="$dispatch('open-apply-price-modal', { priceId: {{ $price['id'] }} })" title="Apply to Orders{{ !empty($price['links_count']) && $price['links_count'] > 0 ? ' (Linked to ' . $price['links_count'] . ' orders)' : '' }}">
                                <i class="fas fa-link"></i>
                            </button>
                            <button class="btn btn-outline border {{ ($price['flag_issue'] ?? false) ? 'btn-warning' : 'bg-white' }}" wire:click="toggleFlagIssue({{ $price['id'] }})" title="{{ ($price['flag_issue'] ?? false) ? 'Remove Flag' : 'Flag Issue' }}">
                                <i class="fas fa-flag"></i>
                            </button>
                            <div class="input-group-text">
                                <input type="checkbox" class="form-check-input mt-0" wire:click="$dispatch('toggle-selected-price', { id: {{ $price['id'] }} })" wire:model="printList.{{$price['id']}}" wire:key="checkbox_{{ $price['id'] }}_{{ now()->timestamp }}" >
                            </div>
                        </div>
                    @else
                        {{$price['price_name']}}
                    @endif
                </td>
                <td style="white-space: nowrap;">
                    {{$price['factory']}}
                </td>
                <td>
                    @if(Gate::allows('price:update') && !$price['season_locked'])
                        <select style="max-width: 80px;" class="small-select form-select form-input-no-bg border-0" wire:model.live="style.{{ $v }}.{{ $p }}.phase_id">
                            <option value=""></option>
                            @foreach($this->phases as $phase)
                                <option value="{{ $phase->id }}">{{ $phase->name }}</option>
                            @endforeach
                        </select>
                    @else
                        {{ $price['phase'] ?? '' }}
                    @endif
                </td>
                <td>

                </td>
                <td>
                    {{ ucwords($price['design_id']) }}
                </td>
                <td>
                    {{ $price['style_version_name'] ?? '' }}
                </td>
                <td style="white-space: nowrap;">
                    {{ $price['colourways_name'] ?? '' }}
                </td>
                <td style="white-space: nowrap;">
                    {{ ucwords($price['description']) }}
                </td>
                <td style="white-space: nowrap;">
                    @foreach(explode(',', $price['yarn']) ?? [] as $yarn)
                        {{$yarn}}<br>
                    @endforeach
                </td>

                <td>
                    @if(Gate::allows('price:update') && !$price['season_locked'])
                        <input type='number' class="form-control form-input-no-bg border-0" wire:model.blur="style.{{ $v }}.{{ $p }}.min_qty">
                    @else
                        {{$price['min_qty'] ?? ""}}
                    @endif
                </td>
                <td>
                    @if(Gate::allows('price:update') && !$price['season_locked'])
                        <div class="input-group">
                            <span class="input-group-text form-input-no-bg border-0">{{$price['fact_currency']}}</span>
                            <input type="number" class="form-control form-input-no-bg border-0" wire:model.blur="style.{{ $v }}.{{ $p }}.cmt">
                            <select style="max-width: 40px;" class="small-select form-select form-input-no-bg border-0" wire:model.live="style.{{ $v }}.{{ $p }}.cmt_status">
                                <option value="not_confirmed">NC</option>
                                <option value="confirmed">CO</option>
                                <option value="estimate">ES</option>
                            </select>
                        </div>
                    @else
                        {{$price['fact_currency']}}{{$price['cmt']}} - {{$price['cmt_status']}}
                    @endif
                </td>
                <td>
                    {{$price['fact_currency']}}{{calculateFactoring($price)}}
                </td>
                <td>
                    {{$price['fact_currency']}}{{calculateSubtotal($price)}}
                </td>
                <td>
                    @if(Gate::allows('price:update') && !$price['season_locked'])
                        <div class="input-group">
                            <span class="input-group-text rounded-0 rounded-start form-input-no-bg border-0">{{$price['cust_currency']}}</span>
                            <input type='number' step='0.01' class="form-control rounded-0 form-input-no-bg border-0" wire:model.blur="style.{{ $v }}.{{ $p }}.quote">
                            <select class="small-select form-select form-input-no-bg border-0" wire:model.live="style.{{ $v }}.{{ $p }}.quote_status">
                                <option value="not_confirmed">NC</option>
                                <option value="confirmed">CO</option>
                                <option value="estimate">ES</option>
                            </select>
                        </div>
                    @else
                        {{$price['cust_currency'] ?? ""}}{{$price['quote'] ?? "0.00"}}
                    @endif
                </td>
                <td>
                    {{$price['cust_currency'] ?? ""}}{{discountPrice($price)}}
                </td>
                <td>
                    {{calculateMargin($price)}}%
                </td>
                <td>

                </td>
                <td style="white-space: nowrap;">
                    {{$price['last_updated_by']}}
                </td>
            </tr>
        @endforeach
    @endforeach
</tbody>
