<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Quote Sheet
        </x-slot:title>
        <x-slot:end>
            <button class="btn btn-primary" wire:click="markAsSent">Mark as Sent</button>
        </x-slot:end>
    </x-title-bar>

	<div class="container-fluid">
        <div class="row">
            <div class="col text-end">
                <img class="print" src="{{$logo}}" height="60">
            </div>
        </div>
        <div class="row">
            <table id="tableSort" class="table align-middle rounded text-center">
                <thead class="text-center" style="">
                    <tr>
                        <th>Style</th>
                        <th>Style Version</th>
                        <th>Image</th>
                        <th>COO</th>
                        <th>Yarns</th>
                        <th>Quote</th>
                        <th>MOQ</th>
                        <th style="min-width: 180px">Quotes Sent</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($form->styles as $p=>$price)
                        @if($price['price_id'] ?? 0)
                            <tr wire:key="{{$p}}"

                            {{-- class="@if($price['style_cancelled']) bg-red @elseif($price['quote_status'] == 'confirmed' &&  $price['cmt_status'] == 'confirmed') bg-good @endif" --}}

                            style="@if(collect($form->styles)->where('style_id', $price['style_id'])->first()['price_id'] == $price['price_id']) border-top: 3px solid black @endif"
                            >
                                @if(collect($form->styles)->where('style_id', $price['style_id'])->first()['price_id'] == $price['price_id'])
                                    <td @if(!$price['style_cancelled']) class="bg-white" @endif rowspan="{{collect($form->styles)->where('style_id', $price['style_id'])->count()}}"
                                        style="position: sticky; left: 0; z-index: 10;"
                                        >
                                        RTD{{$price['design_id']}} <br> <b>{{$price['customer_ref']}}</b>
                                        <br>
                                        {{$price['description']}}
                                    </td>
                                @endif
                                @if(collect($form->styles)->where('style_version_id', $price['style_version_id'])->first()['price_id'] == $price['price_id'])
                                    <td @if(!$price['style_cancelled']) class="bg-white" @endif rowspan="{{collect($form->styles)->where('style_version_id', $price['style_version_id'])->count()}}">
                                        {{$price['style_version_name']}}
                                    </td>
                                    <td @if(!$price['style_cancelled']) class="bg-white" @endif rowspan="{{collect($form->styles)->where('style_version_id', $price['style_version_id'])->count()}}">
                                        @if(!empty($price['image']))
                                            <img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded"
                                            src="{{ url(asset('storage/' . $price['image'])) }}">
                                        @endif
                                    </td>
                                    <td @if(!$price['style_cancelled']) class="bg-white" @endif rowspan="{{collect($form->styles)->where('style_version_id', $price['style_version_id'])->count()}}">
                                        {{$price['coo_name']}}
                                    </td>
                                    <td @if(!$price['style_cancelled']) class="bg-white" @endif rowspan="{{collect($form->styles)->where('style_version_id', $price['style_version_id'])->count()}}">
                                        @foreach($price['yarns'] ?? [] as $yarn)
                                            {{$yarn}}<br>
                                        @endforeach
                                    </td>
                                @endif
                                <td>
                                    {{$price['cust_currency']}}{{$price['quote']}}
                                </td>
                                <td>{{$price['min_qty']}}</td>
                                <td>
                                    @foreach($price['quotes_sent'] ?? [] as $q=>$quote)
                                        <input type="date" class="form-control dont-print" wire:model.live.debounce.500ms="form.styles.{{$p}}.quotes_sent.{{$q}}.date_sent">
                                        {{date_format(date_create($quote['date_sent']), 'd-M')}} - {{$price['cust_currency']}}{{$quote['quote']}}<br>
                                    @endforeach
                                </td>
                                <td>{{$price['customer_notes']}}</td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>


</div>
