<div>
    @if($showModal)
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Apply Price to Orders</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>
                    <div class="modal-body">
                        @if($price)
                            <div class="alert alert-info mb-3">
                                <strong>Price Details:</strong>
                                @if($price->name)
                                    <span class="badge bg-primary">{{ $price->name }}</span>
                                @endif
                                @if($price->quote)
                                    Quote: {{ $price->quote }}
                                @endif
                                @if($price->cmt)
                                    | CMT: {{ $price->cmt }}
                                @endif
                                @if($price->colourways)
                                    | Colourway: {{ $price->colourways->name }}
                                @else
                                    <span class="badge bg-secondary">Generic (All Colourways)</span>
                                @endif
                                @if($price->sizes && $price->sizes_id != 1)
                                    | Size: {{ $price->sizes->name }}
                                @else
                                    <span class="badge bg-secondary">All Sizes</span>
                                @endif
                                @if($price->phase_id)
                                    | Phase: {{ $price->phase_id }}
                                @endif
                            </div>

                            @if($successMessage)
                                <div class="alert alert-success alert-dismissible fade show">
                                    <i class="fas fa-check-circle"></i> {{ $successMessage }}
                                    <button type="button" class="btn-close" wire:click="$set('successMessage', '')"></button>
                                </div>
                            @endif

                            @if($errorMessage)
                                <div class="alert alert-danger alert-dismissible fade show">
                                    <i class="fas fa-exclamation-circle"></i> {{ $errorMessage }}
                                    <button type="button" class="btn-close" wire:click="$set('errorMessage', '')"></button>
                                </div>
                            @endif

                            @if(empty($compatibleOrders))
                                <div class="alert alert-warning">
                                    <i class="fas fa-info-circle"></i> No compatible orders found for this price.
                                    <p class="mb-0 mt-2">
                                        This could mean:
                                        <ul>
                                            <li>No wholesale orders exist for this style version/colourway</li>
                                            <li>All matching orders are cancelled</li>
                                            <li>Phase restrictions don't match any orders</li>
                                        </ul>
                                    </p>
                                </div>
                            @else
                                <p class="text-muted mb-3">
                                    <i class="fas fa-info-circle"></i>
                                    Found {{ count($compatibleOrders) }} compatible order line(s). Select orders and sizes to apply this price as a priority price.
                                </p>

                                <div class="table-responsive">
                                    <table class="table table-sm table-hover">
                                        <thead class="table-light sticky-top">
                                            <tr>
                                                <th width="50">Select</th>
                                                <th>Customer</th>
                                                <th>PO</th>
                                                <th>Order Date</th>
                                                <th>Colourway</th>
                                                <th>Sizes</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($compatibleOrders as $order)
                                                <tr class="{{ isset($selectedOrders[$order['order_line_id']]) ? 'table-primary' : '' }}">
                                                    <td>
                                                        <input type="checkbox" 
                                                            class="form-check-input" 
                                                            wire:click="toggleOrder({{ $order['order_line_id'] }})"
                                                            @if(isset($selectedOrders[$order['order_line_id']])) checked @endif>
                                                    </td>
                                                    <td>{{ $order['customer_name'] }}</td>
                                                    <td>{{ $order['customer_po'] }}</td>
                                                    <td>{{ $order['order_date'] }}</td>
                                                    <td>{{ $order['colourway_name'] }}</td>
                                                    <td>
                                                        @if(isset($selectedOrders[$order['order_line_id']]))
                                                            <div class="form-check form-switch mb-2">
                                                                <input class="form-check-input" type="checkbox" 
                                                                    wire:model="applyToAllSizes.{{ $order['order_line_id'] }}"
                                                                    id="allSizes{{ $order['order_line_id'] }}">
                                                                <label class="form-check-label" for="allSizes{{ $order['order_line_id'] }}">
                                                                    <strong>Apply to All Sizes</strong>
                                                                </label>
                                                            </div>
                                                            
                                                            @if(empty($applyToAllSizes[$order['order_line_id']]))
                                                                <div class="btn-group btn-group-sm flex-wrap" role="group">
                                                                    @foreach($order['quantities'] as $qty)
                                                                        @php
                                                                            $isSelected = isset($selectedSizes[$order['order_line_id']]) 
                                                                                && in_array($qty['id'], $selectedSizes[$order['order_line_id']]);
                                                                        @endphp
                                                                        <button type="button" 
                                                                            class="btn btn-sm {{ $isSelected ? 'btn-primary' : 'btn-outline-primary' }}"
                                                                            wire:click="toggleSize({{ $order['order_line_id'] }}, {{ $qty['id'] }})">
                                                                            {{ $qty['size_name'] }} ({{ $qty['qty'] }})
                                                                            @if($qty['has_priority_price'])
                                                                                <i class="fas fa-link text-warning" title="Has priority price"></i>
                                                                            @endif
                                                                        </button>
                                                                    @endforeach
                                                                </div>
                                                            @else
                                                                <div class="text-muted">
                                                                    @foreach($order['quantities'] as $qty)
                                                                        <span class="badge bg-secondary me-1">
                                                                            {{ $qty['size_name'] }}: {{ $qty['qty'] }}
                                                                            @if($qty['has_priority_price'])
                                                                                <i class="fas fa-link text-warning" title="Has priority price"></i>
                                                                            @endif
                                                                        </span>
                                                                    @endforeach
                                                                </div>
                                                            @endif
                                                        @else
                                                            <span class="text-muted">
                                                                {{ count($order['quantities']) }} size(s)
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @php
                                                            $hasPriorityPrice = collect($order['quantities'])->contains('has_priority_price', true);
                                                        @endphp
                                                        @if($hasPriorityPrice)
                                                            <span class="badge bg-warning text-dark">
                                                                <i class="fas fa-link"></i> Has Priority Price
                                                            </span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                        @endif
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal" @if($processing) disabled @endif>
                            Close
                        </button>
                        @if(!empty($compatibleOrders))
                            <button type="button" class="btn btn-danger" wire:click="removePriorityPrice" 
                                @if($processing || empty($selectedOrders)) disabled @endif>
                                @if($processing)
                                    <span class="spinner-border spinner-border-sm"></span>
                                @endif
                                Remove Priority Price
                            </button>
                            <button type="button" class="btn btn-primary" wire:click="applyPrice" 
                                @if($processing || empty($selectedOrders)) disabled @endif>
                                @if($processing)
                                    <span class="spinner-border spinner-border-sm"></span>
                                @endif
                                Apply Price to Selected
                            </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>



















