<div>
    <div class="modal-body">
        {{-- @if(session('message'))
            <div class="alert {{ session('alert-class') }}">
                {{session('message') ?? ""}}
                @foreach (session('errors') ?? [] as $field => $errors)
                    <ul>
                        @foreach ($errors as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                @endforeach
            </div>
        @endif --}}
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h3>
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
            </div>
        @endif
        <form wire:submit="save">
            <div class="row">
                <div class="col">
                    <div class="row align-items-center">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Department</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            <select class="form-select" wire:model="department">
                                <option value=""></option>
                                @foreach($this->departments as $department)
                                    <option value="{{$department->id}}">{{$department->description}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Season</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            <select class="form-select" wire:model="season">
                                <option value=""></option>
                                @foreach($this->seasons as $season)
                                    <option value="{{$season->id}}">{{$season->description}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Customer</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            <select class="form-select" wire:model.live="customer">
                                <option value=""></option>
                                @foreach($this->customers as $customer)
                                    <option value="{{$customer->id}}">{{$customer->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Incoterms</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            <select class="form-select" wire:model="incoterms">
                                <option value=""></option>
                                <option value="EXW">EXW</option>
                                <option value="FCA">FCA</option>
                                <option value="CPT">CPT</option>
                                <option value="CIP">CIP</option>
                                <option value="DAP">DAP</option>
                                <option value="DPU">DPU</option>
                                <option value="DDP">DDP</option>
                                <option value="FAS">FAS</option>
                                <option value="FOB">FOB</option>
                                <option value="CFR">CFR</option>
                                <option value="CIF">CIF</option>
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center" @if(Gate::check('order:update')) style="height: 37px" @endif>
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Delivery Address</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            <select class="form-select" wire:model="deliveryaddress">
                                <option value=""></option>
                                @foreach($this->deliveryAddresses ?? [] as $address)
                                    <option value="{{$address->id}}">{{$address->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Purchase Order No.</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            <input class="form-control" type="text" wire:model="po">
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Order Date</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            <input class="form-control" type="date" wire:model="date">
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="modal-footer">
            <button class="btn btn-primary"  wire:click.prevent="save">Save</button>
    </div>
</div>
