<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Orders
        </x-slot:title>
        <x-slot:end>
			@can('order:create')
				<button class="btn btn-primary" x-data x-on:click="$dispatch('open-modal', {name:'new-order'})" wire:click="$dispatch('new-order')">New</button>
			@endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="season">
								<option selected value="">All</option>
								@foreach($this->seasons as $season)
									<option value="{{ $season->id }}">{{ $season->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Season:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="department">
								<option selected value="">All</option>
								@foreach($this->departments as $department)
									<option value="{{ $department->id }}">{{ $department->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Department:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="customer">
								<option selected value="">All</option>
								@foreach($this->customers as $customer)
									<option value="{{ $customer->id }}">{{ $customer->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Customer:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="factory">
								<option selected value="">All</option>
								@foreach($this->factories as $factory)
									<option value="{{ $factory->id }}">{{ $factory->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Factory:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="style_version">
								<option selected value="">All</option>
								@foreach($this->styleVersions as $sv)
									<option value="{{ $sv->id }}">{{ $sv->design_id }} | {{ $sv->customer_ref }} ({{ $sv->name }})</option>
								@endforeach
							</select>
							<label class="form-label">Style Version:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="paginate">
								<option selected value="10">10</option>
								<option selected value="50">50</option>
								<option selected value="100">100</option>
								<option selected value="200">200</option>
								<option selected value="500">500</option>
							</select>
							<label class="form-label">Per Page:</label>
						</div>
					</div>
                    <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
                <div class="row mx-1">
                    <div class="col mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                    <div class="col-auto mb-2 px-1 d-flex align-items-center">
                        <button type="button" class="btn btn-outline-secondary" wire:click="clearAllFilters" title="Clear all filters">
                            <i class="fas fa-times-circle me-1"></i> Clear Filters
                        </button>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>


    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
						<tr>
							@if($columns['Order Date'])		<th>Order Date</th>		@endif
							@if($columns['Season'])			<th>Season</th>			@endif
							@if($columns['PO'])				<th>PO</th>				@endif
							@if($columns['Customer'])		<th>Customer</th>		@endif
							@if($columns['Style'])			<th>Style</th>			@endif
							@if($columns['Colourway'])		<th>Colourway</th>		@endif
							@if($columns['Qty'])			<th>Qty</th>			@endif
							@if($columns['Total Qty'])		<th>Total Qty</th>		@endif
							<th style="width: 0" class="dont-print"></th>
						</tr>
					</thead>
					<tbody>
						@foreach($orders as $order)
							@if($order->styles->isEmpty())
								<tr wire:key="nostyle{{$order->id}}">
									@if($columns['Order Date'])		<td>{{date("d-M-Y", strtotime($order->order_date))}}</td>		@endif
									@if($columns['Season'])			<td>{{$order->season}}</td>										@endif
									@if($columns['PO'])				<td>{{$order->po}}</td>											@endif
									@if($columns['Customer'])		<td>{{$order->customer}}</td>									@endif
									@if($columns['Style'])			<td></td>														@endif
									@if($columns['Colourway'])		<td></td>														@endif
									@if($columns['Qty'])			<td></td>														@endif
									@if($columns['Total Qty'])		<td></td>														@endif
									<td class="dont-print">
										<div class="btn-group">
											<button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'edit-dev'})" wire:click="$dispatch('edit-order', { order: {{$order->id}} })">Edit</button>
											@can('admin')
												<button class="btn btn-info" x-data x-on:click="$dispatch('open-modal', {name:'edit-order-v2'})" wire:click="$dispatch('edit-order-v2', { order: {{$order->id}} })">Edit V2</button>
											@endcan
											@can("order:delete")
												<button class="btn btn-danger" wire:click="delete({{$order->id}})" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">X</button>
											@endcan
										</div>
									</td>
								</tr>
							@endif
							@foreach($order->styles as $style)
								<tr wire:key="style{{$order->id}}">
									@if($columns['Order Date'] && $loop->first)		<td rowspan="{{$order->styles_qty}}">{{date("d-M-Y", strtotime($order->order_date))}}</td>		@endif
									@if($columns['Season'] && $loop->first)			<td rowspan="{{$order->styles_qty}}">{{$order->season}}</td>									@endif
									@if($columns['PO'] && $loop->first)				<td rowspan="{{$order->styles_qty}}">{{$order->po}}</td>										@endif
									@if($columns['Customer'] && $loop->first)		<td rowspan="{{$order->styles_qty}}">{{$order->customer}}</td>									@endif
									@if($columns['Style'])							<td @if($style->deleted) class="text-danger" style="text-decoration: line-through;" @endif>{{$style->design}} | {{$style->style}} | {{$style->description}} ({{$style->version_name}})</td>													@endif
									@if($columns['Colourway'])						<td @if($style->deleted) class="text-danger" style="text-decoration: line-through;" @can('order:update') wire:click="restore({{$style->id}})" onclick="confirm('Are you sure you want to restore this line?') || event.stopImmediatePropagation()" @endcan @endif>{{Str::title($style->colourway)}}</td>@endif
									@if($columns['Qty'])							<td @if($style->deleted) class="text-danger" style="text-decoration: line-through;" @endif>{{$style->qty}}</td>																		@endif
									@if($columns['Total Qty'] && $loop->first)		<td rowspan="{{$order->styles_qty}}">{{$order->total_qty}}</td>									@endif
									@if($loop->first)
										<td class="dont-print" rowspan="{{$order->styles_qty}}">
											<div class="btn-group">
                                                {{-- @can('asd')
												    <button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'orders-update-change-season-cust'})" wire:click="$dispatch('edit-season-cust', { order: {{$order->id}} })">Change Season/Cust</button>
                                                @endcan --}}
												<button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'edit-dev'})" wire:click="$dispatch('edit-order', { order: {{$order->id}} })">Edit</button>
                                                @can('admin')
                                                    <button class="btn btn-info" x-data x-on:click="$dispatch('open-modal', {name:'edit-order-v2'})" wire:click="$dispatch('edit-order-v2', { order: {{$order->id}} })">Edit V2</button>
                                                @endcan
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                        More
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="#" x-data x-on:click="$dispatch('open-modal', {name:'orders-update-change-season-cust'})" wire:click="$dispatch('edit-season-cust', { order: {{$order->id}} })">Change Season/Cust</a></li>
                                                        @can("order:delete")
                                                            <li><a class="bg-red dropdown-item" href="#"  wire:click="delete({{$order->id}})" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Delete</a></li>
                                                        @endcan
                                                    </ul>
                                                </div>
											</div>
										</td>
									@endif
								</tr>
							@endforeach
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<x-modal name="new-order" title="New Order">
        <x-slot:body>
            <livewire:sales.orders.orders-new wire:key="new">
        </x-slot:body>
    </x-modal>
    <x-modal name="edit-dev" title="Edit Order" size="modal-fullscreen">
		<x-slot:body>
			<livewire:sales.orders.orders-edit wire:key="orderEdit">
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-order-v2" title="Edit Order (V2)" size="modal-fullscreen">
		<x-slot:body>
			<livewire:sales.orders.orders-edit-v2 wire:key="orderEditV2">
		</x-slot:body>
	</x-modal>
    <x-modal name="orders-update-change-season-cust" title="Edit Season/Customer" size="modal-sm">
		<x-slot:body>
			<livewire:sales.orders.orders-update-change-season-cust wire:key="orderEditSeasonCust">
		</x-slot:body>
	</x-modal>

    <x-footer>
        <x-slot:center>
            {{ $orders->links() }}
        </x-slot:center>
    </x-footer>
</div>
