<div>
    <div class="modal-body" style="height: calc(100vh - 150px);">
        @if(session('message'))
            <div class="alert {{ session('alert-class') }}">
                {{session('message') ?? ""}}
                @foreach (session('errors') ?? [] as $field => $errors)
                    <ul>
                        @foreach ($errors as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                @endforeach
            </div>
        @endif
		@if($order || $new)
        <form wire:submit="save">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-7">
                            <div class="accordion" id="accordionExample">
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        Standard
                                        </button>
                                    </h2>
                                    <div id="collapseOne" class="accordion-collapse collapse show">
                                        <div class="accordion-body">
                                            <div class="row">
                                                <div class="col">
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Department</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && $new)
                                                                <select class="form-select" wire:model.blur="form.orderEdit.departments_id">
                                                                    <option value=""></option>
                                                                    @foreach($this->departments as $department)
                                                                        <option value="{{$department->id}}">{{$department->description}}</option>
                                                                    @endforeach
                                                                </select>
                                                            @else
                                                                {{$form->order->departments->description ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center" @if(Gate::check('order:update') && !$viewOnly) style="height: 37px" @endif>
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Season</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && $new)
                                                                <select class="form-select" wire:model.blur="form.orderEdit.seasons_id">
                                                                    <option value=""></option>
                                                                    @foreach($this->seasons as $season)
                                                                        <option value="{{$season->id}}">{{$season->description}}</option>
                                                                    @endforeach
                                                                </select>
                                                            @else
                                                                {{$form->order->seasons->description ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center" @if(Gate::check('order:update') && !$viewOnly) style="height: 37px" @endif>
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Customer</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && $new)
                                                                <select class="form-select" wire:model.blur="form.orderEdit.customers_id">
                                                                    <option value=""></option>
                                                                    @foreach($this->customers as $customer)
                                                                        <option value="{{$customer->id}}">{{$customer->name}}</option>
                                                                    @endforeach
                                                                </select>
                                                                @else
                                                                {{$form->order->customers->name ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Incoterms</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                            <select class="form-select" wire:model.blur="form.orderEdit.incoterms">
                                                                <option value=""></option>
                                                                <option value="EXW">EXW</option>
                                                                <option value="FCA">FCA</option>
                                                                <option value="CPT">CPT</option>
                                                                <option value="CIP">CIP</option>
                                                                <option value="DAP">DAP</option>
                                                                <option value="DPU">DPU</option>
                                                                <option value="DDP">DDP</option>
                                                                <option value="FAS">FAS</option>
                                                                <option value="FOB">FOB</option>
                                                                <option value="CFR">CFR</option>
                                                                <option value="CIF">CIF</option>
                                                            </select>
                                                            @else
                                                                {{$form->order->incoterms ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center" @if(Gate::check('order:update') && !$viewOnly) style="height: 37px" @endif>
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Delivery Address</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <select class="form-select" wire:model.blur="form.orderEdit.customer_addresses_id">
                                                                    <option value=""></option>
                                                                    @foreach($form->order->customers->customer_addresses ?? [] as $address)
                                                                        <option value="{{$address->id}}">{{$address->name}}</option>
                                                                    @endforeach
                                                                </select>
                                                            @else
                                                                {{$form->order->customer_addresses->name ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Shipment Mode</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <input class="form-control" type="text" wire:model.blur="form.orderEdit.shipment_mode">
                                                            @else
                                                                {{$form->order?->shipment_mode ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Purchase Order No.</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <input class="form-control" type="text" wire:model.blur="form.orderEdit.customer_po">
                                                            @else
                                                                {{$form->order?->customer_po ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Order Date</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <input class="form-control" type="date" wire:model.blur="form.orderEdit.order_date">
                                                            @else
                                                                {{$form->order?->order_date ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Total Value</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            {{$form->order?->customers?->currency}}{{number_format($form->order?->totalSale,2)}}
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Total Qty</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @can('admin')
                                                                {{$form->order?->totalQty}}
                                                            @endcan
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-sm-5">
                                                            <h6 class="mb-0 fw-bold">Files</h6>
                                                        </div>
                                                        <div class="col-sm-7">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <input multiple type="file" class="form-control" wire:model.blur="form.uploadFiles">
                                                            @endif
                                                            <ul class="list-group mt-2">
                                                                @foreach($order->customer_order_files ?? [] as $f=>$file)
                                                                    <li class="list-group-item">
                                                                        @if(Gate::check('order:update') && !$viewOnly)
                                                                            <input type="button" class="btn btn-sm btn-danger" style="width: unset; display: unset;" value="X" wire:click.prevent="deleteFile({{$f}}, {{$file['id']}}, '{{$file['file']}}')">
                                                                        @endif
                                                                        <a class="text-decoration-none" download href="{{url(asset('storage/' . ($file['file'] ?? $file->file)))}}">{{ $file['filename'] ?? $file->filename }}</a>
                                                                    </li>
                                                                @endforeach
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="true" aria-controls="collapseOne">
                                        Advanced
                                        </button>
                                    </h2>
                                    <div id="collapseTwo" class="accordion-collapse collapse">
                                        <div class="accordion-body">
                                            <div class="row">
                                                <div class="col">
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Customer Shipment No</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <input class="form-control" type="text" wire:model="form.orderEdit.cust_ship_no">
                                                            @else
                                                                {{$form->order->cust_ship_no ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Sent To Factory</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <input class="form-control" type="date" wire:model="form.orderEdit.sent_to_factory">
                                                            @else
                                                                {{$form->order->sent_to_factory ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Phase</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <select class="form-select" wire:model="form.orderEdit.phase_id">
                                                                    <option value="">None</option>
                                                                    @foreach($this->phases as $phase)
                                                                        <option value="{{$phase->id}}">{{$phase->name}}</option>
                                                                    @endforeach
                                                                </select>
                                                            @else
                                                                {{$form->order->phase->name ?? ""}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Incomplete</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                            <select class="form-select" wire:model="form.orderEdit.incomplete_flag">
                                                                <option value="1">Yes</option>
                                                                <option value="0">No</option>
                                                            </select>
                                                            @else
                                                                {{($form->order->incomplete_flag ?? 0) ? "Yes" : "No"}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Cancelled</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(Gate::check('order:update') && !$viewOnly)
                                                                <select class="form-select" wire:model="form.orderEdit.cancelled">
                                                                    <option value="1">Yes</option>
                                                                    <option value="0">No</option>
                                                                </select>
                                                            @else
                                                                {{($form->order->cancelled ?? 0) ? "Yes" : "No"}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row align-items-center">
                                                        <div class="col-5">
                                                            <h6 class="mb-0 fw-bold">Last Updated By</h6>
                                                        </div>
                                                        <div class="col-7" style="height: 37px">
                                                            @if(!empty($form->order))
                                                                {{$form->order?->audits()->with('user')->first()?->user?->name}}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    {{-- APPLY EXFTY ACROSS ALL LINE --}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col" style="max-height: 555px; overflow-y: scroll">
                            <div class="d-grid gap-2">
                                @foreach($order->customer_order_lines ?? [] as $c=>$colourway)
                                    <div class="btn-group">
                                        <button
                                            style="border: var(--bs-border-color) solid 1px; padding: 0.9rem"
                                            class="btn d-flex btn-block rounded-0 @if(($colourway['id'] ?? $colourway->id) == $lineEdit) bg-primary text-light @elseif(($colourway['cancelled'] ?? $colourway->cancelled)) bg-red @endif"
                                            wire:click.prevent="editLine({{$colourway['id'] ?? $colourway->id}})"
                                            >
                                            <div class="col-8 text-start">
                                                <b>{{$colourway->colourways->style_versions->styles->designs_id ?? ($colourway['colourways']['style_versions']['styles']['designs_id'] ?? "")}}</b> |
                                                {{$colourway->colourways->style_versions->styles->customer_ref ?? ($colourway['colourways']['style_versions']['styles']['customer_ref'] ?? "")}} |
                                                {{$colourway->colourways->style_versions->factories->name ?? ($colourway['colourways']['style_versions']['factories']['name'] ?? "")}} |
                                                {{$colourway->colourways->style_versions->styles->designs->description ?? ($colourway['colourways']['style_versions']['styles']['designs']['description'] ?? "")}}
                                            </div>
                                            <div class="col-4 text-end">
                                                ({{$colourway->colourways->style_versions->name ?? ($colourway['colourways']['style_versions']['name'] ?? "")}})<b> {{$colourway->colourways->name ?? ($colourway['colourways']['name'] ?? "")}}</b>
                                            </div>
                                        </button>
                                        <button
                                            style="border: var(--bs-border-color) solid 1px; padding: 0.9rem; max-width: 40px; align-items: center;"
                                            class="btn btn-primary d-flex btn-block rounded-0"
                                            wire:click.prevent="changeItem({{$colourway['id'] ?? $colourway->id}})"
                                            >
                                            ↻
                                        </button>

                                        <button
                                            style="border: var(--bs-border-color) solid 1px; padding: 0.9rem; max-width: 40px; align-items: center;"
                                            class="btn btn-primary d-flex btn-block rounded-0"
                                            wire:click.prevent="cancelItem({{$colourway['id'] ?? $colourway->id}}, {{$c}})"
                                            >
                                            C
                                        </button>

                                        <button
                                            style="border: var(--bs-border-color) solid 1px; padding: 0.9rem; max-width: 40px; align-items: center;"
                                            class="btn btn-danger d-flex btn-block rounded-0"
                                            wire:click.prevent="dropItem({{$colourway['id'] ?? $colourway->id}}, {{$c}})"
                                            onclick="confirm('This will delete the item and shipments associated. Continue?') || event.stopImmediatePropagation()"
                                            >
                                            X
                                        </button>
                                    </div>
                                @endforeach
                                @if(count($form->orderEdit['customer_order_lines'] ?? []) == 0)
                                    <button class="btn btn-primary" type="button" wire:click="$toggle('itemPicker')">
                                        Add Item
                                    </button>
                                @else
                                    @if(!$multipleShipmentLines)
                                        <button class="btn btn-primary"  wire:click.prevent="$toggle('quickAdd')">Quick Edit All</button>
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col">
                    @if($quickAdd)
                        <livewire:sales.orders.orders-edit-quickadd orderID="{{$order->id}}" wire:key="quickAdd{{$order->id}}">
                    @else
                        <livewire:sales.orders.orders-edit-line id="{{$lineEdit}}" orderType="{{$order->order_type}}" wire:key="{{$lineEdit}}">
                    @endif
                </div>
            </div>
        </form>
    @endif

    @if($itemPickerChange == 1 && $itemPickerLine)
        <ul class="dropdown-menu  show " style="
            position: absolute;
            inset: 0px auto auto 0px;
            transform: translate(0px, 0px) !important;
            background: #e9e9e9;
            width: calc(100% - 40px);
            padding: 20px;
            margin: 20px;">
                <div>Changing Item:  <b>{{$order->customer_order_lines->find($itemPickerLine)->colourways->style_versions->styles->customer_ref}} - {{$order->customer_order_lines->find($itemPickerLine)->colourways->name}}</b></div>
                <hr>
                <input type="text" class="form-control" wire:model.live="itemSearch">
                <div class="my-3" style="max-height: 250px; overflow: auto;">
                    <h3>Change Item</h3>
                    <table class="table">
                        <thead>
                            <th>RTD</th>
                            <th>Cust. Ref</th>
                            <th>Factory</th>
                            <th>Description</th>
                            <th>Colour</th>
                            <th>Price</th>
                        </thead>
                        <tbody>
                            @foreach($this->items() as $item)
                                <tr class="@if($item->style_versions->prices->where('quote_status', 'confirmed')->first() != NULL) bg-good @endif"  style="cursor: pointer;" wire:click="editItem({{$item->id}})" onclick="confirm('This will change the existing item to the selected one. Continue?') || event.stopImmediatePropagation()">
                                    <td>{{$item->style_versions->styles->designs_id}}</td>
                                    <td>{{$item->style_versions->styles->customer_ref}} ({{$item->style_versions->name}})</td>
                                    <td>{{$item->style_versions->factories?->name}}</td>
                                    <td>{{$item->style_versions->styles->designs->description}}</td>
                                    <td>{{$item->name}} ({{$item->id}})</td>
                                    <td>{{$item->price_model['price']['quote'] ?? "-"}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="col text-end">
                    <button class="btn btn-secondary" type="button" wire:click="$toggle('itemPickerChange')">Close</button>
                </div>
        </ul>
    @endif

    </div>
    <div class="modal-footer" style="display: block">
        <div class="row">
            <div class="col">
                @if($quickAdd)
                    <p class="text-danger fw-bold fs-4 mb-0">Saving here will overwrite dates on all lines.</p>
                @endif
            </div>
            <div class="col d-flex justify-content-end" style="justify-content: flex-end !important; align-items: center; gap: 5px;">
                {{-- @if($this->canChangeSeasonCustomer())
                    <button class="btn btn-primary" type="button" wire:click="$toggle('changeSeasonCust')">
                        Change Customer/Season
                    </button>
                @endif --}}
                <button class="btn btn-primary" type="button" wire:click="$toggle('deletedItems')">
                    Restore Lines
                </button>
                @if($deletedItems == 1)
                    <ul class="dropdown-menu  show " style="
                        position: absolute;
                        inset: 0px auto auto 0px;
                        transform: translate(0px, 0px) !important;
                        background: #e9e9e9;
                        width: calc(100% - 40px);
                        padding: 20px;
                        margin: 20px;">
                            <div class="my-3" style="max-height: 550px; overflow: auto;">
                                <table class="table">
                                    <thead>
                                        <th>RTD</th>
                                        <th>Cust. Ref</th>
                                        <th>Factory</th>
                                        <th>Description</th>
                                        <th>Colour</th>
                                        <th>Price</th>
                                    </thead>
                                    <tbody>
                                        @forelse($this->deletedItemsList ?? [] as $item)
                                            <tr style="cursor: pointer;" wire:click="restoreItem({{$item->id}})">
                                                <td>{{$item->colourways->style_versions->styles->designs_id}}</td>
                                                <td>{{$item->colourways->style_versions->styles->customer_ref}} ({{$item->style_versions?->name}})</td>
                                                <td>{{$item->colourways->style_versions->factories?->name}}</td>
                                                <td>{{$item->colourways->style_versions->styles->designs->description}}</td>
                                                <td>{{$item->colourways->name}}</td>
                                                <td>{{$item->price_model['price']['quote'] ?? "-"}}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td>None found.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <div class="col text-end">
                                <button class="btn btn-secondary" type="button" wire:click="$toggle('deletedItems')">Close</button>
                            </div>
                    </ul>
                @endif
                @if(!$multipleShipmentLines)
                    <button class="btn btn-primary"  wire:click.prevent="$toggle('quickAdd')">Quick Edit All</button>
                @endif
                <button class="btn btn-primary" type="button" wire:click="$toggle('itemPicker')">
                    Add Item
                </button>
                <ul class="dropdown-menu @if($itemPicker == 1) show @endif" style="
                    position: absolute;
                    inset: 0px auto auto 0px;
                    transform: translate(0px, 0px) !important;
                    background: #e9e9e9;
                    width: calc(100% - 40px);
                    padding: 20px;
                    margin: 20px;">
                        <input type="text" class="form-control" wire:model.live="itemSearch">
                        <div class="my-3" style="max-height: 550px; overflow: auto;">
                            <table class="table">
                                <thead>
                                    <th>RTD</th>
                                    <th>Cust. Ref</th>
                                    <th>Factory</th>
                                    <th>Description</th>
                                    <th>Colour</th>
                                    <th>Price</th>
                                </thead>
                                <tbody>
                                    @foreach($this->items() as $item)
                                        <tr class="@if($item->style_versions->prices->where('quote_status', 'confirmed')->first() != NULL) bg-good @endif"  style="cursor: pointer;" wire:click="addItemToList({{$item->id}})">
                                            <td>{{$item->style_versions->styles->designs_id}}</td>
                                            <td>{{$item->style_versions->styles->customer_ref}} ({{$item->style_versions->name}})</td>
                                            <td>{{$item->style_versions->factories?->name}}</td>
                                            <td>{{$item->style_versions->styles->designs->description}}</td>
                                            <td>{{$item->name}} ({{$item->id}})</td>
                                            <td>{{$item->price_model['price']['quote'] ?? "-"}}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="col text-end">
                            <button class="btn btn-secondary" type="button" wire:click="$toggle('itemPicker')">Close</button>
                        </div>
                </ul>
                @if(Gate::check('order:update') && !$viewOnly)
                    <button class="btn btn-primary"  wire:click.prevent="save">Save</button>
                    <button class="btn btn-danger"  wire:click.prevent="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
                @else
                    <button class="btn btn-primary"  wire:click.prevent="$dispatch('close-modal')">Close</button>
                @endif
            </div>
        </div>
    </div>
</div>
