{{-- Quick Edit Mode Component --}}
<div class="oe2-quick-edit">
    
    {{-- Warning Banner --}}
    <div class="alert alert-warning mb-3">
        <i class="fa fa-exclamation-triangle"></i>
        <strong>Warning:</strong> Changes made here will apply to ALL order lines.
    </div>
    
    {{-- Global Date Fields --}}
    <div class="oe2-quick-dates card mb-3">
        <div class="card-body">
            <h6 class="card-title mb-3">Apply Dates to All Lines</h6>
            <div class="row g-2">
                <div class="col-md-3">
                    <label class="form-label small">ExFty</label>
                    <input type="date" 
                           class="form-control form-control-sm"
                           @if($this->readOnly) disabled @endif>
                </div>
                <div class="col-md-3">
                    <label class="form-label small">Customer ExFty</label>
                    <input type="date" 
                           class="form-control form-control-sm"
                           @if($this->readOnly) disabled @endif>
                </div>
                <div class="col-md-3">
                    <label class="form-label small">Into W/H</label>
                    <input type="date" 
                           class="form-control form-control-sm"
                           @if($this->readOnly) disabled @endif>
                </div>
                <div class="col-md-3">
                    <label class="form-label small">Start Knit</label>
                    <input type="date" 
                           class="form-control form-control-sm"
                           @if($this->readOnly) disabled @endif>
                </div>
            </div>
            @if(!$this->readOnly)
            <div class="mt-2">
                <button class="btn btn-primary btn-sm">
                    <i class="fa fa-calendar-check"></i> Apply Dates to All
                </button>
            </div>
            @endif
        </div>
    </div>
    
    {{-- Global Size Management --}}
    @if(!$this->readOnly)
    <div class="oe2-quick-sizes card mb-3">
        <div class="card-body">
            <h6 class="card-title mb-3">Size Management (All Lines)</h6>
            <div class="btn-group btn-group-sm">
                <button class="btn btn-outline-primary">
                    <i class="fa fa-plus-circle"></i> Add Size to All
                </button>
                <button class="btn btn-outline-primary">
                    <i class="fa fa-th"></i> Add Customer Sizes to All
                </button>
                <button class="btn btn-outline-danger">
                    <i class="fa fa-trash"></i> Remove Size from All
                </button>
            </div>
        </div>
    </div>
    @endif
    
    {{-- Quick Edit Table --}}
    <div class="oe2-quick-table-container">
        <div class="table-responsive">
            <table class="table table-sm table-hover oe2-quick-table">
                <thead class="sticky-top">
                    <tr>
                        <th class="oe2-quick-item-col">Item</th>
                        @php
                            $allSizes = collect();
                            foreach($this->orderLines as $line) {
                                $lineSizes = $line->customer_order_line_quantities->pluck('sizes')->pluck('name', 'id');
                                $allSizes = $allSizes->merge($lineSizes);
                            }
                            $uniqueSizes = $allSizes->unique()->sort();
                        @endphp
                        @foreach($uniqueSizes as $sizeId => $sizeName)
                            <th class="text-center oe2-quick-size-col">
                                {{ $sizeName }}
                            </th>
                        @endforeach
                        <th class="text-center fw-bold">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($this->orderLines as $line)
                        {{-- Line Info Row --}}
                        <tr class="oe2-quick-line-row">
                            <td class="oe2-quick-item-col">
                                <div class="d-flex align-items-center">
                                    <div class="oe2-quick-thumb me-2">
                                        @if($line->colourways->style_versions->image_base64)
                                            <img src="data:image/jpeg;base64,{{ $line->colourways->style_versions->image_base64 }}" 
                                                 alt="Item"
                                                 loading="lazy">
                                        @else
                                            <i class="fa fa-image"></i>
                                        @endif
                                    </div>
                                    <div class="small">
                                        <div class="fw-bold">{{ $line->colourways->style_versions->styles->designs_id ?? 'N/A' }}</div>
                                        <div class="text-muted">
                                            {{ $line->colourways->style_versions->styles->customer_ref ?? '' }} | 
                                            {{ $line->colourways->name ?? '' }}
                                        </div>
                                    </div>
                                </div>
                            </td>
                            @foreach($uniqueSizes as $sizeId => $sizeName)
                                @php
                                    $qty = $line->customer_order_line_quantities->where('sizes_id', $sizeId)->first();
                                @endphp
                                <td>
                                    <input type="number" 
                                           class="form-control form-control-sm text-center"
                                           value="{{ $qty->qty ?? '' }}"
                                           min="0"
                                           placeholder="-"
                                           @if($this->readOnly) disabled @endif>
                                </td>
                            @endforeach
                            <td class="text-center fw-bold">
                                {{ $line->customer_order_line_quantities->sum('qty') }}
                            </td>
                        </tr>
                        
                        {{-- Packed Row (if line has drops) --}}
                        @if($line->shipment_lines->count() > 0)
                        <tr class="oe2-quick-packed-row">
                            <td class="oe2-quick-item-col ps-5">
                                <small class="text-muted"><i class="fa fa-box"></i> Packed</small>
                            </td>
                            @foreach($uniqueSizes as $sizeId => $sizeName)
                                @php
                                    $packedQty = 0;
                                    foreach($line->shipment_lines as $drop) {
                                        $packedQty += $drop->shipment_line_sizes->where('sizes_id', $sizeId)->sum('shipped_qty');
                                    }
                                @endphp
                                <td>
                                    <input type="number" 
                                           class="form-control form-control-sm text-center"
                                           value="{{ $packedQty > 0 ? $packedQty : '' }}"
                                           min="0"
                                           placeholder="-"
                                           @if($this->readOnly) disabled @endif>
                                </td>
                            @endforeach
                            <td class="text-center">
                                @php
                                    $totalPacked = 0;
                                    foreach($line->shipment_lines as $drop) {
                                        $totalPacked += $drop->shipment_line_sizes->sum('shipped_qty');
                                    }
                                @endphp
                                {{ $totalPacked }}
                            </td>
                        </tr>
                        @endif
                    @endforeach
                    
                    {{-- Totals Row --}}
                    <tr class="table-secondary fw-bold">
                        <td>TOTAL</td>
                        @foreach($uniqueSizes as $sizeId => $sizeName)
                            @php
                                $sizeTotal = 0;
                                foreach($this->orderLines as $line) {
                                    $qty = $line->customer_order_line_quantities->where('sizes_id', $sizeId)->first();
                                    $sizeTotal += $qty->qty ?? 0;
                                }
                            @endphp
                            <td class="text-center">{{ $sizeTotal }}</td>
                        @endforeach
                        <td class="text-center">
                            {{ $this->orderLines->sum(function($line) {
                                return $line->customer_order_line_quantities->sum('qty');
                            }) }}
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    
    {{-- Save Button --}}
    @if(!$this->readOnly)
    <div class="text-center mt-3">
        <button class="btn btn-primary">
            <i class="fa fa-save"></i> Save All Changes
        </button>
    </div>
    @endif
    
</div>

