{{-- Order Lines Sidebar List --}}
<div class="oe2-lines-list">
    @foreach($this->orderLines as $line)
        <div wire:key="line-{{ $line->id }}" 
             class="oe2-line-card {{ $activeLineId === $line->id ? 'active' : '' }} {{ $line->cancelled ? 'cancelled' : '' }}"
             wire:click="selectLine({{ $line->id }})">
            
            {{-- Line Thumbnail --}}
            <div class="oe2-line-thumb">
                @if($line->colourways->style_versions->image_base64)
                    <img src="data:image/jpeg;base64,{{ $line->colourways->style_versions->image_base64 }}" 
                         alt="Item" 
                         loading="lazy">
                @else
                    <div class="oe2-line-thumb-placeholder">
                        <i class="fa fa-image"></i>
                    </div>
                @endif
            </div>
            
            {{-- Line Info --}}
            <div class="oe2-line-info">
                <div class="oe2-line-title">
                    <strong>{{ $line->colourways->style_versions->styles->designs_id ?? 'N/A' }}</strong>
                    @if($line->cancelled)
                        <span class="badge bg-danger ms-1">Cancelled</span>
                    @endif
                </div>
                <div class="oe2-line-meta">
                    <small class="text-muted">
                        {{ $line->colourways->style_versions->styles->customer_ref ?? '' }}
                        @if($line->colourways->style_versions->styles->customer_ref && $line->colourways->name)
                            |
                        @endif
                        {{ $line->colourways->name ?? '' }}
                    </small>
                </div>
                <div class="oe2-line-meta">
                    <small class="text-muted">
                        <i class="fa fa-building"></i>
                        {{ $line->colourways->style_versions->factories->name ?? 'N/A' }}
                    </small>
                </div>
                
                {{-- Quick Stats --}}
                <div class="oe2-line-stats mt-1">
                    <span class="badge bg-light text-dark">
                        Qty: {{ $line->customer_order_line_quantities->sum('qty') }}
                    </span>
                    @if($line->shipment_lines->count() > 0)
                        <span class="badge bg-info text-dark">
                            {{ $line->shipment_lines->count() }} {{ Str::plural('Drop', $line->shipment_lines->count()) }}
                        </span>
                    @endif
                </div>
            </div>
            
            {{-- Line Actions --}}
            <div class="oe2-line-actions" @click.stop>
                <div class="btn-group btn-group-sm">
                    <button wire:click="openItemPicker('change', {{ $line->id }})" 
                            class="btn btn-sm btn-outline-primary"
                            title="Change Item"
                            @if($this->readOnly) disabled @endif>
                        <i class="fa fa-sync"></i>
                    </button>
                    <button wire:click="toggleCancelLine({{ $line->id }})" 
                            class="btn btn-sm btn-outline-primary"
                            title="{{ $line->cancelled ? 'Un-cancel' : 'Cancel' }}"
                            @if($this->readOnly) disabled @endif>
                        <i class="fa fa-exclamation-circle"></i>
                    </button>
                    <button wire:click="deleteLine({{ $line->id }})" 
                            class="btn btn-sm btn-outline-primary"
                            title="Delete"
                            onclick="return confirm('Are you sure you want to delete this line?')"
                            @if($this->readOnly) disabled @endif>
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    @endforeach
</div>

