{{-- Line Editor Component --}}
@if($this->activeLine)
<div class="oe2-line-editor-content" x-data="{ 
    showDates: true,
    showNotes: false  
}">
    
    {{-- Line Header --}}
    <div class="oe2-line-header">
        <div class="d-flex align-items-start">
            <div class="oe2-line-header-thumb">
                @if($this->activeLine->colourways->style_versions->image_base64)
                    <img src="data:image/jpeg;base64,{{ $this->activeLine->colourways->style_versions->image_base64 }}" 
                         alt="Item">
                @else
                    <div class="oe2-line-header-thumb-placeholder">
                        <i class="fa fa-image"></i>
                    </div>
                @endif
            </div>
            <div class="flex-grow-1">
                <h6 class="mb-1">
                    {{ $this->activeLine->colourways->style_versions->styles->designs_id ?? 'N/A' }}
                    @if($this->activeLine->cancelled)
                        <span class="badge bg-danger">Cancelled</span>
                    @endif
                </h6>
                <div class="text-muted small">
                    <div>Customer Ref: {{ $this->activeLine->colourways->style_versions->styles->customer_ref ?? 'N/A' }}</div>
                    <div>Style: {{ $this->activeLine->colourways->style_versions->name ?? 'N/A' }}</div>
                    <div>Colourway: {{ $this->activeLine->colourways->name ?? 'N/A' }}</div>
                    <div>Factory: {{ $this->activeLine->colourways->style_versions->factories->name ?? 'N/A' }}</div>
                </div>
            </div>
        </div>
    </div>
    
    {{-- Line Tabs --}}
    <ul class="nav nav-tabs oe2-line-tabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" 
                    x-on:click="showDates = true; showNotes = false"
                    :class="showDates ? 'active' : ''">
                <i class="fa fa-calendar"></i> Dates & Quantities
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" 
                    x-on:click="showDates = false; showNotes = true"
                    :class="showNotes ? 'active' : ''">
                <i class="fa fa-sticky-note"></i> Notes
            </button>
        </li>
    </ul>
    
    {{-- Dates & Quantities Tab --}}
    <div x-show="showDates" class="oe2-line-tab-content">
        
        {{-- Date Fields --}}
        <div class="row g-2 mb-3">
            @php
                $totalDrops = $this->activeLine->shipment_lines->count() + ($this->pendingDrops[$this->activeLine->id] ?? 0);
            @endphp
            @if($totalDrops === 1 && $this->activeLine->shipment_lines->count() === 1)
                {{-- Show ExFty when there's exactly 1 drop (and it exists) --}}
                @php
                    $singleDrop = $this->activeLine->shipment_lines->first();
                @endphp
                <div class="col-md-3">
                    <label class="form-label small">ExFty</label>
                    <input type="date" 
                           class="form-control form-control-sm"
                           value="{{ $singleDrop->exfty?->format('Y-m-d') ?? '' }}"
                           wire:change="updateDropExfty({{ $singleDrop->id }}, $event.target.value)"
                           @if($this->readOnly) disabled @endif>
                </div>
            @endif
            <div class="{{ $totalDrops === 1 && $this->activeLine->shipment_lines->count() === 1 ? 'col-md-3' : 'col-md-4' }}">
                <label class="form-label small">Customer ExFty</label>
                <input type="date" 
                       class="form-control form-control-sm"
                       value="{{ $this->activeLine->factory_cust_date?->format('Y-m-d') ?? '' }}"
                       wire:change="updateLineDate('factory_cust_date', $event.target.value)"
                       @if($this->readOnly) disabled @endif>
            </div>
            <div class="{{ $this->activeLine->shipment_lines->count() === 1 ? 'col-md-3' : 'col-md-4' }}">
                <label class="form-label small">Into W/H</label>
                <input type="date" 
                       class="form-control form-control-sm"
                       value="{{ $this->activeLine->wh_cust_date?->format('Y-m-d') ?? '' }}"
                       wire:change="updateLineDate('wh_cust_date', $event.target.value)"
                       @if($this->readOnly) disabled @endif>
            </div>
            <div class="{{ $this->activeLine->shipment_lines->count() === 1 ? 'col-md-3' : 'col-md-4' }}">
                <label class="form-label small">Start Knit</label>
                <input type="date" 
                       class="form-control form-control-sm"
                       value="{{ $this->activeLine->start_knit?->format('Y-m-d') ?? '' }}"
                       wire:change="updateLineDate('start_knit', $event.target.value)"
                       @if($this->readOnly) disabled @endif>
            </div>
        </div>
        
        {{-- Size Management Actions --}}
        @if(!$this->readOnly)
        <div class="oe2-size-actions mb-2">
            <div class="btn-group btn-group-sm">
                <button wire:click="addSize" class="btn btn-sm btn-outline-primary">
                    <i class="fa fa-plus-circle"></i> Add Size
                </button>
                <button wire:click="addCustomerSizes" class="btn btn-sm btn-outline-primary">
                    <i class="fa fa-th"></i> Add Customer Sizes
                </button>
                <button wire:click="addDrop" class="btn btn-sm btn-outline-primary">
                    <i class="fa fa-layer-group"></i> Add Drop
                </button>
            </div>
        </div>
        @endif
        
        {{-- Quantities Table --}}
        <div class="oe2-quantities-table-container">
            <div class="table-responsive">
                <table class="table table-sm oe2-quantities-table">
                    <thead class="sticky-top">
                        <tr>
                            <th class="oe2-qty-row-label">Size</th>
                            @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                @php
                                    $markedForDeletion = isset($this->pendingSizeRemovals[$this->activeLine->id]) 
                                        && in_array($qty->id, $this->pendingSizeRemovals[$this->activeLine->id]);
                                @endphp
                                <th class="text-center {{ $markedForDeletion ? 'bg-danger bg-opacity-25' : '' }}">
                                    @if(!$this->readOnly)
                                        <div class="input-group input-group-sm justify-content-center" style="width: fit-content; margin: 0 auto;">
                                            <input type="text" 
                                                   class="form-control form-control-sm text-center {{ $markedForDeletion ? 'text-decoration-line-through' : '' }}" 
                                                   value="{{ $qty->sizes->name }}"
                                                   x-on:blur="$wire.updateSizeName({{ $qty->id }}, $event.target.value)"
                                                   style="width: 60px; min-width: 60px;"
                                                   title="Edit size name"
                                                   {{ $markedForDeletion ? 'disabled' : '' }}>
                                            @if($markedForDeletion)
                                                <button wire:click="undoRemoveSize({{ $this->activeLine->id }}, {{ $qty->id }})" 
                                                        class="btn btn-success"
                                                        style="padding: 2px 8px;"
                                                        title="Undo removal">
                                                    <i class="fa fa-undo"></i>
                                                </button>
                                            @else
                                                <button x-on:click="if(confirm('Mark this size for removal?')) { $wire.removeSize({{ $qty->id }}) }" 
                                                        class="btn btn-danger"
                                                        style="padding: 2px 8px;"
                                                        title="Remove size">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                            @endif
                                        </div>
                                        @if($markedForDeletion)
                                            <small class="text-danger" style="font-size: 0.7rem;">Will be deleted</small>
                                        @endif
                                    @else
                                        {{ $qty->sizes->name }}
                                    @endif
                                </th>
                            @endforeach
                            {{-- Pending Sizes --}}
                            @if(isset($this->pendingSizes[$this->activeLine->id]))
                                @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                    <th class="text-center bg-warning bg-opacity-25">
                                        @if(!$this->readOnly)
                                            <div class="input-group input-group-sm justify-content-center" style="width: fit-content; margin: 0 auto;">
                                                <input type="text" 
                                                       class="form-control form-control-sm text-center" 
                                                       wire:model.live="pendingSizes.{{ $this->activeLine->id }}.{{ $tempId }}.size_name"
                                                       style="width: 60px; min-width: 60px;"
                                                       title="Edit size name">
                                                <button x-on:click="if(confirm('Remove this pending size?')) { $wire.removePendingSize({{ $this->activeLine->id }}, '{{ $tempId }}') }" 
                                                        class="btn btn-danger"
                                                        style="padding: 2px 8px;"
                                                        title="Remove pending size">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                            </div>
                                            <small class="text-muted" style="font-size: 0.7rem;">Pending</small>
                                        @else
                                            {{ $sizeData['size_name'] }}
                                        @endif
                                    </th>
                                @endforeach
                            @endif
                            <th class="text-center fw-bold">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- Price Row (Wholesale) --}}
                        @if($this->order && $this->order->order_type === 'wholesale')
                        <tr class="oe2-row-price">
                            <td class="oe2-qty-row-label">Price</td>
                            @php
                                $prices = $this->activeLine->colourways->style_versions->prices ?? collect();
                                // Batch load all prices that are referenced
                                $priceIds = $this->activeLine->customer_order_line_quantities->pluck('prices_id')->filter()->unique()->values();
                                $loadedPrices = $priceIds->isNotEmpty() ? \App\Models\Price::whereIn('id', $priceIds)->get()->keyBy('id') : collect();
                            @endphp
                            @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                @php
                                    $markedForDeletion = isset($this->pendingSizeRemovals[$this->activeLine->id]) 
                                        && in_array($qty->id, $this->pendingSizeRemovals[$this->activeLine->id]);
                                    $currentPriceQuote = null;
                                    if ($qty->prices_id && $loadedPrices->has($qty->prices_id)) {
                                        $currentPriceQuote = $loadedPrices[$qty->prices_id]->quote;
                                    } elseif ($qty->price_model && isset($qty->price_model['quote'])) {
                                        $currentPriceQuote = $qty->price_model['quote'];
                                    }
                                @endphp
                                <td class="{{ $markedForDeletion ? 'bg-danger bg-opacity-10' : '' }}">
                                    <select class="form-select form-select-sm {{ $markedForDeletion ? 'text-decoration-line-through' : '' }}"
                                            value="{{ $qty->prices_id ?? '' }}"
                                            @if($this->readOnly || $markedForDeletion) disabled @endif>
                                        <option value="">Default Price{{ $currentPriceQuote ? ' (' . number_format($currentPriceQuote, 2) . ')' : '' }}</option>
                                        @foreach($prices as $price)
                                            <option value="{{ $price->id }}" {{ $qty->prices_id == $price->id ? 'selected' : '' }}>
                                                {{ number_format($price->quote, 2) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            @endforeach
                            {{-- Pending Sizes --}}
                            @if(isset($this->pendingSizes[$this->activeLine->id]))
                                @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                    <td class="bg-warning bg-opacity-10">
                                        <select class="form-select form-select-sm"
                                                wire:model.live="pendingSizes.{{ $this->activeLine->id }}.{{ $tempId }}.price_id"
                                                @if($this->readOnly) disabled @endif>
                                            <option value="">Default Price</option>
                                            @foreach($prices as $price)
                                                <option value="{{ $price->id }}">
                                                    {{ number_format($price->quote, 2) }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                @endforeach
                            @endif
                            <td></td>
                        </tr>
                        @endif
                        
                        {{-- Ordered Row --}}
                        <tr class="oe2-row-ordered">
                            <td class="oe2-qty-row-label">Ordered</td>
                            @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                @php
                                    $markedForDeletion = isset($this->pendingSizeRemovals[$this->activeLine->id]) 
                                        && in_array($qty->id, $this->pendingSizeRemovals[$this->activeLine->id]);
                                @endphp
                                <td class="{{ $markedForDeletion ? 'bg-danger bg-opacity-10' : '' }}">
                                    <input type="number" 
                                           class="form-control form-control-sm text-center {{ $markedForDeletion ? 'text-decoration-line-through' : '' }}"
                                           value="{{ $qty->qty }}"
                                           min="0"
                                           wire:change="updateQuantity({{ $qty->id }}, $event.target.value)"
                                           @if($this->readOnly || $markedForDeletion) disabled @endif>
                                </td>
                            @endforeach
                            {{-- Pending Sizes --}}
                            @if(isset($this->pendingSizes[$this->activeLine->id]))
                                @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                    <td class="bg-warning bg-opacity-10">
                                        <input type="number" 
                                               class="form-control form-control-sm text-center"
                                               wire:model.live="pendingSizes.{{ $this->activeLine->id }}.{{ $tempId }}.qty"
                                               min="0"
                                               @if($this->readOnly) disabled @endif>
                                    </td>
                                @endforeach
                            @endif
                            <td class="text-center fw-bold">
                                @php
                                    $savedTotal = $this->activeLine->customer_order_line_quantities->sum('qty');
                                    $pendingTotal = isset($this->pendingSizes[$this->activeLine->id]) 
                                        ? array_sum(array_column($this->pendingSizes[$this->activeLine->id], 'qty'))
                                        : 0;
                                @endphp
                                {{ $savedTotal + $pendingTotal }}
                            </td>
                        </tr>
                        
                        {{-- Drops Section --}}
                        @if($totalDrops === 1 && $this->activeLine->shipment_lines->count() === 1)
                            {{-- Single Drop - Show only Packed row --}}
                            @php
                                $drop = $this->activeLine->shipment_lines->first();
                            @endphp
                            <tr class="oe2-row-packed">
                                <td class="oe2-qty-row-label">Packed</td>
                                @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                    @php
                                        $dropQty = $drop->shipment_line_sizes->where('sizes_id', $qty->sizes_id)->first();
                                    @endphp
                                    <td>
                                        <input type="number" 
                                               class="form-control form-control-sm text-center"
                                               value="{{ $dropQty->shipped_qty ?? 0 }}"
                                               min="0"
                                               @if($this->readOnly) disabled @endif>
                                    </td>
                                @endforeach
                                {{-- Pending Sizes --}}
                                @if(isset($this->pendingSizes[$this->activeLine->id]))
                                    @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                        <td class="bg-warning bg-opacity-10"></td>
                                    @endforeach
                                @endif
                                <td class="text-center">
                                    {{ $drop->shipment_line_sizes->sum('shipped_qty') }}
                                </td>
                            </tr>
                        @elseif($totalDrops > 1)
                            {{-- Multiple Drops - Show full drop headers --}}
                            @foreach($this->activeLine->shipment_lines as $drop)
                                @php
                                    $pendingSizeCount = isset($this->pendingSizes[$this->activeLine->id]) ? count($this->pendingSizes[$this->activeLine->id]) : 0;
                                @endphp
                                <tr class="oe2-row-drop-header">
                                    <td colspan="{{ $this->activeLine->customer_order_line_quantities->count() + $pendingSizeCount + 2 }}" class="bg-light">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <strong>Drop {{ $loop->iteration }}</strong>
                                            <div>
                                                <input type="date" 
                                                       class="form-control form-control-sm d-inline-block" 
                                                       style="width: auto;"
                                                       value="{{ $drop->exfty?->format('Y-m-d') ?? '' }}"
                                                       wire:change="updateDropExfty({{ $drop->id }}, $event.target.value)"
                                                       @if($this->readOnly) disabled @endif>
                                                @if(!$this->readOnly)
                                                    <button x-on:click="if(confirm('Delete this drop?')) { $wire.deleteDrop({{ $drop->id }}) }"
                                                            class="btn btn-sm btn-outline-danger ms-2"
                                                            title="Delete Drop">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr class="oe2-row-dropping">
                                    <td class="oe2-qty-row-label">Dropping</td>
                                    @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                        @php
                                            $dropQty = $drop->shipment_line_sizes->where('sizes_id', $qty->sizes_id)->first();
                                        @endphp
                                        <td>
                                            <input type="number" 
                                                   class="form-control form-control-sm text-center"
                                                   value="{{ $dropQty->qty ?? 0 }}"
                                                   min="0"
                                                   @if($this->readOnly) disabled @endif>
                                        </td>
                                    @endforeach
                                    {{-- Pending Sizes - not applicable to existing drops --}}
                                    @if(isset($this->pendingSizes[$this->activeLine->id]))
                                        @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                            <td class="bg-warning bg-opacity-10"></td>
                                        @endforeach
                                    @endif
                                    <td class="text-center">
                                        {{ $drop->shipment_line_sizes->sum('qty') }}
                                    </td>
                                </tr>
                                <tr class="oe2-row-packed">
                                    <td class="oe2-qty-row-label">Packed</td>
                                    @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                        @php
                                            $dropQty = $drop->shipment_line_sizes->where('sizes_id', $qty->sizes_id)->first();
                                        @endphp
                                        <td>
                                            <input type="number" 
                                                   class="form-control form-control-sm text-center"
                                                   value="{{ $dropQty->shipped_qty ?? 0 }}"
                                                   min="0"
                                                   @if($this->readOnly) disabled @endif>
                                        </td>
                                    @endforeach
                                    {{-- Pending Sizes - not applicable to existing drops --}}
                                    @if(isset($this->pendingSizes[$this->activeLine->id]))
                                        @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                            <td class="bg-warning bg-opacity-10"></td>
                                        @endforeach
                                    @endif
                                    <td class="text-center">
                                        {{ $drop->shipment_line_sizes->sum('shipped_qty') }}
                                    </td>
                                </tr>
                            @endforeach
                            
                            {{-- Pending Drops --}}
                            @if(isset($this->pendingDrops[$this->activeLine->id]) && $this->pendingDrops[$this->activeLine->id] > 0)
                                @for($i = 0; $i < $this->pendingDrops[$this->activeLine->id]; $i++)
                                    <tr class="oe2-row-drop-header">
                                        <td colspan="{{ $this->activeLine->customer_order_line_quantities->count() + $pendingSizeCount + 2 }}" class="bg-warning bg-opacity-25">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <strong>Drop {{ $this->activeLine->shipment_lines->count() + $i + 1 }} <small class="text-muted">(Pending - Save to Create)</small></strong>
                                                <div>
                                                    <input type="date" 
                                                           class="form-control form-control-sm d-inline-block" 
                                                           style="width: auto;"
                                                           wire:model.live="pendingDropData.{{ $this->activeLine->id }}.{{ $i }}.exfty"
                                                           @if($this->readOnly) disabled @endif>
                                                    @if(!$this->readOnly)
                                                        <button wire:click="removePendingDrop({{ $this->activeLine->id }})"
                                                                class="btn btn-sm btn-outline-danger ms-2"
                                                                title="Remove Pending Drop">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr class="oe2-row-dropping bg-warning bg-opacity-10">
                                        <td class="oe2-qty-row-label">Dropping</td>
                                        @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                            <td>
                                                <input type="number" 
                                                       class="form-control form-control-sm text-center"
                                                       wire:model.live="pendingDropData.{{ $this->activeLine->id }}.{{ $i }}.dropping.{{ $qty->sizes_id }}"
                                                       min="0"
                                                       @if($this->readOnly) disabled @endif>
                                            </td>
                                        @endforeach
                                        <td class="text-center">
                                            {{ array_sum($this->pendingDropData[$this->activeLine->id][$i]['dropping'] ?? []) }}
                                        </td>
                                    </tr>
                                    <tr class="oe2-row-packed bg-warning bg-opacity-10">
                                        <td class="oe2-qty-row-label">Packed</td>
                                        @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                            <td>
                                                <input type="number" 
                                                       class="form-control form-control-sm text-center"
                                                       wire:model.live="pendingDropData.{{ $this->activeLine->id }}.{{ $i }}.packed.{{ $qty->sizes_id }}"
                                                       min="0"
                                                       @if($this->readOnly) disabled @endif>
                                            </td>
                                        @endforeach
                                        <td class="text-center">
                                            {{ array_sum($this->pendingDropData[$this->activeLine->id][$i]['packed'] ?? []) }}
                                        </td>
                                    </tr>
                                @endfor
                            @endif
                        @else
                            {{-- No Drops Yet --}}
                            <tr class="oe2-row-dropping">
                                <td class="oe2-qty-row-label">Dropping</td>
                                @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                    <td>
                                        <input type="number" 
                                               class="form-control form-control-sm text-center"
                                               value="{{ $qty->qty }}"
                                               min="0"
                                               @if($this->readOnly) disabled @endif>
                                    </td>
                                @endforeach
                                {{-- Pending Sizes --}}
                                @if(isset($this->pendingSizes[$this->activeLine->id]))
                                    @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                        <td class="bg-warning bg-opacity-10">
                                            <input type="number" 
                                                   class="form-control form-control-sm text-center"
                                                   wire:model.live="pendingSizes.{{ $this->activeLine->id }}.{{ $tempId }}.qty"
                                                   min="0"
                                                   @if($this->readOnly) disabled @endif>
                                        </td>
                                    @endforeach
                                @endif
                                <td class="text-center">
                                    @php
                                        $savedTotal = $this->activeLine->customer_order_line_quantities->sum('qty');
                                        $pendingTotal = isset($this->pendingSizes[$this->activeLine->id]) 
                                            ? array_sum(array_column($this->pendingSizes[$this->activeLine->id], 'qty'))
                                            : 0;
                                    @endphp
                                    {{ $savedTotal + $pendingTotal }}
                                </td>
                            </tr>
                        @endif
                        
                        {{-- SKU Row --}}
                        <tr class="oe2-row-sku">
                            <td class="oe2-qty-row-label">SKU</td>
                            @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                @php
                                    $markedForDeletion = isset($this->pendingSizeRemovals[$this->activeLine->id]) 
                                        && in_array($qty->id, $this->pendingSizeRemovals[$this->activeLine->id]);
                                @endphp
                                <td class="{{ $markedForDeletion ? 'bg-danger bg-opacity-10' : '' }}">
                                    <input type="text" 
                                           class="form-control form-control-sm text-center {{ $markedForDeletion ? 'text-decoration-line-through' : '' }}"
                                           value="{{ $qty->SKU ?? '' }}"
                                           maxlength="35"
                                           @if($this->readOnly || $markedForDeletion) disabled @endif>
                                </td>
                            @endforeach
                            {{-- Pending Sizes - SKU not editable until saved --}}
                            @if(isset($this->pendingSizes[$this->activeLine->id]))
                                @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                    <td class="bg-warning bg-opacity-10"></td>
                                @endforeach
                            @endif
                            <td></td>
                        </tr>
                        
                        {{-- Barcode Row --}}
                        <tr class="oe2-row-barcode">
                            <td class="oe2-qty-row-label">Barcode</td>
                            @foreach($this->activeLine->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                @php
                                    $markedForDeletion = isset($this->pendingSizeRemovals[$this->activeLine->id]) 
                                        && in_array($qty->id, $this->pendingSizeRemovals[$this->activeLine->id]);
                                @endphp
                                <td class="{{ $markedForDeletion ? 'bg-danger bg-opacity-10' : '' }}">
                                    <input type="text" 
                                           class="form-control form-control-sm text-center {{ $markedForDeletion ? 'text-decoration-line-through' : '' }}"
                                           value="{{ $qty->barcode ?? '' }}"
                                           maxlength="35"
                                           @if($this->readOnly || $markedForDeletion) disabled @endif>
                                </td>
                            @endforeach
                            {{-- Pending Sizes - Barcode not editable until saved --}}
                            @if(isset($this->pendingSizes[$this->activeLine->id]))
                                @foreach($this->pendingSizes[$this->activeLine->id] as $tempId => $sizeData)
                                    <td class="bg-warning bg-opacity-10"></td>
                                @endforeach
                            @endif
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
    </div>
    
    {{-- Notes Tab --}}
    <div x-show="showNotes" x-cloak class="oe2-line-tab-content">
        <div class="mb-3">
            <label class="form-label">Notes</label>
            <textarea class="form-control" 
                      rows="10"
                      @if($this->readOnly) disabled @endif>{{ $this->activeLine->notes ?? '' }}</textarea>
        </div>
    </div>
    
</div>
@endif

