{{-- Item Picker Modal --}}
<div class="oe2-item-picker">
    
    {{-- Header --}}
    <div class="oe2-picker-header">
        <h5 class="mb-0">
            @if($itemPickerMode === 'change')
                Change Item
            @else
                Add Item to Order
            @endif
        </h5>
        <button wire:click="closeItemPicker" class="btn-close"></button>
    </div>
    
    {{-- Search --}}
    <div class="oe2-picker-search">
        <div class="input-group">
            <span class="input-group-text">
                <i class="fa fa-search"></i>
            </span>
            <input type="text" 
                   wire:model.live.debounce.300ms="searchTerm" 
                   class="form-control" 
                   placeholder="Search by design, style, colourway, customer ref..."
                   autofocus>
        </div>
        @if($searchTerm)
            <button wire:click="$set('searchTerm', '')" class="btn btn-sm btn-link">
                Clear search
            </button>
        @endif
    </div>
    
    {{-- Results --}}
    <div class="oe2-picker-results">
        @if($this->availableItems->count() > 0)
            <div class="oe2-items-grid">
                @foreach($this->availableItems as $item)
                    <div wire:key="item-{{ $item->id }}" 
                         class="oe2-item-card"
                         wire:click="{{ $itemPickerMode === 'change' ? 'changeItem' : 'addItem' }}({{ $item->id }})">
                        
                        {{-- Item Image --}}
                        <div class="oe2-item-image">
                            @if($item->style_versions->image_base64)
                                <img src="data:image/jpeg;base64,{{ $item->style_versions->image_base64 }}" 
                                     alt="{{ $item->name }}"
                                     loading="lazy">
                            @else
                                <div class="oe2-item-image-placeholder">
                                    <i class="fa fa-image"></i>
                                </div>
                            @endif
                            
                            {{-- Price Badge --}}
                            @php
                                $hasPrices = $item->style_versions->prices->count() > 0;
                                $confirmedPrice = $item->style_versions->prices->where('colourways_id', $item->id)->where('quote_confirmed', true)->first();
                            @endphp
                            @if($confirmedPrice)
                                <span class="oe2-price-badge confirmed">
                                    <i class="fa fa-check-circle"></i> Confirmed
                                </span>
                            @elseif($hasPrices)
                                <span class="oe2-price-badge">
                                    Price Available
                                </span>
                            @endif
                        </div>
                        
                        {{-- Item Info --}}
                        <div class="oe2-item-details">
                            <div class="fw-bold">
                                {{ $item->style_versions->styles->designs_id ?? 'N/A' }}
                            </div>
                            <div class="small text-muted">
                                {{ $item->style_versions->styles->customer_ref ?? '' }}
                            </div>
                            <div class="small">
                                {{ $item->style_versions->name ?? '' }}
                            </div>
                            <div class="small fw-bold">
                                {{ $item->name }}
                            </div>
                            <div class="small text-muted">
                                <i class="fa fa-building"></i>
                                {{ $item->style_versions->factories->name ?? 'N/A' }}
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @elseif($searchTerm)
            <div class="oe2-empty-state">
                <i class="fa fa-search text-muted" style="font-size: 3rem;"></i>
                <p class="text-muted mt-3">No items found matching "{{ $searchTerm }}"</p>
            </div>
        @else
            <div class="oe2-empty-state">
                <i class="fa fa-box text-muted" style="font-size: 3rem;"></i>
                <p class="text-muted mt-3">Enter search terms to find items</p>
            </div>
        @endif
        
        {{-- Loading State --}}
        <div wire:loading wire:target="searchTerm" class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Searching...</span>
            </div>
        </div>
    </div>
    
    {{-- Footer --}}
    <div class="oe2-picker-footer">
        <button wire:click="closeItemPicker" class="btn btn-secondary">
            Cancel
        </button>
    </div>
</div>

