{{-- Standard Order Fields --}}
<div class="oe2-form-section">
    
    {{-- Department (New Orders Only) --}}
    @if($isNew)
    <div class="mb-3">
        <label class="form-label">Department <span class="text-danger">*</span></label>
        <select wire:model.live="form.departments_id" 
                class="form-select @error('form.departments_id') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="">Select Department</option>
            @foreach($this->departments as $dept)
                <option value="{{ $dept->id }}">{{ $dept->name }}</option>
            @endforeach
        </select>
        @error('form.departments_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    @endif
    
    {{-- Season (New Orders Only) --}}
    @if($isNew)
    <div class="mb-3">
        <label class="form-label">Season <span class="text-danger">*</span></label>
        <select wire:model.live="form.seasons_id" 
                class="form-select @error('form.seasons_id') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="">Select Season</option>
            @foreach($this->seasons as $season)
                <option value="{{ $season->id }}">{{ $season->description }}</option>
            @endforeach
        </select>
        @error('form.seasons_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    @else
    <div class="mb-3">
        <label class="form-label">Season</label>
        <input type="text" class="form-control" value="{{ $order->seasons->description ?? 'N/A' }}" disabled>
    </div>
    @endif
    
    {{-- Customer (New Orders Only) --}}
    @if($isNew)
    <div class="mb-3">
        <label class="form-label">Customer <span class="text-danger">*</span></label>
        <select wire:model.live="form.customers_id" 
                class="form-select @error('form.customers_id') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="">Select Customer</option>
            @foreach($this->customers as $customer)
                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
            @endforeach
        </select>
        @error('form.customers_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    @else
    <div class="mb-3">
        <label class="form-label">Customer</label>
        <input type="text" class="form-control" value="{{ $order->customers->name ?? 'N/A' }}" disabled>
    </div>
    @endif
    
    {{-- Incoterms --}}
    <div class="mb-3">
        <label class="form-label">Incoterms <span class="text-danger">*</span></label>
        <select wire:model.live="form.incoterms" 
                class="form-select @error('form.incoterms') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="EXW">EXW</option>
            <option value="FCA">FCA</option>
            <option value="CPT">CPT</option>
            <option value="CIP">CIP</option>
            <option value="DAP">DAP</option>
            <option value="DPU">DPU</option>
            <option value="DDP">DDP</option>
            <option value="FAS">FAS</option>
            <option value="FOB">FOB</option>
            <option value="CFR">CFR</option>
            <option value="CIF">CIF</option>
        </select>
        @error('form.incoterms') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Delivery Address --}}
    <div class="mb-3">
        <label class="form-label">Delivery Address</label>
        <select wire:model.live="form.customer_addresses_id" 
                class="form-select @error('form.customer_addresses_id') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="">Select Address</option>
            @foreach($this->customerAddresses as $address)
                <option value="{{ $address->id }}">
                    {{ $address->name }}
                </option>
            @endforeach
        </select>
        @error('form.customer_addresses_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Purchase Order Number --}}
    <div class="mb-3">
        <label class="form-label">Purchase Order No. <span class="text-danger">*</span></label>
        <input type="text" 
               wire:model.live.debounce.500ms="form.customer_po" 
               class="form-control @error('form.customer_po') is-invalid @enderror"
               maxlength="35"
               @if($this->readOnly) disabled @endif>
        @error('form.customer_po') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Shipment Mode --}}
    <div class="mb-3">
        <label class="form-label">Shipment Mode</label>
        <input type="text" 
               wire:model.live.debounce.500ms="form.shipment_mode" 
               class="form-control @error('form.shipment_mode') is-invalid @enderror"
               maxlength="35"
               placeholder="e.g. Air, Sea, Express"
               @if($this->readOnly) disabled @endif>
        @error('form.shipment_mode') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Order Date --}}
    <div class="mb-3">
        <label class="form-label">Order Date</label>
        <input type="date" 
               wire:model.live="form.order_date" 
               class="form-control @error('form.order_date') is-invalid @enderror"
               @if($this->readOnly) disabled @endif>
        @error('form.order_date') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
</div>

