{{-- Advanced Order Fields --}}
<div class="oe2-form-section">
    
    {{-- Customer Shipment No --}}
    <div class="mb-3">
        <label class="form-label">Customer Shipment No.</label>
        <input type="text" 
               wire:model.live.debounce.500ms="form.cust_ship_no" 
               class="form-control @error('form.cust_ship_no') is-invalid @enderror"
               maxlength="35"
               @if($this->readOnly) disabled @endif>
        @error('form.cust_ship_no') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Sent to Factory --}}
    <div class="mb-3">
        <label class="form-label">Sent to Factory</label>
        <input type="date" 
               wire:model.live="form.sent_to_factory" 
               class="form-control @error('form.sent_to_factory') is-invalid @enderror"
               @if($this->readOnly) disabled @endif>
        @error('form.sent_to_factory') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Phase --}}
    <div class="mb-3">
        <label class="form-label">Phase</label>
        <select wire:model.live="form.phase_id" 
                class="form-select @error('form.phase_id') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="">Select Phase</option>
            @foreach($this->phases as $phase)
                <option value="{{ $phase->id }}">{{ $phase->name }}</option>
            @endforeach
        </select>
        @error('form.phase_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Incomplete Flag --}}
    <div class="mb-3">
        <label class="form-label">Incomplete <span class="text-danger">*</span></label>
        <select wire:model.live="form.incomplete_flag" 
                class="form-select @error('form.incomplete_flag') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="0">No</option>
            <option value="1">Yes</option>
        </select>
        @error('form.incomplete_flag') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    {{-- Cancelled --}}
    <div class="mb-3">
        <label class="form-label">Cancelled</label>
        <select wire:model.live="form.cancelled" 
                class="form-select @error('form.cancelled') is-invalid @enderror"
                @if($this->readOnly) disabled @endif>
            <option value="0">No</option>
            <option value="1">Yes</option>
        </select>
        @error('form.cancelled') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>
    
    @if($order && $order->audits->first())
    <div class="mb-3">
        <label class="form-label">Last Updated By</label>
        <input type="text" 
               class="form-control" 
               value="{{ $order->audits->first()->user->name ?? 'Unknown' }}" 
               disabled>
    </div>
    @endif
    
</div>

