{{-- File Manager Component --}}
<div class="oe2-file-manager">
    
    {{-- File Upload --}}
    @if(!$this->readOnly)
    <div class="oe2-file-upload mb-3">
        <input type="file" 
               wire:model="form.uploadFiles" 
               multiple 
               class="form-control form-control-sm"
               id="fileUpload">
        <label for="fileUpload" class="form-label">
            <small class="text-muted">
                <i class="fa fa-cloud-upload"></i> Upload files
            </small>
        </label>
        @error('form.uploadFiles.*') 
            <div class="text-danger small">{{ $message }}</div> 
        @enderror
    </div>
    @endif
    
    {{-- Uploaded Files List --}}
    @if($this->orderFiles->count() > 0)
    <div class="oe2-files-list">
        @foreach($this->orderFiles as $file)
            <div wire:key="file-{{ $file->id }}" class="oe2-file-item">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center flex-grow-1">
                        <i class="fa fa-file me-2"></i>
                        <div class="flex-grow-1">
                            <a href="{{ Storage::disk('public')->url($file->file) }}" 
                               target="_blank" 
                               class="text-decoration-none">
                                {{ $file->filename }}
                            </a>
                            <div class="small text-muted">
                                {{ $file->created_at?->format('d M Y') }}
                            </div>
                        </div>
                    </div>
                    @if(!$this->readOnly)
                    <button wire:click="deleteFile({{ $file->id }})" 
                            class="btn btn-sm btn-outline-danger"
                            onclick="return confirm('Delete this file?')"
                            title="Delete">
                        <i class="fa fa-trash"></i>
                    </button>
                    @endif
                </div>
            </div>
        @endforeach
    </div>
    @else
    <div class="text-muted small">
        <i class="fa fa-inbox"></i> No files uploaded
    </div>
    @endif
    
    {{-- Upload Progress --}}
    <div wire:loading wire:target="form.uploadFiles" class="mt-2">
        <div class="progress">
            <div class="progress-bar progress-bar-striped progress-bar-animated" 
                 role="progressbar" 
                 style="width: 100%"></div>
        </div>
        <small class="text-muted">Uploading...</small>
    </div>
</div>

