<div class="orders-edit-v2-container" x-data="{ 
    showAdvanced: false,
    showItemPicker: @entangle('itemPicker'),
    activeTab: 'details'
}" 
x-on:keydown.ctrl.s.window.prevent="$wire.saveOrder()"
x-on:keydown.meta.s.window.prevent="$wire.saveOrder()">

    {{-- Main Layout - Modern Split View --}}
    <div class="oe2-main-layout">
        
        {{-- Left Panel: Order Lines & Editor --}}
        <div class="oe2-left-panel">
            
            {{-- Lines List Header --}}
            <div class="oe2-lines-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h6 class="mb-0 fw-bold">Order Lines</h6>
                    <div class="btn-group btn-group-sm">
                        @if($this->canQuickEdit && $this->orderLines->count() > 0)
                            <button wire:click="toggleMode" 
                                    class="btn btn-sm {{ $mode === 'quick' ? 'btn-primary' : 'btn-outline-primary' }}"
                                    title="Quick Edit Mode">
                                <i class="fa fa-th"></i> Quick Edit
                            </button>
                        @endif
                        @if($order)
                            <button wire:click="openItemPicker('add')" 
                                    class="btn btn-sm btn-success"
                                    title="Add Item">
                                <i class="fa fa-plus-circle"></i> Add Item
                            </button>
                        @endif
                    </div>
                </div>
                
                {{-- Quick Mode Warning --}}
                @if($mode === 'quick' && $this->orderLines->count() > 0)
                    <div class="alert alert-warning alert-sm mt-2 mb-0 py-1">
                        <small><i class="fa fa-exclamation-triangle"></i> Quick Edit: Changes apply to all lines</small>
                    </div>
                @endif
            </div>
            
            {{-- Lines List or Line Editor --}}
            <div class="oe2-content-area">
                @if($mode === 'single')
                    @if($this->orderLines->count() > 0)
                        <div class="oe2-split-view">
                            {{-- Lines Sidebar --}}
                            <div class="oe2-lines-sidebar">
                                @include('livewire.sales.orders.orders-edit-v2.lines-list')
                            </div>
                            
                            {{-- Line Editor --}}
                            <div class="oe2-line-editor">
                                @if($this->activeLine)
                                    @include('livewire.sales.orders.orders-edit-v2.line-editor')
                                @else
                                    <div class="oe2-empty-state">
                                        <i class="fa fa-arrow-left text-muted" style="font-size: 3rem;"></i>
                                        <p class="text-muted mt-3">Select a line to edit</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @else
                        <div class="oe2-empty-state">
                            <i class="fa fa-inbox text-muted" style="font-size: 4rem;"></i>
                            <h5 class="text-muted mt-3">No Items Yet</h5>
                            @if($order)
                                <button wire:click="openItemPicker('add')" class="btn btn-primary mt-2">
                                    <i class="fa fa-plus-circle"></i> Add First Item
                                </button>
                            @else
                                <p class="text-muted">Save the order header first to add items</p>
                            @endif
                        </div>
                    @endif
                @else
                    {{-- Quick Edit Mode --}}
                    @include('livewire.sales.orders.orders-edit-v2.quick-edit')
                @endif
            </div>
        </div>
        
        {{-- Right Panel: Order Header --}}
        <div class="oe2-right-panel">
            <div class="oe2-header-container">
                
                {{-- Sticky Save Bar --}}
                <div class="oe2-save-bar">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            @if($hasUnsavedChanges)
                                <span class="badge bg-warning text-dark">Unsaved Changes</span>
                            @elseif($lastSaved)
                                <span class="badge bg-success">Saved at {{ $lastSaved }}</span>
                            @endif
                        </div>
                        <div class="btn-group">
                            <button wire:click="saveOrder" 
                                    class="btn btn-primary btn-sm"
                                    wire:loading.attr="disabled"
                                    wire:target="saveOrder">
                                <span wire:loading.remove wire:target="saveOrder">
                                    <i class="fa fa-save"></i> Save Order
                                </span>
                                <span wire:loading wire:target="saveOrder">
                                    <span class="spinner-border spinner-border-sm"></span> Saving...
                                </span>
                            </button>
                            <button x-on:click="$dispatch('close-modal')" 
                                    class="btn btn-outline-secondary btn-sm">
                                <i class="fa fa-times"></i> Close
                            </button>
                        </div>
                    </div>
                </div>
                
                {{-- Order Header Form --}}
                <div class="oe2-header-content">
                    <h5 class="oe2-section-title">Order Information</h5>
                    
                    @include('livewire.sales.orders.orders-edit-v2.header-form')
                    
                    {{-- Advanced Section --}}
                    <div class="mt-3">
                        <button x-on:click="showAdvanced = !showAdvanced" 
                                class="btn btn-sm btn-link text-decoration-none w-100 text-start">
                            <i class="bi" :class="showAdvanced ? 'bi-chevron-down' : 'bi-chevron-right'"></i>
                            Advanced Options
                        </button>
                        
                        <div x-show="showAdvanced" 
                             x-collapse
                             class="mt-2">
                            @include('livewire.sales.orders.orders-edit-v2.header-advanced')
                        </div>
                    </div>
                    
                    {{-- Files Section --}}
                    @if($order)
                        <div class="mt-4">
                            <h6 class="oe2-section-subtitle">Attached Files</h6>
                            @include('livewire.sales.orders.orders-edit-v2.file-manager')
                        </div>
                    @endif
                    
                    {{-- Order Summary --}}
                    @if($order)
                        <div class="oe2-order-summary mt-4">
                            <div class="row g-2">
                                <div class="col-6">
                                    <div class="oe2-summary-card">
                                        <small class="text-muted">Total Value</small>
                                        <div class="fw-bold fs-5">{{ $order->customers->currency ?? 'USD' }} {{ number_format($order->total_value ?? 0, 2) }}</div>
                                    </div>
                                </div>
                                @can('admin')
                                <div class="col-6">
                                    <div class="oe2-summary-card">
                                        <small class="text-muted">Total Quantity</small>
                                        <div class="fw-bold fs-5">{{ number_format($order->total_qty ?? 0) }}</div>
                                    </div>
                                </div>
                                @endcan
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    {{-- Item Picker Modal --}}
    @if($itemPicker)
        <div class="oe2-modal-overlay" x-show="showItemPicker">
            <div class="oe2-modal-content" @click.outside="$wire.closeItemPicker()">
                @include('livewire.sales.orders.orders-edit-v2.item-picker')
            </div>
        </div>
    @endif
    
    {{-- Loading Overlay --}}
    <div wire:loading.delay wire:target="saveOrder,addItem,changeItem,deleteLine" class="oe2-loading-overlay">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>
</div>

