<div>
    <hr>
    <div class="row">
        <div class="col">
            <button class="btn btn-primary"  wire:click.prevent="addCustSizes">Add Customer Sizes</button>
            <button class="btn btn-primary"  wire:click.prevent="addSize">Add Size</button>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="col">
            @if (session()->has('message'))
                <div class="alert mt-2 {{ session('alert-class') }}">
                    <h4>{{ $this->humanisedSessionMessage }}</h4>
                    @foreach ($this->humanisedErrors as $error)
                        <div>{{ $error }}</div>
                    @endforeach
                </div>
            @endif

            @if ($errors->any())
                <div class="alert alert-danger mt-2">
                    <h4>Validation Errors</h4>
                    <ul>
                        @foreach ($this->humanisedErrors as $error)
                            <div>{{ $error }}</div>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div wire:loading>
                Saving post...
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col">
            <div class="form-floating">
                <input id="exfty" type="date" class="form-control" @if($this->readOnly) disabled @endif wire:model.blur="form.dates.exfty">
                <label for="exfty">Exfty</label>
            </div>
        </div>
        <div class="col">
            <div class="form-floating">
                <input id="factory_cust_date" type="date" class="form-control" @if($this->readOnly) disabled @endif wire:model.blur="form.dates.factory_cust_date">
                <label for="factory_cust_date">Customer Exfty</label>
            </div>
        </div>
        <div class="col">
            <div class="form-floating">
                <input id="wh_cust_date" type="date" class="form-control" @if($this->readOnly) disabled @endif wire:model.blur="form.dates.wh_cust_date">
                <label for="wh_cust_date">Customer Into W/H</label>
            </div>
        </div>
        <div class="col">
            <div class="form-floating">
                <input id="start_knit" type="date" class="form-control" @if($this->readOnly) disabled @endif wire:model.blur="form.dates.start_knit">
                <label for="start_knit">Start Knit</label>
            </div>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="col">
            <table class="table">
                <thead>
                    <th>Item</th>
                    @forelse($form->sizes ?? [] as $s=>$size)
                        <th style="width: 175px">
                            <div class="input-group">
                                <input type="text" class="form-control" @if($this->readOnly) disabled @endif wire:model="form.sizes.{{$s}}">
                                <button class="btn btn-danger" wire:click.prevent="removeSize({{$s}})">X</button>
                            </div>
                        </th>
                    @empty
                        <th>No Sizing</th>
                    @endforelse
                </thead>
                <tbody>
                    @forelse($form->orderLinesEdit ?? [] as $l=>$line)
                        <tr>
                            <td>{{$line['colourways']['style_versions']['styles']['designs_id'] ?? ""}} - {{$line['colourways']['style_versions']['styles']['customer_ref'] ?? ""}} - {{$line['colourways']['name'] ?? ""}}</td>
                            @forelse($form->sizes as $s=>$size)
                                <td style="width: 150px">
                                    <div class="input-group">
                                        <input type="text" class="form-control" @if($this->readOnly) disabled @endif wire:model="form.qtys.{{$line['id']}}.{{$s}}.ordered">
                                        <input type="text" class="form-control" @if($this->readOnly) disabled @endif wire:model="form.qtys.{{$line['id']}}.{{$s}}.shipped">
                                    </div>
                                </td>
                            @empty
                                <td>No Sizing</td>
                            @endforelse
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5">Please add some items.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
