<div>

    @if($form && $form->orderLineEdit)
        <div class="row">
            <div class="col">
                    <b>{{$form->orderLineEdit['colourways']['style_versions']['styles']['designs_id'] ?? ""}}</b> |
                    {{$form->orderLineEdit['colourways']['style_versions']['styles']['customer_ref'] ?? ""}} |
                    {{$form->orderLineEdit['colourways']['style_versions']['factories']['name'] ?? ""}} |
                    {{$form->orderLineEdit['colourways']['style_versions']['styles']['designs']['description'] ?? ""}}
                    <button class="ms-5 btn btn-primary"  wire:click.prevent="addCustSizes">Add Customer Sizes</button>
                    <button class="btn btn-primary"  wire:click.prevent="addSize">Add Size</button>
                    <button class="btn btn-primary"  wire:click.prevent="addDrop">Add Drop</button>
            </div>
            <div class="col-auto text-end">
                ({{$form->orderLineEdit['colourways']['style_versions']['name'] ?? ""}})
                <b>{{$form->orderLineEdit['colourways']['name'] ?? ""}}</b>
            </div>
        </div>

        <hr>

        @if (session()->has('message'))
            <div class="alert mt-2 {{ session('alert-class') }}">
                <h4>{{ $this->humanisedSessionMessage }}</h4>
                @foreach ($this->humanisedErrors as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger mt-2">
                <h4>Validation Errors</h4>
                <ul>
                    @foreach ($this->humanisedErrors as $error)
                        <div>{{ $error }}</div>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="row">
            <div class="col">
                <div class="row align-items-center">
                    <div class="col-5">
                        <h6 class="mb-0 fw-bold">Customer ExFty</h6>
                    </div>
                    <div class="col-7" style="height: 37px">
                        @if(Gate::check('order:update') && !$this->viewOnly)
                        <input type="date" class="form-control" wire:model="form.orderLineEdit.factory_cust_date">
                        @else
                            {{$form->orderLineEdit['factory_cust_date'] ?? ""}}
                        @endif
                    </div>
                </div>
                <hr>
                <div class="row align-items-center">
                    <div class="col-5">
                        <h6 class="mb-0 fw-bold">Customer Into W/H</h6>
                    </div>
                    <div class="col-7" style="height: 37px">
                        @if(Gate::check('order:update') && !$this->viewOnly)
                            <input type="date" class="form-control" wire:model="form.orderLineEdit.wh_cust_date">
                        @else
                            {{$form->orderLineEdit['wh_cust_date'] ?? ""}}
                        @endif
                    </div>
                </div>
                <hr>
                <div class="row align-items-center">
                    <div class="col-5">
                        <h6 class="mb-0 fw-bold">Start Knit</h6>
                    </div>
                    <div class="col-7" style="height: 37px">
                        @if(Gate::check('order:update') && !$this->viewOnly)
                            <input type="date" class="form-control" wire:model="form.orderLineEdit.start_knit">
                        @else
                            {{$form->orderLineEdit['start_knit'] ?? ""}}
                        @endif
                    </div>
                </div>
                @if(count($form->orderLineEdit['shipment_lines']) <= 1)
                    <hr>
                    <div class="row align-items-center">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">ExFty</h6>
                        </div>
                        <div class="col-7" style="height: 37px">
                            @if(Gate::check('order:update') && !$this->viewOnly)
                                <input type="date" class="form-control" wire:model="form.orderLineEdit.shipment_lines.0.exfty">
                            @else
                                {{$form->orderLineEdit['shipment_lines'][0]['exfty'] ?? ""}}
                            @endif
                        </div>
                    </div>
                @endif
            </div>
            <div class="col">
                <div class="col-lg">
                    <textarea rows="7" class="form-control" wire:model="form.orderLineEdit.notes"></textarea>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col">
                @if(!empty($form->orderLineEdit['customer_order_line_quantities']))
                    <table class="table align-middle">
                        <thead>
                            <th>Size</th>
                            {{-- {{dd($form->orderLineEdit)}} --}}
                            @foreach($form->orderLineEdit['customer_order_line_quantities']  as $s=>$size)
                                <th>
                                    @if(Gate::check('order:update') && !$this->viewOnly)
                                        <div class="input-group">
                                            <input class="form-control" type="text" wire:model="form.orderLineEdit.customer_order_line_quantities.{{$s}}.size">
                                            <button class="btn btn-danger" wire:click.prevent="removeSize({{$s}})">X</button>
                                        </div>
                                    @else
                                        {{$size['sizes']['name']}}
                                    @endif
                                </th>
                            @endforeach
                        </thead>
                        <tbody>
                            <tr>
                                <td>Ordered</td>
                                @foreach($form->orderLineEdit['customer_order_line_quantities'] as $s=>$size)
                                    <td>
                                        @if(Gate::check('order:update') && !$this->viewOnly)
                                            <input class="form-control" type="number" id="ordered_{{$s}}" wire:model="form.orderLineEdit.customer_order_line_quantities.{{$s}}.qty" wire:key="form.ordered{{$s}}Qqty">
                                        @else
                                            {{$size['qty']}}
                                        @endif
                                    </td>
                                    @endforeach

                            </tr>

                            @if($form->orderType == "wholesale" && !empty($availablePrices))
                                <tr>
                                    <td>
                                        <strong>Priority Price</strong>
                                        <small class="d-block text-muted">Optional: Select a specific price</small>
                                    </td>
                                    @foreach($form->orderLineEdit['customer_order_line_quantities'] as $s=>$size)
                                        <td>
                                            @if(Gate::check('order:update') && !$this->viewOnly)
                                                <select class="form-select form-select-sm" wire:model="form.orderLineEdit.customer_order_line_quantities.{{$s}}.prices_id" wire:key="form.ordered{{$s}}prices_id">
                                                    <option value="">-- Use Default Price --</option>
                                                    @foreach($availablePrices as $price)
                                                        <option value="{{ $price['id'] }}">{{ $price['label'] }}</option>
                                                    @endforeach
                                                </select>
                                                @if(!empty($size['prices_id']) && $size['prices_id'] !== '' && $size['prices_id'] !== '0')
                                                    <small class="text-success d-block mt-1">
                                                        <i class="fas fa-check-circle"></i> Priority price set
                                                    </small>
                                                @else
                                                    <small class="text-muted d-block mt-1">
                                                        <i class="fas fa-info-circle"></i> Using dynamic price
                                                    </small>
                                                @endif
                                            @else
                                                @if(!empty($size['prices_id']) && $size['prices_id'] !== '' && $size['prices_id'] !== '0')
                                                    <span class="badge bg-success">Priority Price: {{ $size['prices_id'] }}</span>
                                                @else
                                                    <span class="text-muted">Using Default</span>
                                                @endif
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                            @endif

                            @foreach($form->orderLineEdit['shipment_lines'] as $d=>$drop)
                                @if(count($form->orderLineEdit['shipment_lines']) == 1)
                                    <tr class="bg-light">
                                        <td>
                                            Dropping
                                            @if(Gate::check('order:update') && !$this->viewOnly)
                                                <div class="mt-2">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" wire:model="splitDrops.{{$d}}" id="splitDrop{{$d}}">
                                                        <label class="form-check-label" for="splitDrop{{$d}}">
                                                            Split into new order
                                                        </label>
                                                    </div>
                                                    @if($splitDrops[$d] ?? false)
                                                        <button class="btn btn-sm btn-warning mt-1" wire:click="splitDropIntoNewOrder({{$d}})">
                                                            <i class="fas fa-cut"></i> Split Now
                                                        </button>
                                                    @endif
                                                </div>
                                            @endif
                                        </td>
                                        @foreach($form->orderLineEdit['customer_order_line_quantities'] as $s=>$size)
                                            <td>
                                                @if(Gate::check('order:update') && !$this->viewOnly)
                                                    <input class="form-control" type="text" wire:model="form.orderLineEdit.shipment_lines.{{$d}}.shipment_line_sizes.{{$s}}.qty" wire:key="form.drops{{$d}}Sizes{{$s}}qty">
                                                @else
                                                    {{$form->orderLineEdit['shipment_lines'][$d]['shipment_line_sizes'][$s]['qty'] ?? ''}}
                                                @endif
                                            </td>
                                        @endforeach
                                    </tr>
                                @else
                                    <tr style="border-bottom: 1px solid black">
                                        <td colspan="100%" class="align-bottom" style="height: 70px">
                                            Drop {{$d+1}} ({{$drop['id'] ?? ""}})
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="input-group">
                                                <button class="btn btn-danger" onclick="confirm('This will permanently delete the drop?') || event.stopImmediatePropagation()" wire:click.prevent="deleteDrop({{$d}}, {{$drop['id'] ?? ""}})">X</button>
                                                <input type="date" class="form-control" wire:model="form.orderLineEdit.shipment_lines.{{$d}}.exfty">
                                            </div>
                                            @if(Gate::check('order:update') && !$this->viewOnly)
                                                <div class="mt-2">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" wire:model="splitDrops.{{$d}}" id="splitDrop{{$d}}">
                                                        <label class="form-check-label" for="splitDrop{{$d}}">
                                                            Split into new order
                                                        </label>
                                                    </div>
                                                    @if($splitDrops[$d] ?? false)
                                                        <button class="btn btn-sm btn-warning mt-1" wire:click="splitDropIntoNewOrder({{$d}})">
                                                            <i class="fas fa-cut"></i> Split Now
                                                        </button>
                                                    @endif
                                                </div>
                                            @endif
                                        </td>
                                        @foreach($form->orderLineEdit['customer_order_line_quantities'] as $s=>$size)
                                            <td>
                                                @if(Gate::check('order:update') && !$this->viewOnly)
                                                    <input class="form-control" type="text" wire:model="form.orderLineEdit.shipment_lines.{{$d}}.shipment_line_sizes.{{$s}}.qty" wire:key="form.drops{{$d}}Sizes{{$s}}qty">
                                                @else
                                                    {{$form->orderLineEdit['shipment_lines'][$d]['shipment_line_sizes'][$s]['qty'] ?? ''}}
                                                @endif
                                            </td>
                                        @endforeach
                                    </tr>
                                @endif

                                <tr @if(count($form->orderLineEdit['shipment_lines']) != 1)  style="border-bottom: 1px solid black" @endif>
                                    <td>Packed</td>
                                    @foreach($form->orderLineEdit['customer_order_line_quantities'] as $s=>$size)
                                        <td>
                                            @if(Gate::check('order:update') && !$this->viewOnly)
                                                <input class="form-control" type="text" wire:model="form.orderLineEdit.shipment_lines.{{$d}}.shipment_line_sizes.{{$s}}.shipped_qty" wire:key="form.drops{{$d}}Sizes{{$s}}shippedQty">
                                            @else
                                                {{$form->orderLineEdit['shipment_lines'][$d]['shipment_line_sizes'][$s]['shipped_qty'] ?? ''}}
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                            <tr>
                                <td>SKU</td>
                                @foreach($form->orderLineEdit['customer_order_line_quantities'] as $s=>$size)
                                    <td>
                                        @if(Gate::check('order:update') && !$this->viewOnly)
                                            <input class="form-control" type="text" wire:model="form.orderLineEdit.customer_order_line_quantities.{{$s}}.SKU" wire:key="form.ordered{{$s}}SKU">
                                        @else
                                            {{$size['SKU']}}
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>Barcode</td>
                                @foreach($form->orderLineEdit['customer_order_line_quantities'] as $s=>$size)
                                    <td>
                                        @if(Gate::check('order:update') && !$this->viewOnly)
                                            <input class="form-control" type="text" wire:model="form.orderLineEdit.customer_order_line_quantities.{{$s}}.barcode" wire:key="form.ordered{{$s}}barcode">
                                        @else
                                            {{$size['barcode']}}
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                        </tbody>
                    </table>
                @endif
            </div>
        </div>

    @endif
</div>
