<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Yarn PO
        </x-slot:title>
        <x-slot:end>
			@can('style:create')
				<button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('new-prod')">New</button>
			@endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="spinner">
								<option selected value="">All</option>
								@foreach($this->spinners as $spinner)
									<option value="{{ $spinner->id }}">{{ $spinner->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Spinner:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="customer">
								<option selected value="">All</option>
								@foreach($this->customers as $customer)
									<option value="{{ $customer->id }}">{{ $customer->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Customer:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="paginate">
								<option selected value="10">10</option>
								<option selected value="50">50</option>
								<option selected value="100">100</option>
								<option selected value="200">200</option>
								<option selected value="500">500</option>
							</select>
							<label class="form-label">Per Page:</label>
						</div>
					</div>
                </div>
                <div class="row mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
						<tr>
							<th>PROD</th>
							<th style="min-width: 150px">Date</th>
							<th style="min-width: 200px">Spinner</th>
							<th style="min-width: 200px">Customer</th>
							<th>KG</th>
							<th style="min-width: 200px">Yarn</th>
							<th style="min-width: 100px">Count</th>
							<th>Colour</th>
							<th>Styles</th>
							<th style="width: 0"></th>
						</tr>
					</thead>
					<tbody>
						@foreach($orders->sortByDesc('id') as $order)
							@foreach(json_decode($order->yarns) ?? [NULL] as $yarn)
								<tr>
									@if($loop->first)
										<td class="border-bottom border-primary" rowspan="{{$order->yarn_count == 0 ? 1 : $order->yarn_count}}">{{$order->id}}</td>
										<td class="border-bottom border-primary" rowspan="{{$order->yarn_count == 0 ? 1 : $order->yarn_count}}">{{$order->date->format('d-M-Y')}}</td>
										<td class="border-bottom border-primary" rowspan="{{$order->yarn_count == 0 ? 1 : $order->yarn_count}}">{{$order->spinner}}</td>
										<td class="border-bottom border-primary" rowspan="{{$order->yarn_count == 0 ? 1 : $order->yarn_count}}">{{$order->customer}}</td>
									@endif
									<td @if($loop->last) class="border-bottom border-primary" @endif>{{$yarn?->qty}}</td>
									<td @if($loop->last) class="border-bottom border-primary" @endif>{{$yarn?->yarn}}</td>
									<td @if($loop->last) class="border-bottom border-primary" @endif>{{$yarn?->count}}</td>
									<td @if($loop->last) class="border-bottom border-primary" @endif>RT{{$yarn?->colour_id}} - {{$yarn?->colour_ref}} {{$yarn?->colour}}</td>
									<td @if($loop->last) class="border-bottom border-primary" @endif>
										@foreach (explode(',', $yarn?->styles) ?? [] as $item)
											{{$item}}@if(!$loop->last),@endif
										@endforeach
									</td>
									@if($loop->first)
										<td class="border-bottom border-primary" rowspan="{{$order->yarn_count == 0 ? 1 : $order->yarn_count}}">
											<button class="btn btn-text" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-prod', {order: {{$order->id}}})">Edit</button>
											<button class="btn btn-text" x-data x-on:click="$dispatch('open-modal', {name:'po'})" wire:click="$set('po', {{$order->id}})">PO</button>
										</td>

									@endif
								</tr>
								@endforeach
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<x-modal name="edit" title="Edit Order" size="modal-fullscreen">
		<x-slot:body>
				<livewire:production.yarn.yarn-orders-edit wire:key="edit-{{$editID}}">
		</x-slot:body>
	</x-modal>
	{{-- <x-modal name="new" title="New Order" size="modal-fullscreen">
		<x-slot:body>
			@if($new)
				<livewire:production.yarn.yarn-orders-edit wire:key="new">
			@endif
		</x-slot:body>
	</x-modal> --}}
	<x-modal name="po" title="Yarn PO {{$po}}" size="modal-fullscreen">
		<x-slot:body>
			{{-- @if($po) --}}
				<livewire:production.yarn.yarn-orders-p-o wire:key="po-{{$po}}" prod="{{$po}}">
			{{-- @endif --}}
		</x-slot:body>
	</x-modal>

	<x-footer>
        <x-slot:center>
            {{ $orders->links() }}
        </x-slot:center>
    </x-footer>
</div>
