<div>
    <div id="print" class="modal-body">
        <div class="row mb-3 ">
            <div class="col">
                <div class="colprint align-middle">
                    {{-- <img style="height: 100px" class="img-thumbnail float-start bg-white border-0 m-0" src="https://roberttodds.com/images/robert_todd_logo_merino2.png" alt="Robert Todds"> --}}
                </div>
            </div>
            <div class="col">
                <div class="colprint align-middle">
                    <img style="height: 100px" class="img-thumbnail float-end bg-white border-0 m-0" src="https://roberttodds.com/images/robert_todd_logo_merino2.png" alt="Robert Todds">
                </div>
            </div>
        </div>
        @if($prod != NULL)
            <div class="row">
                <div class="col d-flex align-items-stretch">
                    <div class="card mb-3 w-100">
                        <div class="card-header">PO Details</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Spinner</h6>
                                        </div>
                                        <div class="col-7 text-secondary">
                                            <b>{{ $this->po?->suppliers->name }}</b><br>
                                            {{ $this->po?->suppliers->supplier_addresses?->first()?->line1 }}@if($this->po?->suppliers->supplier_addresses?->first()?->line1 != NULL)<br>@endif
                                            {{ $this->po?->suppliers->supplier_addresses?->first()?->line2 }}@if($this->po?->suppliers->supplier_addresses?->first()?->line2 != NULL)<br>@endif
                                            {{ $this->po?->suppliers->supplier_addresses?->first()?->line3 }}@if($this->po?->suppliers->supplier_addresses?->first()?->line3 != NULL)<br>@endif
                                            {{ $this->po?->suppliers->supplier_addresses?->first()?->city }}@if($this->po?->suppliers->supplier_addresses?->first()?->city != NULL)<br>@endif
                                            {{ $this->po?->suppliers->supplier_addresses?->first()?->region }}@if($this->po?->suppliers->supplier_addresses?->first()?->region != NULL)<br>@endif
                                            {{ $this->po?->suppliers->supplier_addresses?->first()?->postcode }}@if($this->po?->suppliers->supplier_addresses?->first()?->postcode != NULL)<br>@endif
                                            {{ $this->po?->suppliers->supplier_addresses?->first()?->countries->country }}
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">PO Date</h6>
                                        </div>
                                        <div class="col-7 text-secondary">{{ $this->po?->date }}</div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Currency</h6>
                                        </div>
                                        <div class="col-7 text-secondary">{{ $this->po?->suppliers->currency }}</div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">PO Reference</h6>
                                        </div>
                                        <div class="col-7 text-secondary">PROD{{ $this->po?->id }}</div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Deliver To</h6>
                                        </div>
                                        <div class="col-7 text-secondary">
                                            <b>{{ $this->po->deliver_to->name }}</b><br>
                                            @if((!$this->po->deliver_to->supplier_addresses->isEmpty()))
                                                {{ $this->po->deliver_to->supplier_addresses?->first()->line1 }}@if($this->po->deliver_to->supplier_addresses?->first()->line1 != NULL)<br>@endif
                                                {{ $this->po->deliver_to->supplier_addresses?->first()->line2 }}@if($this->po->deliver_to->supplier_addresses?->first()->line2 != NULL)<br>@endif
                                                {{ $this->po->deliver_to->supplier_addresses?->first()->line3 }}@if($this->po->deliver_to->supplier_addresses?->first()->line3 != NULL)<br>@endif
                                                {{ $this->po->deliver_to->supplier_addresses?->first()->city }}@if($this->po->deliver_to->supplier_addresses?->first()->city != NULL)<br>@endif
                                                {{ $this->po->deliver_to->supplier_addresses?->first()->region }}@if($this->po->deliver_to->supplier_addresses?->first()->region != NULL)<br>@endif
                                                {{ $this->po->deliver_to->supplier_addresses?->first()->postcode }}@if($this->po->deliver_to->supplier_addresses?->first()->postcode != NULL)<br>@endif
                                                {{ $this->po->deliver_to->supplier_addresses?->first()->countries->country }}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col d-flex align-items-stretch">
                    <div class="card mb-3 w-100">
                        <div class="card-header">Invoicing Details</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Invoice To</h6>
                                        </div>
                                        <div class="col-7 text-secondary">
                                            <b>{{ $this->po->invoice_to->name }}</b><br>
                                            @if((!$this->po->invoice_to->supplier_addresses->isEmpty()))
                                                {{ $this->po->invoice_to->supplier_addresses?->first()->line1 }}@if($this->po->invoice_to->supplier_addresses?->first()->line1 != NULL)<br>@endif
                                                {{ $this->po->invoice_to->supplier_addresses?->first()->line2 }}@if($this->po->invoice_to->supplier_addresses?->first()->line2 != NULL)<br>@endif
                                                {{ $this->po->invoice_to->supplier_addresses?->first()->line3 }}@if($this->po->invoice_to->supplier_addresses?->first()->line3 != NULL)<br>@endif
                                                {{ $this->po->invoice_to->supplier_addresses?->first()->city }}@if($this->po->invoice_to->supplier_addresses?->first()->city != NULL)<br>@endif
                                                {{ $this->po->invoice_to->supplier_addresses?->first()->region }}@if($this->po->invoice_to->supplier_addresses?->first()->region != NULL)<br>@endif
                                                {{ $this->po->invoice_to->supplier_addresses?->first()->postcode }}@if($this->po->invoice_to->supplier_addresses?->first()->postcode != NULL)<br>@endif
                                                {{ $this->po->invoice_to->supplier_addresses?->first()->countries->country }}
                                            @endif
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Ordered By</h6>
                                        </div>
                                        <div class="col-7 text-secondary">Robert Todd & Son Ltd</div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Robert Todds Contact</h6>
                                        </div>
                                        <div class="print col-7 text-secondary">
                                            {{ $contact['name'] }}<br>
                                            {{ $contact['phone'] }}<br>
                                            {{ $contact['email'] }}
                                        </div>
                                        <div class="dont-print col-7 text-secondary">
                                            <input type="text" class="form-control mb-1" wire:model.live="contact.name">
                                            <input type="text" class="form-control mb-1" wire:model.live="contact.phone">
                                            <input type="text" class="form-control mb-1" wire:model.live="contact.email">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col d-flex align-items-stretch">
                    <div class="card mb-3 w-100">
                        <div class="card-header">Comments</div>
                        <div class="card-body" style="min-height: 100px">
                            <div class="row">
                                <div class="col">
                                    <textarea rows="3" class="form-control dont-print" wire:model.lazy="comments"></textarea>
                                    {{$comments}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <table style="table-layout: fixed; width: 100%;" id="tableSort" class="table text-center align-middle">
                            <thead>
                                <tr>
                                    <th>Yarn Description</th>
                                    <th>Yarn Count</th>
                                    <th>Yarn Price</th>
                                    <th>Colour</th>
                                    <th>Qty (KG)</th>
                                    <th>ExMill</th>
                                    <th>Customer</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($this->po->yarn_order_lines as $i=>$line)
                                    <tr>
                                        <td>{{ $line->yarn_colours->yarn->yarn_code }} {{ $line->yarn_colours->yarn->description }}</td>
                                        <td>{{ $line->yarn_colours->yarn->counts->count }}</td>
                                        <td>{{$line->price}}
                                            {{-- @foreach($line->yarn_order_line_styles as $x=>$styles)
                                                {{ $styles->customer_order_lines?->colourways->style_versions->styles->customer_ref }} / <b>{{ $this->po->suppliers->currency }}{{ number_format($styles->customer_order_lines?->colourways->colourway_yarns->where('yarn_colours_id', $line->yarn_colours_id)->first()->price, 2) }}</b><br>
                                            @endforeach --}}
                                        </td>
                                        <td>{{ $line->yarn_colours->reference }} {{ $line->yarn_colours->description }}</td>
                                        <td>{{ $line->qty }}</td>
                                        <td>{{ $line->ship_date?->format('d-M') }}</td>
                                        <td>
                                            <div class="print col-7 text-secondary">
                                                @if(!empty($customer[$line->id]))
                                                    {{ $customer[$line->id] }}
                                                @endif
                                            </div>
                                            <div class="dont-print col-7 text-secondary">
                                                <input type="text" class="form-control w-100" wire:model.live.debounce(300)="customer.{{$line->id}}">
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @else
            Error: No Prod Selected
        @endif
    </div>
    <div class="modal-footer">
        <button class="btn btn-primary" onclick="printDiv('print')">Print</button>
        <button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
    </div>
</div>
