<div>
    <div class="modal-body">
        {{-- @if (Session::get('message')) --}}
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h3>
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
            </div>
        {{-- @endif --}}
        {{-- @if(!empty($form->order)) --}}
            <form wire:submit="save">
                <div class="row">
                    <div class="col-lg">
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">PROD</h6>
                            </div>
                            <div class="col-9" style="height: 37px">
                                {{$form->order->id ?? ""}}
                            </div>
                        </div>
                        <hr>
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">Spinner</h6>
                            </div>
                            <div class="col-9" style="height: 37px">
                                @if(Gate::check('order:update') && $new)
                                    <select class="form-select" wire:model.live="form.orderEdit.suppliers_id">
                                        <option value=""></option>
                                        @foreach($this->spinners as $spinner)
                                            <option value="{{$spinner->id}}">{{$spinner->name}}</option>
                                        @endforeach
                                    </select>
                                @else
                                    {{$form->order->suppliers->name ?? ""}}
                                @endif
                            </div>
                        </div>
                        <hr>
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">Invoice To</h6>
                            </div>
                            <div class="col-9" style="height: 37px">
                                @if(Gate::check('order:update') && !$viewOnly)
                                    <select class="form-select" wire:model.live="form.orderEdit.invoice_to_id">
                                        <option value=""></option>
                                        @foreach($this->suppliers as $supplier)
                                            <option value="{{$supplier->id}}">{{$supplier->name}}</option>
                                        @endforeach
                                    </select>
                                @else
                                    {{$form->order->invoice_to->name ?? ""}}
                                @endif
                            </div>
                        </div>
                        <hr>
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">Deliver To</h6>
                            </div>
                            <div class="col-9" style="height: 37px">
                                @if(Gate::check('order:update') && !$viewOnly)
                                    <select class="form-select" wire:model.live="form.orderEdit.deliver_to_id">
                                        <option value=""></option>
                                        @foreach($this->suppliers as $supplier)
                                            <option value="{{$supplier->id}}">{{$supplier->name}}</option>
                                        @endforeach
                                    </select>
                                @else
                                    {{$form->order->deliver_to->name ?? ""}}
                                @endif
                            </div>
                        </div>
                        <hr>
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">Season</h6>
                            </div>
                            <div class="col-9" style="height: 37px">
                                @if(Gate::check('order:update') && !$viewOnly)
                                    <select class="form-select" wire:model="form.orderEdit.seasons_id">
                                        <option value=""></option>
                                        @foreach($this->seasons as $season)
                                            <option value="{{$season->id}}">{{$season->description}}</option>
                                        @endforeach
                                    </select>
                                @else
                                    {{$form->order->seasons->description ?? ""}}
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-lg">
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">Order Date</h6>
                            </div>
                            <div class="col-9" style="height: 37px">
                                @if(Gate::check('order:update') && !$viewOnly)
                                    <input type="date" class="form-control" wire:model="form.orderEdit.date">
                                @elseif(!empty($form->order))
                                    {{$form->order->date->format('d-M-Y') ?? ""}}
                                @endif
                            </div>
                        </div>
                        <hr>
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">Customer</h6>
                            </div>
                            <div class="col-9" style="height: 37px">
                                @if(Gate::check('order:update') && $new)
                                    <select class="form-select" wire:model.live="form.orderEdit.customers_id">
                                        <option value=""></option>
                                        @foreach($this->customers as $customer)
                                            <option value="{{$customer->id}}">{{$customer->name}}</option>
                                        @endforeach
                                    </select>
                                @else
                                    {{$form->order->customers->name ?? ""}}
                                @endif
                            </div>
                        </div>
                        <hr>
                        <div class="row align-items-center">
                            <div class="col-3">
                                <h6 class="mb-0 fw-bold">Files</h6>
                            </div>
                            <div class="col-9">
                                @if(Gate::check('order:update') && !$viewOnly)
                                    <input multiple type="file" class="form-control" wire:model.lazy="form.uploadFiles">
                                @endif
                                <ul class="list-group mt-2">
                                    @foreach($this->form->orderEdit['yarn_order_files'] ?? [] as $f=>$file)
                                        <li class="list-group-item">
                                            @if(Gate::check('order:update') && !$viewOnly)
                                                <input type="button" class="btn btn-sm btn-danger" style="width: unset; display: unset;" value="X" wire:click="deleteFile({{$f}}, {{$file['id']}}, '{{$file['file']}}')">
                                            @endif
                                            <a class="text-decoration-none" download href="{{url(asset('storage/' . $file['file']))}}">{{ $file['filename'] }}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <hr>
                        <div class="row align-items-center">
                            @if(Gate::check('order:update') && !$viewOnly)
                                <div class="col">
                                    <label>Requested ExMill</label>
                                    <input type="date" class="form-control" wire:model.lazy="form.ship_date">
                                </div>
                                <div class="col">
                                    <label>Confirmed ExMill</label>
                                    <input type="date" class="form-control" wire:model.lazy="form.actual_ship_date">
                                </div>
                                <div class="col">
                                    <label>Shipped</label>
                                    <input type="date" class="form-control" wire:model.lazy="form.delivery_date">
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-lg">
                        <h6 class="mb-0 fw-bold">Notes</h6>
                        @if(Gate::check('order:update') && !$viewOnly)
                            <textarea rows="3" class="form-control" wire:model="form.orderEdit.comments"></textarea>
                        @elseif(!empty($form->order))
                            {{$form->order->date->format('d-M-Y') ?? ""}}
                        @endif
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Yarn</th>
                                    <th>Colour</th>
                                    <th>KG</th>
                                    <th>Price</th>
                                    <th>ExMill</th>
                                    <th>Confirmed ExMill</th>
                                    <th>Shipped</th>
                                    @if(Gate::check('finance:read'))
                                        <th class="bg-finance">Invoice No</th>
                                        <th class="bg-finance">Invoiced Qty</th>
                                        <th class="bg-finance">Notes</th>
                                    @endif
                                    <th>Order</th>
                                    <th>Colourway</th>
                                    <th>Priced Cost</th>
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <th style="width: 150px"></th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($form->orderEdit['yarn_order_lines'] ?? [] as $i=>$line)
                                    @foreach (!empty($line['yarn_order_line_styles']) ? $line['yarn_order_line_styles'] : [NULL] as $s=>$style)
                                        <tr>
                                            @if($loop->first)
                                                <td rowspan="{{$loop->count}}">
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <select class="form-select" wire:key="yarn_id.{{$i}}" wire:model.live="form.orderEdit.yarn_order_lines.{{$i}}.yarn_id">
                                                            <option value="">Select...</option>
                                                            @foreach ($this->yarns as $yarn)
                                                                <option value="{{$yarn->id}}">{{$yarn->description}} {{$yarn->counts->count}}</option>
                                                            @endforeach
                                                        </select>
                                                    @else
                                                        {{$this->yarnColours->where('id', $line['yarn_colours_id'])->first()->yarn->description}}
                                                        {{$this->yarnColours->where('id', $line['yarn_colours_id'])->first()->yarn->counts->count}}
                                                    @endif
                                                </td>
                                                <td rowspan="{{$loop->count}}">
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <select class="form-select" wire:key="yarn_colours_id.{{$i}}" wire:model.live="form.orderEdit.yarn_order_lines.{{$i}}.yarn_colours_id">
                                                            <option value="">Select...</option>
                                                            @foreach ($this->yarnColours->where('yarn_id', $line['yarn_id']) as $colour)
                                                                <option value="{{$colour->id}}">RT{{$colour->id}} - {{$colour->reference}} {{$colour->description}}</option>
                                                            @endforeach
                                                        </select>
                                                    @else
                                                        {{$this->yarnColours->where('id', $line['yarn_colours_id'])->first()->reference}}
                                                        ({{$this->yarnColours->where('id', $line['yarn_colours_id'])->first()->description}})
                                                    @endif
                                                </td>
                                                <td rowspan="{{$loop->count}}">
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <input class="form-control" type="number" wire:key="qty.{{$i}}" wire:model="form.orderEdit.yarn_order_lines.{{$i}}.qty">
                                                    @else
                                                        {{$line['qty']}}
                                                    @endif
                                                </td>
                                                <td rowspan="{{$loop->count}}">
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <input class="form-control @if($this->isYarnPriceTooLow($i, $style ?? [])) bg-danger text-white @endif" type="number" wire:key="price.{{$i}}" wire:model="form.orderEdit.yarn_order_lines.{{$i}}.price">
                                                    @else
                                                        {{$form->order->suppliers->currency}}{{$line['price']}}
                                                    @endif
                                                </td>
                                                <td rowspan="{{$loop->count}}">
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <input class="form-control" type="date" wire:key="ship_date.{{$i}}" wire:model="form.orderEdit.yarn_order_lines.{{$i}}.ship_date">
                                                    @else
                                                        {{$line['ship_date']}}
                                                    @endif
                                                </td>
                                                <td rowspan="{{$loop->count}}">
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <input class="form-control" type="date" wire:key="actual_ship_date.{{$i}}" wire:model="form.orderEdit.yarn_order_lines.{{$i}}.actual_ship_date">
                                                    @else
                                                        {{$line['actual_ship_date']}}
                                                    @endif
                                                </td>
                                                <td rowspan="{{$loop->count}}">
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <input class="form-control" type="date" wire:key="delivery_date.{{$i}}" wire:model="form.orderEdit.yarn_order_lines.{{$i}}.delivery_date">
                                                    @else
                                                        {{$line['delivery_date']}}
                                                    @endif
                                                </td>
                                                @can('finance:update')
                                                    <td rowspan="{{$loop->count}}" class="bg-finance">
                                                        @if(Gate::check('finance:update') && !empty($line['id']) && !$viewOnly)
                                                            <input class="form-control" type="text" wire:key="invoice_no.{{$i}}" wire:model.lazy="finance.{{$line['id']}}.invoice_no">
                                                        @else
                                                            {{$line['invoice_no'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td rowspan="{{$loop->count}}" class="bg-finance">
                                                        @if(Gate::check('finance:update') && !empty($line['id']) && !$viewOnly)
                                                            <input class="form-control" type="text" wire:key="invoiced_qty.{{$i}}" wire:model.lazy="finance.{{$line['id']}}.invoiced_qty">
                                                        @else
                                                            {{$line['invoiced_qty'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td rowspan="{{$loop->count}}" class="bg-finance">
                                                        @if(Gate::check('finance:update') && !empty($line['id']) && !$viewOnly)
                                                            <input class="form-control" type="text" wire:key="fn_notes.{{$i}}" wire:model.lazy="finance.{{$line['id']}}.fn_notes">
                                                        @else
                                                            {{$line['fn_notes'] ?? ""}}
                                                        @endif
                                                    </td>
                                                @endcan
                                            @endif
                                            <td>
                                                @if(!empty($style))
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <select class="form-select" wire:model.live="form.orderEdit.yarn_order_lines.{{$i}}.yarn_order_line_styles.{{$s}}.customer_orders_id">
                                                            <option value="">Select...</option>
                                                            @foreach ($this->orders?->where('yarn_colours_id', $line['yarn_colours_id'])?->unique('customer_orders_id') ?? [] as $order)
                                                                <option value="{{$order->customer_orders_id}}">{{$order->customer_po}}</option>
                                                            @endforeach
                                                        </select>
                                                    @else
                                                        {{$style['customer_order_lines']['customer_orders']['customer_po'] ?? ""}}
                                                    @endif
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($style))
                                                    @if(Gate::check('order:update') && !$viewOnly)
                                                        <div class="input-group">
                                                            <select class="form-select" wire:model="form.orderEdit.yarn_order_lines.{{$i}}.yarn_order_line_styles.{{$s}}.customer_order_lines_id">
                                                                <option selected value>Select...</option>
                                                                @if(!empty($line['yarn_colours_id']) && !empty($style))
                                                                    @foreach ($this->orders?->where('customer_orders_id', $style['customer_orders_id'])->where('yarn_colours_id', $line['yarn_colours_id'])->unique('customer_order_lines_id') ?? [] as $order)
                                                                        <option value="{{$order->customer_order_lines_id}}">{{$order->design}} | {{$order->customer_ref}} ({{$order->version}}) {{$order->colourway}}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                            <button class="btn btn-danger" wire:click.prevent="deleteStyle({{$i}}, {{$s}})">X</button>
                                                        </div>
                                                        {{-- {{$form->orderEdit['yarn_order_lines'][$i]['yarn_order_line_styles'][$s]['customer_orders_id'] ?? 'NONE'}} --}}
                                                    @else
                                                        {{$style['customer_order_lines']['colourways']['style_versions']['styles']['designs_id'] ?? ""}} |
                                                        {{$style['customer_order_lines']['colourways']['style_versions']['styles']['customer_ref'] ?? ""}}
                                                        ({{$style['customer_order_lines']['colourways']['style_versions']['name'] ?? ""}})
                                                        {{$style['customer_order_lines']['colourways']['name'] ?? ""}}
                                                    @endif
                                                @endif
                                            </td>
                                            <td>
                                                {{$style['customer_order_lines']['yarn_cost'] ?? ""}}
                                            </td>
                                            @if($loop->first)
                                                @if(Gate::check('order:update') && !$viewOnly)
                                                    <td rowspan="{{$loop->count}}">
                                                        <button class="btn btn-primary" wire:click.prevent="addStyle({{$i}})">+</button>
                                                        <button class="btn btn-primary" wire:click.prevent="addAllStyles({{$i}}, {{$line['yarn_colours_id']}})">ALL</button>
                                                        <button class="btn btn-danger" wire:click.prevent="deleteLine({{$i}},  {{$line['id'] ?? 0}})">X</button>
                                                    </td>
                                                @endif
                                            @endif
                                        </tr>
                                    @endforeach
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </form>
        {{-- @endif --}}
    </div>
    <div class="modal-footer">
		@if(Gate::check('order:update') && !$viewOnly)
			<button class="btn btn-primary" wire:click="addLine()">Add Yarn</button>
			<button class="btn btn-primary" wire:click="save()">Save</button>
            <button class="btn btn-secondary"
                wire:click="syncColourPrices">
            Sync C/W prices
        </button>
		@endif
        <button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
    </div>
</div>
