<div class="wcal-page" x-data="{ 
    showFilters: true,
    modalAnimation: false
}">
    {{-- Header --}}
    <header class="wcal-header">
        <div class="wcal-header-content">
            {{-- Stats --}}
            <div class="wcal-title-section">
                <div class="wcal-stats">
                    <span class="wcal-stat total">
                        <span class="wcal-stat-value">{{ $this->monthStats['total'] }}</span>
                        <span class="wcal-stat-label">Drops</span>
                    </span>
                    <span class="wcal-stat pending">
                        <span class="wcal-stat-value">{{ $this->monthStats['unshipped'] }}</span>
                        <span class="wcal-stat-label">Unshipped</span>
                    </span>
                    <span class="wcal-stat shipped">
                        <span class="wcal-stat-value">{{ $this->monthStats['shipped'] }}</span>
                        <span class="wcal-stat-label">Shipped</span>
                    </span>
                    <span class="wcal-stat qty">
                        <span class="wcal-stat-value">{{ number_format($this->monthStats['totalQty']) }}</span>
                        <span class="wcal-stat-label">Units</span>
                    </span>
                </div>
            </div>

            {{-- Month Navigation --}}
            <div class="wcal-month-nav">
                <button class="wcal-nav-btn" wire:click="previousMonth" title="Previous Month">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <span class="wcal-current-month">
                    {{ $this->currentMonth->format('F Y') }}
                </span>
                <button class="wcal-nav-btn" wire:click="nextMonth" title="Next Month">
                    <i class="fas fa-chevron-right"></i>
                </button>
                <button class="wcal-today-btn" wire:click="goToToday">
                    Today
                </button>
            </div>

            {{-- Actions --}}
            <div class="wcal-actions">
                <button class="wcal-refresh-btn" wire:click="$refresh" title="Refresh">
                    <i class="fas fa-sync-alt"></i>
                </button>
            </div>
        </div>
    </header>

    {{-- Filters Bar --}}
    <div class="wcal-filter-bar">
        <div class="wcal-filter-content">
            {{-- Mobile Toggle --}}
            <button class="wcal-filter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="wcal-filter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="wcal-filter-items" :class="{ 'show': showFilters }">
                {{-- Status Chips --}}
                <div class="wcal-view-selector">
                    <button class="wcal-view-chip {{ $shipped === '' ? 'active' : '' }}" 
                            wire:click="$set('shipped', '')">
                        <i class="fas fa-layer-group"></i>
                        All
                    </button>
                    <button class="wcal-view-chip {{ $shipped === 'unshipped' ? 'active' : '' }}" 
                            wire:click="$set('shipped', 'unshipped')">
                        <i class="fas fa-box"></i>
                        Unshipped
                    </button>
                    <button class="wcal-view-chip {{ $shipped === 'shipped' ? 'active' : '' }}" 
                            wire:click="$set('shipped', 'shipped')">
                        <i class="fas fa-check-circle"></i>
                        Shipped
                    </button>
                </div>

                <div class="wcal-filter-divider"></div>

                {{-- Customer Multi-Select Dropdown --}}
                <div class="wcal-filter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="wcal-filter-dropdown-btn {{ count($customers) > 0 ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building wcal-filter-icon"></i>
                        <span class="wcal-filter-label">
                            @if(count($customers) > 0)
                                {{ count($customers) }} Customer{{ count($customers) > 1 ? 's' : '' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down wcal-filter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="wcal-filter-dropdown-menu wcal-filter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="wcal-filter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" x-ref="customerSearch">
                        </div>
                        <div class="wcal-filter-options">
                            @if(count($customers) > 0)
                                <button class="wcal-filter-option wcal-filter-clear-option" 
                                        wire:click="$set('customers', [])">
                                    <i class="fas fa-times-circle"></i>
                                    Clear selection
                                </button>
                            @endif
                            @foreach($this->customerList as $c)
                                <button class="wcal-filter-option {{ in_array($c->id, $customers) ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="toggleCustomer({{ $c->id }})">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if(in_array($c->id, $customers))
                                        <i class="fas fa-check wcal-filter-check"></i>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Season Multi-Select Dropdown --}}
                <div class="wcal-filter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="wcal-filter-dropdown-btn {{ count($seasons) > 0 ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-calendar-check wcal-filter-icon"></i>
                        <span class="wcal-filter-label">
                            @if(count($seasons) > 0)
                                {{ count($seasons) }} Season{{ count($seasons) > 1 ? 's' : '' }}
                            @else
                                All Seasons
                            @endif
                        </span>
                        <i class="fas fa-chevron-down wcal-filter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="wcal-filter-dropdown-menu wcal-filter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="wcal-filter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search seasons..." x-model="search">
                        </div>
                        <div class="wcal-filter-options">
                            @if(count($seasons) > 0)
                                <button class="wcal-filter-option wcal-filter-clear-option" 
                                        wire:click="$set('seasons', [])">
                                    <i class="fas fa-times-circle"></i>
                                    Clear selection
                                </button>
                            @endif
                            @foreach($this->seasonList as $s)
                                <button class="wcal-filter-option {{ in_array($s->id, $seasons) ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($s->description) }}'.includes(search.toLowerCase())"
                                        wire:click="toggleSeason({{ $s->id }})">
                                    <i class="fas fa-tag"></i>
                                    {{ $s->description }}
                                    @if(in_array($s->id, $seasons))
                                        <i class="fas fa-check wcal-filter-check"></i>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            {{-- Active Filters Count & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="wcal-filter-active">
                    <span class="wcal-filter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="wcal-filter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                    </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Calendar Grid --}}
    <div class="wcal-container">
        {{-- Weekday Headers --}}
        <div class="wcal-weekdays">
            @foreach(['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'] as $day)
                <div class="wcal-weekday">{{ $day }}</div>
            @endforeach
        </div>

        {{-- Calendar Days --}}
        <div class="wcal-grid">
            @foreach($this->calendarDays as $day)
                @php
                    $dayDrops = $this->dropsByDate->get($day['date'], collect());
                    $hasDrops = $dayDrops->count() > 0;
                    $shippedCount = $dayDrops->where('complete', true)->count();
                    $unshippedCount = $dayDrops->where('complete', false)->count();
                    $overdueCount = $dayDrops->filter(fn($d) => !$d->complete && $d->exfty < now()->startOfDay())->count();
                @endphp
                <div 
                    class="wcal-day {{ !$day['isCurrentMonth'] ? 'other-month' : '' }} {{ $day['isToday'] ? 'today' : '' }} {{ $day['isWeekend'] ? 'weekend' : '' }} {{ $hasDrops ? 'has-events' : '' }}"
                    @if($hasDrops)
                        wire:click="openDayModal('{{ $day['date'] }}')"
                        style="cursor: pointer;"
                    @endif
                >
                    <div class="wcal-day-header">
                        <span class="wcal-day-number">{{ $day['day'] }}</span>
                        @if($hasDrops)
                            <span class="wcal-day-count">{{ $dayDrops->count() }}</span>
                        @endif
                    </div>
                    
                    @if($hasDrops)
                        <div class="wcal-day-events">
                            @foreach($dayDrops->take(3) as $drop)
                                @php
                                    $statusClass = $this->getDropStatusClass($drop);
                                    $styleRef = $drop->customer_order_lines?->colourways?->style_versions?->styles?->customer_ref ?? 'Unknown';
                                    $customer = $drop->customer_order_lines?->customer_orders?->customers?->name ?? 'Unknown';
                                @endphp
                                <div class="wcal-event {{ $statusClass }}">
                                    <span class="wcal-event-style">{{ Str::limit($styleRef, 12) }}</span>
                                    <span class="wcal-event-customer">{{ Str::limit($customer, 10) }}</span>
                                </div>
                            @endforeach
                            @if($dayDrops->count() > 3)
                                <div class="wcal-event-more">
                                    +{{ $dayDrops->count() - 3 }} more
                                </div>
                            @endif
                        </div>

                        {{-- Status indicators --}}
                        <div class="wcal-day-status">
                            @if($overdueCount > 0)
                                <span class="wcal-status-dot overdue" title="{{ $overdueCount }} overdue"></span>
                            @endif
                            @if($unshippedCount > 0 && $overdueCount !== $unshippedCount)
                                <span class="wcal-status-dot pending" title="{{ $unshippedCount - $overdueCount }} pending"></span>
                            @endif
                            @if($shippedCount > 0)
                                <span class="wcal-status-dot shipped" title="{{ $shippedCount }} shipped"></span>
                            @endif
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>

    {{-- Quick Month/Year Jump --}}
    <div class="wcal-month-jump">
        <div class="wcal-year-nav">
            <button class="wcal-year-btn" wire:click="goToMonth({{ $year - 1 }}, {{ $month }})" title="Previous Year">
                <i class="fas fa-chevron-left"></i>
            </button>
            <span class="wcal-year-label">{{ $year }}</span>
            <button class="wcal-year-btn" wire:click="goToMonth({{ $year + 1 }}, {{ $month }})" title="Next Year">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
        <div class="wcal-months-row">
            @for($m = 1; $m <= 12; $m++)
                <button 
                    class="wcal-month-btn {{ $m === $month ? 'active' : '' }}"
                    wire:click="goToMonth({{ $year }}, {{ $m }})"
                >
                    {{ Carbon\Carbon::create(null, $m, 1)->format('M') }}
                </button>
            @endfor
        </div>
    </div>

    {{-- Day Detail Modal --}}
    @if($showDayModal && $selectedDate)
        <div 
            class="wcal-modal-backdrop" 
            wire:click="closeDayModal"
            x-data
            x-init="$nextTick(() => modalAnimation = true)"
            x-show="modalAnimation"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div 
                class="wcal-modal" 
                wire:click.stop
                x-show="modalAnimation"
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100"
            >
                <div class="wcal-modal-header">
                    <h3 class="wcal-modal-title">
                        <i class="fas fa-calendar-day"></i>
                        {{ Carbon\Carbon::parse($selectedDate)->format('l, F j, Y') }}
                    </h3>
                    <button class="wcal-modal-close" wire:click="closeDayModal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>

                <div class="wcal-modal-body">
                    @if($this->selectedDateDrops->count() > 0)
                        <div class="wcal-drops-list">
                            @foreach($this->selectedDateDrops as $drop)
                                @php
                                    $statusClass = $this->getDropStatusClass($drop);
                                    $styleRef = $drop->customer_order_lines?->colourways?->style_versions?->styles?->customer_ref ?? 'Unknown';
                                    $styleName = $drop->customer_order_lines?->colourways?->style_versions?->styles?->designs?->description ?? '';
                                    $colourway = $drop->customer_order_lines?->colourways?->name ?? '';
                                    $customer = $drop->customer_order_lines?->customer_orders?->customers?->name ?? 'Unknown';
                                    $customerPo = $drop->customer_order_lines?->customer_orders?->customer_po ?? '';
                                    $season = $drop->customer_order_lines?->customer_orders?->seasons?->description ?? '';
                                    $totalQty = $drop->shipment_line_sizes->sum('qty');
                                    $shippedQty = $drop->shipment_line_sizes->sum('shipped_qty') ?: 0;
                                    $thumbUrl = $drop->customer_order_lines?->colourways?->img_thumb ? asset('storage/' . $drop->customer_order_lines->colourways->img_thumb) : null;
                                @endphp
                                <div class="wcal-drop-card {{ $statusClass }}">
                                    <div class="wcal-drop-thumb">
                                        @if($thumbUrl)
                                            <img src="{{ $thumbUrl }}" alt="{{ $styleRef }}" loading="lazy">
                                        @else
                                            <div class="wcal-drop-thumb-placeholder">
                                                <i class="fas fa-tshirt"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="wcal-drop-info">
                                        <div class="wcal-drop-title">
                                            <span class="wcal-drop-ref">{{ $styleRef }}</span>
                                            @if($colourway)
                                                <span class="wcal-drop-colour">{{ $colourway }}</span>
                                            @endif
                                        </div>
                                        @if($styleName)
                                            <div class="wcal-drop-name">{{ $styleName }}</div>
                                        @endif
                                        <div class="wcal-drop-meta">
                                            <span class="wcal-drop-customer">
                                                <i class="fas fa-building"></i> {{ $customer }}
                                            </span>
                                            @if($customerPo)
                                                <span class="wcal-drop-po">
                                                    <i class="fas fa-file-alt"></i> {{ $customerPo }}
                                                </span>
                                            @endif
                                            @if($season)
                                                <span class="wcal-drop-season">
                                                    <i class="fas fa-leaf"></i> {{ $season }}
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="wcal-drop-qty">
                                        <div class="wcal-drop-qty-main">
                                            {{ number_format($totalQty) }}
                                        </div>
                                        <div class="wcal-drop-qty-label">units</div>
                                        @if($drop->complete)
                                            <span class="wcal-drop-badge shipped">
                                                <i class="fas fa-check"></i> Shipped
                                            </span>
                                        @elseif($drop->exfty < now()->startOfDay())
                                            <span class="wcal-drop-badge overdue">
                                                <i class="fas fa-exclamation-triangle"></i> Overdue
                                            </span>
                                        @else
                                            <span class="wcal-drop-badge pending">
                                                <i class="fas fa-clock"></i> Pending
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="wcal-empty">
                            <i class="fas fa-calendar-times"></i>
                            <p>No drops scheduled for this day</p>
                        </div>
                    @endif
                </div>

                <div class="wcal-modal-footer">
                    <span class="wcal-modal-summary">
                        {{ $this->selectedDateDrops->count() }} drop(s) · 
                        {{ number_format($this->selectedDateDrops->sum(fn($d) => $d->shipment_line_sizes->sum('qty'))) }} units
                    </span>
                    <a 
                        href="{{ route('shipmentschedule', ['fromDate' => $selectedDate, 'toDate' => $selectedDate]) }}" 
                        class="wcal-btn wcal-btn-primary"
                    >
                        <i class="fas fa-external-link-alt"></i>
                        View in Schedule
                    </a>
                </div>
            </div>
        </div>
    @endif

    {{-- Loading Overlay --}}
    <div wire:loading.delay class="wcal-loading">
        <div class="wcal-loading-spinner"></div>
    </div>
</div>









