<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Shipments
        </x-slot:title>
        <x-slot:end>
			@can('style:create')
				<button class="btn btn-light"  x-on:click="$dispatch('open-modal', {name:'new'})" wire:click="$dispatch('new-shipment')">New</button>
			@endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="transporter">
								<option selected value="">All</option>
								@foreach($this->transporters as $transporter)
									<option value="{{ $transporter->id }}">{{ $transporter->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Transporter:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="customer">
								<option selected value="">All</option>
								@foreach($this->customers as $customer)
									<option value="{{ $customer->id }}">{{ $customer->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Customer:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="paginate">
								<option selected value="10">10</option>
								<option selected value="50">50</option>
								<option selected value="100">100</option>
								<option selected value="200">200</option>
								<option selected value="500">500</option>
							</select>
							<label class="form-label">Per Page:</label>
						</div>
					</div>
                    <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>

    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
						<tr>
							@if($columns['Shipment No'])<th>Shipment No.</th>@endif
							@if($columns['Created'])<th style="width: 120px">Created</th>@endif
							@if($columns['Organiser'])<th>Organiser</th>@endif
							@if($columns['Transporter'])<th style="width: 200px">Transporter</th>@endif
							@if($columns['Price'])<th>Price</th>@endif
							@if($columns['Qty'])<th>Qty</th>@endif
							@if($columns['Shipped Qty'])<th>Shipped Qty</th>@endif
							@if($columns['Factory'])<th>Factory</th>@endif
							@if($columns['Style'])<th style="display:none">Style</th>@endif
							@if($columns['Description'])<th style="display:none">Description</th>@endif
							@if($columns['Customer'])<th>Customer</th>@endif
							<th style="width: 0" class="dont-print"></th>
						</tr>
					</thead>
					<tbody>
						@foreach($shipments as $shipment)
							@php
								$factories = $shipment->shipment_lines->map(function($l){
									return $l->factories?->name ?? $l->customer_order_lines?->colourways?->style_versions?->factories?->name;
								})->filter()->unique()->values();
								$customers = $shipment->shipment_lines->map(fn($l) => $l->customer_order_lines?->customer_orders?->customers?->name)->filter()->unique()->values();
								$rowspan = max(1, max($factories->count(), $customers->count()));
							@endphp
							@for($i = 0; $i < $rowspan; $i++)
								<tr>
									@if($i === 0)
										@if($columns['Shipment No'])<td class="border-bottom border-primary" rowspan="{{$rowspan}}">{{$shipment->id}}</td>@endif
										@if($columns['Created'])<td class="border-bottom border-primary" rowspan="{{$rowspan}}">{{$shipment->created_at->format('d-M-Y')}}</td>@endif
										@if($columns['Organiser'])<td class="border-bottom border-primary" rowspan="{{$rowspan}}">{{$shipment->organiser}}</td>@endif
										@if($columns['Transporter'])<td class="border-bottom border-primary" rowspan="{{$rowspan}}">{{$shipment->transporters?->name}}</td>@endif
										@if($columns['Price'])<td class="border-bottom border-primary" rowspan="{{$rowspan}}">£{{number_format($shipment->cost, 2)}}</td>@endif
										@if($columns['Qty'])<td class="border-bottom border-primary" rowspan="{{$rowspan}}">{{ $shipment->shipment_lines->sum(fn($l) => $l->shipment_line_sizes->sum('qty')) }}</td>@endif
										@if($columns['Shipped Qty'])<td class="border-bottom border-primary" rowspan="{{$rowspan}}">{{ $shipment->shipment_lines->sum(fn($l) => $l->shipment_line_sizes->sum('shipped_qty')) }}</td>@endif
									@endif

									@if($columns['Factory'])<td @if($i === $rowspan - 1) class="border-bottom border-primary" @endif>{{ $factories[$i] ?? '' }}</td>@endif
									@if($columns['Style'])<td @if($i === $rowspan - 1) class="border-bottom border-primary" @endif></td>@endif
									@if($columns['Description'])<td @if($i === $rowspan - 1) class="border-bottom border-primary" @endif></td>@endif
									@if($columns['Customer'])<td @if($i === $rowspan - 1) class="border-bottom border-primary" @endif>{{ $customers[$i] ?? '' }}</td>@endif

									@if($i === 0)
										<td class="border-bottom border-primary dont-print" rowspan="{{$rowspan}}">
											<button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-shipment', {shipment: {{$shipment->id}}})">Edit</button>
										</td>
									@endif
								</tr>
							@endfor
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<x-modal name="edit" title="Edit Shipment">
		<x-slot:body>
			<livewire:production.shipments.shipments-edit wire:key="shipmentEdit">
		</x-slot:body>
	</x-modal>

	<x-modal name="new" title="New Shipment">
		<x-slot:body>
			<livewire:production.shipments.shipments-edit wire:key="shipmentNew">
		</x-slot:body>
	</x-modal>



    <x-footer>
        <x-slot:center>
            {{ $shipments->links() }}
        </x-slot:center>
    </x-footer>
</div>
