<div>
    <div class="modal-body">
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h3>
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
            </div>
        @endif
		<div>
                <hr>
                <h5>Details {{$viewOnly}}</h5>
                <hr>
                <div class="ms-5">
                    <div class="row">
                        <div class="col-lg">
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">Shipment No.</h6>
                                </div>
                                <div class="col-7">
                                    {{$form->shipmentEdit['id'] ?? ""}}
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">Transporter</h6>
                                </div>
                                <div class="col-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <select class="form-select" wire:model="form.shipmentEdit.transporter_id">
                                            <option value=""></option>
                                            @foreach($this->transporters as $transporter)
                                                <option value="{{$transporter->id}}">{{$transporter->name}}</option>
                                            @endforeach
                                        </select>
                                    @else
                                        {{$form->shipmentEdit['transporters']['name'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">Organiser</h6>
                                </div>
                                <div class="col-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input class="form-control" type="text" wire:model="form.shipmentEdit.organiser">
                                    @else
                                        {{$form->shipmentEdit['organiser'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">Cost</h6>
                                </div>
                                <div class="col-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input class="form-control" type="number" wire:model="form.shipmentEdit.cost">
                                    @else
                                        {{$form->shipmentEdit['cost'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">Additional Cost</h6>
                                </div>
                                <div class="col-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input class="form-control" type="text" wire:model="form.shipmentEdit.additional_cost">
                                    @else
                                        {{$form->shipmentEdit['additional_cost'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">UK Customs Submitted</h6>
                                </div>
                                @if(Gate::check('order:update') && !$viewOnly)
                                    <div class="col-sm-1">
                                        <div class="form-check form-switch pb-0">
                                            <input class="form-check-input" type="checkbox" wire:model="form.shipmentEdit.customs_submitted">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" wire:model="form.shipmentEdit.customs_submitted_text">
                                    </div>
                                @else
                                    <div class="col-sm-1">
                                        <input disabled type="checkbox" class="form-check-input" @if($form->shipmentEdit['customs_submitted'] ?? "") checked @endif>
                                    </div>
                                    <div class="col-sm-6">
                                        {{$form->shipmentEdit['customs_submitted_text'] ?? ""}}
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h6 class="mb-0 fw-bold">Comments</h6>
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <textarea class="form-control" rows="5" wire:model="form.shipmentEdit.comments"></textarea>
                                    @else
                                        {{$form->shipmentEdit['additional_cost'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Customs Files</h6>
                                </div>
                                <div class="col-sm-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input multiple type="file" class="form-control" wire:model.lazy="form.uploadFiles.customs">
                                    @endif
                                    <ul class="list-group mt-2">
                                        @foreach(collect($form->shipmentEdit['shipment_files'] ?? [])->where('type', 'customs') ?? [] as $f=>$file)
                                            <li class="list-group-item">
                                                @if(Gate::check('order:update') && !$viewOnly)
                                                    <input type="button" class="btn btn-sm btn-danger" style="width: unset; display: unset;" value="X" wire:click="deleteFile({{$f}}, {{$file['id']}}, '{{$file['file']}}')">
                                                @endif
                                                <a class="text-decoration-none" download href="{{url(asset('storage/' . $file['file']))}}">{{ $file['filename'] }}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Packing Lists</h6>
                                </div>
                                <div class="col-sm-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input multiple type="file" class="form-control" wire:model.lazy="form.uploadFiles.packing">
                                    @endif
                                    <ul class="list-group mt-2">
                                        @foreach(collect($form->shipmentEdit['shipment_files'] ?? [])->where('type', 'packingList') ?? [] as $f=>$file)
                                            <li class="list-group-item">
                                                @if(Gate::check('order:update') && !$viewOnly)
                                                    <input type="button" class="btn btn-sm btn-danger" style="width: unset; display: unset;" value="X" wire:click="deleteFile({{$f}}, {{$file['id']}}, '{{$file['file']}}')">
                                                @endif
                                                <a class="text-decoration-none" download href="{{url(asset('storage/' . $file['file']))}}">{{ $file['filename'] }}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Transporter Invoice</h6>
                                </div>
                                <div class="col-sm-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input multiple type="file" class="form-control" wire:model.lazy="form.uploadFiles.transporter">
                                    @endif
                                    <ul class="list-group mt-2">
                                        @foreach(collect($form->shipmentEdit['shipment_files']?? [])->where('type', 'transporters_invoice') ?? [] as $f=>$file)
                                            <li class="list-group-item">
                                                @if(Gate::check('order:update') && !$viewOnly)
                                                    <input type="button" class="btn btn-sm btn-danger" style="width: unset; display: unset;" value="X" wire:click="deleteFile({{$f}}, {{$file['id']}}, '{{$file['file']}}')">
                                                @endif
                                                <a class="text-decoration-none" download href="{{url(asset('storage/' . $file['file']))}}">{{ $file['filename'] }}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Other Files</h6>
                                </div>
                                <div class="col-sm-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input multiple type="file" class="form-control" wire:model.lazy="form.uploadFiles.other">
                                    @endif
                                    <ul class="list-group mt-2">
                                        @foreach(collect($form->shipmentEdit['shipment_files'] ?? [])->where('type', 'other') ?? [] as $f=>$file)
                                            <li class="list-group-item">
                                                @if(Gate::check('order:update') && !$viewOnly)
                                                    <input type="button" class="btn btn-sm btn-danger" style="width: unset; display: unset;" value="X" wire:click="deleteFile({{$f}}, {{$file['id']}}, '{{$file['file']}}')">
                                                @endif
                                                <a class="text-decoration-none" download href="{{url(asset('storage/' . $file['file']))}}">{{ $file['filename'] }}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <h5>Totals</h5>
                <hr>
                <div class="ms-5">
                    <div class="row">
                        <div class="col-lg">
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Garments</h6>
                                </div>
                                <div class="col-sm-6">
                                    @if(!empty($this->form->shipment->id))
                                        {{ $this->form->shipment->goods_qty }}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Shipped Garments</h6>
                                </div>
                                <div class="col-sm-6">
                                    @if(!empty($this->form->shipment->id))
                                        {{ (int) round($this->lines->sum('total_shipped')) }}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Pickups</h6>
                                </div>
                                <div class="col-sm-6">
                                    @if(!empty($this->form->shipment->id))
                                        {{ $this->lines->unique('factory_name')->count() }}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Deliveries</h6>
                                </div>
                                <div class="col-sm-6">
                                    @if(!empty($this->form->shipment->id))
                                        {{ $this->lines->unique('delivery_address')->count() }}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Budget</h6>
                                </div>
                                <div class="col-sm-6">
                                    @if(!empty($this->form->shipment->id))
                                        £{{ number_format($this->form->shipment->transport_budget, 2) }}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-sm-5">
                                    <h6 class="mb-0 fw-bold">Sale Value</h6>
                                </div>
                                <div class="col-sm-6">
                                    @if(!empty($this->form->shipment->id))
                                        £{{ number_format($this->form->shipment->goods_value, 2) }}
                                    @endif
                                </div>
                            </div>
                            <hr>
                        </div>
                        <div class="col-lg">
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">No. Cartons</h6>
                                </div>
                                <div class="col-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input class="form-control" type="text" wire:model="form.shipmentEdit.no_cartons">
                                    @else
                                        {{$form->shipmentEdit['no_cartons'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">Weight</h6>
                                </div>
                                <div class="col-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input class="form-control" type="text" wire:model="form.shipmentEdit.weight">
                                    @else
                                        {{$form->shipmentEdit['weight'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                            <hr>
                            <div class="row align-items-center">
                                <div class="col-5">
                                    <h6 class="mb-0 fw-bold">Trucks</h6>
                                </div>
                                <div class="col-7">
                                    @if(Gate::check('order:update') && !$viewOnly)
                                        <input class="form-control" type="text" wire:model="form.shipmentEdit.no_trucks">
                                    @else
                                        {{$form->shipmentEdit['no_trucks'] ?? ""}}
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <h5>Drops</h5>
                <hr>
                <div class="ms-5">
                    <div class="row">
                        <div class="col-lg">
                            <div class="table-responsive">
                                <table class="table align-middle text-center">
                                    <thead>
                                        <tr>
                                            <th>Order Line</th>
                                            <th>Plates</th>
                                            <th>Collection</th>
                                            <th>Delivery</th>
                                            <th>Delivered</th>
                                            <th>Qty</th>
                                            <th>Shipped Qty</th>
                                            <th>RT Invoice</th>
                                            <th>Factory Invoice</th>
                                            <th>Customs Invoice</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $grouped = collect($form->shipmentEdit['shipment_lines'] ?? [])->groupBy(function($ln){
                                                return $ln['customer_order_lines']['colourways']['style_versions']['styles']['id'] ?? null;
                                            });
                                        @endphp
                                        @foreach($grouped as $styleId => $styleLines)
                                            @php
                                                $first = $styleLines->first();
                                                $styleLabel = trim((($first['customer_order_lines']['colourways']['style_versions']['styles']['designs']['id'] ?? '') . ' | ' . ($first['customer_order_lines']['colourways']['style_versions']['styles']['customer_ref'] ?? '') . ' ' . ($first['customer_order_lines']['colourways']['style_versions']['styles']['designs']['description'] ?? '')));
                                                $styleQty = $styleLines->sum(function($ln){ return collect($ln['shipment_line_sizes'] ?? [])->sum('qty'); });
                                                $styleShipped = $styleLines->sum(function($ln){ return collect($ln['shipment_line_sizes'] ?? [])->sum('shipped_qty'); });
                                            @endphp
                                            @foreach($styleLines as $l=>$line)
                                                <tr>
                                                    <td>
                                                        {{$line['customer_order_lines']['colourways']['style_versions']['styles']['designs']['id']}} |
                                                        {{$line['customer_order_lines']['colourways']['style_versions']['styles']['customer_ref']}}
                                                        {{$line['customer_order_lines']['colourways']['style_versions']['styles']['designs']['description']}}
                                                        ({{$line['customer_order_lines']['colourways']['style_versions']['name']}})
                                                        {{$line['customer_order_lines']['colourways']['name']}}
                                                    </td>
                                                    <td>
                                                        @if(Gate::check('order:update') && !$viewOnly)
                                                            <input class="form-control" type="text" wire:model="form.shipmentEdit.shipment_lines.{{$l}}.truck_plates">
                                                        @else
                                                            {{$line['truck_plates'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(Gate::check('order:update') && !$viewOnly)
                                                            <input class="form-control" type="date" wire:model="form.shipmentEdit.shipment_lines.{{$l}}.collection_date">
                                                        @else
                                                            {{$line['collection_date'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(Gate::check('order:update') && !$viewOnly)
                                                            <input class="form-control" type="date" wire:model="form.shipmentEdit.shipment_lines.{{$l}}.delivery_date">
                                                        @else
                                                            {{$line['delivery_date'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(Gate::check('order:update') && !$viewOnly)
                                                            <input class="form-check-input" type="checkbox" wire:model="form.shipmentEdit.shipment_lines.{{$l}}.complete">
                                                        @else
                                                            {{$line['complete'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        {{ collect($line['shipment_line_sizes'] ?? [])->sum('qty') }}
                                                    </td>
                                                    <td>
                                                        {{ collect($line['shipment_line_sizes'] ?? [])->sum('shipped_qty') }}
                                                    </td>
                                                    <td>
                                                        @if(Gate::check('finance:update') && !$viewOnly)
                                                            <input class="form-control" type="text" wire:model="form.shipmentEdit.shipment_lines.{{$l}}.lines.0.rt_invoice">
                                                        @else
                                                            {{$line['lines.0.rt_invoice'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(Gate::check('finance:update') && !$viewOnly)
                                                            <input class="form-control" type="text" wire:model="form.shipmentEdit.shipment_lines.{{$l}}.factory_invoice">
                                                        @else
                                                            {{$line['factory_invoice'] ?? ""}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(Gate::check('finance:update') && !$viewOnly)
                                                            <input class="form-control" type="text" wire:model="form.shipmentEdit.shipment_lines.{{$l}}.customs_agency_invoice">
                                                        @else
                                                            {{$line['customs_agency_invoice'] ?? ""}}
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                            <tr class="table-light">
                                                <td colspan="5" class="text-end fw-bold">Subtotal — {{ $styleLabel }}</td>
                                                <td class="fw-bold">{{ $styleQty }}</td>
                                                <td class="fw-bold">{{ $styleShipped }}</td>
                                                <td colspan="3"></td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
        </div>

    </div>
    <div class="modal-footer">
        <button class="btn btn-primary"  wire:click="save">Save</button>
        <button class="btn btn-danger"  wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
    </div>
</div>
