<div>
    <style>
        .new-order-section {
            border-left: 4px solid #ffc107;
            background-color: #fff3cd;
        }
        .new-order-alert {
            border-color: #ffc107;
            background-color: #fff3cd;
        }
        .new-order-table th {
            background-color: #ffc107 !important;
            color: #000 !important;
        }
        .new-order-checkbox {
            border: 2px solid #ffc107;
            border-radius: 8px;
            padding: 15px;
            background-color: #fffbf0;
        }
        .new-order-checkbox:has(input:checked) {
            border-color: #28a745;
            background-color: #f8fff9;
        }
        .split-warning {
            border-left: 4px solid #dc3545;
            background-color: #f8d7da;
        }
        .split-info {
            border-left: 4px solid #17a2b8;
            background-color: #d1ecf1;
        }
        .order-summary-card {
            border: 2px solid #e9ecef;
            border-radius: 8px;
        }
        .order-summary-card .card-header {
            background-color: #f8f9fa;
            border-bottom: 2px solid #e9ecef;
        }
        .original-order-section {
            border-left: 4px solid #007bff;
            background-color: #f8f9fa;
        }
        .new-order-section {
            border-left: 4px solid #28a745;
            background-color: #f8fff9;
        }
        .step-navigation {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 15px;
            background-color: #f8f9fa;
        }
        .step-button {
            min-width: 100px;
            position: relative;
        }
        .step-button .step-indicator {
            position: absolute;
            top: -5px;
            right: -5px;
            background-color: #28a745;
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            font-size: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
    
    <script>
        document.addEventListener('livewire:init', () => {
            Livewire.on('new-order-checkbox-changed', (event) => {
                // Handle any additional UI updates when the checkbox changes
                console.log('New order checkbox changed:', event.detail);
            });
        });
    </script>
    
    <div class="modal-body">
        @if(!$drop)
            <div class="text-center py-4">
                <div class="spinner-border" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <p class="mt-2">Loading split drop form...</p>
            </div>
        @else
            @if($errorMessage)
                <div class="alert alert-danger" role="alert">
                    {{ $errorMessage }}
                </div>
            @endif

            @if($successMessage)
                <div class="alert alert-success" role="alert">
                    {{ $successMessage }}
                </div>
            @endif

        <!-- Progress Bar -->
        <div class="progress mb-4" style="height: 8px;">
            <div class="progress-bar" role="progressbar" style="width: {{ ($step / $totalSteps) * 100 }}%"></div>
        </div>

        <!-- Step Navigation -->
        <div class="step-navigation mb-4">
            <div class="d-flex justify-content-between">
                @for($i = 1; $i <= $totalSteps; $i++)
                    <button 
                        type="button" 
                        class="btn {{ $step >= $i ? 'btn-primary' : 'btn-outline-primary' }} btn-sm step-button"
                        wire:click="goToStep({{ $i }})"
                        @if($step < $i) disabled @endif
                    >
                        Step {{ $i }}
                        @if($i === 3 && $createNewOrder)
                            <small class="d-block">(Orders)</small>
                        @endif
                        @if($i === 3 && !$createNewOrder)
                            <small class="d-block">(Final)</small>
                        @endif
                        @if($i === $step)
                            <div class="step-indicator">
                                <i class="fas fa-arrow-right"></i>
                            </div>
                        @endif
                    </button>
                @endfor
            </div>
        </div>
        
        <!-- Current Step Description -->
        <div class="text-center mb-3">
            <h6 class="text-muted">{{ $this->getCurrentStepDescription() }}</h6>
            @if($createNewOrder && $step >= 2)
                <small class="text-info">
                    <i class="fas fa-info-circle me-1"></i>
                    Creating new order for split drop
                </small>
            @endif
        </div>

        <!-- Step 1: Order Quantities and Current Drops -->
        @if($step === 1)
            <div class="step-content">
                <h5 class="mb-3">Step 1: Order Overview</h5>
                <p class="text-muted mb-3">Review the order quantities and existing drops.</p>
                
                <!-- Order Quantities -->
                <h6 class="mb-2">Order Quantities</h6>
                <div class="table-responsive mb-3">
                    <table class="table table-bordered">
                        <thead class="table-light">
                            <tr>
                                <th>Size</th>
                                <th>Order Qty</th>
                                <th>Shipped</th>
                                <th>Remaining</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orderQtys as $sizeId => $orderData)
                                @php
                                    $shippedQty = $currentDropShippedQtys[$sizeId]['shipped_qty'] ?? 0;
                                    $remaining = $orderData['qty'] - $shippedQty;
                                @endphp
                                <tr>
                                    <td><strong>{{ $orderData['size_name'] }}</strong></td>
                                    <td>{{ $orderData['qty'] }}</td>
                                    <td class="{{ $shippedQty > 0 ? 'text-success' : '' }}">
                                        {{ $shippedQty }}
                                    </td>
                                    <td class="{{ $remaining > 0 ? 'text-warning' : ($remaining == 0 ? 'text-success' : 'text-danger') }}">
                                        {{ $remaining }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Existing Drops -->
                @if(count($existingDrops) > 1)
                    <h6 class="mb-2">Existing Drops</h6>
                    <div class="table-responsive mb-3">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Drop ID</th>
                                    <th>ExFty</th>
                                    <th>Status</th>
                                    <th>Total Qty</th>
                                    <th>Total Shipped</th>
                                    <th>To Ship</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($existingDrops as $drop)
                                    @php
                                        $totalShipped = array_sum($drop['shipped_quantities'] ?? []);
                                        $remaining = $drop['total_pieces'] - $totalShipped;
                                    @endphp
                                    <tr>
                                        <td>{{ $drop['id'] }}</td>
                                        <td>{{ $drop['exfty'] }}</td>
                                        <td>
                                            @if($drop['complete'])
                                                <span class="badge bg-success">Shipped</span>
                                            @else
                                                <span class="badge bg-warning">Unshipped</span>
                                            @endif
                                        </td>
                                        <td>{{ $drop['total_pieces'] }}</td>
                                        <td class="{{ $totalShipped > 0 ? 'text-success' : '' }}">
                                            {{ $totalShipped }}
                                        </td>
                                        <td class="{{ $remaining > 0 ? 'text-warning' : ($remaining == 0 ? 'text-success' : 'text-danger') }}">
                                            {{ $remaining }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif

                <div class="d-flex justify-content-end mt-3">
                    <button type="button" class="btn btn-primary" wire:click="nextStep">
                        Next <i class="fas fa-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>
        @endif

        <!-- Step 2: Drop Configuration & Quantities -->
        @if($step === 2)
            <div class="step-content">
                <h5 class="mb-3">Step 2: Drop Configuration & Quantities</h5>
                <p class="text-muted mb-3">Configure the new drop date and set quantities.</p>
                
                <!-- New Drop Date -->
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="newDropDate0" class="form-label">New Drop Shipping Date (Ex-FTY)</label>
                            <input 
                                type="date" 
                                id="newDropDate0"
                                class="form-control @error("newDropDates.0") is-invalid @enderror"
                                wire:model.live="newDropDates.0"
                                min="{{ $drop->exfty ? date('Y-m-d', strtotime($drop->exfty . ' +1 day')) : date('Y-m-d', strtotime('+1 day')) }}"
                            >
                            <small class="text-muted">Must be after {{ $drop->exfty ?? 'existing drop date' }}</small>
                            @error("newDropDates.0")
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- New Order Option -->
                @if($this->canCreateNewOrder())
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="form-check new-order-checkbox">
                                <input 
                                    class="form-check-input" 
                                    type="checkbox" 
                                    id="createNewOrder"
                                    wire:model.live="createNewOrder"
                                >
                                <label class="form-check-label" for="createNewOrder">
                                    <strong>Create a new order for this drop?</strong>
                                    <small class="text-muted d-block">
                                        If checked, a new order will be created with the same details as the original order. 
                                        The new drop will be linked to this new order, and quantities will be adjusted accordingly.
                                    </small>
                                </label>
                            </div>
                        </div>
                    </div>
                @else
                    @php
                        $warningMessage = $this->getNewOrderWarningMessage();
                    @endphp
                    @if($warningMessage)
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <strong>New Order Creation Not Available:</strong>
                                    {{ $warningMessage }}
                                </div>
                            </div>
                        </div>
                    @endif
                @endif

                @if($createNewOrder)
                    <div class="alert alert-info mb-3">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Creating New Order:</strong> You are creating a new order for this drop. 
                        The quantities you set here will be moved to the new order, and the remaining quantities will stay in the original order.
                    </div>
                @else
                    <p class="text-muted mb-3">Set quantities for the new drop. Total quantities should equal order quantities.</p>
                @endif
                
                <!-- Take from existing drop option (only show if there's exactly one unshipped drop) -->
                @if($this->canShowTakeFromExistingCheckbox())
                    <div class="form-check new-order-checkbox mb-3">
                        <input 
                            class="form-check-input" 
                            type="checkbox" 
                            id="takeFromExisting"
                            wire:model.live="takeFromExisting"
                        >
                        <label class="form-check-label" for="takeFromExisting">
                            <strong>Take units from existing drop?</strong>
                            <small class="text-muted d-block">
                                If checked, existing drop quantities will be automatically calculated and adjusted accordingly.
                            </small>
                        </label>
                    </div>
                @endif

                <!-- Unified Drop Quantities Table -->
                <div class="table-responsive mb-3">
                    <table class="table table-bordered borders-strong">
                        <thead class="table-light">
                            <tr>
                                <th>Size</th>
                                <th>Order Qty</th>
                                @foreach($existingDrops as $dropIndex => $drop)
                                    <th class="bg-primary text-white">
                                        {{ date('d-M-y', strtotime($drop['exfty'])) }}
                                        @if($drop['complete'])
                                            <br><small>(Shipped)</small>
                                        @endif
                                    </th>
                                @endforeach
                                @for($i = 0; $i < $newDropCount; $i++)
                                    <th class="bg-success text-white">{{ $newDropDates[$i] ? date('d-M-y', strtotime($newDropDates[$i])) : 'Date not set' }}</th>
                                @endfor
                                <th>Allocated</th>
                                <th>Totals</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orderQtys as $sizeId => $orderData)
                                @php
                                    $existingDropsQty = 0;
                                    $existingDropsShipped = 0;
                                    foreach($existingDrops as $drop) {
                                        $existingDropsQty += $drop['quantities'][$sizeId] ?? 0;
                                        $existingDropsShipped += $drop['shipped_quantities'][$sizeId] ?? 0;
                                    }
                                    $newDropsQty = 0;
                                    foreach($newDropQtys as $dropQtys) {
                                        $newDropsQty += $dropQtys[$sizeId]['qty'] ?? 0;
                                    }
                                    $totalAllocated = $existingDropsQty + $newDropsQty;
                                    $totalShipped = $existingDropsShipped;
                                    $remaining = $orderData['qty'] - $totalShipped;
                                @endphp
                                <tr>
                                    <td><strong>{{ $orderData['size_name'] }}</strong></td>
                                    <td>{{ $orderData['qty'] }}</td>
                                    @foreach($existingDrops as $dropIndex => $drop)
                                        @php
                                            $dropQty = $drop['quantities'][$sizeId] ?? 0;
                                            $shippedQty = $drop['shipped_quantities'][$sizeId] ?? 0;
                                        @endphp
                                        <td class="tinted-col-blue">
                                            @if(!$drop['complete'] && $this->canEditExistingDrops())
                                                <input 
                                                    type="number" 
                                                    class="form-control form-control-sm"
                                                    wire:model.live="existingDrops.{{ $dropIndex }}.quantities.{{ $sizeId }}"
                                                    min="0"
                                                    max="{{ $orderData['qty'] }}"
                                                    style="width: 80px;"
                                                    wire:change="updateExistingDropQuantity({{ $drop['id'] }}, {{ $sizeId }}, $event.target.value)"
                                                >
                                                <small class="text-muted d-block mt-1">
                                                    Shipped: {{ $shippedQty }}
                                                </small>
                                            @else
                                                <div>
                                                    <strong>Due: {{ $dropQty }}</strong>
                                                    @if($shippedQty > 0)
                                                        <br><small class="text-success">Shipped: {{ $shippedQty }}</small>
                                                    @endif
                                                </div>
                                            @endif
                                        </td>
                                    @endforeach
                                    @for($i = 0; $i < $newDropCount; $i++)
                                        <td class="tinted-col-green">
                                            <input 
                                                type="number" 
                                                class="form-control form-control-sm @if(($newDropQtys[$i][$sizeId]['qty'] ?? 0) > $orderData['qty']) is-invalid @endif"
                                                wire:model.live="newDropQtys.{{ $i }}.{{ $sizeId }}.qty"
                                                min="0"
                                                max="{{ $orderData['qty'] }}"
                                                style="width: 80px;"
                                            >
                                        </td>
                                    @endfor
                                    <td class="{{ $totalAllocated == $orderData['qty'] ? 'table-success' : '' }}">
                                        <strong>{{ $totalAllocated }}</strong>
                                    </td>
                                    <td>
                                        <div>
                                            <strong class="{{ $remaining != 0 ? 'text-warning' : 'text-success' }}">
                                                To Ship: {{ $remaining }}
                                            </strong>
                                            <small class="d-block text-muted">
                                                Ordered: {{ $orderData['qty'] }}
                                            </small>
                                            <small class="d-block text-muted">
                                                Shipped: {{ $totalShipped }}
                                            </small>
                                            <small class="d-block text-muted">
                                                Drop Orders: {{ $totalAllocated }}
                                            </small>
                                            @if($createNewOrder && $remaining < 0)
                                                <small class="d-block text-danger">Exceeds order qty</small>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @if($createNewOrder)
                    <div class="alert alert-warning split-info">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Note:</strong> When creating a new order, the remaining quantities will stay in the original order. 
                        Make sure the split makes sense for your business needs.
                    </div>
                    
                    @if(!$this->isSplitReasonable())
                        <div class="alert alert-danger split-warning">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <strong>Warning:</strong> The current split may not be reasonable for business purposes. 
                            Consider leaving at least 20% of quantities in the original order.
                        </div>
                    @endif
                @endif


                <div class="d-flex justify-content-between mt-3">
                    <button type="button" class="btn btn-secondary" wire:click="previousStep">
                        <i class="fas fa-arrow-left me-1"></i> Previous
                    </button>
                    <button type="button" class="btn btn-primary" wire:click="nextStep">
                        Next <i class="fas fa-arrow-right ms-1"></i>
                    </button>
                </div>
            </div>
        @endif



        <!-- Step 3: Drops Overview / Order Comparison -->
        @if($step === 3)
            <div class="step-content">
                @if($createNewOrder)
                    <h5 class="mb-3">Step 3: Order Comparison</h5>
                    <p class="text-muted mb-3">Compare the original order with the new order to be created.</p>

                    <!-- Drops Overview Table -->
                    <div class="card mb-3">
                        <div class="card-header">
                            <h6 class="mb-0">Drops Overview</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered borders-strong">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Size</th>
                                            <th>Order Qty</th>
                                            <th>Shipped</th>
                                            <th>New Drop Qty</th>
                                            <th>Totals</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($overview as $sizeId => $data)
                                            @php
                                                $totalAllocated = $data['total_new_drop_qty'] + $data['existing_drops_qty'];
                                                $isBalanced = $totalAllocated == $data['order_qty'];
                                                $movingToNewOrder = $data['total_new_drop_qty'];
                                            @endphp
                                            <tr class="{{ $isBalanced ? 'table-success' : 'table-warning' }}">
                                                <td><strong>{{ $data['size_name'] }}</strong></td>
                                                <td>{{ $data['order_qty'] }}</td>
                                                <td class="{{ $data['total_shipped'] > 0 ? 'text-success' : '' }}">
                                                    {{ $data['total_shipped'] }}
                                                </td>
                                                <td class="text-success"><strong>{{ $movingToNewOrder }}</strong></td>
                                                <td>
                                                    @if($isBalanced)
                                                        <span class="badge bg-success">Balanced</span>
                                                    @else
                                                        <span class="badge bg-warning">Unbalanced</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Warning if quantities don't balance -->
                            @php
                                $hasUnbalanced = false;
                                foreach($overview as $sizeId => $data) {
                                    $totalAllocated = $data['total_new_drop_qty'] + $data['existing_drops_qty'];
                                    if ($totalAllocated != $data['order_qty']) {
                                        $hasUnbalanced = true;
                                        break;
                                    }
                                }
                            @endphp

                            @if($hasUnbalanced)
                                <div class="alert alert-warning mt-3">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <strong>Warning:</strong> Some sizes have quantities that don't balance with the order. 
                                    Please review the quantities in Step 2 to ensure totals equal order quantities.
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="alert alert-warning new-order-alert mb-3">
                        <h6><i class="fas fa-exclamation-triangle me-2"></i>Important: New Order Creation</h6>
                        <p class="mb-2">
                            You are about to create a <strong>new order</strong> with the following details:
                        </p>
                        <ul class="mb-0">
                            <li>A new customer order will be created with the same details as the original</li>
                            <li>The new order qtys will match the new drop qtys</li>
                            <li>The new drop will be linked to the new order</li>
                            <li>The original order qtys will be the remaining quantities</li>
                        </ul>
                    </div>

                    <!-- Order Summary -->
                    @php
                        $orderSummary = $this->getNewOrderSummary();
                    @endphp
                    @if($orderSummary)
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="mb-0">Order Comparison</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="original-order-section p-3 rounded">
                                            <h6 class="text-primary fw-bold">Original Order</h6>
                                            <p><strong>PO:</strong> {{ $orderSummary['original_order']['po'] }}</p>
                                            <p><strong>Customer:</strong> {{ $orderSummary['original_order']['customer'] }}</p>
                                            <p><strong>Quantities:</strong></p>
                                            <ul class="list-unstyled ms-3">
                                                @foreach($orderSummary['original_order']['remaining_quantities'] as $sizeId => $data)
                                                    <li>{{ $data['size_name'] }}: {{ $data['qty'] }} units</li>
                                                @endforeach
                                            </ul>
                                            <p><strong>Drops:</strong></p>
                                            <ul class="list-unstyled ms-3">
                                                @foreach($existingDrops as $drop)
                                                    <li>{{ date('d/m/y', strtotime($drop['exfty'])) }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="new-order-section p-3 rounded">
                                            <h6 class="text-success fw-bold">New Order</h6>
                                            <p><strong>PO:</strong> {{ $orderSummary['new_order']['po'] }}</p>
                                            <p><strong>Customer:</strong> {{ $orderSummary['original_order']['customer'] }}</p>
                                            <p><strong>Quantities:</strong></p>
                                            <ul class="list-unstyled ms-3">
                                                @foreach($orderSummary['new_order']['quantities'] as $sizeId => $data)
                                                    <li>{{ $data['size_name'] }}: {{ $data['qty'] }} units</li>
                                                @endforeach
                                            </ul>
                                            <p><strong>Drops:</strong></p>
                                            <ul class="list-unstyled ms-3">
                                                @for($i = 0; $i < $newDropCount; $i++)
                                                    @if($newDropDates[$i])
                                                        <li>{{ date('d/m/y', strtotime($newDropDates[$i])) }} (new)</li>
                                                    @endif
                                                @endfor
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Final Confirmation Message -->
                    @php
                        $finalConfirmation = $this->getFinalConfirmationMessage();
                    @endphp
                    @if($finalConfirmation)
                        <div class="alert {{ $finalConfirmation['is_reasonable'] ? 'alert-success' : 'alert-warning' }} mb-3">
                            <p class="mb-2">
                                You are about to split <strong>{{ $finalConfirmation['total_new_order_qty'] }} units ({{ $finalConfirmation['split_percentage'] }}%)</strong> 
                                from the original order into a new order.
                            </p>
                            <p class="mb-0">
                                The original order will retain <strong>{{ $finalConfirmation['remaining_in_original'] }} units</strong>.
                            </p>
                        </div>
                    @endif
                @else
                    <h5 class="mb-3">Step 3: Drops Overview</h5>
                    <p class="text-muted mb-3">Review the complete drops configuration and quantities.</p>

                    <!-- Overview Table -->
                    <div class="table-responsive mb-3">
                        <table class="table table-bordered borders-strong">
                            <thead class="table-light">
                                <tr>
                                    <th>Size</th>
                                    <th>Order Qty</th>
                                    <th>Shipped</th>
                                    <th>New Drop Qty</th>
                                    <th>Totals</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($overview as $sizeId => $data)
                                    @php
                                        $totalAllocated = $data['total_new_drop_qty'] + $data['existing_drops_qty'];
                                        $isBalanced = $totalAllocated == $data['order_qty'];
                                    @endphp
                                    <tr class="{{ $isBalanced ? 'table-success' : 'table-warning' }}">
                                        <td><strong>{{ $data['size_name'] }}</strong></td>
                                        <td>{{ $data['order_qty'] }}</td>
                                        <td class="{{ $data['total_shipped'] > 0 ? 'text-success' : '' }}">
                                            {{ $data['total_shipped'] }}
                                        </td>
                                        <td class="text-primary"><strong>{{ $data['total_new_drop_qty'] }}</strong></td>
                                        <td>
                                            @if($isBalanced)
                                                <span class="badge bg-success">Balanced</span>
                                            @else
                                                <span class="badge bg-warning">Unbalanced</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Warning if quantities don't balance -->
                    @php
                        $hasUnbalanced = false;
                        foreach($overview as $sizeId => $data) {
                            $totalAllocated = $data['total_new_drop_qty'] + $data['existing_drops_qty'];
                            if ($totalAllocated != $data['order_qty']) {
                                $hasUnbalanced = true;
                                break;
                            }
                        }
                    @endphp

                    @if($hasUnbalanced)
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Warning:</strong> Some sizes have quantities that don't balance with the order. 
                            Please review the quantities in Step 2 to ensure totals equal order quantities.
                        </div>
                    @endif

                    <!-- New Drop to be Created -->
                    <div class="alert alert-success mb-3">
                        <h6>New Drop to be Created:</h6>
                        <ul class="mb-0 list-unstyled">
                            <li class="mb-2">
                                <strong>{{ $newDropDates[0] ? date('d-M-y', strtotime($newDropDates[0])) : 'Date not set' }}</strong>
                                <ul class="list-unstyled mt-1">
                                    @foreach($orderQtys as $sizeId => $orderData)
                                        @php
                                            $qty = $newDropQtys[0][$sizeId]['qty'] ?? 0;
                                        @endphp
                                        @if($qty > 0)
                                            <li class="ms-3">{{ $orderData['size_name'] }}: {{ $qty }} units</li>
                                        @endif
                                    @endforeach
                                </ul>
                            </li>
                        </ul>
                    </div>

                    <!-- Existing Drops to be Updated -->
                    @if(!empty($existingDropChanges))
                        <div class="alert alert-info mb-3">
                            <h6>Existing Drops to be Updated:</h6>
                            <ul class="mb-0 list-unstyled">
                                @foreach($existingDropChanges as $change)
                                    <li class="mb-2">
                                        <strong>Drop #{{ $change['id'] }}</strong> ({{ date('d-M-y', strtotime($change['exfty'])) }}):
                                        <ul class="list-unstyled ms-3">
                                            @foreach($change['size_changes'] as $sc)
                                                <li>{{ $sc['size_name'] }}: {{ $sc['old'] }} → {{ $sc['new'] }} (@if($sc['delta']>0)+@endif{{ $sc['delta'] }})</li>
                                            @endforeach
                                        </ul>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                @endif

                <div class="d-flex justify-content-between mt-3">
                    <button type="button" class="btn btn-secondary" wire:click="previousStep">
                        <i class="fas fa-arrow-left me-1"></i> Previous
                    </button>
                    @if($createNewOrder)
                        <button type="button" class="btn btn-success" wire:click="save">
                            <i class="fas fa-save me-1"></i> Create New Order & Drops
                        </button>
                    @else
                        <button type="button" class="btn btn-success" wire:click="save">
                            <i class="fas fa-save me-1"></i> Create Drops
                        </button>
                    @endif
                </div>
            </div>
        @endif
        @endif
    </div>
</div>
