<x-slot name="title">
	Customer Shipments
</x-slot>
<div>
	<div>
		<div class="row">
			<div class="col">
                <div class="row" style="margin-top: 50px">
                    <table id="tableSort" class="table align-middle rounded text-center">
                        <thead class="text-center" style="position: sticky; top: 220px; background: white;">
                            <tr>
                                <th>Season</th>
                                <th>Factory</th>
                                <th>Customer</th>
                                <th>Order No</th>
                                <th>Style</th>
                                <th>Description</th>
                                <th>Colour</th>
                                <th>Total Qty</th>
                                <th>ExFty</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($drops as $d=>$drop)
                                <tr id="{{$drop->id}}">
                                    <td>{{ $drop->season }}</td>
                                    <td>{{ $drop->factory }}</td>
                                    <td>{{ $drop->customer }}</td>
                                    <td>{{ $drop->customer_po }}</td>
                                    <td>
                                            RTD{{ explode(',', $drop->style)[0] }}<br>
                                            @if(!empty(explode(',', $drop->style)[1]))
                                                <b>{{ explode(',', $drop->style)[1] }}</b>
                                            @endif
                                        </td>
                                    <td>{{ Str::title($drop->description) }}</td>
                                    <td>{{ Str::title($drop->colour) }}</td>
                                    <td>{{ $drop->total_qty }}</td>
                                    <td>
                                        @if(!empty($drop->revised_exfty))
                                            {{ date_format(date_create($drop->revised_exfty), "d-M") }}
                                        @else
                                            No Date
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
			</div>
		</div>
	</div>
</div>
