<div>
    <div class="modal-body">
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h3>
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
            </div>
        @endif
		<div class="row">
			<div class="col">
				<form wire:submit="save">
                    @if(Gate::check('order:update'))
                    <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Drop</h5>
                    <div class="row ms-5 me-0 p-3 bg-light">
                            <div class="col-lg">
                                @if(Gate::check('style:update') || Gate::check('order:update'))
                                    <div class="row align-items-center">
                                        <div class="col-3">
                                            <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.notes_update">Notes</h6>
                                        </div>
                                        <div class="col-9">
                                            <textarea class="form-control" rows="3" wire:model.blur="form.notes"></textarea>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Dates</h5>
                        <div class="row ms-5 me-0 p-3 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.exfty_update">ExFty</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="date" class="form-control" wire:model.blur="form.exfty">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.customer_exfty_update">Customer ExFty</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="date" class="form-control" wire:model.blur="form.customer_exfty">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.customer_into_wh_update">Customer Into W/H</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="date" class="form-control" wire:model.blur="form.customer_into_wh">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Shipment</h5>
                        <div class="row ms-5 me-0 p-3 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.shipment_update">Shipment</h6>
                                    </div>
                                    <div class="col-9">
                                        <select class="form-select" wire:model.blur="form.shipment">
                                            <option value=""></option>
                                            @foreach($this->shipments as $shipment)
                                                <option value="{{$shipment->id}}">{{$shipment->id}} {{$shipment->transporters?->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.collection_update">Collection</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="date" class="form-control" wire:model.blur="form.collection">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.complete_update">Shipped</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="checkbox" class="form-check-input" wire:model.blur="form.complete">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.flag_issue_update">Flag Issue</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="checkbox" class="form-check-input" wire:model.blur="form.flag_issue">
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if(Gate::check('style:update') || Gate::check('order:update'))
                    <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Sealer Sample</h5>
                    <div class="row ms-5 me-0 p-3 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.sealer_status_update">Status</h6>
                                    </div>
                                    <div class="col-9">
                                        <select class="form-select" wire:model.blur="form.sealer_status">
                                            <option default value=""></option>
                                            <option value="pending">TBC</option>
                                            <option value="approved">Approved</option>
                                            <option value="rejected">Rejected</option>
                                        </select>
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.sealer_sent_update">Sent</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="date" class="form-control" wire:model.blur="form.sealer_sent">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.sealer_comments_update">Comments</h6>
                                    </div>
                                    <div class="col-9">
                                        <textarea class="form-control" rows="3" wire:model.blur="form.sealer_comments"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Shipment Sample</h5>
                        <div class="row ms-5 me-0 p-3 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.shipment_status_update">Status</h6>
                                    </div>
                                    <div class="col-9">
                                        <select class="form-select" wire:model.blur="form.shipment_status">
                                            <option default value=""></option>
                                            <option value="pending">TBC</option>
                                            <option value="approved">Approved</option>
                                            <option value="rejected">Rejected</option>
                                        </select>
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.shipment_sent_update">Sent</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="date" class="form-control" wire:model.blur="form.shipment_sent">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.shipment_comments_update">Comments</h6>
                                    </div>
                                    <div class="col-9">
                                        <textarea class="form-control" rows="3" wire:model.blur="form.shipment_comments"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if(Gate::check('style:update') || Gate::check('order:update') || Gate::check('finance:update'))
                        <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Finance</h5>
                        <div class="row ms-5 me-0 p-3 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.fn_notes_update">Finance Notes</h6>
                                    </div>
                                    <div class="col-9">
                                        <textarea class="form-control" rows="3" wire:model.blur="form.fn_notes"></textarea>
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.rt_update">RT Invoice</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="text" class="form-control" wire:model.blur="form.rt">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.factory_update">Factory Invoice</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="text" class="form-control" wire:model.blur="form.factory">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.customs_update">Customs Invoice</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="text" class="form-control" wire:model.blur="form.customs">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.transporter_update">Transporter Invoice</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="text" class="form-control" wire:model.blur="form.transporter">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model="form.finance_complete_update">Finance Complete</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="checkbox" class="form-check-input" wire:model.blur="form.finance_complete">
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </form>
			</div>
		</div>
    </div>
    <div class="modal-footer">
        <button class="btn btn-primary"  wire:click="save">Save</button>
    </div>
</div>
