<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Sales Outlook Report
        </x-slot:title>
        <x-slot:end>
            <div class="btn-group" role="group" x-data="{ exporting: false }">
                <button class="btn btn-light" 
                        wire:click="exportToCSV" 
                        :disabled="!@js($fromDate && $toDate)"
                        title="Download CSV file">
                    <i class="fas fa-download me-1"></i>Export CSV
                </button>
                <button class="btn btn-light" 
                        x-on:click="
                            exporting = true;
                            fetch('{{ route('salesoutlook.export-sheets') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                    'Accept': 'application/json',
                                },
                                body: JSON.stringify({
                                    includeAll: {{ $includeAll ? 'true' : 'false' }},
                                    showBaseCurrency: {{ $showBaseCurrency ? 'true' : 'false' }},
                                    fromDate: '{{ $fromDate }}',
                                    toDate: '{{ $toDate }}',
                                    metric: '{{ $metric }}'
                                })
                            })
                            .then(response => {
                                if (response.status === 401) {
                                    return response.json().then(data => {
                                        if (data.needs_auth) {
                                            exporting = false;
                                            if (confirm('You need to connect your Google account first. Would you like to connect now?')) {
                                                window.location.href = '{{ route('google.connect') }}';
                                            }
                                            throw new Error('Authentication required');
                                        }
                                    });
                                }
                                return response.json();
                            })
                            .then(data => {
                                exporting = false;
                                if (data && data.success) {
                                    window.open(data.url, '_blank');
                                } else if (data && data.error) {
                                    alert('Error: ' + data.error);
                                }
                            })
                            .catch(error => {
                                exporting = false;
                                if (error.message !== 'Authentication required') {
                                    alert('Error creating Google Sheet: ' + error.message);
                                    console.error(error);
                                }
                            });
                        "
                        :disabled="exporting || !@js($fromDate && $toDate)"
                        title="Create new Google Sheet with your data">
                    <i class="fas fa-table me-1"></i>
                    <span x-show="!exporting">Open in Sheets</span>
                    <span x-show="exporting" x-cloak>
                        <i class="fas fa-spinner fa-spin"></i> Creating...
                    </span>
                </button>
            </div>
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">
                        {{$hideFilters ? 'Show' :'Hide'}} Filters
                    </button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="metric">
                                @foreach($metrics as $key => $label)
                                    <option value="{{ $key }}">{{ $label }}</option>
                                @endforeach
                            </select>
                            <label>Metric</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-check form-switch d-flex align-items-center" style="height: calc(3.5rem + 2px);">
                            <input class="form-check-input" type="checkbox" id="includeAll" 
                                   wire:model.live="includeAll" style="margin-right: 10px;">
                            <label class="form-check-label" for="includeAll">
                                Include All (not just unshipped)
                            </label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-check form-switch d-flex align-items-center" style="height: calc(3.5rem + 2px);">
                            <input class="form-check-input" type="checkbox" id="showBaseCurrency" 
                                   wire:model.live="showBaseCurrency" style="margin-right: 10px;">
                            <label class="form-check-label" for="showBaseCurrency">
                                Show Base Currency (GBP)
                            </label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="date" style="height: calc(3.5rem + 2px);" 
                                   class="form-control @error('fromDate') is-invalid @enderror" 
                                   wire:model.live.lazy="fromDate">
                            <label>From Date *</label>
                            @error('fromDate') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="date" style="height: calc(3.5rem + 2px);" 
                                   class="form-control @error('toDate') is-invalid @enderror" 
                                   wire:model.live.lazy="toDate">
                            <label>To Date *</label>
                            @error('toDate') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <button class="btn w-100 btn-secondary" style="height: calc(3.5rem + 2px);" 
                                type="button" wire:click="go">
                            Go
                        </button>
                    </div>
                </div>
                <div class="row mx-1">
                    <div class="col-12">
                        <small class="text-muted">* Date range maximum: 2 years</small>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>

    <div id="page-content-container" class="container-fluid">
        @if($fromDate && $toDate && count($data) > 0)
            <div class="table-responsive mt-3">
                <table class="table table-sm table-bordered table-hover">
                    <thead class="table-dark sticky-top">
                        <tr>
                            <th class="text-start" style="min-width: 200px;">Customer</th>
                            <th class="text-center" style="min-width: 80px;">Currency</th>
                            @foreach($months as $month)
                                <th class="text-end" style="min-width: 120px;">{{ $month['label'] }}</th>
                            @endforeach
                            <th class="text-end" style="min-width: 120px;"><strong>Total</strong></th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $columnTotals = [];
                            $grandTotal = 0;
                        @endphp
                        
                        @foreach($data as $row)
                            <tr>
                                <td class="text-start">{{ $row['customer_name'] }}</td>
                                <td class="text-center">{{ $showBaseCurrency ? 'GBP' : $row['currency'] }}</td>
                                @foreach($months as $month)
                                    @php
                                        // Display value (customer or base depending on toggle)
                                        $displayValue = $showBaseCurrency 
                                            ? ($row['months_base'][$month['key']] ?? 0)
                                            : ($row['months'][$month['key']] ?? 0);
                                        
                                        // Always use base for totals
                                        $baseValue = $row['months_base'][$month['key']] ?? 0;
                                        if (!isset($columnTotals[$month['key']])) {
                                            $columnTotals[$month['key']] = 0;
                                        }
                                        $columnTotals[$month['key']] += $baseValue;
                                    @endphp
                                    <td class="text-end">
                                        @if($displayValue > 0)
                                            @if($metric === 'sales_value')
                                                {{ number_format($displayValue, 2) }}
                                            @else
                                                {{ number_format($displayValue, 0) }}
                                            @endif
                                        @else
                                            -
                                        @endif
                                    </td>
                                @endforeach
                                @php
                                    // Display total (customer or base depending on toggle)
                                    $displayTotal = $showBaseCurrency ? $row['total_base'] : $row['total'];
                                    // Always use base for grand total
                                    $grandTotal += $row['total_base'];
                                @endphp
                                <td class="text-end">
                                    <strong>
                                        @if($metric === 'sales_value')
                                            {{ number_format($displayTotal, 2) }}
                                        @else
                                            {{ number_format($displayTotal, 0) }}
                                        @endif
                                    </strong>
                                </td>
                            </tr>
                        @endforeach
                        
                        <!-- Grand Total Row -->
                        <tr class="bg-primary">
                            <td class="text-end text-white"><strong>GRAND TOTAL</strong></td>
                            <td class="text-center text-white"><strong>GBP</strong></td>
                            @foreach($months as $month)
                                <td class="text-end text-white">
                                    <strong>
                                        @if($metric === 'sales_value')
                                            {{ number_format($columnTotals[$month['key']] ?? 0, 2) }}
                                        @else
                                            {{ number_format($columnTotals[$month['key']] ?? 0, 0) }}
                                        @endif
                                    </strong>
                                </td>
                            @endforeach
                            <td class="text-end text-white">
                                <strong>
                                    @if($metric === 'sales_value')
                                        {{ number_format($grandTotal, 2) }}
                                    @else
                                        {{ number_format($grandTotal, 0) }}
                                    @endif
                                </strong>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        @elseif($fromDate && $toDate)
            <div class="alert alert-info mt-3">
                No data found for the selected date range and filters.
            </div>
        @else
            <div class="alert alert-warning mt-3">
                Please select a date range and click "Go" to view the report.
            </div>
        @endif
    </div>
</div>


