<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Wholesale Critical Path
        </x-slot:title>
        <x-slot:end>
            <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'edit-cp'})" wire:click="edit" >Edit Selected</button>
            <button class="btn btn-light" wire:click="selectAll" >Select All</button>
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="view">
                                <option value="unshipped">Unshipped</option>
                                <option value="financeNC">Finance Not Complete</option>
                                <option value="all">All</option>
                            </select>
                            <label>View</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="season">
                                @foreach($this->seasons as $s=>$season)
                                    <option value="{{$season->id}}">{{$season->description}}</option>
                                @endforeach
                            </select>
                            <label>Season</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="customer">
                                @foreach($this->customers as $s=>$customer)
                                    <option value="{{$customer->id}}">{{$customer->name}}</option>
                                @endforeach
                            </select>
                            <label>Customer</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="factory">
                                <option value="">All</option>
                                @foreach($this->factories as $s=>$factory)
                                    <option value="{{$factory->id}}">{{$factory->name}}</option>
                                @endforeach
                            </select>
                            <label>Factory</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="category">
                                <option value="">All</option>
                                <option value="mens">Mens</option>
                                <option value="ladies">Ladies</option>
                                <option value="childrens">Chidrens</option>
                                <option value="accessories">Accessories</option>
                            </select>
                            <label>Category</label>
                        </div>
                    </div>
                    <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table table-bordered border-primary align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr style="border: white;">
                            <td class="bg-blue">Drop</td>
                            @if($columns['Factory'])
                                <th class="bg-blue" style="min-width:120px">Factory</th>
                            @endif
                            @if($columns['Image'])
                                <th class="bg-blue">Image</th>
                            @endif
                            @if($columns['RT Number'])
                                <th class="bg-blue" style="min-width:120px">RT Number</th>
                            @endif
                            @if($columns['RT Description'])
                                <th class="bg-blue" style="min-width:120px">RT Description</th>
                            @endif
                            @if($columns['Order Date'])
                                <th class="bg-blue" style="min-width:120px">Order Date</th>
                            @endif
                            @if($columns['PO Number'])
                                <th class="bg-blue" style="min-width:170px">PO Number</th>
                            @endif
                            @if($columns['Customer Reference'])
                                <th class="bg-blue" style="min-width:150px">Customer Reference</th>
                            @endif
                            @if($columns['Colour'])
                                <th class="bg-blue" style="min-width:120px">Colour</th>
                            @endif
                            @if($columns['Sell Price'])
                                <th class="bg-blue" style="min-width:120px">Avg. Sell Price</th>
                            @endif
                            @if($columns['Total Qty'])
                                <th class="bg-blue" style="min-width:120px">Total Qty</th>
                            @endif

                            @if($columns['Yarn'])
                                <th class="bg-orange" style="min-width:120px">Yarn</th>
                            @endif
                            @if($columns['Yarn Colour'])
                                <th class="bg-orange" style="min-width:120px">Yarn Colour</th>
                            @endif
                            @if($columns['PRODs'])
                                <th class="bg-orange">PROD</th>
                                <th class="bg-orange">Ordered</th>
                                <th class="bg-orange">Conf ExMil</th>
                            @endif
                            @if($columns['Factory Order Yarn (FOY)'])
                                <th class="bg-orange" style="min-width:120px">Factory Order Yarn (FOY)</th>
                            @endif
                            @if($columns['Buttons'])
                                <th class="bg-orange" style="min-width:120px">Buttons</th>
                            @endif
                            @if($columns['Labels'])
                                <th class="bg-orange" style="min-width:120px">Labels</th>
                            @endif
                            @if($columns['Care'])
                                <th class="bg-orange" style="min-width:120px">Care</th>
                            @endif
                            @if($columns['Pre Production Comments'])
                                <th class="bg-orange" style="min-width:120px">Pre Production Comments</th>
                            @endif
                            @if($columns['Photoshoot Deadline'])
                                <th class="bg-orange" style="min-width:120px">Photoshoot Deadline</th>
                            @endif
                            @if($columns['Sealer Deadline'])
                                <th class="bg-orange" style="min-width:120px">Sealer Deadline</th>
                            @endif
                            @if($columns['Sealer Sample'])
                                <th class="bg-orange" style="min-width:120px">Sealer Sample</th>
                            @endif
                            @if($columns['Start Knit'])
                                <th class="bg-yellow" style="min-width:120px">Start Knit</th>
                            @endif
                            @if($columns['Shipment Sample'])
                                <th class="bg-orange" style="min-width:120px">Shipment Sample</th>
                            @endif
                            @if($columns['Exfty'])
                                <th class="bg-pale-red" style="min-width:120px">Exfty</th>
                            @endif
                            @if($columns['Revised Exfty'])
                                <th class="bg-pale-red" style="min-width:120px">Revised Exfty</th>
                            @endif
                            @if($columns['Customer Exfty'])
                                <th class="bg-pale-red" style="min-width:120px">Customer Exfty</th>
                            @endif
                            @if($columns['Comments'])
                                <th class="bg-pale-red" style="min-width:120px">Comments</th>
                            @endif
                            @if($columns['Shipment Complete'])
                                <th class="bg-pale-red" style="min-width:120px">Shipped</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($form->cp as $l=>$sline)
                            @if($sline['colourway_first'] == $sline['id'])
                                <tr class="border-0 border-white" style="height: 15px">
                                    <td colspan="2000ms%"></td>
                                </tr>
                            @endif
                            <tr @if($sline['complete']) class="shipped" @endif  style="height: 1px">
                                @if($sline['colourway_first'] == $sline['id'])
                                    <td class="bg" rowspan="{{$sline['colourway_count']}}">
                                        {{$sline['shipment_lines_id']}}
                                        <input type="checkbox" class="form-check-input" wire:model="selected.{{$sline['id']}}">
                                    </td>
                                @endif
                                @if($columns['Factory'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td class="bg-yellow" rowspan="{{$sline['colourway_count']}}">{{$sline['factory']}}</td>
                                    @endif
                                @endif
                                @if($columns['Image'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}"><img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded"src="{{url(asset('storage/' . $sline['img_thumb']))}}"></td>
                                    @endif
                                @endif
                                @if($columns['RT Number'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            {{$sline['designs_id']}}
                                        </td>
                                    @endif
                                @endif
                                @if($columns['RT Description'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            {{$sline['description']}}
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Order Date'])
                                    <td>
                                        {{$sline['order_date']}}
                                    </td>
                                @endif
                                @if($columns['PO Number'])
                                    <td x-data x-on:click="$dispatch('open-modal', {name:'edit-order'})" wire:click="$dispatch('edit-order', {order: {{$sline['customer_orders_id']}}})">
                                        {{$sline['customer_po']}}
                                    </td>
                                @endif
                                @if($columns['Customer Reference'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$sline['styles_id']}}})" >
                                            {{$sline['customer_ref']}}
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Colour'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            {{$sline['colourways_name']}}
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Sell Price'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <a class="text-decoration-none" target="_blank" href="/pricing?goTo={{$sline['styles_id']}}">
                                                {{$sline['customer_currency']}}
                                                {{number_format(collect($sline['sizes'])->avg('quote'),2)}}
                                            </a>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Total Qty'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            {{collect($sline['sizes'])->sum('qty')}}
                                        </td>
                                    @endif
                                @endif

                                @if($columns['Yarn'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}" style="white-space: nowrap;">
                                            @foreach ($sline['yarns'] ?? [] as $yarn)
                                                <b>{{$yarn->yarn}}</b> -
                                                {{$yarn->count}}@if(!$loop->last)<br>@endif
                                                @endforeach
                                        </td>
                                    @endif
                                @endif

                                @if($columns['Yarn Colour'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}" style="white-space: nowrap;">
                                            @foreach ($sline['yarns'] ?? [] as $yarn)
                                                {{$yarn->colour}} @if(!$loop->last)<br>@endif
                                            @endforeach
                                        </td>
                                    @endif
                                @endif
                                @if($columns['PRODs'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}" style="white-space: nowrap;">
                                            @foreach ($sline['yarns'] ?? [] as $yarn)
                                                @if(!empty($yarn->prods))
                                                    @foreach($yarn->prods?->unique('prod') ?? [] as $prod)
                                                        <span x-data x-on:click="$dispatch('open-modal', {name:'prods'})" wire:click="$dispatch('edit-prod', {order: {{$prod->prod}}})">PROD{{ $prod->prod }}</span>
                                                        @if($loop->count > 1) / @endif
                                                    @endforeach
                                                @endif
                                                <br>
                                            @endforeach
                                        </td>
                                        <td rowspan="{{$sline['colourway_count']}}" style="white-space: nowrap;">
                                            @foreach ($sline['yarns'] ?? [] as $yarn)
                                                @if(!empty($yarn->prods))
                                                    @foreach($yarn->prods?->unique('prod') ?? [] as $prod)
                                                        {{date_format(date_create($prod->ordered), 'd-M')}}
                                                        @if($loop->count > 1) / @endif
                                                    @endforeach
                                                @endif
                                                <br>
                                            @endforeach
                                        </td>
                                        <td rowspan="{{$sline['colourway_count']}}" style="white-space: nowrap;">
                                            @foreach ($sline['yarns'] ?? [] as $yarn)
                                                @if(!empty($yarn->prods))
                                                    @foreach($yarn->prods?->unique('prod') ?? [] as $prod)
                                                        {{date_format(date_create($prod->actual_ship_date), 'd-M')}}
                                                        @if($loop->count > 1) / @endif
                                                    @endforeach
                                                @endif
                                                <br>
                                            @endforeach
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Factory Order Yarn (FOY)'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}" class="
                                            @if($sline['has_prods'] ?? 0 || $sline['foy_delivered'])
                                                bg-good
                                            @elseif(($sline['factory_order_yarn'] && ! $sline['foy_ordered']))
                                                bg-red
                                            @elseif($sline['foy_ordered'] && \Carbon\Carbon::parse($sline['foy_due'])->isPast())
                                                bg-red
                                            @endif
                                        ">
                                            @if($sline['has_prods'] ?? 0)
                                                NA
                                            @else
                                                <input type="checkbox" class="form-check-input mb-3" wire:model.live="form.cp.{{$l}}.factory_order_yarn"><br>
                                                @if($sline['factory_order_yarn'])
                                                    <label for="">Ordered: </label> <input type="checkbox" class="form-check-input mb-3" wire:model.live="form.cp.{{$l}}.foy_ordered">
                                                    <input type="date" class="p-0 form-control form-input-hidden mb-3" wire:model.live="form.cp.{{$l}}.foy_due">
                                                    <label for="">Delivered: </label> <input type="checkbox" class="form-check-input" wire:model.live="form.cp.{{$l}}.foy_delivered">
                                                @endif
                                            @endif
                                        </td>
                                    @endif
                                @endif

                                @if($columns['Buttons'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                            <td rowspan="{{$sline['colourway_count']}}" class="
                                            @if($sline['buttons_done'] || $sline['buttons_required'])
                                                bg-good
                                            @elseif(!empty($sline['buttons_due']) && \Carbon\Carbon::parse($sline['buttons_due'])->isPast())
                                                bg-red
                                            @else
                                                bg-amber
                                            @endif
                                        ">

                                            <input type="checkbox" class="form-check-input mb-3 me-1" wire:model.live="form.cp.{{$l}}.buttons_required"><label for="">N/A</label><br>
                                            @if(!$sline['buttons_required'])
                                                <input type="date" class="p-0 form-control form-input-hidden mb-3" wire:model.live="form.cp.{{$l}}.buttons_due">
                                                <input type="checkbox" class="form-check-input me-1" wire:model.live="form.cp.{{$l}}.buttons_done"><label for="">Delivered </label>
                                            @endif


                                            {{-- <input type="checkbox" class="form-check-input" wire:model.live="form.cp.{{$l}}.buttons_done">
                                            <textarea class="form-control form-textarea-hidden" style="height: 120px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.buttons"></textarea> --}}
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Labels'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="checkbox" class="form-check-input" wire:model.live="form.cp.{{$l}}.labels_done">
                                            <textarea class="form-control form-textarea-hidden" style="height: 120px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.labels"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Care'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="checkbox" class="form-check-input" wire:model.live="form.cp.{{$l}}.care_done">
                                            <textarea class="form-control form-textarea-hidden" style="height: 120px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.care"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Pre Production Comments'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 120px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.pre_production_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Photoshoot Deadline'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.cp_photoshoot_deadline">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Sealer Deadline'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.sealer_deadline">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Sealer Sample'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}" class="p-0" style="height: inherit">
                                            <div
                                                class="text-center h-100 @if($sline['sealer_status'] == "approved" || $sline['sealer']->status == "approved" || $sline['sealer']->status == "Not Required") bg-good @elseif($sline['sealer']->status == "rejected") bg-red @else bg-amber @endif"
                                                >
                                                    <div class="col">
                                                        <b @if($sline['shipment']->id) role="button" x-on:click="$dispatch('open-modal', {name:'edit-sample'})" wire:click="$dispatch('samples-edit', { samples: {{ $sline['shipment']->id }}})" @endif>{{Illuminate\Support\Str::title($sline['sealer_status'] ?? $sline['sealer']->status)}}</b><br>
                                                        {{$sline['sealer']->note}}@if($sline['sealer']->note)<br>@endif
                                                        {{$sline['sealer']->date_sent ? date("d-M", strtotime($sline['sealer']->date_sent)) : NULL}}<br>
                                                        <textarea class="form-control form-textarea-hidden" style="height: 100px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.sealer.comments"></textarea>
                                                    </div>
                                            </div>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Start Knit'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.start_knit">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Shipment Sample'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}" class="p-0" style="height: inherit">
                                            <div
                                                class="text-center h-100 @if($sline['shipment_status'] == "approved" || $sline['shipment']->status == "approved" || $sline['shipment']->status == "Not Required") bg-good @elseif($sline['shipment']->status == "rejected") bg-red @else bg-amber @endif"
                                                >
                                                    <div class="col">
                                                        <b
                                                        @if($sline['shipment']->id) role="button" x-on:click="$dispatch('open-modal', {name:'edit-sample'})" wire:click="$dispatch('samples-edit', { samples: {{ $sline['shipment']->id }}})" @endif
                                                        >{{Illuminate\Support\Str::title($sline['shipment_status'] ?? $sline['shipment']->status)}}</b><br>
                                                        {{$sline['shipment']->note}}@if($sline['shipment']->note)<br>@endif
                                                        {{$sline['shipment']->date_sent ? date("d-M", strtotime($sline['shipment']->date_sent)) : NULL}}<br>
                                                        <textarea class="form-control form-textarea-hidden" style="height: 100px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.shipment.comments"></textarea>
                                                    </div>
                                            </div>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Exfty'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            {{date_format(date_create($sline['first_exfty']), 'd/m/Y')}}
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Revised Exfty'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.exfty">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Customer Exfty'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.factory_cust_date">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Comments'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 140px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.cp_notes"></textarea>
                                        </td>
                                    @endif
                                @endif

                                @if($columns['Shipment Complete'])
                                    <td>
                                        <input type="checkbox" class="form-check-input" wire:model.live="form.cp.{{$l}}.complete">
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <x-modal name="edit-cp" title="Bulk Edit Drops" size="modal-lg">
		<x-slot:body>
				<livewire:production.reports.critical-path-edit wire:key='editBulk'>
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-style" title="Edit Style">
		<x-slot:body>
				<livewire:development.styles.style-edit wire:key='editStyle'>
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-order" title="Edit Order" size="modal-fullscreen">
		<x-slot:body>
			<livewire:sales.orders.orders-edit wire:key="orderEdit">
		</x-slot:body>
	</x-modal>
    <x-modal name="prods" title="Edit PROD" size="modal-fullscreen">
		<x-slot:body>
				<livewire:production.yarn.yarn-orders-edit wire:key="PROD">
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-sample" title="Edit Sample" size="modal-lg">
        <x-slot:body>
                <livewire:development.samples.samples-edit wire:key="sampleEdit">
        </x-slot:body>
    </x-modal>

    <x-footer>
        <x-slot:center>

        </x-slot:center>
    </x-footer>
</div>
