<tbody>
    @foreach($drops as $d=>$drop)
        @if(!isset($this->chunk[$d]))
            {{-- dd($this->chunk, $drops) --}}
            @continue
        @endif
        <tr id="{{$drop['id']}}">

            <td style="min-width:100px" rowspan="2">
                {{$drop['id']}}<br>

                <div x-data="{ checked: @entangle('selected.' . $drop['id']) }">
                    <input type="checkbox"
                        class="form-check-input"
                        x-model="checked"
                        :checked="checked"
                        x-on:change="Livewire.dispatch('updateSelection', { shipmentLineId: {{ $drop['id'] }}, checked })"
                    >
                </div>

            </td>
            @if($columns['Factory'])
                <td style="border-bottom: 0; min-width: 150px">{{ $drop['customer_order_lines']['colourways']['style_versions']['factories']['name'] }}</td>
            @endif
            @if($columns['Image'])
                <td rowspan="2">
                    @if(!empty($drop['customer_order_lines']['colourways']['img_thumb']))
                        <img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded"
                        src="{{ $drop['customer_order_lines']['colourways']['thumb_url'] }}">
                    @endif
                </td>
            @endif
            @if($columns['RT Number'])
                <td role="button" style="border-bottom: 0; " x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$drop['customer_order_lines']['colourways']['style_versions']['styles_id']}}})" style="position: sticky; left: 0; z-index: 10;" {{-- class="@if($drop['complete']) shipped @elseif($drop-['shipment']['status'] == 'Approved') bg-good @else bg-light @endif" --}}>
                    <b>{{ $drop['customer_order_lines']['colourways']['style_versions']['styles']['designs_id'] }}
                </td>
            @endif
            @if($columns['Description'])
                <td style="border-bottom: 0; min-width: 150px">{{ Str::title($drop['customer_order_lines']['colourways']['style_versions']['styles']['designs']['description']) }}</td>
            @endif
            @if($columns['Order Date'])
                <td role="button" style="border-bottom: 0;" x-data x-on:click="$dispatch('open-modal', {name:'edit-order'})" wire:click="$dispatch('edit-order', {order: {{$drop['customer_order_lines']['customer_orders_id']}}})" >
                    {{ date("d-M", strtotime($drop['customer_order_lines']['customer_orders']['order_date'])) }}
                </td>
            @endif
            @if($columns['Order No'])
                <td role="button" style="border-bottom: 0;" x-data x-on:click="$dispatch('open-modal', {name:'edit-order'})" wire:click="$dispatch('edit-order', {order: {{$drop['customer_order_lines']['customer_orders_id']}}})" >
                    <b>{{ $drop['customer_order_lines']['customer_orders']['customer_po'] }}</b><br>
                </td>
            @endif
            @if($columns['Customer Ref'])
                <td role="button" style="border-bottom: 0; " x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$drop['customer_order_lines']['colourways']['style_versions']['styles_id']}}})" style="position: sticky; left: 0; z-index: 10;" {{-- class="@if($drop['complete']) shipped @elseif($drop-['shipment']['status'] == 'Approved') bg-good @else bg-light @endif" --}}>
                    {{ $drop['customer_order_lines']['colourways']['style_versions']['styles']['customer_ref'] ?? "" }}<br><br>
                </td>
            @endif
            @if($columns['Colour'])
                <td style="border-bottom: 0; ">{{ Str::title($drop['customer_order_lines']['colourways']['name']) }}</td>
            @endif
            @if($columns['Price'])
                <td style="border-bottom: 0; ">PRICE</td>
            @endif
            @if($columns['Total Qty'])
                <td rowspan="2">{{ $drop['total_pieces'] }}</td>
            @endif







            @if($columns['Sealer Sample'])
                <td rowspan="2">
                    <b>{{Illuminate\Support\Str::title($drop['sealer_sample']['status'])}}</b><br>
                    @if($drop['sealer_sample']['date_sent'])
                        {{date("d-M", strtotime($drop['sealer_sample']['date_sent']))}}
                    @endif
                    {{$drop['sealer_sample']['note']}}<br>
                    <p>{{$drop['sealer_sample']['comments']}}</p>

                </td>
            @endif
            @if($columns['Shipment Sample'])
                <td rowspan="2">
                    <b>{{Illuminate\Support\Str::title($drop['shipment_sample']['status'])}}</b><br>
                    @if($drop['shipment_sample']['date_sent'])
                        {{date("d-M", strtotime($drop['shipment_sample']['date_sent']))}}
                    @endif
                    {{$drop['shipment_sample']['note']}}<br>
                    <p>{{$drop['shipment_sample']['comments']}}</p>

                </td>
            @endif
            @if($columns['ExFty'])
                <td rowspan="2" style="white-space: nowrap;">
                    <b>
                        @if(!empty($drop['first_exfty'])){{ date_format(date_create($drop['first_exfty']), "d-M") }}@endif
                    </b><br>
                    @if(!empty($drop['first_exfty'])){{ date_format(date_create($drop['first_exfty']), "Y") }}@endif
                </td>
            @endif
            @if($columns['Revised ExFty'])
                <td rowspan="2" style="white-space: nowrap;">
                    <b>
                        @if(!empty($drop['exfty'])){{ date_format(date_create($drop['exfty']), "d-M") }}@endif
                    </b><br>
                    @if(!empty($drop['exfty'])){{ date_format(date_create($drop['exfty']), "Y") }}@endif
                </td>
            @endif
            @if($columns['Customer exFty'])
                <td rowspan="2" style="white-space: nowrap;">
                    <b>
                        @if(!empty($drop['customer_order_lines']['factory_cust_date'])){{ date_format(date_create($drop['customer_order_lines']['factory_cust_date']), "d-M") }}@endif
                    </b><br>
                    @if(!empty($drop['customer_order_lines']['factory_cust_date'])){{ date_format(date_create($drop['customer_order_lines']['factory_cust_date']), "Y") }}@endif
                </td>
            @endif
        </tr>
    @endforeach
</tbody>
