<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Commission Shipment Schedule
        </x-slot:title>
        <x-slot:end>
            {{-- Export Buttons --}}
            <div class="btn-group" role="group" x-data="{ exporting: false }">
                <button class="btn btn-light" 
                        wire:click="exportToCSV" 
                        title="Download CSV file">
                    <i class="fas fa-download me-1"></i>Export CSV
                </button>
                <button class="btn btn-light" 
                        x-on:click="
                            exporting = true;
                            fetch('{{ route('commissionshipmentschedule.export-sheets') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                    'Accept': 'application/json',
                                },
                                body: JSON.stringify({
                                    view: '{{ $view }}',
                                    fromDate: '{{ $fromDate }}',
                                    toDate: '{{ $toDate }}',
                                    season: @js($season),
                                    customer: @js($customer),
                                    factory: @js($factory),
                                    coo: @js($coo),
                                    search: '{{ $search }}'
                                })
                            })
                            .then(response => {
                                if (response.status === 401) {
                                    return response.json().then(data => {
                                        if (data.needs_auth) {
                                            exporting = false;
                                            if (confirm('You need to connect your Google account first. Would you like to connect now?')) {
                                                window.location.href = '{{ route('google.connect') }}';
                                            }
                                            throw new Error('Authentication required');
                                        }
                                    });
                                }
                                return response.json();
                            })
                            .then(data => {
                                exporting = false;
                                if (data && data.success) {
                                    window.open(data.url, '_blank');
                                } else if (data && data.error) {
                                    alert('Error: ' + data.error);
                                }
                            })
                            .catch(error => {
                                exporting = false;
                                if (error.message !== 'Authentication required') {
                                    alert('Error creating Google Sheet: ' + error.message);
                                    console.error(error);
                                }
                            });
                        "
                        :disabled="exporting"
                        title="Create new Google Sheet with your data">
                    <i class="fas fa-table me-1"></i>
                    <span x-show="!exporting">Open in Sheets</span>
                    <span x-show="exporting" x-cloak>
                        <i class="fas fa-spinner fa-spin"></i> Creating...
                    </span>
                </button>
            </div>
            
            <a class="btn btn-light" wire:click="selectAll">Select All</a>
            <a class="btn btn-light" wire:click="$toggle('editQtys')">Edit Qtys</a>
            <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'edit-ss'})" wire:click="edit">Edit Selected</button>
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{ $hideFilters ? 'Show' : 'Hide' }}</button>
                </div>
            </div>
            @if(!$hideFilters)
            <div class="row mt-2 mx-1">
                <div class="col-xl col-6 mb-2 px-1">
                    <div class="form-floating form-outline">
                        <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="view">
                            <option value="">All</option>
                            <option value="unshipped">Unshipped</option>
                            <option value="financeNC">Finance Not Complete</option>
                            <option value="noRTInvoice">Not Invoiced Out</option>
                        </select>
                        <label>View</label>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <div class="form-floating form-outline">
                        <input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="fromDate">
                        <label>From</label>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <div class="form-floating form-outline">
                        <input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="toDate">
                        <label>To</label>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <div x-data="{ open: $wire.entangle('showSeasonDropdown') }">
                        <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">Seasons @if(empty($season)) (All) @else() ({{count($season)}} Selected) @endif</button>

                        <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display: none;" x-show="open" x-on:click.outside="open = false">
                            <li class="px-3 py-1">
                                <button class="btn btn-primary w-100" wire:click="select('season')">All</button>
                            </li>
                            @foreach($this->seasons as $i=>$c)
                                <li class="px-3 py-1 @if($season[$c->id] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('season', {{$c->id}})">{{ $c->description }}</span><br>
                                </li>
                            @endforeach
                            @if($this->endedSeasons->count() > 0)
                                <li class="px-3 py-1 border-top">
                                    <button class="btn btn-outline-secondary w-100" wire:click="toggleEndedSeasons">
                                        @if($showEndedSeasons)
                                            <i class="fas fa-eye-slash me-2"></i>Hide ended seasons
                                        @else
                                            <i class="fas fa-eye me-2"></i>Show ended seasons ({{ $this->endedSeasons->count() }})
                                        @endif
                                    </button>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <div x-data="{ open: $wire.entangle('showCustomerDropdown') }">
                        <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">Customers @if(empty($customer)) (All) @else() ({{count($customer)}} Selected) @endif</button>

                        <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display: none;" x-show="open" x-on:click.outside="open = false">
                            <li class="px-3 py-1">
                                <button class="btn btn-primary w-100" wire:click="select('customer')">All</button>
                            </li>
                            @foreach($this->customers as $i=>$c)
                                <li class="px-3 py-1 @if($customer[$c->id] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('customer', {{$c->id}})">{{ $c->name }}</span><br>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>

                <div class="col-xl col-6 mb-2 px-1">
                    <div x-data="{ open: $wire.entangle('showFactoryDropdown') }">
                        <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">Factories @if(empty($factory)) (All) @else() ({{count($factory)}} Selected) @endif</button>

                        <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display: none;" x-show="open" x-on:click.outside="open = false">
                            <li class="px-3 py-1">
                                <button class="btn btn-primary w-100" wire:click="select('factory')">All</button>
                            </li>
                            @foreach($this->factories as $i=>$c)
                                <li class="px-3 py-1 @if($factory[$c->id] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('factory', {{$c->id}})">{{ $c->name }}</span><br>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>

                <div class="col-xl col-6 mb-2 px-1">
                    <div x-data="{ open: $wire.entangle('showCooDropdown') }">
                        <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">COO @if(empty($coo)) (All) @else() ({{count($coo)}} Selected) @endif</button>

                        <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display: none;" x-show="open" x-on:click.outside="open = false">
                            <li class="px-3 py-1">
                                <button class="btn btn-primary w-100" wire:click="select('coo')">All</button>
                            </li>
                            @foreach($this->factories->unique('countries_id') as $i=>$c)
                                <li class="px-3 py-1 @if($coo[$c->countries->id] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('coo', {{$c->countries->id}})">{{ $c->countries->country }}</span><br>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <div x-data="{ open: $wire.entangle('showDeptDropdown') }">
                        <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">Department @if(empty($department)) (All) @else() ({{count($department)}} Selected) @endif</button>

                        <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display: none;" x-show="open" x-on:click.outside="open = false">
                            <li class="px-3 py-1">
                                <button class="btn btn-primary w-100" wire:click="select('department')">All</button>
                            </li>
                            @foreach($this->departments as $i=>$c)
                                <li class="px-3 py-1 @if($department[$c->id] ?? 0) bg-good @endif">
                                    <span style="cursor: pointer;" wire:click="select('department', {{$c->id}})">{{ $c->description }}</span><br>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <div x-data="{ open: $wire.entangle('showCatDropdown') }">
                        <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">Category @if(empty($category)) (All) @else() ({{count($category)}} Selected) @endif</button>

                        <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display: none;" x-show="open" x-on:click.outside="open = false">
                            <li class="px-3 py-1">
                                <button class="btn btn-primary w-100" wire:click="select('category')">All</button>
                            </li>
                            <li class="px-3 py-1 @if($category['mens'] ?? 0) bg-good @endif">
                                <span style="cursor: pointer;" wire:click="select('category', 'mens')">Mens</span><br>
                            </li>
                            <li class="px-3 py-1 @if($category['ladies'] ?? 0) bg-good @endif">
                                <span style="cursor: pointer;" wire:click="select('category', 'ladies')">Ladies</span><br>
                            </li>
                            <li class="px-3 py-1 @if($category['childrens'] ?? 0) bg-good @endif">
                                <span style="cursor: pointer;" wire:click="select('category', 'childrens')">Chidrens</span><br>
                            </li>
                            <li class="px-3 py-1 @if($category['accessories'] ?? 0) bg-good @endif">
                                <span style="cursor: pointer;" wire:click="select('category', 'accessories')">Accessories</span><br>
                            </li>

                        </ul>
                    </div>
                </div>
            </div>
            <div class="row mx-1">
                <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                <div class="col-xl col-6 mb-2 px-1">
                    <div class="form-floating form-outline">
                        <select class="form-select" wire:model.live="paginate">
                            <option selected value="10">10</option>
                            <option selected value="50">50</option>
                            <option selected value="100">100</option>
                            <option selected value="200">200</option>
                            <option selected value="500">500</option>
                            <option selected value="1000">1000</option>
                        </select>
                        <label class="form-label">Per Page:</label>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <div class="form-floating form-outline">
                        <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                        <label>Search</label>
                        <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                    </div>
                </div>
                <div class="col-xl col-6 mb-2 px-1">
                    <button class="btn w-100 btn-outline bg-white border-primary" style="height: calc(3.5rem + 2px);" type="button" wire:click="clearFilters">
                        Clear
                    </button>
                </div>
            </div>
        @endif
        </x-slot:sub>
    </x-title-bar>

    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table table-bordered rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr class="border-white">
                            <th class="bg-light">Drop</th>
                            @if($columns['Season'])                <th class="bg-blue">Season</th>                     @endif
                            @if($columns['Factory'])               <th class="bg-blue">Factory</th>                    @endif
                            @if($columns['Customer'])              <th class="bg-blue">Customer</th>                   @endif
                            @if($columns['Order Issued'])          <th class="bg-blue">Order Issued</th>               @endif
                            @if($columns['Order No'])              <th class="bg-blue">Order No</th>                   @endif
                            @if($columns['Style'])                 <th class="bg-blue">Style</th>                      @endif
                            @if($columns['Description'])           <th class="bg-blue">Description</th>                @endif
                            @if($columns['Colour'])                <th class="bg-blue">Colour</th>                     @endif
                            @if($columns['Image'])                 <th class="bg-blue">Image</th>                      @endif
                            @if($columns['Sizes'])                 <th class="bg-yellow">Sizes</th>                    @endif
                            @if($columns['Total Qty'])             <th class="bg-yellow">Total Qty</th>                @endif
                            @if($columns['Total Shipped'])         <th class="bg-yellow">Total Shipped</th>            @endif
                            @if($columns['Commission'])            <th class="bg-yellow">Commission</th>               @endif
                            @if($columns['Value With Discount'])   <th class="bg-yellow">Value With Discount</th>      @endif
                            @if($columns['Value Without Discount'])<th class="bg-yellow">Value Without Discount</th>   @endif
                            @if($columns['ExFty'])                 <th class="bg-pale-red">ExFty</th>                  @endif
                            @if($columns['Revised ExFty'])         <th class="bg-pale-red">Revised ExFty</th>          @endif
                            @if($columns['Shipped'])               <th class="bg-pale-red">Shipped</th>                @endif
                            @if($columns['Notes For Finance'])     <th class="bg-finance">Notes For Finance</th>       @endif
                            @if($columns['Finance'])               <th class="bg-finance">Finance</th>                 @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($drops as $d => $drop)
                            <tr class="border-white border-0">
                                <td colspan="100%"></td>
                            </tr>
                            <tr class="@if($drop->complete) shipped @endif" wire:key="{{ $drop->shipment_lines_id }}">
                                <td style="white-space: nowrap;" class="bg-light">
                                    {{ $drop->shipment_lines_id }}<br>
                                    <input type="checkbox" class="form-check-input" wire:model.live="selected.{{$drop->shipment_lines_id}}">
                                    <br>
                                    @can('order:create')
                                        <button class="btn btn-sm btn-outline-primary mt-1" 
                                                x-data 
                                                x-on:click="$dispatch('open-modal', {name:'split-drop'}); Livewire.dispatch('open-split-drop-modal', {dropId: {{ $drop->shipment_lines_id }}})"
                                                title="Split this drop into multiple drops">
                                            <i class="fas fa-cut"></i> Split
                                        </button>
                                    @endcan
                                </td>
                                @if($columns['Season'])
                                    <td style="white-space: nowrap;">{{ $drop->season }}</td>
                                @endif
                                @if($columns['Factory'])
                                    <td style="white-space: nowrap;">{{ $drop->factory }}</td>
                                @endif
                                @if($columns['Customer'])
                                    <td style="white-space: nowrap;">{{ $drop->customer }}</td>
                                @endif
                                @if($columns['Order Issued'])
                                    <td style="white-space: nowrap;">{{ date("M-d", strtotime($drop->order_issued)) }}</td>
                                @endif
                                @if($columns['Order No'])
                                    <td role="button" style x-data x-on:click="$dispatch('open-modal', {name:'edit-order'})" wire:click="$dispatch('edit-order', {order: {{ $drop->customer_orders_id }}})" >{{ $drop->customer_po }}</td>
                                @endif
                                @if($columns['Style'])
                                    <td class="border-0" role="button" style x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{ $drop->styles_id }}})" style="position: sticky; left: 0; z-index: 10;" class="@if($drop->complete) shipped @else bg-light @endif">
                                        RTD{{ $drop->designs_id }}<br>
                                        {{ $drop->customer_ref ?? "" }}
                                    </td>
                                @endif
                                @if($columns['Description'])
                                    <td style="min-width: 150px">{{ Str::title($drop->description) }}</td>
                                @endif

                                @if($columns['Colour'])
                                    <td>{{ Str::title($drop->colour) }}</td>
                                @endif
                                @if($columns['Image'])
                                    <td>
                                        @if(!empty($drop->img_thumb))
                                            <img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded"
                                            src="{{ url(asset('storage/' . $drop->img_thumb)) }}">
                                        @endif
                                    </td>
                                @endif
                                @if($columns['Sizes'])
                                    <td>
                                        @if(!empty($drop->sizes))
                                            <table class="table table-borderless text-center" style="width: unset; margin: auto;">
                                                <tr>
                                                    <td></td>
                                                    @foreach($drop->sizes as $size)
                                                        <td class="text-center"><b>{{ $size->size }}</b></td>
                                                    @endforeach
                                                    <td>Total</td>
                                                </tr>
                                                <tr x-data="handleOrderedData('{{ $drop->id }}', @js($drop->sizes->pluck('qty', 'sls_id')))" style="background: inherit !important">
                                                    <td class="text-end">Ordered</td>
                                                    @foreach($drop->sizes as $s => $size)
                                                        <td>
                                                            @if((Gate::check('order:update') || Gate::check('finance:update')) && $editQtys)
                                                            <input type="text"
                                                                class="form-control form-input-no-bg text-center"
                                                                style="width: 50px; padding: 0;"
                                                                id="qty_{{ $drop->id }}_{{ $size->sizes_id }}"
                                                                x-model="fieldValues[{{ $size->sls_id }}]"
                                                                x-on:change.debounce.500ms="$wire.updateQty({{ $size->sls_id }}, fieldValues[{{ $size->sls_id }}])"
                                                                x-on:input="updateValue({{ $size->sls_id }}, $event.target.value)"
                                                                data-sls-id="{{ $size->sls_id }}"
                                                                x-on:paste.prevent="handlePaste($event, '{{ $drop->id }}')"
                                                            >
                                                            @else
                                                                <span>{{ $size->qty }}</span><br>
                                                            @endif
                                                        </td>
                                                    @endforeach
                                                    <td><b x-text="calculateTotalShipped()"></b></td>
                                                </tr>
                                                <tr x-data="handleShipmentData('{{ $drop->id }}', @js($drop->sizes->pluck('shipped_qty', 'sls_id')))" style="background: inherit !important">
                                                    <td class="text-end">Shipped</td>
                                                    @foreach($drop->sizes as $s => $size)
                                                        <td>
                                                            @if((Gate::check('order:update') || Gate::check('finance:update')) && $editQtys)
                                                            <input type="text"
                                                                class="form-control form-input-no-bg text-center"
                                                                style="width: 50px; padding: 0;"
                                                                id="shipped_{{ $drop->id }}_{{ $size->sizes_id }}"
                                                                x-model="fieldValues[{{ $size->sls_id }}]"
                                                                x-on:change.debounce.500ms="$wire.updateShippedQty({{ $size->sls_id }}, fieldValues[{{ $size->sls_id }}])"
                                                                x-on:input="updateValue({{ $size->sls_id }}, $event.target.value)"
                                                                data-sls-id="{{ $size->sls_id }}"
                                                                x-on:paste.prevent="handlePaste($event, '{{ $drop->id }}')"
                                                            >
                                                            @else
                                                                <span>{{ $size->shipped_qty }}</span><br>
                                                            @endif
                                                        </td>
                                                    @endforeach
                                                    <td><b x-text="calculateTotalShipped()"></b></td>
                                                </tr>
                                                <tr>
                                                    <td class="text-end">Price ({{ $drop->cust_currency }})</td>
                                                    @foreach($drop->sizes as $size)
                                                        <td>
                                                            @if(Gate::check('order:update') && $editQtys)
                                                                <input type="text"
                                                                    class="form-control text-center form-input-no-bg"
                                                                    style="width: 50px; padding: 0; min-width:50px"
                                                                    x-data="{ fieldValue: @js($size->price) }"
                                                                    x-model="fieldValue"
                                                                    x-on:change.debounce.500ms="$wire.updatePrice({{ $size->colq_id }}, fieldValue)"
                                                                >
                                                            @else
                                                                {{ $size->price }}
                                                            @endif
                                                        </td>
                                                    @endforeach
                                                </tr>
                                                <tr>
                                                    <td class="text-end">Discount (%)</td>
                                                    @foreach($drop->sizes as $size)
                                                        <td>
                                                            @if(Gate::check('order:update') && $editQtys)
                                                                <input type="text"
                                                                    class="form-control text-center form-input-no-bg"
                                                                    style="width: 50px; padding: 0; min-width:50px"
                                                                    x-data="{ fieldValue: @js($size->discount) }"
                                                                    x-model="fieldValue"
                                                                    x-on:change.debounce.500ms="$wire.updateDiscount({{ $size->colq_id }}, fieldValue)"
                                                                >
                                                            @else
                                                                {{ $size->discount }}
                                                            @endif
                                                        </td>
                                                    @endforeach
                                                </tr>
                                                <tr>
                                                    <td class="text-end" style="min-width: 130px">Commission (%)</td>
                                                    @foreach($drop->sizes as $size)
                                                        <td>
                                                            @if(Gate::check('order:update') && $editQtys)
                                                                <input type="text"
                                                                    class="form-control text-center form-input-no-bg"
                                                                    style="width: 50px; padding: 0; min-width:50px"
                                                                    x-data="{ fieldValue: @js($size->commission) }"
                                                                    x-model="fieldValue"
                                                                    x-on:change.debounce.500ms="$wire.updateCommission({{ $size->colq_id }}, fieldValue)"
                                                                >
                                                            @else
                                                                {{ $size->commission }}
                                                            @endif
                                                        </td>
                                                    @endforeach
                                                </tr>
                                            </table>
                                        @endif
                                    </td>
                                @endif
                                @if($columns['Total Qty'])
                                    <td>{{ $drop->total_qty }}</td>
                                @endif

                                @if($columns['Total Shipped'])
                                    <td>
                                        {{ $drop->total_shipped }}
                                    </td>
                                @endif

                                @if($columns['Commission'])
                                    <td>{{ $drop->cust_currency }}{{ number_format($drop->commission, 2) }}</td>
                                @endif
                                @if($columns['Value Without Discount'])
                                    <td>{{ $drop->cust_currency }}{{ number_format($drop->valueDiscount, 2) }}</td>
                                @endif
                                @if($columns['Value With Discount'])
                                    <td>{{ $drop->cust_currency }}{{ number_format($drop->value, 2) }}</td>
                                @endif

                                @if($columns['ExFty'])
                                    <td style="min-width: 100px;">
                                        @if(!empty($drop->first_exfty))
                                            <span>{{ date_format(date_create($drop->first_exfty), "d/m/Y") }}</span>
                                        @endif
                                    </td>
                                @endif
                                @if($columns['Revised ExFty'])
                                    <td class="bg-blue" style="min-width: 100px;">
                                        @if(!empty($drop->revised_exfty))
                                            @can('order:update')
                                                <input type="date"
                                                    class="form-control form-input-no-bg"
                                                    style="width: 110px; padding: 0;"
                                                    x-data="{ fieldValue: @js($drop->revised_exfty) }"
                                                    x-model="fieldValue"
                                                    x-on:change.debounce.500ms="$wire.updateRevisedExfty({{ $drop->shipment_lines_id }}, fieldValue)"
                                                >
                                            @else
                                                {{ date_format(date_create($drop->revised_exfty), "d/m/Y") }}
                                            @endcan
                                        @else
                                            No Date
                                        @endif
                                    </td>
                                @endif

                                @if($columns['Shipped'])
                                    <td>
                                        @can('order:update')
                                            <input type="checkbox"
                                                class="form-check-input"
                                                x-data="{ fieldValue: @js($drop->shipped) }"
                                                x-model="fieldValue"
                                                x-on:change="$wire.updateShipped({{ $drop->shipment_lines_id }}, fieldValue)"
                                            >
                                        @else
                                            <input type="checkbox" class="form-check-input" disabled {{ $drop->shipped ? 'checked' : '' }}>
                                        @endcan
                                    </td>
                                @endif
                                @if($columns['Notes For Finance'])
                                    <td style="padding: 0.5rem;">
                                        @if(Gate::check('style:update') || Gate::check('order:update') || Gate::check('finance:update'))
                                            <textarea
                                                class="form-control form-input-no-bg"
                                                style="min-width: 110px; width: 100%; height: 100%; min-height: 120px; resize: none;"
                                                x-data="{ fieldValue: @js($drop->fn_notes) }"
                                                x-model="fieldValue"
                                                x-on:change.debounce.500ms="$wire.updateFnNotes({{ $drop->shipment_lines_id }}, fieldValue)"
                                            ></textarea>
                                        @else
                                            {{ $drop->fn_notes }}
                                        @endif
                                    </td>
                                @endif
                                @if($columns['Finance'])
                                    <td class="align-middle" style="min-width: 220px;">
                                        <div class="d-flex flex-column gap-1 align-items-start">
                                            <div class="w-100 d-flex align-items-center gap-2">
                                                <label class="small text-muted mb-0" style="width: 95px; text-align: right;">RT Inv</label>
                                                @can('finance:update')
                                                    <input type="text" class="form-control form-control-sm bg-white border" style="max-width: 120px" x-data="{ fieldValue: @js($drop->rt_invoice) }" x-model="fieldValue" x-on:change.debounce.500ms="$wire.updateRtInvoice({{ $drop->shipment_lines_id }}, fieldValue)">
                                                @else
                                                    <span class="small">{{ $drop->rt_invoice }}</span>
                                                @endcan
                                            </div>
                                            <div class="w-100 d-flex align-items-center gap-2">
                                                <label class="small text-muted mb-0" style="width: 95px; text-align: right;">Qty Inv</label>
                                                @can('finance:update')
                                                    <input type="text" class="form-control form-control-sm bg-white border" style="max-width: 120px" x-data="{ fieldValue: @js($drop->no_invoiced) }" x-model="fieldValue" x-on:change.debounce.500ms="$wire.updateNoInvoiced({{ $drop->shipment_lines_id }}, fieldValue)">
                                                @else
                                                    <span class="small">{{ $drop->no_invoiced }}</span>
                                                @endcan
                                            </div>
                                            <div class="w-100 d-flex align-items-center gap-2">
                                                <label class="small text-muted mb-0" style="width: 95px; text-align: right;">Factory Inv</label>
                                                @can('finance:update')
                                                    <input type="text" class="form-control form-control-sm bg-white border" style="max-width: 120px" x-data="{ fieldValue: @js($drop->factory_invoice) }" x-model="fieldValue" x-on:change.debounce.500ms="$wire.updateFactoryInvoice({{ $drop->shipment_lines_id }}, fieldValue)">
                                                @else
                                                    <span class="small">{{ $drop->factory_invoice }}</span>
                                                @endcan
                                            </div>
                                            <div class="w-100 d-flex align-items-center gap-2">
                                                <label class="small text-muted mb-0" style="width: 95px; text-align: right;">Complete</label>
                                                <div class="finance-input-slot" style="width: 120px; display: flex; align-items: center; height: calc(1.5em + .5rem + 2px);">
                                                    @can('finance:update')
                                                        <input type="checkbox" class="form-check-input" style="margin: 0;" x-data="{ fieldValue: @js($drop->finance_complete) }" x-model="fieldValue" x-on:change="$wire.updateFinanceComplete({{ $drop->shipment_lines_id }}, fieldValue)">
                                                    @else
                                                        <input type="checkbox" class="form-check-input" style="margin: 0;" disabled {{ $drop->finance_complete ? 'checked' : '' }}>
                                                    @endcan
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                        <!-- Additional rows if needed -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modals -->
    <x-modal name="edit-style" title="Edit Style">
        <x-slot:body>
            <livewire:development.styles.style-edit wire:key='editStyle'>
        </x-slot:body>
    </x-modal>
    <x-modal name="edit-order" title="Edit Order" size="modal-fullscreen">
        <x-slot:body>
            <livewire:sales.orders.orders-edit wire:key="orderCommissionEdit">
        </x-slot:body>
    </x-modal>
	<x-modal name="edit-ss" title="Bulk Edit Drops" size="modal-lg">
		<x-slot:body>
				<livewire:production.reports.commission-shipment-schedule-edit wire:key='editBulk'>
		</x-slot:body>
	</x-modal>

	<!-- Split Drop Modal -->
	<x-modal name="split-drop" title="Split Drop" size="modal-lg">
		<x-slot:body>
			<livewire:production.reports.shipment-schedule-split-drop wire:key="splitDrop" lazy />
		</x-slot:body>
	</x-modal>

    <x-footer>
        <x-slot:center>
            {{ $drops->links() }}
        </x-slot:center>
        <x-slot:end>
            <div class="text-end fw-bold">
                Total Selected Shipped: <span>{{ $selectedTotalShipped }}</span>
            </div>
        </x-slot:end>
    </x-footer>

    <script>
        function handleShipmentData(dropId, initialValues) {
            return {
                fieldValues: initialValues,
                calculateTotalShipped() {
                    return Object.values(this.fieldValues).reduce((total, qty) => total + parseFloat(qty || 0), 0);
                },
                updateValue(slsId, value) {
                    this.fieldValues[slsId] = value;
                },
                handlePaste(event, dropId) {
                    const pastedValues = event.clipboardData.getData('text').split('\t');
                    const inputs = document.querySelectorAll(`input[id^=shipped_${dropId}]`);

                    inputs.forEach((input, index) => {
                        if (pastedValues[index] !== undefined) {
                            input.value = pastedValues[index].trim();
                            this.updateValue(input.getAttribute('data-sls-id'), input.value);
                            input.dispatchEvent(new Event('input', { bubbles: true })); // To trigger Alpine's reactivity
                            const livewireComponent = Livewire.find("{{$this->__id}}");
                            const slsId = input.getAttribute('data-sls-id');
                            livewireComponent.call('updateShippedQty', slsId, input.value.trim());
                        }
                    });
                }
            };
        }
        function handleOrderedData(dropId, initialValues) {
            return {
                fieldValues: initialValues,
                calculateTotalShipped() {
                    return Object.values(this.fieldValues).reduce((total, qty) => total + parseFloat(qty || 0), 0);
                },
                updateValue(slsId, value) {
                    this.fieldValues[slsId] = value;
                },
                handlePaste(event, dropId) {
                    const pastedValues = event.clipboardData.getData('text').split('\t');
                    const inputs = document.querySelectorAll(`input[id^=qty_${dropId}]`);

                    inputs.forEach((input, index) => {
                        if (pastedValues[index] !== undefined) {
                            input.value = pastedValues[index].trim();
                            this.updateValue(input.getAttribute('data-sls-id'), input.value);
                            input.dispatchEvent(new Event('input', { bubbles: true })); // To trigger Alpine's reactivity
                            const livewireComponent = Livewire.find("{{$this->__id}}");
                            const slsId = input.getAttribute('data-sls-id');
                            livewireComponent.call('updateQty', slsId, input.value.trim());
                        }
                    });
                }
            };
        }
    </script>
</div>



{{-- ADD BULK EDIT..... --}}
