{{-- Commission Shipment Schedule Row Component --}}
<tbody wire:loading.class="opacity-75">
    @foreach($drops as $drop)
        <tr class="@if($drop['complete'] ?? false) shipped @endif align-middle" wire:key="drop-{{ $drop['id'] }}">
            {{-- Drop# --}}
            <td style="white-space: nowrap; background-color: #eaf3ff;" class="text-center align-middle">
                <div class="d-flex flex-column align-items-center text-center">
                    <div class="fw-bold text-primary mb-3 fs-5">{{ $drop['id'] }}</div>
                    <div class="form-check mb-3 d-flex justify-content-center">
                        <input type="checkbox"
                               class="form-check-input"
                               style="transform: scale(1.2);"
                               wire:model.live="selected.{{$drop['id']}}">
                    </div>
                    @can('order:create')
                        <button class="btn btn-sm btn-outline-primary" 
                                x-data 
                                x-on:click="$dispatch('open-modal', {name:'split-drop'}); Livewire.dispatch('open-split-drop-modal', {dropId: {{ $drop['id'] }}})"
                                title="Split this drop into multiple drops">
                            <i class="fas fa-cut me-1"></i>Split
                        </button>
                    @endcan
                </div>
            </td>

            {{-- Season --}}
            @if($this->columns['Season'])
                <td style="white-space: nowrap;" class="text-center">
                    <span class="fw-bold">{{ $drop['season'] ?? '' }}</span>
                </td>
            @endif

            {{-- Factory --}}
            @if($this->columns['Factory'])
                <td style="white-space: nowrap;" class="text-center">
                    <span class="fw-semibold">{{ $drop['factory'] ?? '' }}</span>
                </td>
            @endif

            {{-- Customer --}}
            @if($this->columns['Customer'])
                <td style="white-space: nowrap;" class="text-center">
                    <span class="fw-bold text-dark">{{ $drop['customer'] ?? '' }}</span>
                </td>
            @endif

            {{-- Order Issued --}}
            @if($this->columns['Order Issued'])
                <td style="white-space: nowrap;" class="text-center">
                    @if(!empty($drop['order_issued']))
                        {{ date("M-d", strtotime($drop['order_issued'])) }}
                    @endif
                </td>
            @endif

            {{-- Order No --}}
            @if($this->columns['Order No'])
                <td class="text-center align-middle" role="button" 
                    style="background-color: #fff3cd; border-radius: 6px;"
                    x-data 
                    x-on:click="$dispatch('open-modal', {name:'edit-order'})" 
                    wire:click="$dispatch('edit-order', {order: {{ $drop['customer_orders_id'] ?? 0 }}})">
                    {{ $drop['customer_po'] ?? '' }}
                </td>
            @endif

            {{-- Style --}}
            @if($this->columns['Style'])
                <td class="text-center align-middle" role="button" 
                    x-data 
                    x-on:click="$dispatch('open-modal', {name:'edit-style'})" 
                    wire:click="$dispatch('edit-style', {style: {{ $drop['styles_id'] ?? 0 }}})">
                    <div class="d-flex flex-wrap gap-1 mb-1 justify-content-center">
                        <div class="badge bg-primary">{{ $drop['designs_id'] ?? '' }}</div>
                        @if(!empty($drop['style_version_name']))
                            <div class="badge bg-secondary">{{ $drop['style_version_name'] }}</div>
                        @endif
                    </div>
                    @if(!empty($drop['customer_ref']))
                        <div class="text-muted small">{{ $drop['customer_ref'] }}</div>
                    @endif
                </td>
            @endif

            {{-- Description --}}
            @if($this->columns['Description'])
                <td style="min-width: 150px" class="text-center align-middle">
                    <div class="text-muted">{{ Str::title($drop['description'] ?? '') }}</div>
                </td>
            @endif

            {{-- Colour --}}
            @if($this->columns['Colour'])
                <td class="text-center align-middle">
                    <span class="fw-bold">{{ Str::title($drop['colour'] ?? '') }}</span>
                </td>
            @endif

            

            {{-- Total Qty with Size Dropdown --}}
            @if($this->columns['Total Qty'])
                <td class="text-center align-middle css-qty-cell" style="background-color: #f3e5f5; position: relative;">
                    <div class="css-qty-editor" 
                         x-data="{ 
                            open: false,
                            dropdownStyle: {},
                            sizes: @js(collect($drop['shipment_line_sizes'] ?? [])->map(fn($s) => [
                                'id' => $s['sls_id'] ?? 0,
                                'name' => $s['sizes']['name'] ?? '',
                                'qty' => (int)($s['qty'] ?? 0),
                                'shipped_qty' => (int)($s['shipped_qty'] ?? 0)
                            ])->values()->toArray()),
                            openDropdown() {
                                const rect = this.$refs.trigger.getBoundingClientRect();
                                const viewportHeight = window.innerHeight;
                                const viewportWidth = window.innerWidth;
                                const dropdownHeight = 350;
                                const dropdownWidth = 380;
                                
                                let top = rect.bottom + 4;
                                let left = rect.left + (rect.width / 2) - (dropdownWidth / 2);
                                
                                if (top + dropdownHeight > viewportHeight - 20) {
                                    top = rect.top - dropdownHeight - 4;
                                }
                                if (left < 10) left = 10;
                                if (left + dropdownWidth > viewportWidth - 10) {
                                    left = viewportWidth - dropdownWidth - 10;
                                }
                                
                                this.dropdownStyle = {
                                    position: 'fixed',
                                    top: top + 'px',
                                    left: left + 'px',
                                    width: dropdownWidth + 'px',
                                    zIndex: 9999
                                };
                                this.open = true;
                            },
                            saveQty(sizeId, value) {
                                Livewire.dispatch('updateQty', { sizeId: sizeId, value: value });
                            },
                            saveShipped(sizeId, value) {
                                Livewire.dispatch('updateShippedQty', { sizeId: sizeId, value: value });
                            },
                            get totalQty() {
                                return this.sizes.reduce((sum, s) => sum + (parseInt(s.qty) || 0), 0);
                            },
                            get totalShipped() {
                                return this.sizes.reduce((sum, s) => sum + (parseInt(s.shipped_qty) || 0), 0);
                            },
                            handlePaste(event, field) {
                                event.preventDefault();
                                let clipboardData = event.clipboardData || window.clipboardData;
                                let pastedValues = clipboardData.getData('text').split('\t').map(val => val.trim()).filter(val => val !== '');
                                let inputs = this.$el.querySelectorAll(`input[data-field='${field}']`);
                                inputs.forEach((input, index) => {
                                    if (pastedValues[index] !== undefined) {
                                        let newValue = parseInt(pastedValues[index]) || 0;
                                        let sizeId = parseInt(input.dataset.sizeId);
                                        input.value = newValue;
                                        let sizeObj = this.sizes.find(s => s.id === sizeId);
                                        if (sizeObj) {
                                            sizeObj[field] = newValue;
                                            if (field === 'qty') {
                                                this.saveQty(sizeId, newValue);
                                            } else {
                                                this.saveShipped(sizeId, newValue);
                                            }
                                        }
                                    }
                                });
                            }
                         }"
                         x-on:click.away="open = false"
                         x-on:keydown.escape.window="open = false">
                        
                        {{-- Trigger --}}
                        <div x-ref="trigger" 
                             class="css-qty-trigger"
                             x-on:mouseenter="openDropdown()"
                             x-on:click="openDropdown()">
                            <span class="fw-bold fs-5">{{ $drop['total_qty'] ?? 0 }}</span>
                        </div>
                        
                        {{-- Dropdown --}}
                        <div x-show="open" 
                             x-cloak
                             x-transition:enter="transition ease-out duration-150"
                             x-transition:enter-start="opacity-0 transform scale-95"
                             x-transition:enter-end="opacity-100 transform scale-100"
                             x-transition:leave="transition ease-in duration-100"
                             x-transition:leave-start="opacity-100 transform scale-100"
                             x-transition:leave-end="opacity-0 transform scale-95"
                             :style="dropdownStyle"
                             class="css-qty-dropdown">
                            
                            <div class="css-qty-dropdown-header">
                                <span class="css-qty-dropdown-title">Size Quantities</span>
                                <button type="button" class="css-qty-close-btn" x-on:click="open = false">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                            
                            <table class="css-qty-table">
                                <thead>
                                    <tr>
                                        <th class="css-qty-th">SIZE</th>
                                        <th class="css-qty-th">ORDER QTY</th>
                                        <th class="css-qty-th">SHIPPED</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <template x-for="size in sizes" :key="size.id">
                                        <tr class="css-qty-row">
                                            <td class="css-qty-size-label" x-text="size.name"></td>
                                            <td class="css-qty-input-cell">
                                                @if(Gate::check('order:update') || Gate::check('finance:update'))
                                                    <input type="number" 
                                                           class="css-qty-input"
                                                           :data-size-id="size.id"
                                                           data-field="qty"
                                                           x-model.number="size.qty"
                                                           @change="saveQty(size.id, size.qty)"
                                                           @paste.prevent="handlePaste($event, 'qty')"
                                                           min="0">
                                                @else
                                                    <span class="css-qty-value" x-text="size.qty"></span>
                                                @endif
                                            </td>
                                            <td class="css-qty-input-cell">
                                                @if(Gate::check('order:update') || Gate::check('finance:update'))
                                                    <input type="number" 
                                                           class="css-qty-input css-qty-input-shipped"
                                                           :data-size-id="size.id"
                                                           data-field="shipped_qty"
                                                           x-model.number="size.shipped_qty"
                                                           @change="saveShipped(size.id, size.shipped_qty)"
                                                           @paste.prevent="handlePaste($event, 'shipped_qty')"
                                                           min="0"
                                                           :max="size.qty">
                                                @else
                                                    <span class="css-qty-value css-qty-shipped-value" x-text="size.shipped_qty"></span>
                                                @endif
                                            </td>
                                        </tr>
                                    </template>
                                </tbody>
                                <tfoot>
                                    <tr class="css-qty-total-row">
                                        <td class="css-qty-total-label">Total</td>
                                        <td class="css-qty-total-value" x-text="totalQty"></td>
                                        <td class="css-qty-total-value css-qty-shipped-total" x-text="totalShipped"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </td>
            @endif

            {{-- Total Shipped --}}
            @if($this->columns['Total Shipped'])
                <td class="text-center"><span class="fw-bold">{{ $drop['total_shipped'] ?? 0 }}</span></td>
            @endif

            {{-- Commission --}}
            @if($this->columns['Commission'])
                <td class="text-center"><span class="fw-bold">{{ $drop['cust_currency'] ?? 'USD' }}{{ number_format($drop['commission'] ?? 0, 2) }}</span></td>
            @endif

            {{-- Value With Discount --}}
            @if($this->columns['Value With Discount'])
                <td class="text-center"><span class="fw-bold">{{ $drop['cust_currency'] ?? 'USD' }}{{ number_format($drop['value'] ?? 0, 2) }}</span></td>
            @endif

            {{-- Value Without Discount --}}
            @if($this->columns['Value Without Discount'])
                <td class="text-center"><span class="fw-bold">{{ $drop['cust_currency'] ?? 'USD' }}{{ number_format($drop['valueDiscount'] ?? 0, 2) }}</span></td>
            @endif

            {{-- ExFty --}}
            @if($this->columns['ExFty'])
                <td style="min-width: 100px;" class="text-center align-middle">
                    @if(!empty($drop['first_exfty']) && $drop['first_exfty'] !== false && $drop['first_exfty'] !== 'false')
                        @php $firstExftyDate = date_create($drop['first_exfty']); @endphp
                        @if($firstExftyDate)
                            <div class="fw-bold fs-4 text-dark">{{ date_format($firstExftyDate, "d") }}</div>
                            <div class="fw-bold text-dark">{{ date_format($firstExftyDate, "M") }}</div>
                            <small class="text-muted">{{ date_format($firstExftyDate, "Y") }}</small>
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    @else
                        <span class="text-muted">-</span>
                    @endif
                </td>
            @endif

            {{-- Revised ExFty --}}
            @if($this->columns['Revised ExFty'])
                <td class="text-center align-middle" style="min-width: 100px; background-color: #eefaf0; border-radius: 6px;" x-data="{ showInput: false, fieldValue: @js(!empty($drop['revised_exfty']) ? date('Y-m-d', strtotime($drop['revised_exfty'])) : '') }" x-on:click.away="showInput = false">
                    <div x-show="!showInput" @can('order:update') x-on:click="showInput = true" class="cursor-pointer" @endcan>
                        @php
                            $isAfterCustomerExfty = false;
                            if (!empty($drop['revised_exfty']) && !empty($drop['factory_cust_date'])) {
                                $isAfterCustomerExfty = strtotime($drop['revised_exfty']) > strtotime($drop['factory_cust_date']);
                            }
                        @endphp
                        @if(!empty($drop['revised_exfty']))
                            @php $revisedExftyDate = date_create($drop['revised_exfty']); @endphp
                            @if($revisedExftyDate)
                                <div class="fw-bold fs-4 {{ $isAfterCustomerExfty ? 'text-danger' : 'text-success' }}">{{ date_format($revisedExftyDate, "d") }}</div>
                                <div class="fw-bold {{ $isAfterCustomerExfty ? 'text-danger' : 'text-success' }}">{{ date_format($revisedExftyDate, "M") }}</div>
                                <small class="text-muted">{{ date_format($revisedExftyDate, "Y") }}</small>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </div>
                    @can('order:update')
                        <div x-show="showInput">
                            <input type="date"
                                   class="form-control form-control-sm text-center"
                                   x-model="fieldValue"
                                   x-on:change.debounce.300ms="$wire.updateRevisedExfty({{ $drop['id'] }}, fieldValue); showInput = false"
                                   x-on:blur.debounce.400ms="showInput = false"
                                   x-on:keydown.enter="$event.target.blur()"
                                   x-on:keydown.escape="showInput = false"
                                   style="min-width: 120px;">
                        </div>
                    @endcan
                </td>
            @endif

            {{-- Shipped --}}
            @if($this->columns['Shipped'])
                <td class="text-center">
                    @can('order:update')
                        <input type="checkbox"
                            class="form-check-input"
                            x-data="{ fieldValue: @js($drop['shipped'] ?? false) }"
                            x-model="fieldValue"
                            x-on:change="$wire.updateShipmentComplete({{ $drop['id'] }}, fieldValue)"
                        >
                    @else
                        <input type="checkbox" class="form-check-input" disabled {{ ($drop['shipped'] ?? false) ? 'checked' : '' }}>
                    @endcan
                </td>
            @endif

            {{-- Notes For Finance --}}
            @if($this->columns['Notes For Finance'])
                <td class="text-center align-middle" style="width: 100px; min-width: 100px; padding: 0.5rem;">
                    @if(Gate::check('style:update') || Gate::check('order:update') || Gate::check('finance:update'))
                        <textarea
                            class="form-control form-control-sm bg-white border"
                            style="width: 100%; height: 100%; min-height: 120px; resize: none;"
                            x-data="{ fieldValue: @js($drop['fn_notes'] ?? '') }"
                            x-model="fieldValue"
                            x-on:change.debounce.500ms="$wire.updateShipmentLine({{ $drop['id'] }}, 'fn_notes', fieldValue)"
                        ></textarea>
                    @else
                        <div class="text-muted small text-truncate" style="max-width: 100px;" title="{{ $drop['fn_notes'] ?? '' }}">
                            {{ $drop['fn_notes'] ?? '' }}
                        </div>
                    @endif
                </td>
            @endif

            {{-- Finance (RT Invoice, Qty Invoiced, Factory Invoice, Finance Complete) --}}
            @if($this->columns['Finance'])
                <td class="align-middle" style="min-width: 220px;">
                    <div class="d-flex flex-column gap-1 align-items-start">
                        <div class="w-100 d-flex align-items-center gap-2">
                            <label class="small text-muted mb-0" style="width: 95px; text-align: right;">RT Inv</label>
                            @can('finance:update')
                                <input type="text" class="form-control form-control-sm bg-white border" style="max-width: 120px" x-data="{ fieldValue: @js($drop['rt_invoice'] ?? '') }" x-model="fieldValue" x-on:change.debounce.500ms="$wire.updateShipmentLine({{ $drop['id'] }}, 'rt_invoice', fieldValue)">
                            @else
                                <span class="small">{{ $drop['rt_invoice'] ?? '' }}</span>
                            @endcan
                        </div>
                        <div class="w-100 d-flex align-items-center gap-2">
                            <label class="small text-muted mb-0" style="width: 95px; text-align: right;">Qty Inv</label>
                            @can('finance:update')
                                <input type="text" class="form-control form-control-sm bg-white border" style="max-width: 120px" x-data="{ fieldValue: @js($drop['no_invoiced'] ?? 0) }" x-model="fieldValue" x-on:change.debounce.500ms="$wire.updateShipmentLine({{ $drop['id'] }}, 'no_invoiced', fieldValue)">
                            @else
                                <span class="small">{{ $drop['no_invoiced'] ?? 0 }}</span>
                            @endcan
                        </div>
                        <div class="w-100 d-flex align-items-center gap-2">
                            <label class="small text-muted mb-0" style="width: 95px; text-align: right;">Factory Inv</label>
                            @can('finance:update')
                                <input type="text" class="form-control form-control-sm bg-white border" style="max-width: 120px" x-data="{ fieldValue: @js($drop['factory_invoice'] ?? '') }" x-model="fieldValue" x-on:change.debounce.500ms="$wire.updateShipmentLine({{ $drop['id'] }}, 'factory_invoice', fieldValue)">
                            @else
                                <span class="small">{{ $drop['factory_invoice'] ?? '' }}</span>
                            @endcan
                        </div>
                        <div class="w-100 d-flex align-items-center gap-2">
                            <label class="small text-muted mb-0" style="width: 95px; text-align: right;">Complete</label>
                            <div class="finance-input-slot" style="width: 120px; display: flex; align-items: center; height: calc(1.5em + .5rem + 2px);">
                                @can('finance:update')
                                    <input type="checkbox" class="form-check-input" style="margin: 0;" x-data="{ fieldValue: @js($drop['finance_complete'] ?? false) }" x-model="fieldValue" x-on:change="$wire.updateShipmentLine({{ $drop['id'] }}, 'invoiced', fieldValue)">
                                @else
                                    <input type="checkbox" class="form-check-input" style="margin: 0;" disabled {{ ($drop['finance_complete'] ?? false) ? 'checked' : '' }}>
                                @endcan
                            </div>
                        </div>
                    </div>
                </td>
            @endif
        </tr>
    @endforeach
</tbody>

