{{-- commission-shipment-schedule-modern.blade.php --}}
<div id="page-content" x-data="{ 
    seasonSearch: '', 
    customerSearch: '', 
    factorySearch: '', 
    cooSearch: '', 
    departmentSearch: '', 
    truckSearch: '' 
}">
    {{-- Title Bar --}}
    <x-title-bar>
        <x-slot:title>
            Commission Shipment Schedule
        </x-slot:title>
        <x-slot:end>
            {{-- Save Indicators --}}
            <button id="saved" class="btn btn-success" style="display: none">Saved</button>
            <button id="saving" class="btn btn-danger" style="display: none">Saving Changes...</button>

            {{-- Export Buttons --}}
            <div class="btn-group" role="group" x-data="{ exporting: false }">
                <button class="btn btn-light" 
                        x-on:click="
                            exporting = true;
                            fetch('{{ route('commissionshipmentschedule.export-sheets') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                    'Accept': 'application/json',
                                },
                                body: JSON.stringify({
                                    view: '{{ $view }}',
                                    fromDate: '{{ $fromDate }}',
                                    toDate: '{{ $toDate }}',
                                    season: @js($season),
                                    customer: @js($customer),
                                    factory: @js($factory),
                                    coo: @js($coo),
                                    search: '{{ $search }}'
                                })
                            })
                            .then(response => {
                                if (response.status === 401) {
                                    return response.json().then(data => {
                                        if (data.needs_auth) {
                                            exporting = false;
                                            if (confirm('You need to connect your Google account first. Would you like to connect now?')) {
                                                window.location.href = '{{ route('google.connect') }}';
                                            }
                                            throw new Error('Authentication required');
                                        }
                                    });
                                }
                                return response.json();
                            })
                            .then(data => {
                                exporting = false;
                                if (data && data.success) {
                                    window.open(data.url, '_blank');
                                } else if (data && data.error) {
                                    alert('Error: ' + data.error);
                                }
                            })
                            .catch(error => {
                                exporting = false;
                                if (error.message !== 'Authentication required') {
                                    alert('Error creating Google Sheet: ' + error.message);
                                    console.error(error);
                                }
                            });
                        "
                        :disabled="exporting"
                        title="Create new Google Sheet with your data">
                    <i class="fas fa-table me-1"></i>
                    <span x-show="!exporting">Open in Sheets</span>
                    <span x-show="exporting" x-cloak>
                        <i class="fas fa-spinner fa-spin"></i> Creating...
                    </span>
                </button>
            </div>

            {{-- Other Actions --}}
            <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'totals'})" wire:click="$dispatch('calcTotals')">Totals</button>
            <a class="btn btn-light" wire:click="selectAll" @if($this->hasMorePages()) onclick="confirm('This will select every item matching the filters, even if they are not yet loaded on this page. Continue?') || event.stopImmediatePropagation()" @endif>Select All</a>
            <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'edit-ss'})" wire:click="edit">Edit Selected</button>
            <a class="btn btn-light" wire:click="$toggle('editQtys')">Edit Qtys</a>
        </x-slot:end>
        <x-slot:sub>
            {{-- Bootstrap 5 Modern Filters --}}
            <div>
                {{-- Top Line: View and Dates --}}
                <div class="row g-3 mb-3">
                    <div class="col-lg-2 col-md-4 col-6">
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-eye text-primary me-2"></i>
                                    <span>View</span>
                                </div>
                                <span class="badge bg-secondary ms-2">{{ $view ? ucfirst(str_replace(['financeNC', 'noRTInvoice'], ['Finance NC', 'No Invoice'], $view)) : 'All' }}</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end w-100">
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if(empty($view)) active @endif" wire:click="$set('view', '')">
                                        All
                                        @if(empty($view))
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if($view === 'unshipped') active @endif" wire:click="$set('view', 'unshipped')">
                                        Unshipped
                                        @if($view === 'unshipped')
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if($view === 'financeNC') active @endif" wire:click="$set('view', 'financeNC')">
                                        Finance NC
                                        @if($view === 'financeNC')
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if($view === 'noRTInvoice') active @endif" wire:click="$set('view', 'noRTInvoice')">
                                        No Invoice
                                        @if($view === 'noRTInvoice')
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </div>
                    
                    @if(empty($this->view))
                        <div class="col-lg-2 col-md-4 col-6">
                        <div class="input-group">
                            <span class="input-group-text bg-white border-end-0" style="border: 1px solid var(--bs-primary); border-right: none; border-radius: 0;">
                                <i class="fas fa-calendar-plus text-primary"></i>
                            </span>
                            <input type="date" wire:model.live.lazy="fromDate" class="form-control border-start-0 border-end-0" style="border: 1px solid var(--bs-primary); border-left: none; border-right: none; border-radius: 0;">
                            <span class="input-group-text bg-light border-start-0" style="border: 1px solid var(--bs-primary); border-left: none; border-radius: 0;">
                                <small class="text-muted fw-bold">FROM</small>
                            </span>
                        </div>
                        </div>
                    @endif
                    
                    <div class="col-lg-2 col-md-4 col-6">
                        <div class="input-group">
                            <span class="input-group-text bg-white border-end-0" style="border: 1px solid var(--bs-primary); border-right: none; border-radius: 0;">
                                <i class="fas fa-calendar-check text-primary"></i>
                            </span>
                            <input type="date" wire:model.live.lazy="toDate" class="form-control border-start-0 border-end-0" style="border: 1px solid var(--bs-primary); border-left: none; border-right: none; border-radius: 0;">
                            <span class="input-group-text bg-light border-start-0" style="border: 1px solid var(--bs-primary); border-left: none; border-radius: 0;">
                                <small class="text-muted fw-bold">TO</small>
                            </span>
                        </div>
                    </div>
                </div>
                
                {{-- Middle Line: All Other Filters --}}
                <div class="row g-3 mb-3">
                    <div class="col">
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-calendar-alt text-primary me-2"></i>
                                    <span>Seasons</span>
                                </div>
                                <span class="badge bg-secondary ms-2">@if(empty($season)) All @else {{count($season)}} @endif</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end w-100">
                                <li class="px-3 py-2 border-bottom">
                                    <input type="text" class="form-control form-control-sm" placeholder="Search seasons..." 
                                           x-model="seasonSearch">
                                </li>
                                <li><button class="dropdown-item" wire:click="select('season')">Clear All</button></li>
                                @foreach($this->seasons as $i=>$c)
                                    <li x-show="!seasonSearch || '{{ strtolower($c->description) }}'.includes(seasonSearch.toLowerCase())">
                                        <button class="dropdown-item d-flex justify-content-between align-items-center @if($season[$c->id] ?? 0) active @endif" wire:click="select('season', {{$c->id}})">
                                            {{ $c->description }}
                                            @if($season[$c->id] ?? 0)
                                                <i class="fas fa-check text-primary"></i>
                                            @endif
                                        </button>
                                    </li>
                                @endforeach
                                @if($this->endedSeasons->count() > 0)
                                    <li class="border-top">
                                        <button class="dropdown-item text-muted d-flex align-items-center justify-content-between" wire:click="toggleEndedSeasons">
                                            @if($showEndedSeasons)
                                                <span><i class="fas fa-eye-slash me-2"></i>Hide ended seasons</span>
                                            @else
                                                <span><i class="fas fa-eye me-2"></i>Show ended seasons ({{ $this->endedSeasons->count() }})</span>
                                            @endif
                                        </button>
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-users text-primary me-2"></i>
                                    <span>Customers</span>
                                </div>
                                <span class="badge bg-secondary ms-2">@if(empty($customer)) All @else {{count($customer)}} @endif</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end w-100">
                                <li class="px-3 py-2 border-bottom">
                                    <input type="text" class="form-control form-control-sm" placeholder="Search customers..." 
                                           x-model="customerSearch">
                                </li>
                                <li><button class="dropdown-item" wire:click="select('customer')">Clear All</button></li>
                                @foreach($this->customers as $i=>$c)
                                    <li x-show="!customerSearch || '{{ strtolower($c->name) }}'.includes(customerSearch.toLowerCase())">
                                        <button class="dropdown-item d-flex justify-content-between align-items-center @if($customer[$c->id] ?? 0) active @endif" wire:click="select('customer', {{$c->id}})">
                                            {{ $c->name }}
                                            @if($customer[$c->id] ?? 0)
                                                <i class="fas fa-check text-primary"></i>
                                            @endif
                                        </button>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-industry text-primary me-2"></i>
                                    <span>Factories</span>
                                </div>
                                <span class="badge bg-secondary ms-2">@if(empty($factory)) All @else {{count($factory)}} @endif</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end w-100">
                                <li class="px-3 py-2 border-bottom">
                                    <input type="text" class="form-control form-control-sm" placeholder="Search factories..." 
                                           x-model="factorySearch">
                                </li>
                                <li><button class="dropdown-item" wire:click="select('factory')">Clear All</button></li>
                                @foreach($this->factories as $i=>$c)
                                    <li x-show="!factorySearch || '{{ strtolower($c->name) }}'.includes(factorySearch.toLowerCase())">
                                        <button class="dropdown-item d-flex justify-content-between align-items-center @if($factory[$c->id] ?? 0) active @endif" wire:click="select('factory', {{$c->id}})">
                                            {{ $c->name }}
                                            @if($factory[$c->id] ?? 0)
                                                <i class="fas fa-check text-primary"></i>
                                            @endif
                                        </button>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-flag text-primary me-2"></i>
                                    <span>COO</span>
                                </div>
                                <span class="badge bg-secondary ms-2">@if(empty($coo)) All @else {{count($coo)}} @endif</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end w-100">
                                <li class="px-3 py-2 border-bottom">
                                    <input type="text" class="form-control form-control-sm" placeholder="Search countries..." 
                                           x-model="cooSearch">
                                </li>
                                <li><button class="dropdown-item" wire:click="select('coo')">Clear All</button></li>
                                @foreach($this->factories->unique('countries_id') as $i=>$c)
                                    <li x-show="!cooSearch || '{{ strtolower($c->countries->country) }}'.includes(cooSearch.toLowerCase())">
                                        <button class="dropdown-item d-flex justify-content-between align-items-center @if($coo[$c->countries->id] ?? 0) active @endif" wire:click="select('coo', {{$c->countries->id}})">
                                            {{ $c->countries->country }}
                                            @if($coo[$c->countries->id] ?? 0)
                                                <i class="fas fa-check text-primary"></i>
                                            @endif
                                        </button>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-building text-primary me-2"></i>
                                    <span>Dept</span>
                                </div>
                                <span class="badge bg-secondary ms-2">@if(empty($department)) All @else {{count($department)}} @endif</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end w-100">
                                <li class="px-3 py-2 border-bottom">
                                    <input type="text" class="form-control form-control-sm" placeholder="Search departments..." 
                                           x-model="departmentSearch">
                                </li>
                                <li><button class="dropdown-item" wire:click="select('department')">Clear All</button></li>
                                @foreach($this->departments as $i=>$c)
                                    <li x-show="!departmentSearch || '{{ strtolower($c->description) }}'.includes(departmentSearch.toLowerCase())">
                                        <button class="dropdown-item d-flex justify-content-between align-items-center @if($department[$c->id] ?? 0) active @endif" wire:click="select('department', {{$c->id}})">
                                            {{ $c->description }}
                                            @if($department[$c->id] ?? 0)
                                                <i class="fas fa-check text-primary"></i>
                                            @endif
                                        </button>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-tags text-primary me-2"></i>
                                    <span>Category</span>
                                </div>
                                <span class="badge bg-secondary ms-2">@if(empty($category)) All @else {{count($category)}} @endif</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end w-100">
                                <li><button class="dropdown-item" wire:click="select('category')">Clear All</button></li>
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if($category['mens'] ?? 0) active @endif" wire:click="select('category', 'mens')">
                                        Mens
                                        @if($category['mens'] ?? 0)
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if($category['ladies'] ?? 0) active @endif" wire:click="select('category', 'ladies')">
                                        Ladies
                                        @if($category['ladies'] ?? 0)
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if($category['childrens'] ?? 0) active @endif" wire:click="select('category', 'childrens')">
                                        Childrens
                                        @if($category['childrens'] ?? 0)
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item d-flex justify-content-between align-items-center @if($category['accessories'] ?? 0) active @endif" wire:click="select('category', 'accessories')">
                                        Accessories
                                        @if($category['accessories'] ?? 0)
                                            <i class="fas fa-check text-primary"></i>
                                        @endif
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                {{-- Bottom Line: Search, Columns, Clear --}}
                <div class="row g-3 mb-3">
                    <div class="col-lg-6 col-md-8">
                        <div class="input-group">
                            <span class="input-group-text bg-white border-end-0" style="border: 1px solid var(--bs-primary); border-right: none; border-radius: 0;">
                                <i class="fas fa-search text-primary"></i>
                            </span>
                            <input type="text" class="form-control border-start-0" placeholder="Search shipments..." wire:model.live.debounce.500ms="search" style="border: 1px solid var(--bs-primary); border-left: none; border-radius: 0; background-color: white;">
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-4">
                        <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" variant="modern" />
                    </div>
                    
                    <div class="col-lg-2 col-md-12">
                        <button class="btn btn-outline-danger w-100" wire:click="clearFilters" style="background-color: white;" onmouseover="this.style.backgroundColor='var(--bs-primary)'; this.style.color='white'; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = 'white'; });" onmouseout="this.style.backgroundColor='white'; this.style.color=''; this.querySelectorAll('i, .badge, span').forEach(el => { el.style.color = ''; });">
                            <i class="fas fa-eraser me-1"></i>
                            Clear All
                        </button>
                    </div>
                </div>
            </div>
        </x-slot:sub>
    </x-title-bar>

    {{-- Main Content --}}
    <div id="page-content-container" class="container-fluid">
        {{-- Alert Messages --}}
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert alert-dark" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        {{-- Data Table --}}
        <div class="row">
            <div class="col">
                <form method="POST" id="ss-form">
                    @csrf
                    <table class="mt-2 table shipment-table rounded">
                        <thead class="bg-white sticky-top">
                            <tr>
                                <th class="box-shaddow-border-y-2 text-center">Drop#</th>
                                @if($this->columns['Season'])				<th class="box-shaddow-border-y-2 text-center">Season</th>					                        @endif
                                @if($this->columns['Factory'])				<th class="box-shaddow-border-y-2 text-center">Factory</th>				                            @endif
                                @if($this->columns['Customer'])				<th class="box-shaddow-border-y-2 text-center">Customer</th>				                        @endif
                                @if($this->columns['Order Issued'])			<th class="box-shaddow-border-y-2 text-center">Order Issued</th>				                    @endif
                                @if($this->columns['Order No'])				<th class="box-shaddow-border-y-2 text-center">Order No</th>				                        @endif
                                @if($this->columns['Style'])				<th class="box-shaddow-border-y-2 text-center">Style</th>					                        @endif
                                @if($this->columns['Description'])			<th class="box-shaddow-border-y-2 text-center">Description</th>			                            @endif
                                @if($this->columns['Colour'])				<th class="box-shaddow-border-y-2 text-center">Colour</th>					                        @endif
                                
                                @if($this->columns['Total Qty'])			<th class="box-shaddow-border-y-2 text-center">Qty</th>				                        @endif
                                @if($this->columns['Total Shipped'])		<th class="box-shaddow-border-y-2 text-center" style="min-width: 80px;">Total Shipped</th>			@endif
                                @if($this->columns['Commission'])			<th class="box-shaddow-border-y-2 text-center">Commission</th>				                        @endif
                                @if($this->columns['Value With Discount'])	<th class="box-shaddow-border-y-2 text-center">Value With Discount</th>		                    @endif
                                @if($this->columns['Value Without Discount'])<th class="box-shaddow-border-y-2 text-center">Value Without Discount</th>	                    @endif
                                @if($this->columns['ExFty'])				<th class="box-shaddow-border-y-2 text-center">First ExFty</th>					                    @endif
                                @if($this->columns['Revised ExFty'])		<th class="box-shaddow-border-y-2 text-center">Revised ExFty</th>			                        @endif
                                @if($this->columns['Shipped'])				<th class="box-shaddow-border-y-2 text-center">Shipped</th>				                            @endif
                                @if($this->columns['Notes For Finance'])	<th class="box-shaddow-border-y-2 text-center">Notes For Finance</th>		                        @endif
                                @if($this->columns['Finance'])				<th class="box-shaddow-border-y-2 text-center">Finance</th>		                                @endif
                            </tr>
                        </thead>
                        @if(!empty($chunks))
                            @foreach (array_slice($chunks, 0, $page) as $chunk)
                                <livewire:production.reports.commission-shipment-schedule-row
                                    :columns="$columns"
                                    :chunk="$chunk"
                                    :selected="$selected"
                                    :editQtys="$editQtys"
                                    :key="'chunk-' . md5(json_encode($chunk)) . '-' . $refreshKey"
                                />
                            @endforeach
                        @endif
                        <tr>
                            <td colspan="100%">
                                @if ($this->hasMorePages())
                                    <div x-data="{ loading: false }"
                                         class="w-100">
                                        {{-- Early prefetch sentinel to keep a 1-chunk buffer --}}
                                        <div x-intersect="
                                                if (!loading) {
                                                    loading = true;
                                                    $wire.loadMore().then(() => { loading = false; });
                                                }
                                            "
                                            class="text-center mt-3 w-100"
        									style="transform: translateY(-160vh); height: 1px;"></div>
                                        <div x-intersect="
                                                if (!loading) {
                                                    loading = true;
                                                    $wire.loadMore()
                                                        .then(() => $wire.loadMore())
                                                        .finally(() => { loading = false; });
                                                }
                                            "
                                            class="text-center mt-3 w-100"
                                            style="height: 2px;"></div>
                                        
                                        <div class="text-center mt-3 p-5" x-show="loading">
                                            <div class="text-4 mt-2 h4 fst-italic">Loading more records...</div>
                                        </div>
                                    </div>
                                @endif
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>

    <x-modal name="edit-style" title="Edit Style">
		<x-slot:body>
				<livewire:development.styles.style-edit wire:key='editStyle' />
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-order" title="Edit Order" size="modal-fullscreen">
		<x-slot:body>
            @can('order:create')
			    <livewire:sales.orders.orders-edit wire:key="orderEdit" />
            @endcan
		</x-slot:body>
	</x-modal>
	<x-modal name="edit-ss" title="Bulk Edit Drops" size="modal-lg">
		<x-slot:body>
				<livewire:production.reports.commission-shipment-schedule-edit wire:key='editBulk' />
		</x-slot:body>
	</x-modal>
	<x-modal name="view-audit-log" title="Audit Log" size="modal-lg">
		<x-slot:body>
				<livewire:view-audit-log wire:key='auditLog' />
		</x-slot:body>
	</x-modal>

    <x-modal name="totals" title="Totals" size="modal-sm">
		<x-slot:body>
            <div class="modal-body">
                <livewire:production.reports.commission-shipment-schedule-totals :chunks="$chunks" :key="$refreshKey" />
            </div>
		</x-slot:body>
	</x-modal>

    <x-modal name="invoices" title="Invoices" size="modal-lg">
        <x-slot:body>
            <livewire:zoho.zoho-invoice-manager :selectedDrops="array_keys($selected)" />
        </x-slot:body>
    </x-modal>

    <x-modal name="split-drop" title="Split Drop" size="modal-lg">
        <x-slot:body>
            <livewire:production.reports.shipment-schedule-split-drop wire:key="splitDrop" lazy />
        </x-slot:body>
    </x-modal>

    <script>
        function calculateTotalOrdered(dropId) {
            console.log('calcd');
            let total = 0;
            const inputs = document.querySelectorAll(`input[id^='qty_${dropId}_']`);
            inputs.forEach(input => {
                total += parseInt(input.value) || 0;
            });
            return total;
        }
        function calculateTotalShipped(dropId) {
            let total = 0;
            const inputs = document.querySelectorAll(`input[id^='shipped_${dropId}_']`);
            inputs.forEach(input => {
                total += parseInt(input.value) || 0;
            });
            return total;
        }
    </script>
<script>
document.addEventListener("alpine:init", () => {
    Alpine.data("shipmentHandler", (dropId, initialValue) => ({
        fieldValue: initialValue, // Set the initial value from the Blade template

                                                        handlePaste(event, dropId) {
    console.log('Paste handler called for dropId:', dropId);
    event.preventDefault(); // Prevent default paste behavior

    let clipboardData = event.clipboardData || window.clipboardData;
    let pastedValues = clipboardData.getData("text").split("\t").map(val => val.trim()).filter(val => val !== "");
    console.log('Pasted values:', pastedValues);

    // Get all inputs matching this drop ID
    let inputs = document.querySelectorAll(`input[id^="shipped_qty_${dropId}_"]`);
    console.log('Found inputs:', inputs.length);

    inputs.forEach((input, index) => {
        if (pastedValues[index] !== undefined) {
            let newValue = pastedValues[index];
            console.log(`Updating input ${index} with value:`, newValue);

            // Update input visually
            input.value = newValue;

            // Dispatch event to update Alpine's reactivity
            input.dispatchEvent(new Event("input", { bubbles: true }));

            // Extract size ID from the input ID (same as regular change handler)
            let sizeId = input.id.split("_").pop(); // Gets the last part of the ID (which should be `size_id`)
            console.log('Size ID:', sizeId, 'Value:', newValue);

            // Try to find the specific row component and call method directly
            let rowComponent = input.closest('[wire\\:id]');
            if (rowComponent) {
                let componentId = rowComponent.getAttribute('wire:id');
                console.log('Found row component ID:', componentId);
                
                // Call the method directly on the row component
                Livewire.find(componentId).call('updateShippedQty', parseInt(sizeId), newValue);
                console.log('Called updateShippedQty method on row component with sizeId:', parseInt(sizeId));
            } else {
                // Fallback to global dispatch
                Livewire.dispatch('updateShippedQty', { sizeId: parseInt(sizeId), value: newValue });
                console.log('Dispatched updateShippedQty event globally with sizeId:', parseInt(sizeId));
            }
        }
    });
}
    }));
});
    </script>

<style>
/* Remove all borders from table rows and cells */
#tableSort tbody tr {
    border-top: none !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

#tableSort tbody td {
    border-top: none !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

/* Override any inline styles that add borders */
#tableSort tbody tr[style*="border"] {
    border-top: none !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

.cursor-pointer {
    cursor: pointer;
}

.exfty-history-compact {
    text-align: left;
    padding: 2px;
}

.exfty-history-item {
    font-size: 0.8em;
    line-height: 1.1;
    padding: 1px 0;
    margin: 0;
    color: #6c757d;
    white-space: nowrap;
}

.exfty-history-item.current {
    font-weight: bold;
    color: #28a745;
}

.exfty-arrow {
    text-align: center;
    font-size: 0.7em;
    color: #6c757d;
    padding: 1px 0;
    margin: 0;
    line-height: 1;
}

/* Sticky table header layering adjustments */
.table thead.sticky-top { /* override Bootstrap's default z-index */
    z-index: 10 !important;
}
.table thead.sticky-top th {
    position: sticky;
    top: 0;
    z-index: 11; /* enough to sit above cells but below overlays */
}

/* Ensure the shipment table allows sticky to render properly */
.shipment-table {
    overflow: visible !important; /* override global .table overflow hidden */
    border-spacing: 0; /* eliminate gaps that can appear as borders */
}
.shipment-table.table>:not(caption)>*>*{
    border-bottom-width: 1px;
}
/* Ensure dropdown menus and modals render above sticky header (scoped) */
#page-content .dropdown-menu { 
    z-index: 2000 !important; 
    max-height: 300px !important;
    overflow-y: auto !important;
    overflow-x: hidden !important;
}

/* Search input styling in dropdowns */
#page-content .dropdown-menu .form-control-sm {
    font-size: 0.875rem;
    border: 1px solid #dee2e6;
    border-radius: 0.25rem;
}

#page-content .dropdown-menu .form-control-sm:focus {
    border-color: var(--bs-primary);
    box-shadow: 0 0 0 0.2rem rgba(var(--bs-primary-rgb), 0.25);
}

#page-content .modal-backdrop { z-index: 3990 !important; }
#page-content .modal { z-index: 4000 !important; }
</style>

</div>
