<div>
    <form wire:submit.prevent="save">
    <div class="modal-body">
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h4>
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
            </div>
        @endif
        
        <div class="alert alert-info">
            <small>Selected: {{ is_array($selected) ? count($selected) . ' items' : (is_string($selected) ? 'JSON string' : 'None') }}</small>
        </div>
		<div class="row">
			<div class="col">
                    @if(Gate::check('order:update'))
                        <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Dates</h5>
                        <div class="row ms-5 me-0 p-3 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model.live="form.exfty_update">ExFty</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="date" class="form-control" wire:model.live="form.exfty">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Shipment</h5>
                        <div class="row ms-5 p-3 me-0 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model.live="form.complete_update">Shipped</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="checkbox" class="form-check-input" wire:model.live="form.complete">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model.live="form.flag_issue_update">Flag Issue</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="checkbox" class="form-check-input" wire:model.live="form.flag_issue">
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if(Gate::check('style:update') || Gate::check('order:update') || Gate::check('finance:update'))
                        <h5 class="py-3 ps-2 mt-3 bg-secondary text-white">Finance</h5>
                        <div class="row ms-5 p-3 me-0 bg-light">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model.live="form.fn_notes_update">Finance Notes</h6>
                                    </div>
                                    <div class="col-9">
                                        <textarea class="form-control" rows="3" wire:model.blur="form.fn_notes"></textarea>
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model.live="form.rt_update">RT Invoice</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="text" class="form-control" wire:model.blur="form.rt">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-3">
                                        <h6 class="mb-0 fw-bold"><input type="checkbox" class="form-check-input mt-0 me-2" wire:model.live="form.finance_complete_update">Finance Complete</h6>
                                    </div>
                                    <div class="col-9">
                                        <input type="checkbox" class="form-check-input" wire:model.live="form.finance_complete">
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
			</div>
		</div>
    </div>
    <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Save</button>
    </div>
    </form>
</div>
