<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Commission Sales Values by Exfty
        </x-slot:title>
        <x-slot:end>
            @can('design:create')
                <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'new'})">New</button>
            @endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="view">
								<option value="unshipped">Unshipped</option>
                                <option value="noRTInvoice">Not Invoiced Out</option>
								<option value="all">All</option>
							</select>
							<label>View</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="fromDate">
							<label>From</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="toDate">
							<label>To</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<button class="btn w-100 btn-secondary" style="height: calc(3.5rem + 2px);" type="button" wire:click="go">
							Go
						</button>
					</div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>


    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
		<div class="row">
			<div class="col my-2">
				<div id="wdr-component"></div>
				<link href="https://cdn.webdatarocks.com/latest/webdatarocks.min.css" rel="stylesheet"/>
				<script src="https://cdn.webdatarocks.com/latest/webdatarocks.toolbar.min.js"></script>
				<script src="https://cdn.webdatarocks.com/latest/webdatarocks.js"></script>
				@script
					<script>
						console.log(getContentAreaHeight());
						var pivot = new WebDataRocks({
							container: "#wdr-component",
							height: getContentAreaHeight(),
							customizeCell: customizeCellFunction,
							toolbar: true,
							report: {!! json_encode($pivot) !!}
						});


						function customizeCellFunction(cellBuilder, cellData) {
							if (cellData.type == "value") {
								if (cellData.rowIndex % 2 == 0) {
									cellBuilder.addClass("bg-light");
								} else {
									cellBuilder.addClass("pivot-alternating-2");
								}
							}
						}

					</script>
				@endscript
			</div>
		</div>
	</div>


    <x-footer>
        <x-slot:center>

        </x-slot:center>
    </x-footer>

</div>
