<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Asos Critical Path
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="paginate">
                                <option selected value="18">18</option>
                                <option selected value="60">60</option>
                                <option selected value="150">150</option>
                                <option selected value="300">300</option>
                                <option selected value="900">900</option>
                            </select>
                            <label class="form-label">Per Page:</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="view">
                                <option value="unshipped">Unshipped</option>
                                <option value="financeNC">Finance Not Complete</option>
                                <option value="all">All</option>
                            </select>
                            <label>View</label>
                        </div>
                    </div>
                    <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
                <div class="row mx-1">
                    <div class="col-xl-3 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" class="form-control" wire:model.live.debounce.500ms="rtd">
                            <label>RTD</label>
                            <div class="invalid-feedback">@error('rtd') {{ $message }} @enderror</div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="date" class="form-control" wire:model="from_date" wire:change="$refresh">
                            <label>From Date (Exfty)</label>
                            <div class="invalid-feedback">@error('from_date') {{ $message }} @enderror</div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table table-bordered align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr style="border: white;">
                            @if($columns['Factory'])
                                <th class="bg-blue">Factory</th>
                            @endif
                                <th class="bg-blue">Season</th>
                            @if($columns['Image'])
                                <th class="bg-blue">Image</th>
                            @endif
                            @if($columns['RT Number'])
                                <th class="bg-blue" style="min-width:120px">RT Number</th>
                            @endif
                            @if($columns['RT Description'])
                                <th class="bg-blue" style="min-width:120px">RT Description</th>
                            @endif
                            @if($columns['PO Number'])
                                <th class="bg-blue" style="min-width:170px">PO Number</th>
                            @endif
                            @if($columns['Customer Reference'])
                                <th class="bg-blue" style="min-width:150px">Customer Reference</th>
                            @endif
                            @if($columns['Customer Description'])
                                <th class="bg-blue" style="min-width:150px">Customer Description</th>
                            @endif
                            @if($columns['Colour'])
                                <th class="bg-blue" style="min-width:120px">Colour</th>
                            @endif
                            @if($columns['Cost Price'])
                                <th class="bg-blue" style="min-width:120px">Cost Price</th>
                            @endif
                            @if($columns['Sell Price'])
                                <th class="bg-blue" style="min-width:120px">Sell Price</th>
                            @endif
                            @if($columns['3% Discounted Sell Price'])
                                <th class="bg-blue" style="min-width:120px">3% Discounted Sell Price</th>
                            @endif
                            @if($columns['Sizes'])
                                @foreach ($sizes as $size)
                                    <th class="bg-yellow">{{$size}}</th>
                                @endforeach
                            @endif
                            @if($columns['Required Exfty'])
                                <th class="bg-pale-red" style="min-width:120px">Required Exfty</th>
                            @endif
                            @if($columns['Warehouse'])
                                <th class="bg-pale-red" style="min-width:120px">Warehouse</th>
                            @endif
                            @if($columns['Order Received'])
                                <th class="bg-blue" style="min-width:120px">Order Received</th>
                            @endif
                            @if($columns['Sent to Factory'])
                                <th class="bg-blue" style="min-width:120px">Sent to Factory</th>
                            @endif
                            @if($columns['Margin'])
                                <th class="bg-dark-green" style="min-width:120px">Margin</th>
                            @endif
                            @if($columns['Order Value'])
                                <th class="bg-dark-green" style="min-width:120px">Order Value</th>
                            @endif
                            @if($columns['Cost Value'])
                                <th class="bg-dark-green" style="min-width:120px">Cost Value</th>
                            @endif
                            @if($columns['Gross Profit'])
                                <th class="bg-dark-green" style="min-width:120px">Gross Profit</th>
                            @endif
                            @if($columns['Yarn/Spinner'])
                                <th class="bg-orange" style="min-width:120px">Yarn/Spinner</th>
                            @endif
                            @if($columns['Composition'])
                                <th class="bg-orange" style="min-width:120px">Composition</th>
                            @endif
                            @if($columns['Colour Approval'])
                                <th class="bg-orange" style="min-width:150px">Colour Approval</th>
                            @endif
                            @if($columns['Bulk Yarn Ordered'])
                                <th class="bg-yellow" style="min-width:120px">Bulk Yarn Ordered</th>
                            @endif
                            @if($columns['Bulk Yarn In House'])
                                <th class="bg-yellow" style="min-width:120px">Bulk Yarn In House</th>
                            @endif
                            @if($columns['Start Knit'])
                                <th class="bg-yellow" style="min-width:120px">Start Knit</th>
                            @endif
                            @if($columns['Samp No.'])
                                <th class="bg-yellow" style="min-width:120px">Samp No.</th>
                            @endif
                            @if($columns['Green Seal Approval'])
                                <th class="bg-yellow" style="min-width:120px">Green Seal Approval (First Fit/PP)</th>
                            @endif
                            @if($columns['Photo Shoot Sample'])
                                <th class="bg-yellow" style="min-width:120px">Photo Shoot Sample</th>
                            @endif
                            @if($columns['Accessories'])
                                <th class="bg-blue" style="min-width:120px">Accessories</th>
                            @endif
                            @if($columns['Testing'])
                                <th class="bg-blue" style="min-width:120px">Testing</th>
                            @endif
                            @if($columns['ASN'])
                                <th class="bg-pale-red" style="min-width:120px">ASN</th>
                            @endif
                            @if($columns['ASN Transferred'])
                                <th class="bg-pale-red" style="min-width:120px">ASN Transferred</th>
                            @endif
                            @if($columns['Shipped Date'])
                                <th class="bg-pale-red" style="min-width:120px">Shipped Date</th>
                            @endif
                            @if($columns['Shipped Amount'])
                                <th class="bg-pale-red" style="min-width:120px">Shipped Amount</th>
                            @endif
                            @if($columns['Shipment Complete'])
                                <th class="bg-pale-red" style="min-width:120px">Shipment Complete</th>
                            @endif
                            @if($columns['RT Invoice No'])
                                <th class="bg-pale-red" style="min-width:120px">RT Invoice No.</th>
                            @endif
                            @if($columns['Cust Invoice No'])
                                <th class="bg-pale-red" style="min-width:120px">Cust Invoice No.</th>
                            @endif
                            @if($columns['CIs & PLs Sent'])
                                <th class="bg-pale-red" style="min-width:120px">CI'S & PL's Sent</th>
                            @endif
                            @if($columns['Factory Invoice No'])
                                <th class="bg-pale-red" style="min-width:120px">Factory Invoice No.</th>
                            @endif
                            @if($columns['Payment Ref'])
                                <th class="bg-pale-red" style="min-width:120px">Payment Ref.</th>
                            @endif
                            @if($columns['BOL Number'])
                                <th class="bg-pale-red" style="min-width:120px">BOL Number</th>
                            @endif
                            @if($columns['BOL Tracking (Factory)'])
                                <th class="bg-pale-red" style="min-width:120px">BOL Tracking (Factory)</th>
                            @endif
                            @if($columns['BOL Tracking (RT)'])
                                <th class="bg-pale-red" style="min-width:120px">BOL Tracking (RT)</th>
                            @endif
                            @if($columns['Container number'])
                                <th class="bg-pale-red" style="min-width:120px">Container number</th>
                            @endif
                            @if($columns['Container ETA'])
                                <th class="bg-pale-red" style="min-width:120px; border-top-right-radius: .5rem">Container ETA</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($form->cp as $l=>$sline)
                            @if($sline['colourway_first'] == $sline['id'])
                                <tr class="border-0 border-white" style="height: 15px">
                                    <td colspan="2000ms%"></td>
                                </tr>
                            @endif
                            <tr wire:key="{{$sline['id']}}" @if($sline['complete']) class="shipped" @endif>
                                @if($columns['Factory'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td class="bg-yellow" rowspan="{{$sline['colourway_count']}}">{{$sline['factory']}}</td>
                                    @endif
                                @endif
                                @if($columns['Factory'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">{{$sline['season']}}</td>
                                    @endif
                                @endif
                                @if($columns['Image'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            @if(!empty($sline['img_thumb']))
                                                <img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded"src="{{url(asset('storage/' . $sline['img_thumb']))}}">
                                            @endif
                                        </td>
                                    @endif
                                @endif
                                @if($columns['RT Number'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            {{$sline['designs_id']}}
                                        </td>
                                    @endif
                                @endif
                                @if($columns['RT Description'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.description"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['PO Number'])
                                    <td>
                                        <input class="form-control form-input-hidden" type="text" wire:model.live.debounce.500ms="form.cp.{{$l}}.customer_po">
                                        {{-- {{$sline['customer_ref']}} --}}
                                    </td>
                                @endif
                                @if($columns['Customer Reference'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.customer_ref"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Customer Description'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.customer_description"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Colour'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.colourways_name"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Cost Price'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <div class="input-group">
                                                <span class="py-2 pe-2">{{$sline['factory_currency']}}</span>
                                                {{-- <span class="ps-3 py-2">{{number_format(reset($sline['sizes'])['cmt_cache'],2)}}</span> --}}
                                                <input style="text-align: left; background: none" class="form-control border-0" type="text" wire:model.live.debounce.500ms="form.cp.{{$l}}.cmt">
                                                {{-- {{json_encode($form->cp[$l]['sizes'])}} --}}
                                            </div>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Sell Price'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <div class="input-group">
                                                <span class=" py-2 pe-2">{{$sline['customer_currency']}}</span>
                                                {{-- <span class="ps-3 py-2">{{number_format(reset($sline['sizes'])['quote_cache'],2)}}</span> --}}
                                                <input style="text-align: left; background: none" class="form-control border-0" type="text" wire:model.live.debounce.500ms="form.cp.{{$l}}.quote">
                                            </div>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['3% Discounted Sell Price'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <div class="input-group">
                                                <span class="ps-3 py-2">{{$sline['customer_currency']}}</span>
                                                <span class="ps-3 py-2">{{number_format($sline['quote'] * (1 - $sline['cust_discount']),2)}}</span>
                                            </div>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Sizes'])
                                    @foreach ($sizes as $s=>$size)
                                        <th class="bg-yellow align-middle">

                                            {{-- {{$sline['id']}},{{$sline['colourway_first']}},{{$sline['colourway_last']}} --}}
                                            {{-- {{$sline['colourways_name']}} --}}
                                            <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.sizes.{{$s}}.qty">
                                        </th>
                                    @endforeach
                                @endif
                                @if($columns['Required Exfty'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.exfty">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Warehouse'])
                                    <td>
                                        {{$sline['customer_address']}}
                                        {{-- <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.customer_address"> --}}
                                    </td>
                                @endif
                                @if($columns['Order Received'])
                                    <td>
                                        <textarea class="form-control form-textarea-hidden" style="height: 60px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.order_received"></textarea>
                                    </td>
                                @endif
                                @if($columns['Sent to Factory'])
                                    <td>
                                        <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.order_sent_factory">
                                    </td>
                                @endif
                                @if($columns['Margin'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                    <td rowspan="{{$sline['colourway_count']}}">

                                    </td>
                                    @endif
                                @endif
                                @if($columns['Order Value'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Cost Value'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Gross Profit'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Yarn/Spinner'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            @foreach ($sline['yarns'] ?? [] as $yarn)
                                                <b>{{$yarn['yarn']}}</b> -
                                                {{$yarn['count']}} <br>
                                            @endforeach
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Composition'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.composition"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Colour Approval'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height:250px" wire:model.live.debounce.500ms="form.cp.{{$l}}.colour_approval_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Bulk Yarn Ordered'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.bulk_yarn_order_date">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.bulk_yarn_order_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Bulk Yarn In House'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.bulk_yarn_order_delivery_date">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.bulk_yarn_order_delivery_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Start Knit'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.start_knit">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.start_knit_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Samp No.'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.customer_samp_no"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Green Seal Approval'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.green_seal_approval_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Photo Shoot Sample'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.photo_shoot_sample_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Accessories'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.accessories"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['Testing'])
                                    @if($sline['colourway_first'] == $sline['id'])
                                        <td rowspan="{{$sline['colourway_count']}}">
                                            <textarea class="form-control form-textarea-hidden" style="height: 130px;" wire:model.live.debounce.500ms="form.cp.{{$l}}.testing_comments"></textarea>
                                        </td>
                                    @endif
                                @endif
                                @if($columns['ASN'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.asn">
                                    </td>
                                @endif
                                @if($columns['ASN Transferred'])
                                    <td>
                                        <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.asn_transferred_date">
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.asn_transferred_comments">
                                    </td>
                                @endif
                                @if($columns['Shipped Date'])
                                    <td>
                                        <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.collection_date">
                                    </td>
                                @endif
                                @if($columns['Shipped Amount'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.shipped_qty">
                                    </td>
                                @endif
                                @if($columns['Shipment Complete'])
                                    <td>
                                        <input type="checkbox" class="form-check-input" @if($sline['complete'])  checked wire:click="complete(0, {{$l}})" @else wire:click="complete(1, {{$l}})" @endif>
                                    </td>
                                @endif
                                @if($columns['RT Invoice No'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.rt_invoice">
                                    </td>
                                @endif
                                @if($columns['Cust Invoice No'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.customer_invoice_no">
                                    </td>
                                @endif
                                @if($columns['CIs & PLs Sent'])
                                    <td>
                                        <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.pl_sent_date">
                                    </td>
                                @endif
                                @if($columns['Factory Invoice No'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.factory_invoice">
                                    </td>
                                @endif
                                @if($columns['Payment Ref'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.payment_reference">
                                    </td>
                                @endif
                                @if($columns['BOL Number'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.bol_reference">
                                    </td>
                                @endif
                                @if($columns['BOL Tracking (Factory)'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.bol_tracking_factory">
                                    </td>
                                @endif
                                @if($columns['BOL Tracking (RT)'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.bol_tracking_rt">
                                    </td>
                                @endif
                                @if($columns['Container number'])
                                    <td>
                                        <input type="text" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.container_no">
                                    </td>
                                @endif
                                @if($columns['Container ETA'])
                                    <td>
                                        <input type="date" style="min-width: 40px" class="p-0 form-control form-input-hidden" wire:model.live.debounce.500ms="form.cp.{{$l}}.container_eta">
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <x-footer>
        <x-slot:center>
            {{ $sl->links() }}
        </x-slot:center>
    </x-footer>
</div>
