<div class="container-fluid">
    <div class="card mb-3">
        <div class="card-body">
            <div class="row g-3 align-items-end">
                <div class="col-md-3">
                    <label class="form-label">Season</label>
                    <select class="form-select" wire:model.live="seasonId">
                        <option value="">All</option>
                        @foreach($seasons as $s)
                            <option value="{{$s->id}}">{{$s->description}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Customer</label>
                    <select class="form-select" wire:model.live="customerId">
                        <option value="">All</option>
                        @foreach($customers as $c)
                            <option value="{{$c->id}}">{{$c->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Order</label>
                    <select class="form-select" wire:model.live="orderId">
                        <option value="">Select an order</option>
                        @foreach($orders as $o)
                            <option value="{{$o->id}}">{{$o->customer_po}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>

    @foreach($orderLines as $line)
        <div class="card mb-4">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <strong>Style:</strong> {{$line->colourways->style_versions->styles->designs_id}} ({{$line->colourways->style_versions->name}})
                        &nbsp;|&nbsp;
                        <strong>Customer Ref:</strong> {{$line->colourways->style_versions->styles->customer_ref}}
                        &nbsp;|&nbsp;
                        <strong>Description:</strong> {{$line->colourways->style_versions->styles->designs->description}}
                        &nbsp;|&nbsp;
                        <strong>Colour:</strong> {{$line->colourways->name}}
                        &nbsp;|&nbsp;
                        <strong>Order Qty:</strong> {{$line->total_pieces}}
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-bordered table-sm align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="min-width:220px">DESIGN ID / CUSTOMER REF / DESCRIPTION / COLOUR</th>
                                @foreach($line->customer_order_line_quantities->sortBy(fn($q)=>$q->sizes->order) as $q)
                                    <th class="text-center">{{$q->sizes->name}}</th>
                                @endforeach
                                <th class="text-center">COLLECTION DATE</th>
                                <th class="text-center">TRUCK</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><strong>ORIGINAL ORDER QUANTITY</strong></td>
                                @foreach($line->customer_order_line_quantities->sortBy(fn($q)=>$q->sizes->order) as $q)
                                    <td class="text-center">{{$q->qty}}</td>
                                @endforeach
                                <td></td>
                                <td></td>
                            </tr>
                            @php $dropIndex = 1; @endphp
                            @foreach($line->shipment_lines as $drop)
                                <tr>
                                    <td><strong>DROP {{$dropIndex}}</strong></td>
                                    @php $sizes = $drop->shipment_line_sizes->sortBy(fn($s)=>$s->sizes->order)->keyBy('sizes_id'); @endphp
                                    @foreach($line->customer_order_line_quantities->sortBy(fn($q)=>$q->sizes->order) as $q)
                                        <td class="text-center">{{$sizes[$q->sizes_id]->shipped_qty ?? ''}}</td>
                                    @endforeach
                                    <td class="text-center">{{ $drop->collection_date ? date('d-M-Y', strtotime($drop->collection_date)) : '' }}</td>
                                    <td class="text-center">{{$drop->shipment_id}}</td>
                                </tr>
                                @php $dropIndex++; @endphp
                            @endforeach
                            <tr>
                                <td><strong>TOTAL</strong></td>
                                @foreach($line->customer_order_line_quantities->sortBy(fn($q)=>$q->sizes->order) as $q)
                                    @php
                                        $sum = $line->shipment_lines->flatMap->shipment_line_sizes
                                            ->where('sizes_id', $q->sizes_id)
                                            ->sum('shipped_qty');
                                        $ordered = (int) $q->qty;
                                        $differs = $sum !== $ordered;
                                    @endphp
                                    <td class="text-center {{ $differs ? 'bg-danger text-white fw-bold' : '' }}">{{$sum}}</td>
                                @endforeach
                                <td colspan="2"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endforeach
</div>


