<div>
@if(count($sub_headings) > 0 || count($tertiary ?? []) > 0)
<li class="dropdown">
    @php
        $dropdownId = $this->getDropdownId();
        // Check if any sub link is active (works for both segment-based and named routes)
        $isAnySubActive = false;
        foreach ($sub_links ?? [] as $link) {
            if (request()->routeIs($link) || request()->routeIs($link . '*') || request()->segment(1) == $link) {
                $isAnySubActive = true;
                break;
            }
        }
    @endphp
    <a role="button" class="dropdown-button ps-4 p-2 mb-2 text-decoration-none d-flex align-items-center cursor-pointer text-white {{ $isAnySubActive ? 'bg-secondary' : '' }}" id="dropdown-{{$dropdownId}}-btn">
        <span class="fw-semibold">
        @if(in_array($dropdownName, ['Development', 'PD']))
            <i class="fas fa-ruler text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Products')
            <i class="fas fa-box text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Orders')
            <i class="fas fa-clipboard-list text-white" style="width: 20px; height: 20px;"></i>
        @elseif(in_array($dropdownName, ['Sales', 'Orders & Sales']))
            <i class="fas fa-chart-line text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Shipments')
            <i class="fas fa-truck text-white" style="width: 20px; height: 20px;"></i>
        @elseif(in_array($dropdownName, ['Production', 'Production & Logistics']))
            <i class="fas fa-industry text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Invoicing')
            <i class="fas fa-file-invoice-dollar text-white" style="width: 20px; height: 20px;"></i>
        @elseif(in_array($dropdownName, ['Finance', 'Finance & Invoicing']))
            <i class="fas fa-dollar-sign text-white" style="width: 20px; height: 20px;"></i>
        @elseif(in_array($dropdownName, ['Tools', 'Master Data']))
            <i class="fas fa-database text-white" style="width: 20px; height: 20px;"></i>
        @elseif(in_array($dropdownName, ['Import', 'System']))
            <i class="fas fa-cog text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Analytics')
            <i class="fas fa-chart-bar text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Management')
            <i class="fas fa-users-cog text-white" style="width: 20px; height: 20px;"></i>
        @else
            <i class="fas fa-folder text-white" style="width: 20px; height: 20px;"></i>
        @endif
        <span class="ms-3" id="{{$dropdownId}}-down">{{$dropdownName}} &nbsp;&nbsp;<i class="fa-solid fa-angle-down text-white"></i></span>
        <span class="ms-3" id="{{$dropdownId}}-up" style="display: none;">{{$dropdownName}} &nbsp;&nbsp;<i class="fa-solid fa-angle-up text-white"></i></span>
        </span>
    </a>
    <ul id="dropdown-{{$dropdownId}}" class="dropdown-header list-unstyled mb-3" style="display: none;">
        @foreach ($sub_headings as $h=>$heading)
            <li class="ms-5">
                <a class="px-4 py-2 text-decoration-none d-flex align-items-center cursor-pointer text-white {{ request()->routeIs($heading) || request()->segment(1) == $heading ? 'bg-secondary' : '' }} " href="{{route($heading)}}">
                    <span class="fw-semibold">{{ucfirst(trans($h))}}</span>
                </a>
            </li>
        @endforeach
        @foreach ($tertiary ?? [] as $i=>$headings)
            @php
                $isTertiaryActive = false;
                foreach ($headings as $tRoute) {
                    if (request()->routeIs($tRoute) || request()->segment(1) == $tRoute) {
                        $isTertiaryActive = true;
                        break;
                    }
                }
            @endphp
            <li class="ms-5">
                <div class="dropdown-button dropup btn-group w-100">
                    <span role="button" class="px-4 py-2 text-decoration-none d-flex align-items-center cursor-pointer text-white w-100 {{ $isTertiaryActive ? 'bg-secondary' : '' }}" data-bs-toggle="dropdown" aria-expanded="false">
                        <span class="fw-semibold">{{ucfirst(trans($i))}}<i class="ms-2 fa-solid fa-angle-right text-white"></i></span>
                    </span>
                    <ul class="dropdown-menu bg-primary border-0 text-white p-0" style="left: 200px;    margin-bottom: -38px;">
                        @foreach($headings as $h=>$heading)
                            <li class="">
                                <a class="p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->routeIs($heading) || request()->segment(1) == $heading ? 'bg-secondary' : '' }}" href="{{ route($heading) }}">
                                    <span class="fw-semibold">
                                        <span class="ms-3">{{$h}}</span>
                                    </span>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </li>
        @endforeach
    </ul>
</li>
@script
    <script>
        handleDropdown("dropdown-{{$dropdownId}}-btn", "dropdown-{{$dropdownId}}", "{{$dropdownId}}-down", "{{$dropdownId}}-up", $wire.sub_links);
    </script>
@endscript
@endif
</div>