
<nav id="sidebar" class="navbar navbar-expand-md p-0">
    <div class="d-flex flex-column flex-shrink-0 w-100 bg-commission" style="height: 100vh;">
        <div class="px-3">
            <a href="{{ route('commission.dashboard') }}" class="">
                <span class=""><img class="mx-auto d-block" src="/logo-white.png" style="max-width: 150px"></span>
            </a>
            
            <!-- Mode Toggle -->
            <div class="mode-toggle-container mt-2 mb-2">
                <div class="btn-group w-100" role="group">
                    <button type="button" class="btn btn-outline-light btn-sm" wire:click="switchToWholesale">
                        <i class="fas fa-boxes"></i> Wholesale
                    </button>
                    <button type="button" class="btn btn-light btn-sm active" disabled>
                        <i class="fas fa-percentage"></i> Commission
                    </button>
                </div>
            </div>
            
            <hr class="text-white my-2">
        </div>
        
        <ul class="nav nav-pills flex-column mb-auto">
            <!-- Dashboard -->
            <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->routeIs('commission.dashboard') ? 'bg-secondary' : '' }}" href="{{ route('commission.dashboard') }}">
                    <span class="fw-semibold">
                        <i class="fas fa-tachometer-alt text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Dashboard</span>
                    </span>
                </a>
            </li>

            <!-- Orders (Top Level - Most Used) -->
            <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->routeIs('commission.orders') || request()->routeIs('commission.orders.*') ? 'bg-secondary' : '' }}" href="{{ route('commission.orders') }}">
                    <span class="fw-semibold">
                        <i class="fas fa-clipboard-list text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Orders</span>
                    </span>
                </a>
            </li>

            <!-- Shipment Schedule (Top Level) -->
            <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->routeIs('commission.shipment-schedule') ? 'bg-secondary' : '' }}" href="{{ route('commission.shipment-schedule') }}">
                    <span class="fw-semibold">
                        <i class="fas fa-truck text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Shipment Schedule</span>
                    </span>
                </a>
            </li>

            <!-- Invoice Groups (Top Level) -->
            <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->routeIs('commission.invoices') || request()->routeIs('commission.invoices.*') ? 'bg-secondary' : '' }}" href="{{ route('commission.invoices') }}">
                    <span class="fw-semibold">
                        <i class="fas fa-file-invoice-dollar text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Invoice Groups</span>
                    </span>
                </a>
            </li>

            <!-- Import Section -->
            <livewire:navigation.navigation-dropdown 
                dropdownName="Import"
                img="sales.png"
                :subs="[
                    'Import Orders' => 'commission.batch-import',
                    'Import Packing List' => 'imports.commission_pl',
                    'Import Invoice' => 'commission.import-invoice'
                ]"
                wire:key="CommissionImport" />

            <!-- Products Section -->
            <livewire:navigation.navigation-dropdown 
                dropdownName="Products"
                img="dev.png"
                :subs="[
                    'Styles' => 'commission.styles',
                    'Styles Overview' => 'commission.styles-overview',
                    'Sample Tracker' => 'commission.samples'
                ]"
                wire:key="CommissionProducts" />

            <!-- Finance Section -->
            <livewire:navigation.navigation-dropdown 
                dropdownName="Finance"
                img="finance.png"
                :subs="[
                    'Zoho Export' => 'commission.sl-invoicing'
                ]"
                wire:key="CommissionFinance" />

            <!-- Calendar -->
            <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->routeIs('commission.calendar') ? 'bg-secondary' : '' }}" href="{{ route('commission.calendar') }}">
                    <span class="fw-semibold">
                        <i class="fas fa-calendar-alt text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Calendar</span>
                    </span>
                </a>
            </li>

        </ul>
        
        <hr>
        <div class="px-3 pb-3">
            <button class="btn btn-outline-light w-100" onclick="toggleTheme()">
                <i class="fas fa-adjust"></i> Toggle Theme
            </button>
            <script>
                (function() {
                    try {
                        var stored = localStorage.getItem('theme');
                        if (!stored && window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) stored = 'dark';
                        applyTheme(stored || 'light');
                    } catch (e) {}
                })();
                function applyTheme(theme){
                    if(theme === 'dark'){
                        document.documentElement.setAttribute('data-bs-theme','dark');
                    } else {
                        document.documentElement.setAttribute('data-bs-theme','light');
                    }
                    try { localStorage.setItem('theme', theme); } catch(e) {}
                }
                function toggleTheme(){
                    var current = document.documentElement.getAttribute('data-bs-theme') || 'light';
                    applyTheme(current === 'dark' ? 'light' : 'dark');
                }
            </script>
        </div>
    </div>
</nav>

